/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.epm.far.business.common.dataset.dto.DataSetResult;
import kd.epm.far.business.common.enums.FormulaExceptionEnum;
import kd.epm.far.common.common.enums.DimTypesEnum;

public class DataSetArrangeUtil {
    public void sort(String isPositiveSequence, List<DataSetResult> dataSetResults, List<String> measureList) {
        if (CollectionUtils.isEmpty(dataSetResults) || dataSetResults.size() < 2) {
            return;
        }
        if (dataSetResults.get(0).getOrderList().size() == 0) {
            return;
        }
        boolean isPositive = "1".equals(isPositiveSequence);
        Collections.sort(dataSetResults, (dataSetResult1, dataSetResult2) -> {
            List<String> orderList1 = dataSetResult1.getOrderList();
            List<String> orderList2 = dataSetResult2.getOrderList();
            int compareRes = 0;
            for (int i = 0; i < orderList1.size(); ++i) {
                String order1 = orderList1.get(i);
                String order2 = orderList2.get(i);
                if (measureList.contains(order1) && measureList.contains(order2)) {
                    int index = this.getMeasureByNumber(measureList, order1);
                    String fmoney1 = dataSetResult1.getMeasureList().get(index);
                    String fmoney2 = dataSetResult2.getMeasureList().get(index);
                    try {
                        if (isPositive) {
                            return new BigDecimal(fmoney1).compareTo(new BigDecimal(fmoney2));
                        }
                        return new BigDecimal(fmoney2).compareTo(new BigDecimal(fmoney1));
                    }
                    catch (NumberFormatException exception) {
                        compareRes = order1.compareTo(order2);
                        if (compareRes == 0) continue;
                        if (isPositive) {
                            return compareRes;
                        }
                        return -compareRes;
                    }
                    catch (Exception exception) {
                        return 1;
                    }
                }
                try {
                    compareRes = new BigDecimal(order1).compareTo(new BigDecimal(order2));
                }
                catch (NumberFormatException exception) {
                    compareRes = order1.compareTo(order2);
                }
                catch (Exception exception) {
                    return 1;
                }
                if (compareRes == 0) continue;
                if (isPositive) {
                    return compareRes;
                }
                return -compareRes;
            }
            return compareRes;
        });
    }

    private int getMeasureByNumber(List<String> measureList, String number) {
        for (int i = 0; i < measureList.size(); ++i) {
            if (!number.equals(measureList.get(i))) continue;
            return i;
        }
        return 0;
    }

    public List<DataSetResult> groupbySum(List<DataSetResult> dataSetResults) {
        HashMap<String, DataSetResult> dataSetMap = new HashMap<String, DataSetResult>();
        String key = null;
        for (DataSetResult dataSetResult : dataSetResults) {
            key = this.getGroupKey(dataSetResult.getGroupList());
            if (dataSetMap.containsKey(key)) {
                this.addMeasure((DataSetResult)dataSetMap.get(key), dataSetResult);
                continue;
            }
            dataSetMap.put(key, dataSetResult);
        }
        return Lists.newArrayList(dataSetMap.values());
    }

    private void addMeasure(DataSetResult dataSetResultSelf, DataSetResult dataSetResultAdd) {
        List<String> measureListSelf = dataSetResultSelf.getMeasureList();
        List<String> measureListAdd = dataSetResultAdd.getMeasureList();
        String measureStr = null;
        try {
            for (int i = 0; i < measureListSelf.size(); ++i) {
                measureStr = measureListSelf.get(i);
                BigDecimal bd = new BigDecimal(measureStr);
                measureListSelf.set(i, bd.add(new BigDecimal(measureListAdd.get(i))).toString());
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(FormulaExceptionEnum.MEASURE_NOT_NUMBER.getName(), measureStr));
        }
    }

    private String getGroupKey(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String str : list) {
            sb.append(str);
        }
        return sb.toString();
    }

    public <T> T getResultByDataSet(List<String> selectAttrList, List<DataSetResult> dataSets, Integer top, List<String> measureAttrList) {
        LinkedList result = new LinkedList();
        LinkedHashMap<String, String> map = null;
        DataSetResult dataSetResult = null;
        List<String> groupList = null;
        List<String> measureList = null;
        for (int i = 0; i < dataSets.size(); ++i) {
            int j;
            dataSetResult = dataSets.get(i);
            groupList = dataSetResult.getGroupList();
            measureList = dataSetResult.getMeasureList();
            map = new LinkedHashMap<String, String>(16);
            for (j = 0; j < groupList.size(); ++j) {
                String number = selectAttrList.get(j);
                String value = groupList.get(j);
                if (DimTypesEnum.ENTITY.getNumber().equals(number) && value.contains("_")) {
                    value = value.split("_")[1];
                }
                map.put(number, value);
            }
            for (j = 0; j < measureList.size(); ++j) {
                map.put(measureAttrList.get(j), measureList.get(j));
            }
            result.add(map);
            top = top - 1;
            if (top == 0) break;
        }
        return (T)result;
    }
}

