/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.base;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.dataset.calculate.base.IDataSetCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.CalculateStrategy;
import kd.epm.far.business.common.dataset.calculate.cal.MetadataCalculate;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.far.enums.VariableTypeEnum;
import kd.epm.far.business.far.model.AnalysisDataHandler;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;

public abstract class AbsDataSet {
    private Long calcId;
    protected Long datasetId;
    protected DynamicObject ds;
    protected Map<String, Object> varParams = Maps.newHashMapWithExpectedSize((int)16);
    protected Map<String, Set<String>> dimMembers = Maps.newHashMapWithExpectedSize((int)16);
    protected Set<String> hasAllDim = Sets.newHashSetWithExpectedSize((int)16);
    protected Map<Long, String> formulaMap;
    protected Long chapterId;
    protected boolean fromPreview;
    protected IDataSetCalculate calculate;
    private static final Pattern VARIABLE_REGEX = Pattern.compile("\\$[a-zA-Z0-9_\\-]+\\$");

    protected AbsDataSet(Long datasetId, boolean fromPreview) {
        this.calcId = GlobalIdUtil.genGlobalLongId();
        this.fromPreview = fromPreview;
        this.datasetId = datasetId;
        if (!LongUtil.isvalidLong((Object)datasetId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5df2\u4e0d\u5b58\u5728\u3002", (String)"DatasetServiceHelper_6", (String)"epm-far-business", (Object[])new Object[0]));
        }
        this.ds = DatasetDataReader.getDataSet(datasetId);
        this.calculate = CalculateStrategy.getStrategy(this.calcId, this.ds, fromPreview);
        this.formulaMap = this.calculate.getOriException();
        if (Objects.nonNull(this.formulaMap)) {
            this.paramsHandler();
            this.calculate.setHasAllDim(this.hasAllDim);
        }
    }

    private void paramsHandler() {
        Boolean isISC = Boolean.FALSE;
        if (MetadataCalculate.class.isAssignableFrom(this.calculate.getClass())) {
            isISC = Boolean.TRUE;
        }
        Boolean finalIsISC = isISC;
        this.formulaMap.values().forEach(v -> {
            AbsDataSet.extractVarParams(v, this.varParams);
            if (DatasetSpecialVarHelper.isContain(v)) {
                String[] exps;
                for (String exp : exps = v.split(",")) {
                    String shortNumber;
                    if (AbsDataSet.isDimContainKeyword(exp, "$cur")) {
                        shortNumber = exp.substring(0, exp.indexOf(46)).trim().toUpperCase(Locale.ENGLISH);
                        if (finalIsISC.booleanValue()) {
                            shortNumber = exp.substring(0, exp.indexOf(46)).trim();
                        }
                        this.dimMembers.put(shortNumber, null);
                    }
                    if (!AbsDataSet.isDimContainKeyword(exp, "$all")) continue;
                    shortNumber = exp.substring(0, exp.indexOf(46)).trim().toUpperCase(Locale.ENGLISH);
                    this.hasAllDim.add(shortNumber);
                }
            }
        });
    }

    public static void extractVarParams(String formula, Map<String, Object> varParams) {
        Matcher var = VARIABLE_REGEX.matcher(formula);
        while (var.find()) {
            String varNumber = formula.substring(var.start() + 1, var.end() - 1);
            varParams.put(varNumber, null);
        }
    }

    private static boolean isDimContainKeyword(String expression, String keyword) {
        if (expression == null) {
            return false;
        }
        if (expression.indexOf(46) < 0) {
            return false;
        }
        String[] dimStr = DatasetExpressionHelper.splitDimAndMemb(expression);
        String values = dimStr[1];
        String para = values.startsWith("{") && values.endsWith("}") ? values.substring(1, values.length() - 1) : values;
        List<String> members = Arrays.asList(para.split(";"));
        return members.stream().anyMatch(s -> DatasetSpecialVarHelper.isContain(s, keyword));
    }

    protected void dbHandler(Long chapterId) {
        Long dmModelId = this.ds.getLong("discmodel.id");
        AbsDataSet.extractDBHandler(dmModelId, chapterId, this.varParams);
    }

    public static void extractDBHandler(Long dmModelId, Long chapterId, Map<String, Object> varParams) {
        QFilter qFilter = new QFilter("model", "=", (Object)dmModelId).and("number", "in", varParams.keySet());
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"fidm_disc_variable", (String)"id,name,number,defaultvalue,valuetype,scope,chapterid,dimmembertype", (QFilter[])new QFilter[]{qFilter}, (String)"scope asc");
        for (DynamicObject dyn : dyns) {
            String valueType = dyn.getString("valuetype");
            if (Objects.equals("1", dyn.getString("scope"))) {
                AbsDataSet.buildVarParam(dmModelId, dyn, valueType, varParams);
                continue;
            }
            if (!LongUtil.isvalidLong((Object)chapterId) || !Objects.equals(chapterId, dyn.getLong("chapterid"))) continue;
            AbsDataSet.buildVarParam(dmModelId, dyn, valueType, varParams);
        }
        AbsDataSet.checkParam(varParams);
    }

    private static void checkParam(Map<String, Object> params) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (!Objects.isNull(entry.getValue())) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u4ef6\u53d8\u91cf\u503c\u201c%s\u201d\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u53d8\u91cf\u503c\u3002", (String)"AnalysisServiceHelper_10", (String)"epm-far-business", (Object[])new Object[0]), entry.getKey()));
        }
    }

    private static void buildVarParam(Long dmModelId, DynamicObject dyn, String valueType, Map<String, Object> varParams) {
        if (VariableTypeEnum.ENUM.getCode() == Integer.parseInt(valueType)) {
            DynamicObjectCollection enumCollection = QueryServiceHelper.query((String)"fidm_disc_variable", (String)"entryentity.enum_number enumnum,entryentity.enum_name enumname,entryentity.isdefault isenumdefault", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dyn.getLong("id"))});
            for (DynamicObject enumInfo : enumCollection) {
                if (!enumInfo.getBoolean("isenumdefault")) continue;
                varParams.put(dyn.getString("number"), enumInfo.getString("enumnum"));
            }
            return;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List<DimensionInfo> allDims = modelStrategyEx.getDim().getDimList();
        if (VariableTypeEnum.DIM.getCode() == Integer.parseInt(valueType)) {
            String entity = dyn.getString("dimmembertype");
            String defaultValue = dyn.getString("defaultvalue");
            DimMemberInfo member = modelStrategyEx.getDimMember().findMemberById(entity, LongUtil.toLong((Object)defaultValue));
            if (Objects.isNull(member)) {
                return;
            }
            DimensionInfo dim = DimensionUtils.getDimByEntity(allDims, entity);
            if (Objects.isNull(dim)) {
                return;
            }
            String shortNumber = dim.getShortNumber();
            varParams.put(dyn.getString("number"), shortNumber + "." + member.getNumber());
            return;
        }
        varParams.put(dyn.getString("number"), dyn.getString("defaultvalue"));
    }

    public Object getResult() {
        return this.getResult(null);
    }

    public Object getResult(Map<String, String> needFillProperty) {
        return this.getResult(null, needFillProperty);
    }

    public Object getResult(AnalysisDataHandler dataHandler, Map<String, String> needFillProperty) {
        HashMap returnData = new HashMap();
        if (Objects.isNull(this.ds)) {
            return returnData;
        }
        return this.calculate.getResult(this.varParams, this.dimMembers, dataHandler, needFillProperty);
    }

    public Long getCalcId() {
        return this.calcId;
    }

    public Map<Long, String> getFormula() {
        return this.formulaMap;
    }
}

