/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.Collector;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.dataset.dto.DataSetResult;
import kd.epm.far.business.common.dataset.dto.DatasetCalculateVo;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetJoinVo;
import kd.epm.far.business.common.dataset.util.DatasetMutilExpressionHelper;
import kd.epm.far.business.far.model.AnalysisDataHandler;
import kd.epm.far.common.common.Pair;

public interface IDataSetCalculate {
    public static final Log log = LogFactory.getLog(IDataSetCalculate.class);

    public Object getResult(Map<String, Object> var1, Map<String, Set<String>> var2, AnalysisDataHandler var3, Map<String, String> var4);

    public void beforeCalculate(Object ... var1);

    public Object afterCalculate(Object ... var1);

    public Map<Long, String> getOriException();

    default public String getSingleException(DatasetDto dto) {
        return dto.getExpression();
    }

    public void setHasAllDim(Set<String> var1);

    default public void setHasSourceOrg(boolean isHasOrg) {
    }

    default public void hideColumn(String data, List<LinkedHashMap<String, Object>> res) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return;
        }
        DatasetDataVo datasetDataVo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(datasetDataVo.getHideColumns())) {
            return;
        }
        for (LinkedHashMap<String, Object> re : res) {
            for (String hideColumn : datasetDataVo.getHideColumns()) {
                re.remove(hideColumn);
            }
        }
    }

    default public void addColumns(Map<String, Pair<String, Map<String, String>>> map, List<DatasetCalculateVo> calculateList, List<LinkedHashMap<String, Object>> result) {
        if (map.isEmpty() && org.apache.commons.collections.CollectionUtils.isEmpty(calculateList)) {
            return;
        }
        for (LinkedHashMap<String, Object> value : result) {
            for (Map.Entry<String, Pair<String, Map<String, String>>> entry : map.entrySet()) {
                String column = (String)entry.getValue().p1;
                if (!value.containsKey(column)) continue;
                Object o = value.get(column);
                String s = (String)((Map)entry.getValue().p2).get(o.toString());
                if (StringUtils.isBlank((CharSequence)s)) {
                    value.put(entry.getKey(), "");
                    continue;
                }
                value.put(entry.getKey(), s);
            }
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(calculateList)) continue;
            try {
                value.putAll(DatasetMutilExpressionHelper.calculate(calculateList, value));
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u8868\u8fbe\u5f0f\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"IDataSetCalculate_0", (String)"epm-far-business", (Object[])new Object[0]));
            }
        }
    }

    default public DataSet createDataset(List<LinkedHashMap<String, Object>> result, Map<String, DataType> columnTypeMap) {
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        Set<String> strings = result.get(0).keySet();
        String[] columns = new String[strings.size()];
        HashMap columnMap = Maps.newHashMapWithExpectedSize((int)16);
        DataType[] dataTypes = new DataType[strings.size()];
        int index = 0;
        for (String string : strings) {
            Object number = string;
            if (string.contains("=")) {
                number = ((String)number).split("=")[1].replace("'", "");
                columnMap.put(number, string);
            }
            columns[index] = number;
            dataTypes[index] = columnTypeMap.getOrDefault(number, (DataType)DataType.StringType);
            ++index;
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])columns, (DataType[])dataTypes);
        ArrayList<Object[]> coll = new ArrayList<Object[]>(2);
        for (LinkedHashMap linkedHashMap : result) {
            Object[] tempData = new Object[linkedHashMap.size()];
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i];
                Object value = columnMap.containsKey(column) ? linkedHashMap.get(columnMap.get(column)) : linkedHashMap.get(column);
                DataType dataType = columnTypeMap.get(column);
                tempData[i] = DataType.StringType == dataType ? value : this.getRealValue(value, dataType);
            }
            coll.add(tempData);
        }
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)this.getClass().getName()).createDataSet(new Input[]{inputs});
    }

    default public Object getRealValue(Object value, DataType dataType) {
        if (StringUtils.isBlank((Object)value)) {
            return null;
        }
        if (DataType.IntegerType == dataType) {
            return Integer.valueOf(value.toString());
        }
        if (DataType.LongType == dataType) {
            return Long.valueOf(value.toString());
        }
        if (DataType.DoubleType == dataType) {
            return Double.valueOf(value.toString());
        }
        if (DataType.BigDecimalType == dataType) {
            return new BigDecimal(value.toString());
        }
        return value;
    }

    default public List<LinkedHashMap<String, Object>> join(List<DatasetJoinVo> joinList, List<LinkedHashMap<String, Object>> res, Map<String, Pair<DataType, Set<Object>>> columns) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(joinList)) {
            return res;
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(res)) {
            return res;
        }
        LinkedHashMap columnTypeMap = Maps.newLinkedHashMapWithExpectedSize((int)columns.size());
        for (Map.Entry<String, Pair<DataType, Set<Object>>> entry : columns.entrySet()) {
            columnTypeMap.put(entry.getKey(), entry.getValue().p1);
        }
        HashMap rowTransMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet strings = Sets.newHashSetWithExpectedSize((int)16);
        for (String s : res.get(0).keySet()) {
            if (s.contains("=")) {
                String number = s.split("=")[1].replace("'", "");
                rowTransMap.put(number, s);
                strings.add(number);
                continue;
            }
            strings.add(s);
        }
        DataSet ds = this.createDataset(res, columnTypeMap);
        ArrayList result = Lists.newArrayListWithCapacity((int)16);
        for (DatasetJoinVo datasetJoinVo : joinList) {
            try {
                Object selectField;
                Object selectField22;
                final HashSet selectFields = Sets.newHashSet(datasetJoinVo.getSelectFields());
                if (!this.checkSameDataset(datasetJoinVo, columns)) {
                    for (Object selectField22 : selectFields) {
                        strings.add(datasetJoinVo.getEntityName() + "." + (String)selectField22);
                        ds = ds.addField("\"\"", datasetJoinVo.getEntityName() + "." + (String)selectField22);
                    }
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                selectFields.add(datasetJoinVo.getOnField());
                selectField22 = selectFields.iterator();
                while (selectField22.hasNext()) {
                    selectField = (String)selectField22.next();
                    sb.append((String)selectField).append(",");
                }
                final DataSet originalDs = QueryServiceHelper.queryDataSet((String)"Dataset.join", (String)datasetJoinVo.getEntityName(), (String)sb.substring(0, sb.length() - 1), (QFilter[])new QFilter[]{new QFilter(datasetJoinVo.getOnField(), "in", columns.get((Object)datasetJoinVo.getJoinNumber()).p2)}, null);
                selectField = null;
                try {
                    DataSet groupDs = originalDs.groupBy(new String[]{datasetJoinVo.getOnField()}).reduceGroup(new ReduceGroupFunctionWithCollector(){
                        private static final long serialVersionUID = 6737324895393300611L;

                        public RowMeta getResultRowMeta() {
                            String[] fieldNames = new String[selectFields.size()];
                            DataType[] dataTypes = new DataType[selectFields.size()];
                            int index = 0;
                            Iterator iterator = selectFields.iterator();
                            while (iterator.hasNext()) {
                                String selectField;
                                fieldNames[index] = selectField = (String)iterator.next();
                                dataTypes[index] = DataType.StringType;
                                ++index;
                            }
                            RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
                            return originalDs.getRowMeta();
                        }

                        public void reduce(Iterator<Row> iterator, Collector collector) {
                            Object[] curRow = new Object[selectFields.size()];
                            HashMap map = Maps.newHashMapWithExpectedSize((int)selectFields.size());
                            while (iterator.hasNext()) {
                                Row row = iterator.next();
                                int index = 0;
                                for (String selectField : selectFields) {
                                    Object o = row.get(selectField);
                                    if (o instanceof String) {
                                        if (map.containsKey(selectField)) {
                                            Set values = (Set)((Pair)map.get((Object)selectField)).p2;
                                            values.add(o.toString());
                                        } else {
                                            map.put(selectField, new Pair((Object)index, (Object)Sets.newHashSet((Object[])new String[]{o.toString()})));
                                        }
                                    } else {
                                        map.put(selectField, new Pair((Object)index, o));
                                    }
                                    ++index;
                                }
                            }
                            for (Pair value : map.values()) {
                                if (value.p2 instanceof Set) {
                                    curRow[((Integer)value.p1).intValue()] = String.join((CharSequence)",", (Set)value.p2);
                                    continue;
                                }
                                curRow[((Integer)value.p1).intValue()] = value.p2;
                            }
                            collector.collect(curRow);
                        }
                    });
                    if (!groupDs.hasNext()) {
                        for (String selectField3 : datasetJoinVo.getSelectFields()) {
                            ds = ds.addField("\"\"", datasetJoinVo.getEntityName() + "." + selectField3);
                            strings.add(datasetJoinVo.getEntityName() + "." + selectField3);
                        }
                        continue;
                    }
                    String[] selectArray = new String[datasetJoinVo.getSelectFields().size()];
                    int index = 0;
                    for (String selectField4 : datasetJoinVo.getSelectFields()) {
                        selectArray[index] = selectField4 + " as " + datasetJoinVo.getEntityName() + "." + selectField4;
                        ++index;
                    }
                    DataSet finish = ds.leftJoin(groupDs).on(datasetJoinVo.getJoinNumber(), datasetJoinVo.getOnField()).select(strings.toArray(new String[0]), selectArray).finish();
                    for (String selectField5 : datasetJoinVo.getSelectFields()) {
                        strings.add(datasetJoinVo.getEntityName() + "." + selectField5);
                    }
                    ds = finish.copy();
                }
                catch (Throwable throwable) {
                    selectField = throwable;
                    throw throwable;
                }
                finally {
                    if (originalDs == null) continue;
                    if (selectField != null) {
                        try {
                            originalDs.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)selectField).addSuppressed(throwable);
                        }
                        continue;
                    }
                    originalDs.close();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IDataSetCalculate_1", (String)"epm-far-business", (Object[])new Object[0]));
            }
        }
        while (ds.hasNext()) {
            Row next = ds.next();
            LinkedHashMap returnMap = Maps.newLinkedHashMapWithExpectedSize((int)strings.size());
            for (String column : strings) {
                try {
                    String newColumn = column;
                    Object o = next.get(column);
                    if (rowTransMap.containsKey(column)) {
                        newColumn = (String)rowTransMap.get(column);
                    }
                    if (Objects.nonNull(o)) {
                        returnMap.put(newColumn, o.toString());
                        continue;
                    }
                    returnMap.put(newColumn, o);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IDataSetCalculate_1", (String)"epm-far-business", (Object[])new Object[0]));
                }
            }
            result.add(returnMap);
        }
        return result;
    }

    default public boolean checkSameDataset(DatasetJoinVo datasetJoinVo, Map<String, Pair<DataType, Set<Object>>> columns) {
        return datasetJoinVo.getOnField().equals("id") ? DataType.LongType.equals(columns.get((Object)datasetJoinVo.getJoinNumber()).p1) : DataType.StringType.equals(columns.get((Object)datasetJoinVo.getJoinNumber()).p1);
    }

    default public List<DatasetCalculateVo> getCalculateList(DatasetDto dto) {
        if (Objects.isNull(dto) || Objects.isNull(dto.getManageVo())) {
            return Collections.emptyList();
        }
        List<DatasetCalculateVo> calculateVos = dto.getManageVo().getCalculateVos();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(calculateVos)) {
            return Collections.emptyList();
        }
        return calculateVos;
    }

    default public List<DatasetJoinVo> getJoinList(DatasetDto dto) {
        if (Objects.isNull(dto) || Objects.isNull(dto.getManageVo())) {
            return Collections.emptyList();
        }
        List<DatasetJoinVo> joinVos = dto.getManageVo().getJoinVos();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(joinVos)) {
            return Collections.emptyList();
        }
        return joinVos;
    }

    default public List<DataSetResult> buildDataSetResult(List<String> groupList, List<String> orderList, List<LinkedHashMap<String, Object>> result, List<String> measureList) {
        LinkedList<DataSetResult> dsrs = new LinkedList<DataSetResult>();
        DataSetResult dsr = null;
        for (LinkedHashMap<String, Object> obj : result) {
            dsr = new DataSetResult();
            for (String group : groupList) {
                dsr.addGroupList(obj.get(group) + "");
            }
            for (String order : orderList) {
                if (measureList.contains(order)) {
                    dsr.addOrderList(order);
                    continue;
                }
                dsr.addOrderList(String.valueOf(obj.get(order)));
            }
            for (String measure : measureList) {
                Object value = obj.get(measure);
                if (Objects.isNull(value)) continue;
                dsr.addMeasureList(String.valueOf(value));
            }
            dsrs.add(dsr);
        }
        return dsrs;
    }

    default public List<LinkedHashMap<String, Object>> subList(List<LinkedHashMap<String, Object>> result, int top) {
        int maxRowSize = result.size();
        if (top <= 0 || top >= maxRowSize) {
            return result;
        }
        ArrayList returnLists = Lists.newArrayListWithExpectedSize((int)top);
        for (int i = 0; i < top; ++i) {
            returnLists.add(result.get(i));
        }
        return returnLists;
    }
}

