/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.base;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.bcm.dto.BCMMemberTreeNode;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaBaseInputDto;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.far.enums.MoudleLinkageEnum;
import kd.epm.far.business.far.model.AnalysisDataHandler;

public interface IHandlerData {
    default public void handlerData(DatasetDto dto, FormulaBaseInputDto input, Object dimParams, Object handler) {
        if (Objects.isNull(handler)) {
            return;
        }
        AnalysisDataHandler dataHandler = (AnalysisDataHandler)handler;
        if (Objects.equals((Object)dataHandler.getLinkageEnum(), (Object)MoudleLinkageEnum.DRILLING)) {
            input.setContent(this.drillingData(dto, input.getContent(), dataHandler.getParam()));
        }
        if (Objects.equals((Object)dataHandler.getLinkageEnum(), (Object)MoudleLinkageEnum.LINKAGE)) {
            input.setContent(this.linkageData(dto, input.getContent(), dataHandler.getParam(), dataHandler.getAdditionParam(), dimParams));
        }
    }

    default public String linkageData(DatasetDto dto, String expression, Map<String, String> dimMapForLinkage, Map<String, String> dimMapForDrill, Object dimMembersMap) {
        if (Objects.isNull(dimMembersMap)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8054\u52a8\u8bbe\u7f6e\u7f3a\u5c11\u5173\u8054\u7ef4\u5ea6\u6210\u5458\u3002", (String)"MutipleRowDataSet_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        Set dimMembers = ((Map)dimMembersMap).keySet();
        String modelTypeEnumStr = DisModelTypeEnum.getModelType(dto.getDataSrcType(), dto.getDataSrcId()).getType();
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dto.getDataSrcId(), modelTypeEnumStr);
        List<DimensionInfo> allDims = modelStrategyEx.getDim().getDimList();
        HashMap newMap = Maps.newHashMapWithExpectedSize((int)dimMapForLinkage.size());
        for (Map.Entry<String, String> entry : dimMapForLinkage.entrySet()) {
            DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(allDims, entry.getKey());
            if (dimensionInfo == null) continue;
            newMap.put(dimensionInfo.getShortNumber(), entry.getValue());
        }
        Map<String, List<String>> mapAboutDill = this.getSubordinateMember(dto, dimMapForDrill);
        String[] dims = expression.split(",");
        ArrayList dimsList = Lists.newArrayList();
        for (String dim : dims) {
            String[] dimMember = DatasetExpressionHelper.splitDimAndMemb(dim);
            String right = dimMember[1];
            String para = right.startsWith("{") && right.endsWith("}") ? right.substring(1, right.length() - 1) : right;
            List<String> members = Arrays.asList(para.split(";"));
            if (mapAboutDill.containsKey(dimMember[0])) {
                members = mapAboutDill.get(dimMember[0]);
                mapAboutDill.remove(dimMember[0]);
            }
            if (newMap.containsKey(dimMember[0])) {
                String member = (String)newMap.get(dimMember[0]);
                newMap.remove(dimMember[0]);
                if (dimMembers.contains(dimMember[0]) || members.contains(member)) {
                    members = Collections.singletonList(member);
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8054\u52a8\u8bbe\u7f6e\u7f3a\u5c11\u5173\u8054\u7ef4\u5ea6\u6210\u5458\u3002", (String)"MutipleRowDataSet_2", (String)"epm-far-business", (Object[])new Object[0]));
                }
            }
            this.buildDimList(dimMember[0], members, dimsList);
        }
        if (!newMap.isEmpty()) {
            for (Map.Entry entry : newMap.entrySet()) {
                this.buildDimList((String)entry.getKey(), Collections.singletonList(entry.getValue()), dimsList);
            }
        }
        return Joiner.on((String)",").join((Iterable)dimsList);
    }

    default public String drillingData(DatasetDto dto, String expression, Map<String, String> dimMap) {
        Map<String, List<String>> map = this.getSubordinateMember(dto, dimMap);
        String[] dims = expression.split(",");
        ArrayList dimsList = Lists.newArrayList();
        for (String dim : dims) {
            List<String> members;
            String[] dimMember = DatasetExpressionHelper.splitDimAndMemb(dim);
            if (map.containsKey(dimMember[0])) {
                members = map.get(dimMember[0]);
                map.remove(dimMember[0]);
            } else {
                String right = dimMember[1];
                String para = right.startsWith("{") && right.endsWith("}") ? right.substring(1, right.length() - 1) : right;
                members = Arrays.asList(para.split(";"));
            }
            this.buildDimList(dimMember[0], members, dimsList);
        }
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                this.buildDimList((String)entry.getKey(), (List)entry.getValue(), dimsList);
            }
        }
        return Joiner.on((String)",").join((Iterable)dimsList);
    }

    default public void buildDimList(String shortNumber, List<String> members, List<String> dimsList) {
        dimsList.add(this.buildDimAndMember(shortNumber, members, "{", ";", "}"));
    }

    default public String buildDimAndMember(String dimMember, List<String> newMembers, String leftBracket, String semicolon, String rightBracket) {
        StringBuilder sb = new StringBuilder();
        sb.append(dimMember);
        sb.append(".");
        if (newMembers.size() > 1) {
            sb.append(leftBracket);
            sb.append(Joiner.on((String)semicolon).join(newMembers));
            sb.append(rightBracket);
        } else {
            sb.append(newMembers.get(0));
        }
        return sb.toString();
    }

    default public Map<String, List<String>> getSubordinateMember(DatasetDto dto, Map<String, String> dimMap) {
        String modelTypeEnumStr = DisModelTypeEnum.getModelType(dto.getDataSrcType(), dto.getDataSrcId()).getType();
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dto.getDataSrcId(), modelTypeEnumStr);
        List<DimensionInfo> allDims = modelStrategyEx.getDim().getDimList();
        String number = BCMMemberReader.findModelNumberById(dto.getDataSrcId());
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, String> entry : dimMap.entrySet()) {
            BCMMemberTreeNode memberByNumber;
            String dimNumber = entry.getKey();
            DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(allDims, dimNumber);
            if (dimensionInfo == null || (memberByNumber = BCMMemberReader.findMemberByNumber(number, dimNumber, entry.getValue())) == null || Objects.equals(BCMMemberTreeNode.NotFoundTreeNode, memberByNumber)) continue;
            if (memberByNumber.isLeaf()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u94bb\u53d6\u975e\u660e\u7ec6\u8282\u70b9\u3002", (String)"MutipleRowDataSet_1", (String)"epm-far-business", (Object[])new Object[0]));
            }
            map.put(dimensionInfo.getShortNumber(), memberByNumber.getChildren().stream().map(BCMMemberTreeNode::getNumber).collect(Collectors.toList()));
        }
        return map;
    }
}

