/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.cal;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.bcm.BCMDataReader;
import kd.epm.far.business.bcm.BCMDimensionHelper;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.bcm.dto.BcmPermService;
import kd.epm.far.business.bcm.dto.ExtendsQueryInfo;
import kd.epm.far.business.bcm.dto.ExtendsResultSet;
import kd.epm.far.business.bcm.dto.OlapResultSet;
import kd.epm.far.business.bcm.dto.OlapSQLBuilder;
import kd.epm.far.business.bcm.dto.ReportDimResult;
import kd.epm.far.business.common.dataset.calculate.cal.DataSetExtService;
import kd.epm.far.business.common.dataset.calculate.cal.FormulaCalculateService;
import kd.epm.far.business.common.dataset.calculate.cal.FormulaExCalculateService;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaBaseInputDto;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaCalculateInputDto;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaExCalculateInputDto;
import kd.epm.far.business.common.dataset.dto.ColumnTypeEnum;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.dto.SourceEntityVo;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.enums.DataSetCalculateTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.common.common.enums.FacTabFieldDefEnum;
import kd.epm.far.common.common.enums.FieldTypeEnum;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;
import org.apache.commons.collections4.map.MultiKeyMap;

public class BcmCalculate {
    protected Long calcId;
    protected Set<String> hasAllDim;
    protected TreeMap<String, Collection<String>> kvMap = new TreeMap();
    protected Map<String, String> fillPropertyMap;
    private static final int DEFAUT_SIZE = 50000;
    public static final String JoinChar = "\\|";
    protected Map<String, Long> dimMap;
    protected Map<String, Set<Object>> dimMembers = Maps.newHashMapWithExpectedSize((int)16);
    protected boolean hasSourceOrg = false;
    public static final String SOURCEENTITY = "SourceEntity";
    public static final String SE = "SE";
    protected DatasetDto dto;

    protected boolean checkPerm(String expression, Long modelId) {
        String[] dims;
        String modelNumber = BCMDimensionHelper.findModelNumberById(modelId);
        for (String dim : dims = expression.split(",")) {
            String dimNumber;
            Set<String> strings;
            String[] dimMember = DatasetExpressionHelper.splitDimAndMemb(dim);
            String right = dimMember[1];
            String para = right.startsWith("{") && right.endsWith("}") ? right.substring(1, right.length() - 1) : right;
            Set<String> collect = Arrays.stream(para.split(";")).collect(Collectors.toSet());
            if (collect.stream().anyMatch(DatasetSpecialVarHelper::isEqualsAllVar) || !org.apache.commons.collections.CollectionUtils.isEmpty(strings = BCMMsServiceHelper.filterHasPermMember(modelNumber, dimNumber = DimTypesEnum.getDimNumber((String)dimMember[0], (long)modelId), collect)) && strings.containsAll(collect)) continue;
            return false;
        }
        return true;
    }

    protected HashMultimap<String, String> getSqlFilterDims(FormulaExCalculateInputDto formulaInput, String dimAndMembers) {
        HashMultimap dim2MembMap = HashMultimap.create();
        if (StringUtils.isEmpty((CharSequence)dimAndMembers)) {
            return dim2MembMap;
        }
        String[] arrays = null;
        ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
        HashSet currencys = new HashSet(16);
        for (String s : dim2MemList) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            arrays = DatasetExpressionHelper.splitDimAndMemb(s);
            String left = formulaInput.getShortNumber2Num().get(arrays[0]);
            String right = arrays[1];
            String para = right.startsWith("{") && right.endsWith("}") ? right.substring(1, right.length() - 1) : right;
            Collection<String> members = Arrays.asList(para.split(";"));
            MultiKeyMap map = formulaInput.getOrgCurrencymap();
            if (formulaInput.getUseEcDcPcStr() == Boolean.TRUE && "C".equalsIgnoreCase(arrays[0]) && Objects.nonNull(map) && map.values().size() > 0) {
                map.values().forEach(p -> {
                    if (p instanceof HashSet) {
                        currencys.addAll((HashSet)p);
                    } else {
                        currencys.add(p.toString());
                    }
                });
                members = currencys;
            }
            this.addMembers(members, (HashMultimap<String, String>)dim2MembMap, left);
        }
        return dim2MembMap;
    }

    protected void addMembers(Collection<String> members, HashMultimap<String, String> dim2MembMap, String left) {
        for (String member : members) {
            dim2MembMap.put((Object)left, (Object)member);
        }
    }

    public void filterMapCheck(Map<String, String[]> dimFilter) {
        if (!(dimFilter.containsKey(DimTypesEnum.SCENARIO.getNumber()) && dimFilter.containsKey(DimTypesEnum.YEAR.getNumber()) && dimFilter.containsKey(DimTypesEnum.PERIOD.getNumber()) && dimFilter.containsKey(DimTypesEnum.ENTITY.getNumber()) && dimFilter.containsKey(DimTypesEnum.CURRENCY.getNumber()) && dimFilter.containsKey(DimTypesEnum.PROCESS.getNumber()) && dimFilter.containsKey(DimTypesEnum.AUDITTRIAL.getNumber()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u7f6e\u62d3\u5c55\u7ef4\u6570\u636e\u96c6\u65f6\uff0c\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u3001\u7ec4\u7ec7\u3001\u5e01\u79cd\u3001\u8fc7\u7a0b\u548c\u5ba1\u8ba1\u7ebf\u7d22\u5fc5\u987b\u5f55\u5165\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u96c6\u540e\u91cd\u8bd5\u3002", (String)"DataSetExtService_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (dimFilter.get(DimTypesEnum.PROCESS.getNumber()).length > 1 || dimFilter.get(DimTypesEnum.AUDITTRIAL.getNumber()).length > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u7a0b\u3001\u5ba1\u8ba1\u7ebf\u7d22\u53ea\u80fd\u6307\u5b9a\u4e00\u4e2a\u6210\u5458", (String)"DataSetExtService_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    protected ExtendsResultSet getEdResultSet(FormulaExCalculateInputDto formulaInput, HashMultimap<String, String> dim2MembMap, Map<String, String[]> dimFilter, QFilter filter) {
        ExtendsQueryInfo edQueryComInfo = new ExtendsQueryInfo();
        edQueryComInfo.setShowNumber(formulaInput.getModelShowNumber());
        edQueryComInfo.setExtGroup(formulaInput.getGroupNumber());
        edQueryComInfo.setDatamodel(formulaInput.getExtendsModelNumber());
        edQueryComInfo.setExtselects(formulaInput.getExtfields().toArray(new String[0]));
        edQueryComInfo.setNeedSum(true);
        edQueryComInfo.setMultiOrg(true);
        List keys = dim2MembMap.keys().stream().distinct().collect(Collectors.toList());
        if (this.hasSourceOrg) {
            keys.add(SOURCEENTITY);
        }
        edQueryComInfo.setDimselects((String[])keys.stream().distinct().toArray(String[]::new));
        edQueryComInfo.setDimFilter(dimFilter);
        if (Objects.nonNull(filter)) {
            edQueryComInfo.setCustomFilter(filter.toSerializedString());
        }
        return BCMMsServiceHelper.extendsQueryData(edQueryComInfo);
    }

    protected void beforeSelectPermFilter(FormulaBaseInputDto input) {
        Long modelId = input.getModelId();
        String expression = input.getContent();
        String modelNumber = BCMMemberReader.findModelNumberById(modelId);
        String[] dims = expression.split(",");
        ArrayList newDims = Lists.newArrayListWithCapacity((int)dims.length);
        boolean needChange = false;
        for (String dim : dims) {
            String[] dimMember = DatasetExpressionHelper.splitDimAndMemb(dim);
            String right = dimMember[1];
            String para = right.startsWith("{") && right.endsWith("}") ? right.substring(1, right.length() - 1) : right;
            Set<String> collect = Arrays.stream(para.split(";")).collect(Collectors.toSet());
            if (collect.stream().anyMatch(DatasetSpecialVarHelper::isEqualsAllVar)) {
                newDims.add(dim);
                continue;
            }
            String dimNumber = DimTypesEnum.getDimNumber((String)dimMember[0], (long)modelId);
            Set<String> newMembers = BCMMsServiceHelper.filterHasPermMember(modelNumber, dimNumber, collect);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(newMembers)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u96c6\u5b58\u5728\u65e0\u6743\u6210\u5458\u3002", (String)"IDataSet_1", (String)"epm-far-business", (Object[])new Object[0]));
            }
            if (!newMembers.containsAll(collect)) {
                needChange = true;
            }
            newDims.add(BcmCalculate.buildDimAndMember(dimMember[0], Lists.newArrayList(newMembers)));
        }
        if (!needChange) {
            return;
        }
        input.setContent(Joiner.on((String)",").join((Iterable)newDims));
    }

    private static String buildDimAndMember(String dimMember, List<String> newMembers) {
        StringBuilder sb = new StringBuilder();
        sb.append(dimMember);
        sb.append(".");
        if (newMembers.size() > 1) {
            sb.append("{");
            sb.append(Joiner.on((String)";").join(newMembers));
            sb.append("}");
        } else {
            sb.append(newMembers.get(0));
        }
        return sb.toString();
    }

    protected Object afterSelectPermFilter(FormulaBaseInputDto input, Object result) {
        Long modelId = input.getModelId();
        if (BCMDataReader.isAdmin(modelId)) {
            return result;
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(this.hasAllDim)) {
            return result;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId, DisModelTypeEnum.CM.getType());
        List<DimensionInfo> allDimensionInfos = modelStrategyEx.getDim().getDimList();
        Map<String, String> shortNumberMap = BCMMemberReader.getDimensionShortNumber2NumberMap(BCMMemberReader.findModelNumberById(modelId));
        HashMap dimMap = Maps.newHashMapWithExpectedSize((int)this.hasAllDim.size());
        this.hasAllDim.forEach(t -> {
            String dimNumber = (String)shortNumberMap.get(t);
            DimensionInfo dimension = DimensionUtils.getDimByNumber(allDimensionInfos, dimNumber);
            Long dimId = 0L;
            if (dimension != null) {
                dimId = dimension.getId();
            }
            dimMap.put(dimNumber, new BcmPermService(modelId, dimId));
        });
        List resultList = (List)result;
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)resultList)) {
            return result;
        }
        Iterator iterator = resultList.iterator();
        block0: while (iterator.hasNext()) {
            Map next = (Map)iterator.next();
            for (Map.Entry entry : dimMap.entrySet()) {
                String memberNum = (String)next.get(entry.getKey());
                if (((BcmPermService)entry.getValue()).hasPerm(memberNum)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return resultList;
    }

    protected boolean hasProperty(Object res) {
        if (Objects.isNull(this.fillPropertyMap)) {
            return true;
        }
        if (this.fillPropertyMap.isEmpty()) {
            return true;
        }
        List result = (List)res;
        if (((List)res).isEmpty()) {
            return false;
        }
        return !((LinkedHashMap)result.get(0)).keySet().containsAll(this.fillPropertyMap.values());
    }

    protected List<LinkedHashMap<String, Object>> fillProperty(List<LinkedHashMap<String, Object>> res) {
        Iterator<LinkedHashMap<String, Object>> iterator = res.iterator();
        block0: while (iterator.hasNext()) {
            Map re = iterator.next();
            for (Map.Entry<String, String> entry : this.fillPropertyMap.entrySet()) {
                if (Objects.isNull(re.get(entry.getValue()))) {
                    iterator.remove();
                    continue block0;
                }
                String newValue = re.get(entry.getKey()).toString() + ";" + re.get(entry.getValue()).toString();
                re.put(entry.getKey(), newValue);
            }
        }
        return res;
    }

    protected Map<String, Pair<String, Map<String, String>>> buildPropertyMap(Long modelId, List<DatasetPropertyVo> propertyList) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(propertyList)) {
            return map;
        }
        Map<String, Map<Integer, List<DatasetPropertyVo>>> propertyMap = this.getPropertyMap(propertyList);
        for (Map.Entry<String, Map<Integer, List<DatasetPropertyVo>>> entry : propertyMap.entrySet()) {
            String entityName;
            String number;
            if (Objects.equals(entry.getKey(), "extend")) continue;
            if (Objects.equals(entry.getKey(), SOURCEENTITY)) {
                number = DimTypesEnum.ENTITY.getNumber();
                entityName = "bcm_entitymembertree";
            } else {
                number = entry.getKey();
                entityName = BCMDimensionHelper.getDimMembEntityNumByDimNum(entry.getKey());
            }
            HashSet selectFields = Sets.newHashSetWithExpectedSize((int)16);
            HashMap nameMap = Maps.newHashMapWithExpectedSize((int)16);
            Long dimId = this.getDimId(modelId, number);
            QFilter dimensionFilter = new QFilter("dimension", "=", (Object)dimId);
            HashMap propertyIdMap = Maps.newHashMapWithExpectedSize((int)16);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)entry.getValue().get(ColumnTypeEnum.ATTRIBUTE_COLUMN.getCode()))) {
                HashSet numbers = Sets.newHashSetWithExpectedSize((int)16);
                for (DatasetPropertyVo vo : entry.getValue().get(ColumnTypeEnum.ATTRIBUTE_COLUMN.getCode())) {
                    numbers.add(vo.getNumber());
                    map.put(entry.getKey() + "-Property-" + vo.getNumber(), new Pair((Object)entry.getKey(), (Object)Maps.newHashMapWithExpectedSize((int)16)));
                }
                DynamicObjectCollection propertyDys = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,number,propertyid.propertyn,propertyid.id", (QFilter[])new QFilter[]{dimensionFilter, new QFilter("number", "in", (Object)numbers)});
                HashSet propertyIds = Sets.newHashSetWithExpectedSize((int)propertyDys.size());
                for (DynamicObject propertyDy : propertyDys) {
                    selectFields.add(propertyDy.getString("propertyid.propertyn"));
                    nameMap.put(propertyDy.getString("propertyid.propertyn"), entry.getKey() + "-Property-" + propertyDy.getString("number"));
                    propertyIds.add(propertyDy.getLong("propertyid.id"));
                }
                DynamicObjectCollection property = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("propertyid", "in", (Object)propertyIds)});
                for (DynamicObject propertyDy : property) {
                    propertyIdMap.put(propertyDy.getLong("id"), propertyDy.getString("name"));
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)entry.getValue().get(ColumnTypeEnum.FIXED_COLUMN.getCode()))) {
                for (DatasetPropertyVo vo : entry.getValue().get(ColumnTypeEnum.FIXED_COLUMN.getCode())) {
                    selectFields.add(vo.getNumber());
                    map.put(entry.getKey() + "-" + vo.getNumber(), new Pair((Object)entry.getKey(), (Object)Maps.newHashMapWithExpectedSize((int)16)));
                    nameMap.put(vo.getNumber(), entry.getKey() + "-" + vo.getNumber());
                }
            }
            String selectFieldStr = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)selectFields) ? "number" : (selectFields.contains("number") ? Joiner.on((String)",").join((Iterable)selectFields) : Joiner.on((String)",").join((Iterable)selectFields) + ",number");
            DynamicObjectCollection members = QueryServiceHelper.query((String)entityName, (String)selectFieldStr, (QFilter[])new QFilter[]{dimensionFilter, new QFilter("number", "in", this.dimMembers.get(entry.getKey()))});
            for (DynamicObject member : members) {
                for (String selectField : selectFields) {
                    String value;
                    String column = (String)nameMap.get(selectField);
                    if (selectField.startsWith("dproperty")) {
                        long propertyId = member.getLong(selectField);
                        value = (String)propertyIdMap.get(propertyId);
                    } else {
                        value = member.getString(selectField);
                    }
                    ((Map)((Pair)map.get((Object)column)).p2).put(member.getString("number"), value);
                }
            }
        }
        return map;
    }

    private Map<String, BcmPermService> getPermMap(Long modelId, String[] dimNumbers) {
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)dimNumbers.length);
        for (String dimNumber : dimNumbers) {
            Long dimId = this.getDimId(modelId, dimNumber);
            returnMap.put(dimNumber, new BcmPermService(modelId, dimId));
        }
        return returnMap;
    }

    protected Long getDimId(Long modelId, String dimNumber) {
        if (Objects.isNull(this.dimMap)) {
            this.dimMap = Maps.newHashMapWithExpectedSize((int)16);
            Long dimId = BCMDimensionHelper.getDimId(modelId, dimNumber);
            this.dimMap.put(dimNumber, dimId);
            return dimId;
        }
        if (this.dimMap.containsKey(dimNumber)) {
            return this.dimMap.get(dimNumber);
        }
        Long dimId = BCMDimensionHelper.getDimId(modelId, dimNumber);
        this.dimMap.put(dimNumber, dimId);
        return dimId;
    }

    protected List<LinkedHashMap<String, Object>> commonFillBack(FormulaBaseInputDto input, OlapResultSet olapResult) {
        ReportDimResult reportDimResult;
        ArrayList<LinkedHashMap<String, Object>> result = new ArrayList<LinkedHashMap<String, Object>>(2);
        if (olapResult == null || olapResult.getRows() == null || olapResult.getRows().size() == 0) {
            return result;
        }
        String[] fields = olapResult.getOlapSQLBuilder().getSelectField();
        Map<String, BcmPermService> numberPermMap = this.getPermMap(input.getModelId(), fields);
        LinkedHashSet<Object> dimKeys = new LinkedHashSet(16);
        List<Object> dimValues = Collections.emptyList();
        boolean isComponent = false;
        if (LongUtil.isvalidLong((Object)input.getComponentId()) && Objects.nonNull(reportDimResult = BCMMsServiceHelper.reportDimResultQueryData(input.getComponentId()))) {
            dimKeys = reportDimResult.getDimKeys();
            dimValues = reportDimResult.getDimValues();
            isComponent = true;
        }
        for (Object obj : olapResult.getRows()) {
            List<Object> rowData;
            Map itemMap = (Map)obj;
            if (itemMap == null || (rowData = BcmCalculate.getRowValues(itemMap.get("key") == null ? "" : itemMap.get("key").toString())) == null || rowData.size() == 0) continue;
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(fields.length + 1);
            boolean noPerm = false;
            for (int i = 0; i < fields.length; ++i) {
                String string;
                String shortNumber = fields[i];
                String checkMember = string = rowData.get(i).toString();
                BcmPermService bcmPermService = numberPermMap.get(shortNumber);
                if (DimTypesEnum.ENTITY.getNumber().equals(shortNumber) && checkMember.contains("_")) {
                    checkMember = checkMember.split("_")[1];
                }
                if (!bcmPermService.hasPerm(checkMember)) {
                    noPerm = true;
                    break;
                }
                item.put(shortNumber, string);
            }
            if (noPerm) {
                if (!Objects.equals(input.getType(), DataSetTypeEnum.SINGLE_VALUED.getType())) continue;
                return null;
            }
            if (isComponent) {
                StringBuilder sb = new StringBuilder();
                for (String string : dimKeys) {
                    String s = (String)item.getOrDefault(string, "");
                    sb.append(s.split(";")[0]).append("#");
                }
                if (!dimValues.contains(sb.toString())) continue;
            }
            this.buildDimMembers(item);
            if (olapResult.getOlapSQLBuilder().getMeasures() != null && olapResult.getOlapSQLBuilder().getMeasures().size() > 0) {
                String fmoney = olapResult.getOlapSQLBuilder().getMeasures().get(0);
                item.put(fmoney, itemMap.get(fmoney));
            }
            result.add(item);
        }
        return result;
    }

    private void buildDimMembers(Map<String, Object> itemMap) {
        for (Map.Entry<String, Object> entry : itemMap.entrySet()) {
            if (this.dimMembers.containsKey(entry.getKey())) {
                this.dimMembers.get(entry.getKey()).add(entry.getValue());
                continue;
            }
            this.dimMembers.put(entry.getKey(), Sets.newHashSet((Object[])new Object[]{entry.getValue()}));
        }
    }

    public static List<Object> getRowValues(String dimKeyStr) {
        if (StringUtils.isEmpty((CharSequence)dimKeyStr)) {
            return new ArrayList<Object>(2);
        }
        return Lists.newArrayList((Object[])dimKeyStr.split(JoinChar));
    }

    protected Object fillBack(FormulaCalculateService calculateService, FormulaCalculateInputDto formulaInput, List<LinkedHashMap<String, Object>> result) {
        return null;
    }

    public Object getResult(FormulaBaseInputDto input, DatasetDto dto) {
        boolean isFinancial;
        FormulaCalculateService calculateService = new FormulaCalculateService();
        FormulaCalculateInputDto formulaInput = calculateService.createFormulaRunningEntity(input);
        Map<String, String> shortNumber2Num = formulaInput.getShortNumber2Num();
        HashMultimap<String, String> dim2MembMap = calculateService.getSqlFilterDims(formulaInput, shortNumber2Num, formulaInput.getContent());
        if (Objects.equals(input.getType(), DataSetCalculateTypeEnum.SingleValue.getType()) && (isFinancial = Objects.equals((Object)DisModelTypeEnum.RPT, (Object)DisModelTypeEnum.getModelType(dto.getDataSrcType(), dto.getDataSrcId())))) {
            dim2MembMap.removeAll((Object)"Process");
            dim2MembMap.put((Object)"Process", (Object)"ERpt");
        }
        if ((formulaInput.getMemberinAllCols("E") || formulaInput.getMemberinAllCols("BP")) && formulaInput.getUseEcDcPcStr() == Boolean.TRUE) {
            formulaInput.addAllCols("C");
        }
        dim2MembMap.asMap().forEach((k, v) -> {
            if (!formulaInput.getNumbersAllCols().contains(k)) {
                this.kvMap.put((String)k, (Collection<String>)v);
            }
        });
        Map<String, Set<String>> newHashMap = this.getFilter(input);
        if (newHashMap == null) {
            return null;
        }
        OlapSQLBuilder sql = new OlapSQLBuilder(formulaInput.getCube());
        sql.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
        HashSet<String> filedsselected = new HashSet<String>(16);
        List<String> groupList = calculateService.getNormalNumberList(formulaInput.getShortNumber2Num(), formulaInput.getGroupList(), false);
        if (!CollectionUtils.isEmpty(groupList)) {
            groupList.forEach(e -> filedsselected.addAll(groupList));
        }
        sql.setTop(50000);
        this.kvMap.forEach((k, v) -> {
            if (CollectionUtils.isEmpty((Collection)groupList)) {
                filedsselected.add((String)k);
            }
            if (newHashMap.containsKey(k)) {
                v.retainAll((Collection)newHashMap.get(k));
            } else {
                this.dimMembers.put((String)k, Sets.newHashSet((Iterable)v));
            }
            sql.addFilter((String)k, v.toArray(new String[0]));
        });
        for (Map.Entry<String, Set<String>> entry : newHashMap.entrySet()) {
            if (this.kvMap.containsKey(entry.getKey())) continue;
            sql.addFilter(entry.getKey(), entry.getValue().toArray(new String[0]));
        }
        List<String> cols = formulaInput.getNumbersAllCols();
        if (Objects.nonNull(cols) && cols.size() > 0) {
            filedsselected.addAll(cols);
        }
        if (!formulaInput.getMemberinAllCols("BP") && !input.getContent().contains("BP")) {
            sql.addSelectField(filedsselected.stream().filter(r -> !DimTypesEnum.PROCESS.getNumber().equals(r)).collect(Collectors.toList()).toArray(new String[0]));
        } else {
            sql.addSelectField(filedsselected.toArray(new String[0]));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getExcludeDynaData())) {
            sql.setExcludeDynaData("1".equals(dto.getExcludeDynaData()));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getExcludeNullData())) {
            sql.setExcludeNullData("1".equals(dto.getExcludeNullData()));
        }
        OlapResultSet olapResultSet = BCMMsServiceHelper.olapQueryData(sql);
        return this.fillBack(calculateService, formulaInput, this.commonFillBack(formulaInput, olapResultSet));
    }

    private Map<String, Set<String>> getFilter(FormulaBaseInputDto input) {
        List<DatasetPropertyVo> list = input.getPropertyList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        List<DatasetPropertyVo> collect = list.stream().filter(t -> !Objects.equals(t.getType(), ColumnTypeEnum.MEASURE.getCode()) && org.apache.commons.collections.CollectionUtils.isNotEmpty(t.getFilters())).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(collect)) {
            return Collections.emptyMap();
        }
        Map<String, Map<Integer, List<DatasetPropertyVo>>> propertyMap = this.getPropertyMap(collect);
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)propertyMap.size());
        QFilter modelFilter = new QFilter("model", "=", (Object)input.getModelId());
        for (Map.Entry<String, Map<Integer, List<DatasetPropertyVo>>> entry : propertyMap.entrySet()) {
            DynamicObjectCollection dynamicObjectCollection;
            List<DatasetPropertyVo> fixedVos;
            String entityName;
            String number;
            if (Objects.equals(entry.getKey(), SOURCEENTITY)) {
                number = DimTypesEnum.ENTITY.getNumber();
                entityName = "bcm_entitymembertree";
            } else {
                number = entry.getKey();
                entityName = BCMDimensionHelper.getDimMembEntityNumByDimNum(entry.getKey());
            }
            Long dimId = this.getDimId(input.getModelId(), number);
            QFilter dimensionFilter = new QFilter("dimension", "=", (Object)dimId);
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(modelFilter);
            List<DatasetPropertyVo> propertyVos = entry.getValue().get(ColumnTypeEnum.ATTRIBUTE_COLUMN.getCode());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(propertyVos)) {
                for (DatasetPropertyVo datasetPropertyVo : propertyVos) {
                    QFilter filter = datasetPropertyVo.getFilter("name", FieldTypeEnum.STRING.getNumber());
                    DynamicObjectCollection propertyDys = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,propertyid.propertyn", (QFilter[])new QFilter[]{modelFilter, dimensionFilter, filter});
                    if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)propertyDys)) {
                        return null;
                    }
                    String filterKey = ((DynamicObject)propertyDys.get(0)).getString("propertyid.propertyn");
                    List id = propertyDys.stream().map(t -> t.getLong("id")).collect(Collectors.toList());
                    qfBuilder.add(new QFilter(filterKey, "in", id));
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fixedVos = entry.getValue().get(ColumnTypeEnum.FIXED_COLUMN.getCode()))) {
                for (DatasetPropertyVo propertyVo2 : fixedVos) {
                    QFilter filter = propertyVo2.getFilter(propertyVo2.getNumber(), FieldTypeEnum.STRING.getNumber());
                    qfBuilder.add(filter);
                }
            }
            if (this.kvMap.containsKey(entry.getKey())) {
                qfBuilder.add(new QFilter("number", "in", this.kvMap.get(entry.getKey())));
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(dynamicObjectCollection = QueryServiceHelper.query((String)entityName, (String)"number", (QFilter[])qfBuilder.toArray())))) {
                return null;
            }
            returnMap.put(entry.getKey(), dynamicObjectCollection.stream().map(t -> t.getString("number")).collect(Collectors.toSet()));
        }
        return returnMap;
    }

    protected Map<String, Map<Integer, List<DatasetPropertyVo>>> getPropertyMap(List<DatasetPropertyVo> collect) {
        HashMap propertyMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DatasetPropertyVo vo : collect) {
            Map<Integer, ArrayList> integerListMap;
            String source = vo.getSource();
            Integer type = vo.getType();
            if (propertyMap.containsKey(source)) {
                integerListMap = (Map)propertyMap.get(source);
                if (integerListMap.containsKey(type)) {
                    ((List)integerListMap.get(type)).add(vo);
                    continue;
                }
                integerListMap.put(type, Lists.newArrayList((Object[])new DatasetPropertyVo[]{vo}));
                continue;
            }
            integerListMap = Maps.newHashMapWithExpectedSize((int)2);
            integerListMap.put(type, Lists.newArrayList((Object[])new DatasetPropertyVo[]{vo}));
            propertyMap.put(source, integerListMap);
        }
        return propertyMap;
    }

    protected Object getExResult(FormulaBaseInputDto input) {
        DataSetExtService extService = new DataSetExtService();
        FormulaExCalculateService calculateService = new FormulaExCalculateService();
        FormulaExCalculateInputDto formulaInput = calculateService.createFormulaRunningEntity(input);
        HashMultimap<String, String> dim2MembMap = this.getSqlFilterDims(formulaInput, formulaInput.getContent());
        Map<String, String> fieldMappedForCols = extService.getColsFieldMapped(formulaInput.getModelId(), formulaInput.getExtfields(), formulaInput.getGroupNumber());
        Map<String, String> fieldMappedForTypes = extService.getColsTypeMapped(formulaInput.getExtfields().toArray(new String[0]), formulaInput.getModelId(), formulaInput.getGroupNumber());
        Map<String, String> fieldcals = extService.getFieldsByType(fieldMappedForCols, fieldMappedForTypes, "cal");
        HashMap<String, String[]> dimFilter = new HashMap<String, String[]>();
        dim2MembMap.asMap().forEach((k, v) -> {
            if (!formulaInput.getNumbersAllCols().contains(k)) {
                this.kvMap.put((String)k, (Collection<String>)v);
            }
        });
        Map<String, Set<String>> newHashMap = this.getFilter(input);
        if (newHashMap == null) {
            return null;
        }
        for (Map.Entry<String, Set<String>> entry : newHashMap.entrySet()) {
            HashSet set = Sets.newHashSetWithExpectedSize((int)entry.getValue().size());
            set.addAll((Collection)entry.getValue());
            this.dimMembers.put(entry.getKey(), set);
        }
        this.kvMap.forEach((k, v) -> {
            if (newHashMap.containsKey(k)) {
                v.retainAll((Collection)newHashMap.get(k));
            } else {
                this.dimMembers.put((String)k, Sets.newHashSet((Iterable)v));
            }
            dimFilter.put((String)k, v.toArray(new String[0]));
        });
        this.filterMapCheck(dimFilter);
        Map<String, String> selectMap = this.selectHandler(dim2MembMap);
        QFilter customFilter = this.getCustomFilter(input, fieldMappedForCols, fieldcals);
        customFilter = this.buildSEQF(newHashMap, customFilter, input);
        this.hasSourceOrg = this.hasSourceOrg ? this.hasSourceOrg : BcmCalculate.hasOrg(input.getData());
        ExtendsResultSet edResultSet = this.getEdResultSet(formulaInput, dim2MembMap, dimFilter, customFilter);
        return this.exFillBack(edResultSet, selectMap, fieldcals);
    }

    public static boolean hasOrg(String data) {
        DatasetDataVo datasetDataVo;
        if (!StringUtils.isEmpty((CharSequence)data) && StringUtils.isNotBlank((CharSequence)data) && (datasetDataVo = (DatasetDataVo)JSONObject.parseObject((String)data, DatasetDataVo.class)) != null) {
            List collect;
            if (datasetDataVo.getSourceEntityVo() != null) {
                return true;
            }
            List<DatasetPropertyVo> columns = datasetDataVo.getColumns();
            if (columns != null && !columns.isEmpty() && !(collect = columns.stream().filter(v -> SOURCEENTITY.equals(v.getSource())).collect(Collectors.toList())).isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private QFilter buildSEQF(Map<String, Set<String>> newHashMap, QFilter customFilter, FormulaBaseInputDto input) {
        Set<String> strings = newHashMap.get(SOURCEENTITY);
        String data = input.getData();
        if (strings != null && !strings.isEmpty()) {
            if (customFilter == null) {
                customFilter = new QFilter("entity", "in", strings);
            } else {
                customFilter.and(new QFilter("entity", "in", strings));
            }
        } else if (BcmCalculate.hasOrg(data)) {
            boolean onlyMs = true;
            if (!StringUtils.isEmpty((CharSequence)data) && StringUtils.isNotBlank((CharSequence)data)) {
                List collect;
                DatasetDataVo datasetDataVo = (DatasetDataVo)JSONObject.parseObject((String)data, DatasetDataVo.class);
                SourceEntityVo sourceEntityVo = datasetDataVo.getSourceEntityVo();
                List<DatasetPropertyVo> columns = datasetDataVo.getColumns();
                if (columns != null && !columns.isEmpty() && !(collect = columns.stream().filter(v -> SOURCEENTITY.equals(v.getSource())).collect(Collectors.toList())).isEmpty()) {
                    for (DatasetPropertyVo vo : collect) {
                        if (vo.getFilters() == null || vo.getFilters().isEmpty()) continue;
                        onlyMs = false;
                        break;
                    }
                }
                if (onlyMs && sourceEntityVo != null && sourceEntityVo.getMembers() != null && !sourceEntityVo.getMembers().isEmpty()) {
                    List<String> msByRange = BcmCalculate.getMsByRange(input.getModelId(), sourceEntityVo.getMembers());
                    if (customFilter == null) {
                        customFilter = new QFilter("entity", "in", msByRange);
                    } else {
                        customFilter.and(new QFilter("entity", "in", msByRange));
                    }
                }
            }
        }
        return customFilter;
    }

    public static List<String> getMsByRange(Long modelId, List<DimMemberInfo> dims) {
        String dimNumber = DimTypesEnum.getDimNumber((String)"E", (long)modelId);
        ArrayList<String> re = new ArrayList<String>(12);
        for (DimMemberInfo dim : dims) {
            String number = dim.getNumber();
            int range = dim.getRange();
            if (range != 0 && range != 10) {
                Set<String> result = BCMMsServiceHelper.batchGetMemberNumbers(BCMDimensionHelper.findModelNumberById(modelId), dimNumber, number, RangeEnum.getRangeByVal((int)range));
                re.addAll(result.stream().collect(Collectors.toList()));
                continue;
            }
            re.add(number);
        }
        return re;
    }

    private QFilter getCustomFilter(FormulaBaseInputDto input, Map<String, String> fieldMappedForCols, Map<String, String> fieldcals) {
        List<DatasetPropertyVo> propertyList = input.getPropertyList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(propertyList)) {
            return null;
        }
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)propertyList.size());
        for (DatasetPropertyVo datasetPropertyVo : propertyList) {
            if (!Objects.equals(ColumnTypeEnum.MEASURE.getCode(), datasetPropertyVo.getType()) || !org.apache.commons.collections.CollectionUtils.isNotEmpty(datasetPropertyVo.getFilters())) continue;
            String number = fieldcals.containsKey(datasetPropertyVo.getNumber()) ? FieldTypeEnum.DECIMAL.getNumber() : FieldTypeEnum.STRING.getNumber();
            qFilters.add(datasetPropertyVo.getFilter(fieldMappedForCols.get(datasetPropertyVo.getNumber()), number));
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)qFilters)) {
            return input.getCustomFilter();
        }
        QFilter qFilter = (QFilter)qFilters.get(0);
        for (int i = 1; i < qFilters.size(); ++i) {
            qFilter.and((QFilter)qFilters.get(i));
        }
        if (Objects.nonNull(input.getCustomFilter())) {
            qFilter.and(input.getCustomFilter());
        }
        return qFilter;
    }

    protected Object exFillBack(ExtendsResultSet edResultSet, Map<String, String> selectMap, Map<String, String> fieldcals) {
        return null;
    }

    private Map<String, String> selectHandler(HashMultimap<String, String> dim2MembMap) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        String process = dim2MembMap.get((Object)DimTypesEnum.PROCESS.getNumber()).toArray(new String[0])[0];
        String auditTrial = dim2MembMap.get((Object)DimTypesEnum.AUDITTRIAL.getNumber()).toArray(new String[0])[0];
        map.put(DimTypesEnum.PROCESS.getNumber(), process);
        map.put(DimTypesEnum.AUDITTRIAL.getNumber(), auditTrial);
        return map;
    }
}

