/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.cal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.orm.util.CollectionUtils;
import kd.epm.far.business.common.dataset.calculate.DataSetArrangeUtil;
import kd.epm.far.business.common.dataset.calculate.base.IDataSetCalculate;
import kd.epm.far.business.common.dataset.calculate.base.IHandlerData;
import kd.epm.far.business.common.dataset.calculate.cal.BcmCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.FormulaCalculateService;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaBaseInputDto;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaCalculateInputDto;
import kd.epm.far.business.common.dataset.calculate.input.MutiLineInputInput;
import kd.epm.far.business.common.dataset.dto.DataSetResult;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.util.DatasetMemberHelper;
import kd.epm.far.business.common.dataset.util.DatasetRowHelper;
import kd.epm.far.business.far.model.AnalysisDataHandler;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.enums.FacTabFieldDefEnum;

public class BcmMultiLineCalculate
extends BcmCalculate
implements IDataSetCalculate,
IHandlerData {
    private FormulaBaseInputDto input;
    private boolean fromPreview;

    public BcmMultiLineCalculate(Long calcId, DatasetDto dto, boolean fromPreview) {
        this.calcId = calcId;
        this.dto = dto;
        this.fromPreview = fromPreview;
    }

    @Override
    public Object getResult(Map<String, Object> varParams, Map<String, Set<String>> dimParams, AnalysisDataHandler handler, Map<String, String> fillProperty) {
        this.beforeCalculate(varParams, dimParams, handler);
        this.fillPropertyMap = fillProperty;
        Object calculate = this.getResult(this.input, this.dto);
        return this.afterCalculate(calculate);
    }

    @Override
    public void beforeCalculate(Object ... params) {
        this.input = new MutiLineInputInput().create(this.dto, params);
        this.handlerData(this.dto, this.input, params[1], params[2]);
        this.beforeSelectPermFilter(this.input);
    }

    @Override
    public Object afterCalculate(Object ... params) {
        List<LinkedHashMap<String, Object>> result = (List<LinkedHashMap<String, Object>>)params[0];
        if (CollectionUtils.isEmpty((Collection)result)) {
            return result;
        }
        if (CollectionUtils.isEmpty(result = DatasetRowHelper.rowTransferHandler(this.dto, result, this.fromPreview))) {
            return result;
        }
        result = this.subList(result, this.input.getTop());
        Map<String, Pair<String, Map<String, String>>> map = this.buildPropertyMap(this.input.getModelId(), this.input.getPropertyList());
        this.addColumns(map, this.getCalculateList(this.dto), result);
        HashMap columns = Maps.newHashMapWithExpectedSize((int)this.dimMembers.size());
        for (Map.Entry<String, Object> entry : result.get(0).entrySet()) {
            columns.put(entry.getKey(), new Pair((Object)DataType.StringType, Collections.emptySet()));
        }
        for (Map.Entry<String, Object> entry : this.dimMembers.entrySet()) {
            columns.put(entry.getKey(), new Pair((Object)DataType.StringType, entry.getValue()));
        }
        result = this.join(this.getJoinList(this.dto), result, columns);
        this.hideColumn(this.input.getData(), result);
        if (!this.fromPreview) {
            result = this.hasProperty(result) ? DatasetMemberHelper.menberWithName(result, this.dto.getDataSrcId(), this.dto.getExtendsModelId()) : this.fillProperty(result);
        }
        return result;
    }

    @Override
    public Map<Long, String> getOriException() {
        HashMap returnMap = Maps.newHashMap();
        returnMap.put(this.dto.getId(), this.getSingleException(this.dto));
        return returnMap;
    }

    @Override
    public void setHasAllDim(Set<String> hasAllDim) {
        this.hasAllDim = hasAllDim;
    }

    @Override
    protected List<LinkedHashMap<String, Object>> fillBack(FormulaCalculateService calculateService, FormulaCalculateInputDto formulaInput, List<LinkedHashMap<String, Object>> result) {
        List<String> selectList = calculateService.shortConvertToDimNumber(formulaInput.getShortNumber2Num(), Lists.newArrayList((Object[])formulaInput.getContent().split(",")));
        List<String> groupList = calculateService.getNormalNumberList(formulaInput.getShortNumber2Num(), formulaInput.getGroupList(), false);
        List<String> orderList = calculateService.getNormalNumberList(formulaInput.getShortNumber2Num(), formulaInput.getOrderList(), true);
        if (!formulaInput.getMemberinAllCols("BP") && !this.input.getContent().contains("BP")) {
            selectList.remove("Process");
        }
        if (CollectionUtils.isEmpty(groupList) && CollectionUtils.isEmpty(orderList)) {
            return result;
        }
        List<DataSetResult> dataSets = null;
        DataSetArrangeUtil dsau = new DataSetArrangeUtil();
        LinkedList<String> measureList = new LinkedList<String>();
        measureList.add(FacTabFieldDefEnum.FIELD_MONEY.getField());
        if (CollectionUtils.isEmpty(groupList)) {
            dataSets = this.buildDataSetResult(selectList, orderList, result, measureList);
        } else {
            dataSets = this.buildDataSetResult(groupList, orderList, result, measureList);
            dataSets = dsau.groupbySum(dataSets);
        }
        if (!CollectionUtils.isEmpty(orderList)) {
            dsau.sort(this.dto.getAsc(), dataSets, measureList);
        }
        result = CollectionUtils.isEmpty(groupList) ? (List)dsau.getResultByDataSet(selectList, dataSets, -1, measureList) : (List)dsau.getResultByDataSet(groupList, dataSets, -1, measureList);
        return result;
    }
}

