/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.cal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.orm.util.CollectionUtils;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.bcm.dto.ExtendsResultSet;
import kd.epm.far.business.common.dataset.calculate.DataSetArrangeUtil;
import kd.epm.far.business.common.dataset.calculate.base.IDataSetCalculate;
import kd.epm.far.business.common.dataset.calculate.base.IHandlerData;
import kd.epm.far.business.common.dataset.calculate.cal.BcmCalculate;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaBaseInputDto;
import kd.epm.far.business.common.dataset.calculate.input.MutiLineExInputInput;
import kd.epm.far.business.common.dataset.dto.DataSetResult;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.util.DatasetMemberHelper;
import kd.epm.far.business.far.model.AnalysisDataHandler;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.enums.DimTypesEnum;

public class BcmMultiLineExCalculate
extends BcmCalculate
implements IDataSetCalculate,
IHandlerData {
    private FormulaBaseInputDto input;
    private boolean fromPreview;

    public BcmMultiLineExCalculate(DatasetDto dto, boolean fromPreview) {
        this.dto = dto;
        this.fromPreview = fromPreview;
    }

    @Override
    public Object getResult(Map<String, Object> varParams, Map<String, Set<String>> dimParams, AnalysisDataHandler handler, Map<String, String> fillProperty) {
        this.beforeCalculate(varParams, dimParams, handler);
        this.fillPropertyMap = fillProperty;
        Object calculate = this.getExResult(this.input);
        return this.afterCalculate(calculate);
    }

    @Override
    protected Object exFillBack(ExtendsResultSet edResultSet, Map<String, String> selectMap, Map<String, String> fieldcals) {
        if (CollectionUtils.isEmpty((Collection)edResultSet.getRows())) {
            return Collections.emptyList();
        }
        String cube = BCMMemberReader.findModelNumberByShowNum(this.input.getModelShowNumber());
        Map<String, String> shortNumber2Num = BCMMemberReader.getDimensionShortNumber2NumberMap(cube);
        HashMap<String, String> nima = new HashMap<String, String>(12);
        nima.put("SE", "SourceEntity");
        if (shortNumber2Num != null) {
            nima.putAll(shortNumber2Num);
        }
        nima.put("SE", "SourceEntity");
        List<String> groupList = this.input.getGroupList().stream().map(nima::get).collect(Collectors.toList());
        List<String> orderList = this.input.getOrderList().stream().map(order -> nima.getOrDefault(order, (String)order)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(groupList) && CollectionUtils.isEmpty(orderList)) {
            List<LinkedHashMap<String, Object>> result = this.getSimpleResult(edResultSet, selectMap, fieldcals);
            return this.subList(result, this.input.getTop());
        }
        ArrayList measureList = Lists.newArrayList(fieldcals.keySet());
        List<String> selectList = this.getColumns(edResultSet);
        List<DataSetResult> dataSets = null;
        DataSetArrangeUtil dsau = new DataSetArrangeUtil();
        if (CollectionUtils.isEmpty(groupList)) {
            dataSets = this.buildDataSetResult(selectList, orderList, edResultSet, (List<String>)measureList);
        } else {
            dataSets = this.buildDataSetResult(groupList, orderList, edResultSet, (List<String>)measureList);
            dataSets = dsau.groupbySum(dataSets);
        }
        if (!CollectionUtils.isEmpty(orderList)) {
            dsau.sort(this.dto.getAsc(), dataSets, measureList);
        }
        List<Object> result = new ArrayList(2);
        result = CollectionUtils.isEmpty(groupList) ? (List)dsau.getResultByDataSet(selectList, dataSets, -1, measureList) : (List)dsau.getResultByDataSet(groupList, dataSets, -1, measureList);
        result = this.subList(result, this.input.getTop());
        return result;
    }

    public void buildExSourceEntity(FormulaBaseInputDto input, List<LinkedHashMap<String, Object>> res) {
    }

    private List<DataSetResult> buildDataSetResult(List<String> groupList, List<String> orderList, ExtendsResultSet edResultSet, List<String> measureList) {
        LinkedList<DataSetResult> dsrs = new LinkedList<DataSetResult>();
        for (Object obj : edResultSet.getRows()) {
            Map itemMap = (Map)obj;
            if (itemMap == null) continue;
            DataSetResult dsr = new DataSetResult();
            for (String group : groupList) {
                dsr.addGroupList((String)itemMap.get(group));
                if (this.dimMembers.containsKey(group)) {
                    ((Set)this.dimMembers.get(group)).add((String)itemMap.get(group));
                    continue;
                }
                this.dimMembers.put(group, Sets.newHashSet((Object[])new Object[]{(String)itemMap.get(group)}));
            }
            for (String order : orderList) {
                if (this.input.getMoneyList().contains(order) && measureList.contains(order)) {
                    dsr.addOrderList(order);
                    continue;
                }
                dsr.addOrderList((String)itemMap.get(order));
            }
            for (String fieldCal : measureList) {
                dsr.addMeasureList((String)itemMap.get(fieldCal));
            }
            dsrs.add(dsr);
        }
        return dsrs;
    }

    private List<String> getColumns(ExtendsResultSet edResultSet) {
        int columnSize = edResultSet.getExtendsQueryInfo().getDimselects().length + edResultSet.getExtendsQueryInfo().getExtselects().length;
        ArrayList<String> columns = new ArrayList<String>(columnSize);
        for (String item : edResultSet.getExtendsQueryInfo().getDimselects()) {
            columns.add(item);
        }
        for (String item : edResultSet.getExtendsQueryInfo().getExtselects()) {
            columns.add(item);
        }
        return columns;
    }

    private List<LinkedHashMap<String, Object>> getSimpleResult(ExtendsResultSet edResultSet, Map<String, String> selectMap, Map<String, String> fieldcals) {
        List<String> columns = this.getColumns(edResultSet);
        int columnSize = columns.size();
        ArrayList result = Lists.newArrayListWithCapacity((int)edResultSet.getRows().size());
        for (Object row : edResultSet.getRows()) {
            if (row == null || !(row instanceof Map)) continue;
            Map rowMap = (Map)row;
            LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)columnSize);
            for (String mdName : columns) {
                String value;
                String string = value = rowMap.get(mdName) == null ? null : rowMap.get(mdName).toString();
                if (DimTypesEnum.ENTITY.getNumber().equals(mdName) && value != null && value.contains("_")) {
                    value = value.split("_")[1];
                }
                if (this.dimMembers.containsKey(mdName)) {
                    ((Set)this.dimMembers.get(mdName)).add(value);
                } else {
                    this.dimMembers.put(mdName, Sets.newHashSet((Object[])new Object[]{value}));
                }
                if (fieldcals.containsKey(mdName)) {
                    if (value == null) continue;
                    if (value.contains("E") || value.contains("e")) {
                        map.put(mdName, new BigDecimal(value).stripTrailingZeros());
                        continue;
                    }
                    map.put(mdName, new BigDecimal(value));
                    continue;
                }
                String res = selectMap.getOrDefault(mdName, value);
                map.put(mdName, res);
            }
            result.add(map);
        }
        return result;
    }

    @Override
    public void beforeCalculate(Object ... params) {
        this.input = new MutiLineExInputInput().create(this.dto, params);
        this.handlerData(this.dto, this.input, params[1], params[2]);
        this.beforeSelectPermFilter(this.input);
    }

    @Override
    public Object afterCalculate(Object ... params) {
        Object result = this.afterSelectPermFilter(this.input, params[0]);
        List<LinkedHashMap<String, Object>> res = (List<LinkedHashMap<String, Object>>)result;
        if (CollectionUtils.isEmpty((Collection)res)) {
            return res;
        }
        Map<String, Pair<String, Map<String, String>>> map = this.buildPropertyMap(this.input.getModelId(), this.input.getPropertyList());
        this.addColumns(map, this.getCalculateList(this.dto), res);
        HashMap columns = Maps.newHashMapWithExpectedSize((int)this.dimMembers.size());
        for (Map.Entry entry : ((LinkedHashMap)res.get(0)).entrySet()) {
            columns.put(entry.getKey(), new Pair((Object)DataType.StringType, Collections.emptySet()));
        }
        for (Map.Entry entry : this.dimMembers.entrySet()) {
            columns.put(entry.getKey(), new Pair((Object)DataType.StringType, entry.getValue()));
        }
        res = this.join(this.getJoinList(this.dto), res, columns);
        this.hideColumn(this.input.getData(), res);
        if (!this.fromPreview) {
            res = this.hasProperty(res) ? DatasetMemberHelper.menberWithName(res, this.dto.getDataSrcId(), this.dto.getExtendsModelId()) : this.fillProperty(res);
        }
        return res;
    }

    @Override
    public Map<Long, String> getOriException() {
        HashMap returnMap = Maps.newHashMap();
        returnMap.put(this.dto.getId(), this.getSingleException(this.dto));
        return returnMap;
    }

    @Override
    public void setHasAllDim(Set<String> hasAllDim) {
        this.hasAllDim = hasAllDim;
    }

    @Override
    public void setHasSourceOrg(boolean hasOrg) {
        this.hasSourceOrg = hasOrg;
    }
}

