/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.cal;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.epm.far.business.common.dataset.calculate.base.IDataSetCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.BcmCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.FormulaCalculateService;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaBaseInputDto;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaCalculateInputDto;
import kd.epm.far.business.common.dataset.calculate.input.SingleValueInputInput;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.far.model.AnalysisDataHandler;
import org.apache.commons.collections.CollectionUtils;

public class BcmSingleValueCalculate
extends BcmCalculate
implements IDataSetCalculate {
    private FormulaBaseInputDto input;

    public BcmSingleValueCalculate(Long calcId, DatasetDto dto) {
        this.calcId = calcId;
        this.dto = dto;
    }

    @Override
    public Object getResult(Map<String, Object> varParams, Map<String, Set<String>> dimParams, AnalysisDataHandler handler, Map<String, String> fillProperty) {
        this.beforeCalculate(varParams, dimParams);
        if (!this.checkPerm(this.input.getContent(), this.input.getModelId())) {
            return "***";
        }
        Object result = this.getResult(this.input, this.dto);
        return this.afterCalculate(result);
    }

    @Override
    public void beforeCalculate(Object ... params) {
        this.input = new SingleValueInputInput().create(this.dto, params);
    }

    @Override
    public Object afterCalculate(Object ... params) {
        return params[0];
    }

    @Override
    public Map<Long, String> getOriException() {
        HashMap returnMap = Maps.newHashMap();
        returnMap.put(this.dto.getId(), this.getSingleException(this.dto));
        return returnMap;
    }

    @Override
    public void setHasAllDim(Set<String> hasAllDim) {
        this.hasAllDim = hasAllDim;
    }

    @Override
    protected Object fillBack(FormulaCalculateService calculateService, FormulaCalculateInputDto formulaInput, List<LinkedHashMap<String, Object>> result) {
        if (Objects.isNull(result)) {
            return "***";
        }
        BigDecimal bg = new BigDecimal(0);
        if (CollectionUtils.isEmpty(result)) {
            return bg;
        }
        boolean onlyOneData = result.size() == 1;
        for (LinkedHashMap<String, Object> next : result) {
            Object v = next.get("FMONEY");
            if (v == null) continue;
            if (v instanceof String && (v.toString().trim().equals("-") || v.toString().trim().equals("\uff0d"))) {
                v = 0;
            }
            try {
                bg = bg.add(new BigDecimal(v.toString()));
            }
            catch (Exception e) {
                if (onlyOneData) {
                    return v;
                }
                return "#VALUE!";
            }
        }
        return bg;
    }
}

