/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.cal;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.dto.ExtendsResultSet;
import kd.epm.far.business.common.dataset.calculate.base.IDataSetCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.BcmCalculate;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaBaseInputDto;
import kd.epm.far.business.common.dataset.calculate.input.SingleValueExInputInput;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.far.model.AnalysisDataHandler;
import org.apache.commons.collections.CollectionUtils;

public class BcmSingleValueExCalculate
extends BcmCalculate
implements IDataSetCalculate {
    private FormulaBaseInputDto input;

    public BcmSingleValueExCalculate(DatasetDto dto) {
        this.dto = dto;
    }

    @Override
    public Object getResult(Map<String, Object> varParams, Map<String, Set<String>> dimParams, AnalysisDataHandler handler, Map<String, String> fillProperty) {
        this.beforeCalculate(varParams, dimParams);
        if (!this.checkPerm(this.input.getContent(), this.input.getModelId())) {
            return "***";
        }
        Object calculate = this.getExResult(this.input);
        return this.afterCalculate(calculate);
    }

    @Override
    protected Object exFillBack(ExtendsResultSet edResultSet, Map<String, String> selectMap, Map<String, String> fieldcals) {
        BigDecimal result = new BigDecimal(0);
        if (CollectionUtils.isEmpty((Collection)edResultSet.getRows())) {
            return result;
        }
        boolean onlyOneData = edResultSet.getRows().size() == 1;
        String fMoney = this.input.getFmoney();
        String key = edResultSet.getExtendsQueryInfo().getExtselects()[0];
        if (StringUtils.isNotEmpty((String)fMoney)) {
            key = fMoney;
        }
        for (Object row : edResultSet.getRows()) {
            Map rowMap;
            Object v;
            if (row == null || !(row instanceof Map) || (v = (rowMap = (Map)row).get(key)) == null) continue;
            if (v instanceof String && (v.toString().trim().equals("-") || v.toString().trim().equals("\uff0d"))) {
                v = 0;
            }
            try {
                result = result.add(new BigDecimal(v.toString()));
            }
            catch (Exception e) {
                if (onlyOneData) {
                    return v;
                }
                return "#VALUE!";
            }
        }
        return result;
    }

    @Override
    public void beforeCalculate(Object ... params) {
        this.input = new SingleValueExInputInput().create(this.dto, params);
    }

    @Override
    public Object afterCalculate(Object ... params) {
        return params[0];
    }

    @Override
    public Map<Long, String> getOriException() {
        HashMap returnMap = Maps.newHashMap();
        returnMap.put(this.dto.getId(), this.getSingleException(this.dto));
        return returnMap;
    }

    @Override
    public void setHasAllDim(Set<String> hasAllDim) {
        this.hasAllDim = hasAllDim;
    }
}

