/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.cal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.common.dataset.calculate.base.IDataSetCalculate;
import kd.epm.far.business.common.dataset.calculate.dto.TemplateInput;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.util.DatasetMemberHelper;
import kd.epm.far.business.far.model.AnalysisDataHandler;
import kd.epm.far.common.common.Pair;
import org.apache.commons.collections.CollectionUtils;

public class BcmTemplateCalculate
implements IDataSetCalculate {
    protected Long calcId;
    private DatasetDto dto;
    private TemplateInput input;
    private boolean fromPreview;
    protected Map<String, Set<Object>> dimMembers = Maps.newHashMapWithExpectedSize((int)16);

    public BcmTemplateCalculate(Long calcId, DatasetDto dto, boolean fromPreview) {
        this.calcId = calcId;
        this.dto = dto;
        this.fromPreview = fromPreview;
    }

    @Override
    public Object getResult(Map<String, Object> varParams, Map<String, Set<String>> dimParams, AnalysisDataHandler handler, Map<String, String> fillProperty) {
        this.beforeCalculate(varParams, dimParams);
        Object result = BCMMsServiceHelper.getTemplateData(this.input.getTemplateId(), this.input.getEntendNumber(), this.input.getDimMap(), this.input.getOrgs());
        return this.afterCalculate(result);
    }

    @Override
    public void beforeCalculate(Object ... params) {
        this.input = new TemplateInput().create(this.dto, params);
    }

    @Override
    public Object afterCalculate(Object ... params) {
        Object result = params[0];
        List<LinkedHashMap<String, Object>> res = (List<LinkedHashMap<String, Object>>)result;
        if (CollectionUtils.isEmpty((Collection)res)) {
            return res;
        }
        Set keySet = ((LinkedHashMap)res.get(0)).keySet();
        HashSet repeatKey = Sets.newHashSetWithExpectedSize((int)res.size());
        Iterator iterator = res.iterator();
        while (iterator.hasNext()) {
            Map next = (Map)iterator.next();
            StringBuilder sb = new StringBuilder();
            for (String s : keySet) {
                Object o = next.get(s);
                sb.append(o).append("#");
                if (this.dimMembers.containsKey(s)) {
                    this.dimMembers.get(s).add(next.get(s));
                    continue;
                }
                this.dimMembers.put(s, Sets.newHashSet((Object[])new Object[]{next.get(s)}));
            }
            if (repeatKey.add(sb.toString())) continue;
            iterator.remove();
        }
        this.addColumns(Collections.emptyMap(), this.getCalculateList(this.dto), res);
        HashMap columns = Maps.newHashMapWithExpectedSize((int)this.dimMembers.size());
        for (Map.Entry<String, Set<Object>> entry : this.dimMembers.entrySet()) {
            columns.put(entry.getKey(), new Pair((Object)DataType.StringType, entry.getValue()));
        }
        res = this.join(this.getJoinList(this.dto), res, columns);
        if (!this.fromPreview) {
            res = DatasetMemberHelper.menberWithName(res, this.dto.getDataSrcId(), this.dto.getExtendsModelId());
        }
        this.hideColumn(this.dto.getData(), res);
        return res;
    }

    @Override
    public Map<Long, String> getOriException() {
        HashMap returnMap = Maps.newHashMap();
        returnMap.put(this.dto.getId(), this.getSingleException(this.dto));
        return returnMap;
    }

    @Override
    public void setHasAllDim(Set<String> hasAllDim) {
    }
}

