/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.cal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.calculate.base.IDataSetCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.BcmMultiLineCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.BcmMultiLineExCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.BcmSingleValueCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.BcmSingleValueExCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.BcmTemplateCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.EPMVoucherCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.EPMVoucherSingleCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.EbMultiLineCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.EbSingleValueCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.MetadataCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.MetadataSingleValueCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.MutilValueCalculate;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetMetadataVo;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.util.LongUtil;

public class CalculateStrategy {
    public static IDataSetCalculate getStrategy(Long caclId, DynamicObject ds, boolean fromPreview) {
        DataSetTypeEnum typeEnum = DataSetTypeEnum.getEnumByType(ds.getString("type"));
        switch (typeEnum) {
            case MULTIPLE_VALUED: {
                return new MutilValueCalculate(caclId, ds);
            }
            case SINGLE_VALUED: {
                DatasetDto dto = DatasetUtil.getSingleDataSetDto(ds.getLong("id"));
                return CalculateStrategy.getSingleCalculate(caclId, dto, fromPreview);
            }
            case MULTIPLE_ROW: {
                DatasetDto dto = DatasetUtil.getSingleDataSetDto(ds.getLong("id"));
                return CalculateStrategy.getMultiCalculate(caclId, dto, fromPreview);
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u53d6\u6570\u7c7b\u578b\u3002", (String)"CalculateStrategy_0", (String)"epm-far-business", (Object[])new Object[0]));
    }

    public static IDataSetCalculate getStrategy(Long caclId, DatasetDto dto, boolean fromPreview, DataSetTypeEnum typeEnum) {
        switch (typeEnum) {
            case SINGLE_VALUED: {
                return CalculateStrategy.getSingleCalculate(caclId, dto, fromPreview);
            }
            case MULTIPLE_ROW: {
                return CalculateStrategy.getMultiCalculate(caclId, dto, fromPreview);
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u53d6\u6570\u7c7b\u578b\u3002", (String)"CalculateStrategy_0", (String)"epm-far-business", (Object[])new Object[0]));
    }

    private static IDataSetCalculate getMultiCalculate(Long caclId, DatasetDto dto, boolean fromPreview) {
        if (CalculateStrategy.checkIsEb(dto)) {
            return new EbMultiLineCalculate(dto, fromPreview);
        }
        if (CalculateStrategy.checkIsTemplate(dto)) {
            return new BcmTemplateCalculate(caclId, dto, fromPreview);
        }
        if (CalculateStrategy.checkIsMetadata(dto)) {
            return new MetadataCalculate(dto, fromPreview);
        }
        if (CalculateStrategy.checkIsVoucher(dto)) {
            return new EPMVoucherCalculate(dto, fromPreview);
        }
        if (CalculateStrategy.checkIsExtends(dto)) {
            return new BcmMultiLineExCalculate(dto, fromPreview);
        }
        return new BcmMultiLineCalculate(caclId, dto, fromPreview);
    }

    private static boolean checkIsVoucher(DatasetDto dto) {
        return Objects.nonNull(dto.getVoucherNumber()) && Objects.nonNull(dto.getVoucherType());
    }

    private static boolean checkIsTemplate(DatasetDto dto) {
        String dataSrcType = dto.getDataSrcType();
        return Objects.equals(DataSrcTypeEnum.CM_TEMPLATE.getType(), dataSrcType);
    }

    private static boolean checkIsMetadata(DatasetDto dto) {
        DatasetDataVo datasetDataVo;
        DatasetMetadataVo datasetMetadataVo;
        String data = dto.getData();
        return StringUtils.isNotEmpty((String)data) && Objects.nonNull(datasetMetadataVo = (datasetDataVo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0])).getMetadata()) && (Objects.nonNull(datasetMetadataVo.getMetadataId()) || Objects.nonNull(datasetMetadataVo.getMetadataType()));
    }

    private static IDataSetCalculate getSingleCalculate(Long caclId, DatasetDto dto, Boolean fromPreview) {
        if (CalculateStrategy.checkIsEb(dto)) {
            return new EbSingleValueCalculate(dto);
        }
        if (CalculateStrategy.checkIsExtends(dto)) {
            return new BcmSingleValueExCalculate(dto);
        }
        if (CalculateStrategy.checkIsMetadata(dto)) {
            return new MetadataSingleValueCalculate(dto, fromPreview);
        }
        if (CalculateStrategy.checkIsVoucher(dto)) {
            return new EPMVoucherSingleCalculate(dto, fromPreview);
        }
        return new BcmSingleValueCalculate(caclId, dto);
    }

    private static boolean checkIsEb(DatasetDto dto) {
        String dataSrcType = dto.getDataSrcType();
        return Objects.equals((Object)DisModelTypeEnum.EB, (Object)DisModelTypeEnum.getModelType(dataSrcType, dto.getDataSrcId()));
    }

    private static boolean checkIsExtends(DatasetDto dto) {
        return LongUtil.isvalidLong((Object)dto.getExtendsModelId());
    }
}

