/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.cal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.dataset.calculate.DataSetArrangeUtil;
import kd.epm.far.business.common.dataset.calculate.base.IDataSetCalculate;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaBaseInputDto;
import kd.epm.far.business.common.dataset.dto.DataSetResult;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.eb.dto.EbBatchMember;
import kd.epm.far.business.eb.dto.EbDim;
import kd.epm.far.business.eb.dto.EbMember;
import kd.epm.far.common.common.enums.FacTabFieldDefEnum;
import org.apache.commons.collections.CollectionUtils;

public abstract class EPMCalculate
implements IDataSetCalculate {
    protected boolean fromPreview;
    protected Map<String, Map<String, String>> numberMap;
    protected Map<String, Set<Object>> dimMembers = Maps.newHashMapWithExpectedSize((int)16);

    public Object getReslut(String modelNumber, String dataSetNumber, FormulaBaseInputDto inputDto, boolean isMultiLine) {
        List<Map<String, String>> memberListByExpression = DatasetExpressionHelper.getMemberListByExpression(inputDto.getContent());
        EbBatchMember ebBatchMember = EbServiceHelper.batchGetMembers(modelNumber, dataSetNumber, memberListByExpression);
        List<EbDim> ebdims = EbServiceHelper.getDim(modelNumber, dataSetNumber);
        Map<String, String> shortMap = ebdims.stream().collect(Collectors.toMap(EbDim::getShortNumber, EbDim::getNumber, (k1, k2) -> k1));
        List<List<EbMember>> result = ebBatchMember.getResult();
        HashMap dimMemberMap = Maps.newHashMapWithExpectedSize((int)result.size());
        this.numberMap = Maps.newHashMapWithExpectedSize((int)16);
        for (List<EbMember> members : result) {
            if (CollectionUtils.isEmpty(members)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u96c6\u5b58\u5728\u65e0\u6743\u6210\u5458\u3002", (String)"EbServiceHelper_06", (String)"epm-far-business", (Object[])new Object[0]));
            }
            EbMember ebMember = members.get(0);
            String dimNumber = ebMember.getDimNumber();
            String number = ebMember.getNumber();
            List valueList = dimMemberMap.getOrDefault(shortMap.get(dimNumber), Lists.newArrayListWithCapacity((int)members.size()));
            valueList.addAll(members.stream().map(EbMember::getNumber).collect(Collectors.toList()));
            List collect = valueList.stream().distinct().collect(Collectors.toList());
            dimMemberMap.put(shortMap.get(dimNumber), collect);
            if (this.fromPreview) continue;
            this.numberMap.computeIfAbsent(shortMap.get(dimNumber), k -> new HashMap()).put(number, ebMember.getName());
        }
        Object data = EbServiceHelper.getReslut(modelNumber, dataSetNumber, dimMemberMap);
        if (isMultiLine) {
            return this.resultHandler(data, inputDto, shortMap, dimMemberMap);
        }
        return data;
    }

    private List<DataSetResult> buildDataSetResult(List<Integer> groupList, List<Integer> orderList, LinkedList<Object> list) {
        LinkedList<DataSetResult> dsrs = new LinkedList<DataSetResult>();
        DataSetResult dsr = null;
        for (Object e : list) {
            int i;
            Object[] data = (Object[])e;
            dsr = new DataSetResult();
            for (i = 0; i < groupList.size(); ++i) {
                dsr.addGroupList(data[groupList.get(i) + 1].toString());
            }
            for (i = 0; i < orderList.size(); ++i) {
                dsr.addOrderList(data[orderList.get(i) + 1].toString());
            }
            dsr.addMeasureList(String.valueOf(data[0]));
            dsrs.add(dsr);
        }
        return dsrs;
    }

    private Object resultHandler(Object reslut, FormulaBaseInputDto input, Map<String, String> shortMap, Map<String, List<String>> dimMemberMap) {
        LinkedList list = (LinkedList)reslut;
        List<Object> result = Lists.newArrayListWithExpectedSize((int)list.size());
        List<String> fields = Arrays.asList((String[])list.get(0));
        list.removeFirst();
        if (CollectionUtils.isEmpty(input.getGroupList()) && CollectionUtils.isEmpty(input.getOrderList())) {
            for (Object o : list) {
                Object[] data = (Object[])o;
                LinkedHashMap resultMap = Maps.newLinkedHashMapWithExpectedSize((int)data.length);
                for (int i = 0; i < fields.size(); ++i) {
                    String numberKey = fields.get(i);
                    Object value = data[i + 1];
                    if (!dimMemberMap.containsKey(numberKey)) continue;
                    if (this.dimMembers.containsKey(numberKey)) {
                        this.dimMembers.get(numberKey).add(value);
                    } else {
                        this.dimMembers.put(numberKey, Sets.newHashSet((Object[])new Object[]{value}));
                    }
                    resultMap.put(numberKey, value);
                }
                resultMap.put("FMONEY", data[0]);
                result.add(resultMap);
            }
            result = this.subList((List<LinkedHashMap<String, Object>>)result, input.getTop());
            return result;
        }
        List<DataSetResult> dataSets = null;
        DataSetArrangeUtil dsau = new DataSetArrangeUtil();
        List<String> groupList = input.getGroupList().stream().map(shortMap::get).collect(Collectors.toList());
        List<String> orderList = input.getOrderList().stream().map(shortMap::get).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(input.getGroupList())) {
            dataSets = this.buildDataSetResult(this.getIndex(fields, fields), this.getIndex(fields, orderList), list);
        } else {
            dataSets = this.buildDataSetResult(this.getIndex(fields, groupList), this.getIndex(fields, orderList), list);
            dataSets = dsau.groupbySum(dataSets);
        }
        LinkedList<String> measureList = new LinkedList<String>();
        measureList.add(FacTabFieldDefEnum.FIELD_MONEY.getField());
        if (!CollectionUtils.isEmpty(orderList)) {
            dsau.sort(input.getIsAsc() ? "1" : "0", dataSets, measureList);
        }
        result = CollectionUtils.isEmpty(groupList) ? (List)dsau.getResultByDataSet(fields, dataSets, -1, measureList) : (List)dsau.getResultByDataSet(groupList, dataSets, -1, measureList);
        return result;
    }

    private List<Integer> getIndex(List<String> ori, List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList returnList = Lists.newArrayListWithExpectedSize((int)list.size());
        for (String s : list) {
            int i = ori.indexOf(s);
            returnList.add(i);
        }
        return returnList;
    }
}

