/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.cal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.dataset.calculate.DataSetArrangeUtil;
import kd.epm.far.business.common.dataset.calculate.base.IDataSetCalculate;
import kd.epm.far.business.common.dataset.dto.DataSetResult;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.epm.EPMServiceHelper;
import kd.epm.far.business.epm.dto.EPMVoucherFieldVo;
import kd.epm.far.business.far.model.AnalysisDataHandler;
import kd.epm.far.common.common.Pair;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class EPMVoucherCalculate
implements IDataSetCalculate {
    DatasetDto dto;
    private boolean fromPreview;

    public EPMVoucherCalculate(DatasetDto dto, boolean fromPreview) {
        this.dto = dto;
        this.fromPreview = fromPreview;
    }

    @Override
    public Object getResult(Map<String, Object> varParams, Map<String, Set<String>> dimParams, AnalysisDataHandler handler, Map<String, String> fillProperty) {
        String data = this.dto.getData();
        if (Objects.isNull(data)) {
            return Collections.emptyList();
        }
        DatasetDataVo datasetDataVo = null;
        try {
            datasetDataVo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception exception) {
            throw new KDBizException(exception.getMessage());
        }
        List<DatasetPropertyVo> properties = datasetDataVo.getColumns();
        if (CollectionUtils.isEmpty(properties)) {
            return Collections.emptyList();
        }
        String number = datasetDataVo.getDatasetVoucherVo().getVoucherNumber();
        List<Map<String, Object>> queryResult = EPMServiceHelper.queryResult(number, properties);
        List<LinkedHashMap<String, Object>> result = this.fillBack(queryResult, properties);
        return this.afterCalculate(result, fillProperty);
    }

    public List<LinkedHashMap<String, Object>> fillBack(List<Map<String, Object>> result, List<DatasetPropertyVo> properties) {
        List res = Lists.newArrayListWithExpectedSize((int)result.size());
        for (Map<String, Object> map : result) {
            LinkedHashMap linkedMap = Maps.newLinkedHashMapWithExpectedSize((int)map.size());
            linkedMap.putAll(map);
            res.add(linkedMap);
        }
        List<String> groupList = this.getListByStr(this.dto.getGroupBy());
        List<String> orderList = this.getListByStr(this.dto.getOrderBy());
        if (CollectionUtils.isEmpty(groupList) && CollectionUtils.isEmpty(orderList)) {
            return this.subList(res, Objects.isNull(this.dto.getTop()) ? 0 : this.dto.getTop());
        }
        List<String> selectList = properties.stream().map(DatasetPropertyVo::getNumber).collect(Collectors.toList());
        List<String> measureList = this.getListByStr(this.dto.getValue());
        List<DataSetResult> dataSets = null;
        DataSetArrangeUtil dsau = new DataSetArrangeUtil();
        if (CollectionUtils.isEmpty(groupList)) {
            dataSets = this.buildDataSetResult(selectList, orderList, res, measureList);
        } else {
            dataSets = this.buildDataSetResult(groupList, orderList, res, measureList);
            dataSets = dsau.groupbySum(dataSets);
        }
        if (!CollectionUtils.isEmpty(orderList)) {
            String isAsc = this.dto.getAsc();
            dsau.sort(isAsc, dataSets, measureList);
        }
        res = CollectionUtils.isEmpty(groupList) ? (List)dsau.getResultByDataSet(selectList, dataSets, -1, measureList) : (List)dsau.getResultByDataSet(groupList, dataSets, -1, measureList);
        return this.subList(res, Objects.isNull(this.dto.getTop()) ? 0 : this.dto.getTop());
    }

    @Override
    public void beforeCalculate(Object ... params) {
    }

    private List<String> getListByStr(String key) {
        if (StringUtils.isBlank((String)key)) {
            return Collections.emptyList();
        }
        String[] split = key.split(",");
        ArrayList returnList = Lists.newArrayListWithCapacity((int)split.length);
        for (String s : split) {
            if (!StringUtils.isNotBlank((String)s)) continue;
            returnList.add(s);
        }
        return returnList;
    }

    @Override
    public Object afterCalculate(Object ... params) {
        List<LinkedHashMap<String, Object>> res = (List<LinkedHashMap<String, Object>>)params[0];
        if (CollectionUtils.isEmpty((Collection)res)) {
            return res;
        }
        String data = this.dto.getData();
        if (Objects.isNull(data)) {
            return res;
        }
        DatasetDataVo datasetDataVo = null;
        try {
            datasetDataVo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception exception) {
            throw new KDBizException(exception.getMessage());
        }
        this.addColumns(Collections.emptyMap(), this.getCalculateList(this.dto), res);
        List<EPMVoucherFieldVo> epmVoucherFieldVos = EPMServiceHelper.getField(datasetDataVo.getDatasetVoucherVo().getId());
        Map<String, Pair<DataType, Set<Object>>> numberMap = epmVoucherFieldVos.stream().collect(Collectors.toMap(EPMVoucherFieldVo::getNumber, t -> {
            if (t.getType().equals("bigint") || t.getType().equals("long")) {
                return new Pair((Object)DataType.LongType, Collections.emptySet());
            }
            if (t.getType().equals("decimal")) {
                return new Pair((Object)DataType.BigDecimalType, Collections.emptySet());
            }
            if (t.getType().equals("integer") || t.getType().equals("int")) {
                return new Pair((Object)DataType.IntegerType, Collections.emptySet());
            }
            if (t.getType().equals("double")) {
                return new Pair((Object)DataType.DoubleType, Collections.emptySet());
            }
            return new Pair((Object)DataType.StringType, Collections.emptySet());
        }, (k1, k2) -> k1));
        res = this.join(this.getJoinList(this.dto), res, numberMap);
        this.hideColumn(this.dto.getData(), res);
        this.afterGetDataList(res, (Map)params[1]);
        return res;
    }

    private void afterGetDataList(List<LinkedHashMap<String, Object>> dataList, Map<String, String> fillProperty) {
        block6: {
            if (dataList.size() <= 0 || this.fromPreview) break block6;
            if (Objects.nonNull(fillProperty) && fillProperty.size() > 0) {
                Set<Map.Entry<String, String>> entrys = fillProperty.entrySet();
                for (Map map : dataList) {
                    for (Map.Entry<String, String> entry : entrys) {
                        String key = entry.getKey();
                        if (map.get(key) == null || !(map.get(key) instanceof String)) continue;
                        String value = (String)map.get(key);
                        map.put(key, value + ";" + value);
                    }
                }
            } else {
                for (Map map : dataList) {
                    Set set = map.entrySet();
                    for (Map.Entry entry : set) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (map.get(key) == null) continue;
                        map.put(key, value + ";" + value);
                    }
                }
            }
        }
    }

    @Override
    public Map<Long, String> getOriException() {
        return null;
    }

    @Override
    public void setHasAllDim(Set<String> hasAllDim) {
    }
}

