/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.cal;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.epm.far.business.common.dataset.calculate.base.IDataSetCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.EPMCalculate;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaBaseInputDto;
import kd.epm.far.business.common.dataset.calculate.input.EbMutiLineInput;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.util.DatasetRowHelper;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.far.model.AnalysisDataHandler;
import kd.epm.far.common.common.Pair;

public class EbMultiLineCalculate
extends EPMCalculate
implements IDataSetCalculate {
    protected DatasetDto dto;
    private FormulaBaseInputDto input;
    protected Map<String, String> fillPropertyMap;

    public EbMultiLineCalculate(DatasetDto dto, boolean fromPreview) {
        this.dto = dto;
        this.fromPreview = fromPreview;
    }

    public Object getResult() {
        DynamicObject model = EbServiceHelper.getModel(this.dto.getDataSrcId());
        return this.getReslut(model.getString("shownumber"), this.dto.getEbDataset(), this.input, true);
    }

    @Override
    public Object getResult(Map<String, Object> varParams, Map<String, Set<String>> dimParams, AnalysisDataHandler handler, Map<String, String> fillProperty) {
        this.beforeCalculate(varParams, dimParams, handler);
        this.fillPropertyMap = fillProperty;
        Object calculate = this.getResult();
        return this.afterCalculate(calculate);
    }

    @Override
    public void beforeCalculate(Object ... params) {
        this.input = new EbMutiLineInput().create(this.dto, params);
    }

    @Override
    public Object afterCalculate(Object ... params) {
        List<LinkedHashMap<String, Object>> res = (List<LinkedHashMap<String, Object>>)params[0];
        if (CollectionUtils.isEmpty((Collection)res)) {
            return res;
        }
        if (CollectionUtils.isEmpty(res = DatasetRowHelper.rowTransferHandler(this.dto, res, this.fromPreview))) {
            return res;
        }
        res = this.subList(res, this.input.getTop());
        this.addColumns(Collections.emptyMap(), this.getCalculateList(this.dto), res);
        HashMap columns = Maps.newHashMapWithExpectedSize((int)this.dimMembers.size());
        for (Map.Entry<String, Object> entry : res.get(0).entrySet()) {
            columns.put(entry.getKey(), new Pair((Object)DataType.StringType, Collections.emptySet()));
        }
        for (Map.Entry<String, Object> entry : this.dimMembers.entrySet()) {
            columns.put(entry.getKey(), new Pair((Object)DataType.StringType, entry.getValue()));
        }
        res = this.join(this.getJoinList(this.dto), res, columns);
        if (!this.fromPreview) {
            Iterator<LinkedHashMap<String, Object>> iterator = res.iterator();
            block2: while (iterator.hasNext()) {
                Map map = iterator.next();
                if (this.fillPropertyMap != null && !this.fillPropertyMap.isEmpty()) {
                    for (Map.Entry<Object, Object> entry : this.fillPropertyMap.entrySet()) {
                        if (Objects.isNull(map.get(entry.getValue()))) {
                            iterator.remove();
                            continue block2;
                        }
                        String newValue = map.get(entry.getKey()).toString() + ";" + map.get(entry.getValue()).toString();
                        map.put(entry.getKey(), newValue);
                    }
                    continue;
                }
                for (Map.Entry entry : map.entrySet()) {
                    Map map2 = (Map)this.numberMap.get(entry.getKey());
                    if (Objects.isNull(map2)) {
                        entry.setValue(entry.getValue());
                        continue;
                    }
                    entry.setValue(entry.getValue() + ";" + (String)map2.get(entry.getValue().toString()));
                }
            }
            return res;
        }
        return res;
    }

    @Override
    public Map<Long, String> getOriException() {
        HashMap returnMap = Maps.newHashMap();
        returnMap.put(this.dto.getId(), this.getSingleException(this.dto));
        return returnMap;
    }

    @Override
    public void setHasAllDim(Set<String> hasAllDim) {
    }
}

