/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.cal;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.far.business.common.dataset.calculate.cal.EPMCalculate;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaBaseInputDto;
import kd.epm.far.business.common.dataset.calculate.input.EbSingleValueInput;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.far.model.AnalysisDataHandler;
import org.apache.commons.collections.CollectionUtils;

public class EbSingleValueCalculate
extends EPMCalculate {
    protected DatasetDto dto;
    private FormulaBaseInputDto input;

    public EbSingleValueCalculate(DatasetDto dto) {
        this.dto = dto;
    }

    public Object getResult() {
        DynamicObject model = EbServiceHelper.getModel(this.dto.getDataSrcId());
        return this.getReslut(model.getString("shownumber"), this.dto.getEbDataset(), this.input, false);
    }

    @Override
    public Object getResult(Map<String, Object> varParams, Map<String, Set<String>> dimParams, AnalysisDataHandler handler, Map<String, String> fillProperty) {
        this.beforeCalculate(varParams, dimParams);
        Object calculate = this.getResult();
        return this.afterCalculate(calculate);
    }

    @Override
    public void beforeCalculate(Object ... params) {
        this.input = new EbSingleValueInput().create(this.dto, params);
    }

    @Override
    public Object afterCalculate(Object ... params) {
        BigDecimal bg = new BigDecimal(0);
        LinkedList result = (LinkedList)params[0];
        if (CollectionUtils.isEmpty((Collection)result)) {
            return bg;
        }
        result.removeFirst();
        boolean onlyOneData = result.size() == 1;
        for (Object v : result) {
            if (Objects.isNull(v)) continue;
            Object[] data = (Object[])v;
            String value = data[0].toString();
            if (data[0] instanceof String && (data[0].toString().trim().equals("-") || data[0].toString().trim().equals("\uff0d"))) {
                value = "0";
            }
            try {
                bg = bg.add(new BigDecimal(value));
            }
            catch (Exception e) {
                if (onlyOneData) {
                    return value;
                }
                return "#VALUE!";
            }
        }
        return bg;
    }

    @Override
    public Map<Long, String> getOriException() {
        HashMap returnMap = Maps.newHashMap();
        returnMap.put(this.dto.getId(), this.getSingleException(this.dto));
        return returnMap;
    }

    @Override
    public void setHasAllDim(Set<String> hasAllDim) {
    }
}

