/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.cal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.bcm.dto.BCMMember;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaBaseInputDto;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaCalculateInputDto;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.other.DmCurrencyUtil;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.cache.GlobalCacheServiceHelper;
import kd.epm.far.common.common.enums.DimEntityNumEnum;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;

public class FormulaCalculateService {
    private static final String ORDER = "order";
    private static final String GROUP = "group";
    protected static final String ORG_RELA_SIGN = "_";
    protected static final List<String> detailoricess = Lists.newArrayList((Object[])new String[]{"RAdj", "IRpt"});
    protected static final String DC = "DC";

    public FormulaCalculateInputDto createFormulaRunningEntity(FormulaBaseInputDto input) {
        FormulaCalculateInputDto formulaInput = new FormulaCalculateInputDto();
        formulaInput.setUuid(input.getUuid());
        formulaInput.setModelId(input.getModelId());
        formulaInput.setModelShowNumber(input.getModelShowNumber());
        formulaInput.setContent(input.getContent());
        formulaInput.setGroupList(input.getGroupList());
        formulaInput.setOrderList(input.getOrderList());
        formulaInput.setTop(input.getTop());
        formulaInput.setIsAsc(input.getIsAsc());
        formulaInput.setModelType(input.getModelType());
        formulaInput.setComponentId(input.getComponentId());
        formulaInput.setData(input.getData());
        String cube = this.getCube(input.getModelShowNumber());
        formulaInput.setCube(cube);
        Map<String, String> shortNumber2Num = BCMMemberReader.getDimensionShortNumber2NumberMap(cube);
        formulaInput.setShortNumber2Num(shortNumber2Num);
        this.checkContent(formulaInput);
        this.checkMemberIsExit(formulaInput);
        this.sortFormulaParamList(formulaInput);
        formulaInput.setDatasetDataVo(input.getDatasetDataVo());
        return formulaInput;
    }

    public HashMultimap<String, String> getSqlFilterDims(FormulaCalculateInputDto formulaInput, Map<String, String> shortNumber2Num, String dimAndMembers) {
        HashMultimap dim2MembMap = HashMultimap.create();
        String[] arrays = null;
        ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
        String realDimVal = null;
        HashSet currencys = new HashSet(16);
        for (String s : dim2MemList) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            arrays = DatasetExpressionHelper.splitDimAndMemb(s);
            realDimVal = this.getRealDimVal(arrays[1]);
            String[] realDimValArr = realDimVal.split(";");
            MultiKeyMap map = formulaInput.getOrgCurrencymap();
            if (formulaInput.getUseEcDcPcStr() == Boolean.TRUE && "C".equalsIgnoreCase(arrays[0]) && Objects.nonNull(map) && map.values().size() > 0) {
                map.values().forEach(p -> currencys.addAll((Collection)p));
                realDimValArr = currencys.toArray(new String[0]);
            }
            for (String realDimValStr : realDimValArr) {
                dim2MembMap.put((Object)shortNumber2Num.get(arrays[0]), (Object)realDimValStr);
            }
        }
        return dim2MembMap;
    }

    private String getRealDimVal(String curDimVal) {
        if (curDimVal.startsWith("{") && curDimVal.endsWith("}")) {
            curDimVal = curDimVal.substring(1, curDimVal.length() - 1);
        }
        return curDimVal;
    }

    private void sortFormulaParamList(FormulaCalculateInputDto formulaInput) {
        Map<String, Integer> dimOrderMap = this.getMemberShortNum2Dseq(formulaInput.getCube());
        String dimAndMembers = formulaInput.getContent();
        ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
        dim2MemList.sort((p1, p2) -> {
            String s1 = DatasetExpressionHelper.splitDimAndMemb(p1)[0];
            String s2 = DatasetExpressionHelper.splitDimAndMemb(p2)[0];
            return (Integer)dimOrderMap.get(s1) - (Integer)dimOrderMap.get(s2);
        });
        String newContent = String.join((CharSequence)",", dim2MemList);
        formulaInput.setContent(newContent);
    }

    private void checkMemberIsExit(FormulaCalculateInputDto formulaInput) {
        List<DimensionInfo> allDims = new ModelStrategyEx(formulaInput.getModelId(), formulaInput.getModelType()).getDim().getDimList();
        String dimAndMembers = formulaInput.getContent();
        String[] dim2MemArr = dimAndMembers.split(",");
        ArrayList<String> entitys = new ArrayList<String>(8);
        ArrayList<String> currencys = new ArrayList<String>(8);
        ArrayList<String> processs = new ArrayList<String>(8);
        for (String item : dim2MemArr) {
            String[] splitArr = DatasetExpressionHelper.splitDimAndMemb(item);
            String dimShortNumber = splitArr[0];
            DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(allDims, formulaInput.getShortNumber2Num().get(dimShortNumber));
            if (splitArr[1].startsWith("{") && splitArr[1].endsWith("}")) {
                splitArr[1] = splitArr[1].substring(1, splitArr[1].length() - 1);
            }
            String[] memSplitArr = splitArr[1].split(";");
            if ("C".equalsIgnoreCase(dimShortNumber) && Arrays.stream(memSplitArr).anyMatch(s -> s.equalsIgnoreCase("ec") || s.equalsIgnoreCase("dc") || s.equalsIgnoreCase("pc"))) {
                formulaInput.setUseEcDcPcStr(Boolean.TRUE);
            }
            for (String memItem : memSplitArr) {
                if (DatasetSpecialVarHelper.isEqualsAllVar(memItem)) {
                    formulaInput.addAllCols(dimShortNumber);
                    continue;
                }
                BCMMember member = null;
                if ("E".equalsIgnoreCase(dimShortNumber) && memItem.contains(ORG_RELA_SIGN)) {
                    int index = memItem.indexOf(ORG_RELA_SIGN);
                    String orgnumber = memItem.substring(index + 1);
                    member = BCMMsServiceHelper.findMemberByNumber(formulaInput.getCube(), DimEntityNumEnum.ENTITY.getNumber(), orgnumber);
                } else {
                    member = BCMMsServiceHelper.findMemberByNumber(formulaInput.getCube(), formulaInput.getShortNumber2Num().get(dimShortNumber), memItem);
                }
                if (Objects.isNull(member)) {
                    throw new KDBizException("Member \"" + memItem + "\" not found");
                }
                if ("E".equalsIgnoreCase(dimShortNumber)) {
                    entitys.add(memItem);
                } else if ("C".equalsIgnoreCase(dimShortNumber)) {
                    currencys.add(memItem);
                } else if ("BP".equalsIgnoreCase(dimShortNumber)) {
                    processs.add(memItem);
                }
                if (dimensionInfo == null || member == null) continue;
                DimMemberInfo dimMemberInfo = new DimMemberInfo();
                dimMemberInfo.setId(member.getMemberId());
                dimMemberInfo.setNumber(member.getNumber());
                dimMemberInfo.setName(member.getName());
                dimensionInfo.getMembers().add(dimMemberInfo);
            }
            if (dimensionInfo == null) continue;
            formulaInput.getDimensionInfos().add(dimensionInfo);
        }
        if (processs.size() == 0 || formulaInput.getMemberinAllCols("BP")) {
            processs.addAll(detailoricess);
            this.changeDimParam(formulaInput, "BP", processs);
        }
        if (formulaInput.getUseEcDcPcStr() == Boolean.TRUE && !formulaInput.getMemberinAllCols("E")) {
            formulaInput.addPCOrgs(entitys.toArray(new String[0]));
            MultiKeyMap<String, Object> orgCurrencyMap = DmCurrencyUtil.handleECDC(formulaInput.getCube(), entitys, currencys, processs, processs.size() == 0 || formulaInput.getMemberinAllCols("BP"));
            formulaInput.addCurrency(currencys.toArray(new String[0]));
            List<String> validEntitys = currencys.contains(DC) && formulaInput.getMemberinAllCols("BP") == Boolean.TRUE.booleanValue() ? entitys : this.getEntitysFormMap(orgCurrencyMap);
            this.changeDimParam(formulaInput, "E", validEntitys);
            formulaInput.setOrgCurrencymap(orgCurrencyMap);
        }
    }

    private List<String> getEntitysFormMap(MultiKeyMap<String, Object> orgCurrencyMap) {
        HashSet<Object> entitys = new HashSet<Object>(orgCurrencyMap.size());
        for (MultiKey entry : orgCurrencyMap.keySet()) {
            entitys.add(entry.getKey(0));
        }
        return Lists.newArrayList(entitys);
    }

    private void changeDimParam(FormulaCalculateInputDto formulaInput, String dim, List<String> value) {
        String dimAndMembers = formulaInput.getContent();
        if (StringUtils.isEmpty((CharSequence)dim) || value.size() == 0) {
            return;
        }
        boolean containBp = Boolean.FALSE;
        StringBuilder sb = new StringBuilder(dim);
        sb.append(".");
        ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
        for (int i = 0; i < dim2MemList.size(); ++i) {
            String[] arrays;
            String s = (String)dim2MemList.get(i);
            if (StringUtils.isEmpty((CharSequence)s) || !Objects.equals(dim, (arrays = DatasetExpressionHelper.splitDimAndMemb(s))[0])) continue;
            containBp = Boolean.TRUE;
            if (value.size() == 1) {
                sb.append(value.get(0));
            } else {
                sb.append("{");
                sb.append(String.join((CharSequence)";", value));
                sb.append("}");
            }
            if (Objects.equals(arrays[1], sb.toString())) {
                return;
            }
            dim2MemList.set(i, sb.toString());
        }
        if (!containBp) {
            sb.append("{");
            sb.append(String.join((CharSequence)";", value));
            sb.append("}");
            dim2MemList.add(sb.toString());
        }
        String newContent = String.join((CharSequence)",", dim2MemList);
        formulaInput.setContent(newContent);
    }

    private Map<String, String> checkContent(FormulaCalculateInputDto formulaInput) {
        HashMap<String, String> formulaDim2member = new HashMap<String, String>(16);
        String dimAndMembers = formulaInput.getContent();
        if (kd.bos.util.StringUtils.isEmpty((String)dimAndMembers)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractFidmCalculate_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String[] dim2MemArr = dimAndMembers.split(",");
        try {
            for (String item : dim2MemArr) {
                String[] splitArr = DatasetExpressionHelper.splitDimAndMemb(item);
                if (splitArr.length != 2 || !formulaInput.getShortNumber2Num().containsKey(splitArr[0])) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u53c2\u6570[%s]", (String)"AbstractFidmCalculate_4", (String)"epm-far-business", (Object[])new Object[0]), item));
                }
                formulaDim2member.put(splitArr[0], splitArr[1]);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\u3002", (String)"AbstractFidmCalculate_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return formulaDim2member;
    }

    private String getCube(String showNumber) {
        String cube = "";
        try {
            cube = BCMMemberReader.findModelNumberByShowNum(showNumber);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AbstractFidmCalculate_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return cube;
    }

    public List<String> shortConvertToDimNumber(Map<String, String> shortNumber2Num, List<String> dim2MemList) {
        LinkedList<String> needList = new LinkedList<String>();
        if (dim2MemList == null || dim2MemList.size() == 0) {
            return needList;
        }
        String[] arrays = null;
        for (String dimStr : dim2MemList) {
            arrays = DatasetExpressionHelper.splitDimAndMemb(dimStr);
            if (arrays != null && arrays.length > 0) {
                needList.add(shortNumber2Num.get(arrays[0]));
                continue;
            }
            needList.add(null);
        }
        return needList;
    }

    public List<String> getNormalNumberList(Map<String, String> shortNumber2Num, List<String> dim2MemList, boolean isOrder) {
        ArrayList<String> list = new ArrayList<String>(2);
        if (dim2MemList != null && dim2MemList.size() > 0) {
            for (String dimMem : dim2MemList) {
                if (isOrder && "FMONEY".equals(dimMem)) {
                    list.add("FMONEY");
                }
                if (!shortNumber2Num.containsKey(dimMem)) continue;
                list.add(shortNumber2Num.get(dimMem));
            }
        }
        return list;
    }

    private Map<String, Integer> getMemberShortNum2Dseq(String modelNum) {
        return (Map)GlobalCacheServiceHelper.getCommonCache().getOrLoad(CacheKey.PrefixString + "dim-snumber-dseq-" + modelNum, () -> {
            HashMap cacheMap = new HashMap(16);
            BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"shortnumber, dseq", (QFilter[])new QFilter("model.number", "=", (Object)modelNum).toArray()).values().forEach(e -> cacheMap.put(e.getString("shortnumber"), e.getInt("dseq")));
            return Collections.unmodifiableMap(cacheMap);
        });
    }
}

