/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.cal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.bcm.BCMDataReader;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.bcm.dto.BCMMemberTreeNode;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaBaseInputDto;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaExCalculateInputDto;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.other.DmCurrencyUtil;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.cache.GlobalCacheServiceHelper;
import kd.epm.far.common.common.enums.DimEntityNumEnum;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;

public class FormulaExCalculateService {
    protected static final String ORG_RELA_SIGN = "_";
    protected static final String DC = "DC";

    public FormulaExCalculateInputDto createFormulaRunningEntity(FormulaBaseInputDto input) {
        FormulaExCalculateInputDto formulaInput = new FormulaExCalculateInputDto();
        formulaInput.setUuid(input.getUuid());
        formulaInput.setModelId(input.getModelId());
        formulaInput.setModelShowNumber(input.getModelShowNumber());
        formulaInput.setContent(input.getContent());
        formulaInput.setGroupList(input.getGroupList());
        formulaInput.setOrderList(input.getOrderList());
        formulaInput.setMoneyList(input.getMoneyList());
        formulaInput.setTop(input.getTop());
        formulaInput.setIsAsc(input.getIsAsc());
        formulaInput.setExtendsModelNumber(input.getExtendsModelNumber());
        String cube = this.getCube(input.getModelShowNumber());
        formulaInput.setCube(cube);
        Map<String, String> shortNumber2Num = BCMMemberReader.getDimensionShortNumber2NumberMap(cube);
        formulaInput.setShortNumber2Num(shortNumber2Num);
        DynamicObject extmodel = BCMDataReader.getExtendsModel(input.getModelId(), input.getExtendsModelNumber());
        DynamicObject groupObj = FormulaExCalculateService.getExtGroupByNumber(input.getModelId(), extmodel.getString("extendsgroup.number"));
        formulaInput.setExtendsModelId(extmodel.getLong("id"));
        formulaInput.setGroupType(groupObj.getString("grouptype"));
        formulaInput.setGroupNumber(groupObj.getString("number"));
        this.checkMemberIsExit(formulaInput, shortNumber2Num, cube);
        this.sortFormulaParamList(formulaInput);
        return formulaInput;
    }

    private void sortFormulaParamList(FormulaExCalculateInputDto formulaInput) {
        Map<String, Integer> dimOrderMap = this.getMemberShortNum2Dseq(formulaInput.getCube());
        String dimAndMembers = formulaInput.getContent();
        ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
        dim2MemList.sort((p1, p2) -> {
            String s1 = DatasetExpressionHelper.splitDimAndMemb(p1)[0];
            String s2 = DatasetExpressionHelper.splitDimAndMemb(p2)[0];
            return (Integer)dimOrderMap.get(s1) - (Integer)dimOrderMap.get(s2);
        });
        String newContent = String.join((CharSequence)",", dim2MemList);
        formulaInput.setContent(newContent);
    }

    private void checkMemberIsExit(FormulaExCalculateInputDto formulaInput, Map<String, String> shortNumber2Num, String cube) {
        String dimAndMembers = formulaInput.getContent();
        String[] dim2MemArr = dimAndMembers.split(",");
        ArrayList<String> allDimShortNumbers = new ArrayList<String>(8);
        ArrayList<String> entitys = new ArrayList<String>(8);
        ArrayList<String> currencys = new ArrayList<String>(8);
        ArrayList<String> processs = new ArrayList<String>(8);
        for (String item : dim2MemArr) {
            String[] splitArr;
            if (kd.bos.util.StringUtils.isEmpty((String)item) || !shortNumber2Num.containsKey((splitArr = DatasetExpressionHelper.splitDimAndMemb(item))[0])) continue;
            String para = splitArr[1].startsWith("{") && splitArr[1].endsWith("}") ? splitArr[1].substring(1, splitArr[1].length() - 1) : splitArr[1];
            List<String> members = Arrays.asList(para.split(";"));
            if ("C".equalsIgnoreCase(splitArr[0]) && members.stream().anyMatch(s -> s.equalsIgnoreCase("ec") || s.equalsIgnoreCase("dc") || s.equalsIgnoreCase("pc"))) {
                formulaInput.setUseEcDcPcStr(Boolean.TRUE);
            }
            for (String member : members) {
                BCMMemberTreeNode membernode = null;
                if ("E".equalsIgnoreCase(splitArr[0]) && member.contains(ORG_RELA_SIGN)) {
                    int index = member.indexOf(ORG_RELA_SIGN);
                    String orgnumber = member.substring(index + 1);
                    membernode = BCMMemberReader.findMemberByNumber(cube, DimEntityNumEnum.ENTITY.getNumber(), orgnumber);
                } else {
                    membernode = BCMMemberReader.findMemberByNumber(cube, shortNumber2Num.get(splitArr[0]), member);
                }
                if (membernode == null || membernode == BCMMemberTreeNode.NotFoundTreeNode) {
                    if (DatasetSpecialVarHelper.isEqualsAllVar(member)) {
                        formulaInput.addAllCols(splitArr[0]);
                        continue;
                    }
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6210\u5458\u6216\u8005\u53d8\u91cf%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AbstractFidmExtCalculate_3", (String)"epm-far-business", (Object[])new Object[0]), member));
                }
                if ("E".equalsIgnoreCase(splitArr[0])) {
                    entitys.add(member);
                    continue;
                }
                if ("C".equalsIgnoreCase(splitArr[0])) {
                    currencys.add(member);
                    continue;
                }
                if (!"BP".equalsIgnoreCase(splitArr[0])) continue;
                processs.add(member);
            }
            allDimShortNumbers.add(splitArr[0]);
        }
        if (formulaInput.getUseEcDcPcStr() == Boolean.TRUE && !formulaInput.getMemberinAllCols("E")) {
            MultiKeyMap<String, Object> orgCurrencyMap = DmCurrencyUtil.handleECDC(formulaInput.getCube(), entitys, currencys, processs, formulaInput.getMemberinAllCols("BP") || processs.size() == 0);
            formulaInput.addCurrency(currencys.toArray(new String[0]));
            List<String> validEntitys = currencys.contains(DC) && formulaInput.getMemberinAllCols("BP") == Boolean.TRUE.booleanValue() ? entitys : this.getEntitysFormMap(orgCurrencyMap);
            this.changeDimParam(formulaInput, "E", validEntitys);
            formulaInput.setOrgCurrencymap(orgCurrencyMap);
        }
        List<String> extdim2MemArr = formulaInput.getMoneyList();
        ArrayList<String> extfields = new ArrayList<String>(8);
        for (String item : extdim2MemArr) {
            if (shortNumber2Num.containsKey(item)) continue;
            QFilter fieldFilter = new QFilter("extmodelid", "=", (Object)formulaInput.getExtendsModelId()).and("extfield.number", "=", (Object)item);
            DynamicObject fieldCol = QueryServiceHelper.queryOne((String)"bcm_extmodelfield", (String)"extfield,extfield.number", (QFilter[])new QFilter[]{fieldFilter});
            if (Objects.isNull(fieldCol)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6210\u5458%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AbstractFidmExtCalculate_4", (String)"epm-far-business", (Object[])new Object[0]), item));
            }
            extfields.add(item);
        }
        formulaInput.setExtfields(extfields);
        formulaInput.setMultiRow((Pair<String[], String[]>)new Pair((Object)new String[0], (Object)extfields.toArray(new String[0])));
        formulaInput.setAllDimShortNumber(allDimShortNumbers.toArray(new String[0]));
    }

    private List<String> getEntitysFormMap(MultiKeyMap<String, Object> orgCurrencyMap) {
        HashSet<Object> entitys = new HashSet<Object>(orgCurrencyMap.size());
        for (MultiKey entry : orgCurrencyMap.keySet()) {
            entitys.add(entry.getKey(0));
        }
        return Lists.newArrayList(entitys);
    }

    private void changeDimParam(FormulaExCalculateInputDto formulaInput, String dim, List<String> value) {
        String dimAndMembers = formulaInput.getContent();
        if (StringUtils.isEmpty((CharSequence)dim) || value.size() == 0) {
            return;
        }
        boolean containBp = Boolean.FALSE;
        StringBuilder sb = new StringBuilder(dim);
        sb.append(".");
        ArrayList dim2MemList = Lists.newArrayList((Object[])dimAndMembers.split(","));
        for (int i = 0; i < dim2MemList.size(); ++i) {
            String[] arrays;
            String s = (String)dim2MemList.get(i);
            if (StringUtils.isEmpty((CharSequence)s) || !Objects.equals(dim, (arrays = DatasetExpressionHelper.splitDimAndMemb(s))[0])) continue;
            containBp = Boolean.TRUE;
            if (value.size() == 1) {
                sb.append(value.get(0));
            } else {
                sb.append("{");
                sb.append(String.join((CharSequence)";", value));
                sb.append("}");
            }
            if (Objects.equals(arrays[1], sb.toString())) {
                return;
            }
            dim2MemList.set(i, sb.toString());
        }
        if (!containBp) {
            sb.append("{");
            sb.append(String.join((CharSequence)";", value));
            sb.append("}");
            dim2MemList.add(sb.toString());
        }
        String newContent = String.join((CharSequence)",", dim2MemList);
        formulaInput.setContent(newContent);
    }

    private static DynamicObject getExtGroupByNumber(Long modelId, String groupNum) {
        QFilter qfilter = new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)groupNum);
        DynamicObject extGroupObject = BusinessDataServiceHelper.loadSingle((String)"bcm_structofextend", (String)"id, grouptype, isparticipmerge", (QFilter[])new QFilter[]{qfilter});
        return extGroupObject;
    }

    private String getCube(String showNumber) {
        String cube = "";
        try {
            cube = BCMMemberReader.findModelNumberByShowNum(showNumber);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AbstractFidmCalculate_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return cube;
    }

    private Map<String, Integer> getMemberShortNum2Dseq(String modelNum) {
        return (Map)GlobalCacheServiceHelper.getCommonCache().getOrLoad(CacheKey.PrefixString + "dim-snumber-dseq-" + modelNum, () -> {
            HashMap cacheMap = new HashMap(16);
            BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"shortnumber, dseq", (QFilter[])new QFilter("model.number", "=", (Object)modelNum).toArray()).values().forEach(e -> cacheMap.put(e.getString("shortnumber"), e.getInt("dseq")));
            return Collections.unmodifiableMap(cacheMap);
        });
    }
}

