/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.cal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.dataset.calculate.base.IDataSetCalculate;
import kd.epm.far.business.common.dataset.calculate.dto.DataInfo;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetFilterVo;
import kd.epm.far.business.common.dataset.dto.DatasetMetadataVo;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.far.model.AnalysisDataHandler;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.enums.FieldTypeEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class MetadataCalculate
implements IDataSetCalculate {
    private static final String PROP_ENTRYENTITY = "prop_entryentity";
    private static final String PROP_NAME = "prop_name";
    private static final String DATA_TYPE = "data_type";
    private static final String DATA_SCHEMA = "data_schema";
    WatchLogger LOGGER = BcmLogFactory.getWatchLogInstance(IDataSetCalculate.class);
    DatasetDto dto;
    private boolean fromPreview;
    private Map<String, Pair<DataType, Set<Object>>> numberMap = Maps.newHashMapWithExpectedSize((int)16);

    public MetadataCalculate(DatasetDto dto, boolean fromPreview) {
        this.dto = dto;
        this.fromPreview = fromPreview;
    }

    private Map<String, String> getFieldTypeEnum(Long iscMetadataId) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject integrateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)iscMetadataId, (String)"isc_metadata_schema");
        DynamicObjectCollection entryentityCollection = integrateObject.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject propEntryEntity : entryentityCollection) {
            DynamicObject childIntegrateObject;
            String propName = propEntryEntity.getString(PROP_NAME);
            String propDataType = propEntryEntity.getString(DATA_TYPE);
            String propDataSchema = propEntryEntity.getString(DATA_SCHEMA);
            map.put(propName, propDataType);
            StringType type = DataType.StringType;
            if (FieldTypeEnum.isLong((String)propDataType)) {
                type = DataType.LongType;
            }
            this.numberMap.put(propName, (Pair<DataType, Set<Object>>)new Pair((Object)type, (Object)Sets.newHashSet()));
            if (!"REF".equals(propDataType) || (childIntegrateObject = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_metadata_schema", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)propDataSchema)})) == null) continue;
            DynamicObjectCollection childEntryentityCollection = childIntegrateObject.getDynamicObjectCollection(PROP_ENTRYENTITY);
            childEntryentityCollection.forEach(childPropEntryEntity -> {
                String childPropName = childPropEntryEntity.getString(PROP_NAME);
                String childPropDataType = childPropEntryEntity.getString(DATA_TYPE);
                String childField = propName + "." + childPropName;
                map.put(childField, childPropDataType);
                StringType childType = DataType.StringType;
                if (FieldTypeEnum.isLong((String)propDataType)) {
                    childType = DataType.LongType;
                }
                this.numberMap.put(childField, (Pair<DataType, Set<Object>>)new Pair((Object)childType, (Object)Sets.newHashSet()));
            });
        }
        return map;
    }

    @Override
    public Object getResult(Map<String, Object> varParams, Map<String, Set<String>> dimParams, AnalysisDataHandler handler, Map<String, String> fillProperty) {
        List<Object> dataList = Lists.newArrayListWithExpectedSize((int)10);
        String data = this.dto.getData();
        if (Objects.isNull(data)) {
            return dataList;
        }
        DatasetDataVo datasetDataVo = null;
        try {
            datasetDataVo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception exception) {
            this.LOGGER.error((Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
        if (Objects.isNull(datasetDataVo.getMetadata()) || Objects.isNull(datasetDataVo.getMetadata().getMetadataId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MetadataCalculate_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        List<DatasetPropertyVo> datasetPropertyVoList = datasetDataVo.getColumns();
        if (datasetPropertyVoList.size() > 0) {
            if (Objects.nonNull(dimParams)) {
                for (DatasetPropertyVo datasetPropertyVo : datasetPropertyVoList) {
                    String number = datasetPropertyVo.getNumber();
                    List<DatasetFilterVo> filters = datasetPropertyVo.getFilters();
                    if (dimParams.get(number) == null || !dimParams.containsKey(number)) continue;
                    for (String dimValue : dimParams.get(number)) {
                        if (!kd.bos.util.StringUtils.isNotEmpty((String)dimValue)) continue;
                        DatasetFilterVo datasetFilterVo = new DatasetFilterVo();
                        datasetFilterVo.setCondition("=");
                        datasetFilterVo.setValue(dimValue);
                        filters.add(datasetFilterVo);
                    }
                }
            }
            ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)datasetPropertyVoList.size());
            ArrayList selectFieldList = Lists.newArrayListWithExpectedSize((int)datasetPropertyVoList.size());
            HashMap lableNames = Maps.newHashMapWithExpectedSize((int)datasetPropertyVoList.size());
            DatasetMetadataVo datasetMetadataVo = datasetDataVo.getMetadata();
            String metadataType = datasetMetadataVo.getMetadataType();
            String dataSrcType = this.dto.getDataSrcType();
            if (Objects.nonNull(datasetMetadataVo)) {
                int top = TypeUtils.convertValueToInt(this.dto.getTop());
                String orderby = this.getOrderBy();
                String selectFields = "";
                String metadataNumber = "";
                if (DataSrcTypeEnum.BCM_ISC_METADATA.getType().equals(dataSrcType)) {
                    Long BCMMetadataId = datasetDataVo.getMetadata().getMetadataId();
                    DynamicObject bcmMetadata = BusinessDataServiceHelper.loadSingleFromCache((Object)BCMMetadataId, (String)"bcm_isdatasource");
                    Long metadataId = bcmMetadata.getLong("iscschema.id");
                    selectFields = this.getSelectFields(metadataId, datasetPropertyVoList, qFilterList, lableNames, selectFieldList);
                    metadataNumber = bcmMetadata.getString("name");
                } else {
                    Long metadataId = datasetDataVo.getMetadata().getMetadataId();
                    selectFields = this.getSelectFields(metadataId, datasetPropertyVoList, qFilterList, lableNames, selectFieldList);
                    metadataNumber = this.getMetadataNumber(datasetMetadataVo);
                }
                String[] group = null;
                Set<String> groupByFields = this.getGroupFields();
                if (groupByFields.size() > 0) {
                    group = groupByFields.toArray(new String[0]);
                }
                dataList = this.getList(metadataType, top, orderby, group, metadataNumber, selectFields, qFilterList, selectFieldList, lableNames);
            }
        }
        this.addColumns(Collections.emptyMap(), this.getCalculateList(this.dto), dataList);
        return this.afterCalculate(dataList, fillProperty);
    }

    private String getMetadataNumber(DatasetMetadataVo datasetMetadataVo) {
        Long iscMetadataId = datasetMetadataVo.getMetadataId();
        DynamicObject integrateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)iscMetadataId, (String)"isc_metadata_schema");
        String metadataNumber = integrateObject.getString("full_name");
        return metadataNumber;
    }

    private String getOrderBy() {
        String orderby = this.dto.getOrderBy();
        String ascValue = this.dto.getAsc();
        if (kd.bos.util.StringUtils.isNotEmpty((String)orderby)) {
            if ("1".equals(ascValue)) {
                ascValue = "asc";
            } else if ("2".equals(ascValue)) {
                ascValue = "desc";
            }
            orderby = orderby + " " + ascValue;
        }
        return orderby;
    }

    private Set<String> getGroupFields() {
        String groupBy = this.dto.getGroupBy();
        return this.getConcreteField(groupBy);
    }

    private Set<String> getFmoneyFields() {
        String value = this.dto.getValue();
        return this.getConcreteField(value);
    }

    private Set<String> getConcreteField(String field) {
        Set<Object> concreteFields = Sets.newHashSetWithExpectedSize((int)1);
        if (kd.bos.util.StringUtils.isNotEmpty((String)field)) {
            if (field.contains(",")) {
                concreteFields = Arrays.stream(field.split(",")).filter(t -> StringUtils.isNotBlank((CharSequence)t.trim())).collect(Collectors.toSet());
            } else {
                concreteFields.add(field);
            }
        }
        return concreteFields;
    }

    private String getSelectFields(Long metadataId, List<DatasetPropertyVo> datasetPropertyVoList, List<QFilter> qFilterList, Map<String, String> lableNames, List<String> selectFieldList) {
        Map<String, String> fieldTypeEnum = this.getFieldTypeEnum(metadataId);
        datasetPropertyVoList.forEach(datasetpropertyvo -> {
            String number = datasetpropertyvo.getNumber();
            String name = datasetpropertyvo.getName();
            lableNames.put(number, name);
            selectFieldList.add(number);
            qFilterList.add(datasetpropertyvo.getFilter(number, (String)fieldTypeEnum.get(number)));
        });
        this.setSelectFieldList(selectFieldList);
        StringBuilder selectFieldBuilder = new StringBuilder();
        selectFieldList.forEach(selectField -> {
            selectFieldBuilder.append((String)selectField);
            selectFieldBuilder.append(",");
        });
        String selectFields = selectFieldBuilder.toString();
        if (selectFields.endsWith(",")) {
            int lastCommaIndex = selectFields.lastIndexOf(",");
            selectFields = selectFields.substring(0, lastCommaIndex);
        }
        return selectFields;
    }

    private void setSelectFieldList(List<String> selectFieldList) {
        Set<String> groupSet = this.getGroupFields();
        Set<String> moneySet = this.getFmoneyFields();
        if (groupSet.size() > 0) {
            groupSet.addAll(moneySet);
            selectFieldList.clear();
            selectFieldList.addAll(groupSet);
        }
    }

    private List<LinkedHashMap<String, Object>> getList(String metadataType, int top, String orderby, String[] group, String metadataNumber, String selectFields, List<QFilter> qFilterList, List<String> selectFieldList, Map<String, String> lableNames) {
        ArrayList dataList = Lists.newArrayListWithExpectedSize((int)10);
        try (DataSet datSet = this.getDataSet(metadataType, top, orderby, group, metadataNumber, selectFields, qFilterList);){
            try {
                if (datSet != null && datSet.hasNext()) {
                    this.setFieldInfo(datSet, selectFieldList, lableNames, dataList);
                }
            }
            catch (Exception exception) {
                this.LOGGER.error((Throwable)exception);
                throw new KDBizException(exception.getMessage());
            }
        }
        return dataList;
    }

    private void setFieldInfo(DataSet dateSet, List<String> selectFieldList, Map<String, String> lableNames, List<LinkedHashMap<String, Object>> dataList) {
        DynamicObjectCollection entityDataBase = ORM.create().toPlainDynamicObjectCollection(dateSet.copy());
        entityDataBase.forEach(entityData -> {
            LinkedHashMap fieldInfo = Maps.newLinkedHashMapWithExpectedSize((int)1);
            for (String selectField : selectFieldList) {
                if (lableNames.get(selectField) == null) continue;
                DataInfo dataInfo = new DataInfo();
                String selectNodeName = (String)lableNames.get(selectField);
                dataInfo.setName(selectNodeName);
                dataInfo.setNumber(selectField);
                Object value = entityData.get(selectField);
                dataInfo.setValue(value);
                fieldInfo.put(selectField, value);
                ((Set)this.numberMap.get((Object)selectField).p2).add(value);
            }
            dataList.add(fieldInfo);
        });
    }

    private DataSet getDataSet(String metadataType, int top, String orderby, String[] group, String metadataNumber, String selectFields, List<QFilter> qFilterList) {
        if ("1".equals(metadataType)) {
            return this.getEntityDataSet(top, orderby, group, metadataNumber, selectFields, qFilterList);
        }
        if ("2".equals(metadataType)) {
            return this.getTableDataSet(top, orderby, group, metadataNumber, selectFields, qFilterList);
        }
        return null;
    }

    private DataSet getEntityDataSet(int top, String orderby, String[] group, String metadataNumber, String selectFields, List<QFilter> qFilterList) {
        String currentOrderBy = orderby;
        if (Objects.nonNull(group) && group.length > 0) {
            currentOrderBy = null;
        }
        DataSet dataSet = null;
        try {
            dataSet = top > 0 ? (Objects.nonNull(group) && group.length > 0 ? QueryServiceHelper.queryDataSet((String)"MetadataCalculate.getDataSet", (String)metadataNumber, (String)selectFields, (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)currentOrderBy) : QueryServiceHelper.queryDataSet((String)"MetadataCalculate.getDataSet", (String)metadataNumber, (String)selectFields, (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)currentOrderBy, (int)top)) : QueryServiceHelper.queryDataSet((String)"MetadataCalculate.getDataSet", (String)metadataNumber, (String)selectFields, (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)currentOrderBy);
            if (Objects.nonNull(group) && group.length > 0) {
                return this.getEntityGroupByDataSet(dataSet, group, top, orderby);
            }
        }
        catch (Exception exception) {
            this.LOGGER.error((Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MetadataCalculate_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return dataSet;
    }

    private DataSet getEntityGroupByDataSet(DataSet dataSet, String[] group, int top, String orderby) {
        Set<String> orderbySet;
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(group);
        Set<String> fmoneySet = this.getFmoneyFields();
        for (String fmoney : fmoneySet) {
            groupbyDataSet = groupbyDataSet.sum(fmoney);
        }
        dataSet = groupbyDataSet.finish();
        if (top > 0) {
            DataSet copyDataSet = dataSet.copy();
            if (kd.bos.util.StringUtils.isNotEmpty((String)orderby)) {
                Set<String> orderbySet2 = this.getConcreteField(orderby);
                if (orderbySet2.size() > 0) {
                    String[] orders = orderbySet2.toArray(new String[0]);
                    DataSet orderByDataSet = copyDataSet.orderBy(orders);
                    DataSet topDataSet = orderByDataSet.top(top);
                    return topDataSet.copy();
                }
                DataSet topDataSet = copyDataSet.top(top);
                return topDataSet.copy();
            }
            DataSet topDataSet = copyDataSet.top(top);
            return topDataSet.copy();
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)orderby) && (orderbySet = this.getConcreteField(orderby)).size() > 0) {
            DataSet copyDataSet = dataSet.copy();
            String[] orders = orderbySet.toArray(new String[0]);
            DataSet orderByDataSet = copyDataSet.orderBy(orders);
            return orderByDataSet;
        }
        return dataSet;
    }

    private DataSet getTableDataSet(int top, String orderby, String[] groupByFields, String metadataNumber, String selectFields, List<QFilter> qFilterList) {
        String[] tableAndRoute = metadataNumber.split("@");
        if (tableAndRoute.length > 1) {
            try {
                String sql = this.getDBSql(top, groupByFields, orderby, selectFields, qFilterList, tableAndRoute[0]);
                DBRoute dBRoute = DBRoute.of((String)tableAndRoute[1]);
                DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dBRoute, (String)sql);
                if (groupByFields != null && groupByFields.length > 0) {
                    dataSet = this.getTableGroupByDataSet(dataSet, groupByFields, top, orderby);
                }
                return dataSet;
            }
            catch (Exception exception) {
                this.LOGGER.error((Throwable)exception);
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MetadataCalculate_1", (String)"epm-far-business", (Object[])new Object[0]));
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6570\u636e\u8868\u8def\u7531\u3002", (String)"MetadataCalculate_2", (String)"epm-far-business", (Object[])new Object[0]));
    }

    private DataSet getTableGroupByDataSet(DataSet dataSet, String[] groupByFields, int top, String orderby) {
        Set<String> orderbySet;
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(groupByFields);
        Set<String> fmoneySet = this.getFmoneyFields();
        for (String fmoney : fmoneySet) {
            groupbyDataSet = groupbyDataSet.sum(fmoney);
        }
        dataSet = groupbyDataSet.finish();
        if (top > 0) {
            DataSet copyDataSet = dataSet.copy();
            if (kd.bos.util.StringUtils.isNotEmpty((String)orderby)) {
                Set<String> orderbySet2 = this.getConcreteField(orderby);
                if (orderbySet2.size() > 0) {
                    String[] orders = orderbySet2.toArray(new String[0]);
                    DataSet orderByDataSet = copyDataSet.orderBy(orders);
                    DataSet topDataSet = orderByDataSet.top(top);
                    DataSet topCopyDataSet = topDataSet.copy();
                    return topCopyDataSet;
                }
                DataSet topDataSet = copyDataSet.top(top);
                DataSet topCopyDataSet = topDataSet.copy();
                return topCopyDataSet;
            }
            DataSet topDataSet = copyDataSet.top(top);
            DataSet topCopyDataSet = topDataSet.copy();
            return topCopyDataSet;
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)orderby) && (orderbySet = this.getConcreteField(orderby)).size() > 0) {
            DataSet copyDataSet = dataSet.copy();
            String[] orders = orderbySet.toArray(new String[0]);
            DataSet orderByDataSet = copyDataSet.orderBy(orders);
            return orderByDataSet;
        }
        return dataSet;
    }

    private String getDBSql(int top, String[] groupByFields, String orderby, String selectFields, List<QFilter> qFilterList, String tableName) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ");
        if ((Objects.isNull(groupByFields) || groupByFields.length == 0) && top > 0) {
            stringBuilder.append("top ");
            stringBuilder.append(top);
            stringBuilder.append(" ");
        }
        stringBuilder.append(selectFields);
        stringBuilder.append(" from ");
        stringBuilder.append(tableName);
        stringBuilder.append(" where ");
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)qFilterList.size());
        qFilterList.forEach(item -> filterList.add(item.toString()));
        String filter = String.join((CharSequence)" and ", filterList);
        if (kd.bos.util.StringUtils.isNotEmpty((String)filter)) {
            stringBuilder.append(filter);
        }
        if ((Objects.isNull(groupByFields) || groupByFields.length == 0) && kd.bos.util.StringUtils.isNotEmpty((String)orderby)) {
            stringBuilder.append(" order by ");
            stringBuilder.append(orderby);
        }
        return stringBuilder.toString();
    }

    private void afterGetDataList(List<LinkedHashMap<String, Object>> dataList, Map<String, String> fillProperty) {
        block6: {
            if (dataList.size() <= 0 || this.fromPreview) break block6;
            if (Objects.nonNull(fillProperty) && fillProperty.size() > 0) {
                Set<Map.Entry<String, String>> entrys = fillProperty.entrySet();
                for (Map map : dataList) {
                    for (Map.Entry<String, String> entry : entrys) {
                        String key = entry.getKey();
                        if (map.get(key) == null || !(map.get(key) instanceof String)) continue;
                        String value = (String)map.get(key);
                        map.put(key, value + ";" + value);
                    }
                }
            } else {
                for (Map map : dataList) {
                    Set set = map.entrySet();
                    for (Map.Entry entry : set) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (map.get(key) == null) continue;
                        map.put(key, value + ";" + value);
                    }
                }
            }
        }
    }

    @Override
    public void beforeCalculate(Object ... params) {
    }

    @Override
    public Object afterCalculate(Object ... params) {
        List<LinkedHashMap<String, Object>> res = (List<LinkedHashMap<String, Object>>)params[0];
        if (CollectionUtils.isEmpty((Collection)res)) {
            return res;
        }
        String data = this.dto.getData();
        if (Objects.isNull(data)) {
            return res;
        }
        res = this.join(this.getJoinList(this.dto), res, this.numberMap);
        this.hideColumn(this.dto.getData(), res);
        this.afterGetDataList(res, (Map)params[1]);
        return res;
    }

    @Override
    public Map<Long, String> getOriException() {
        String exception = this.getSingleException(this.dto);
        if (kd.bos.util.StringUtils.isNotEmpty((String)exception)) {
            HashMap returnMap = Maps.newHashMap();
            returnMap.put(this.dto.getId(), this.getSingleException(this.dto));
            return returnMap;
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public void setHasAllDim(Set<String> hasAllDim) {
    }
}

