/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.cal;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.epm.far.business.common.dataset.calculate.base.IDataSetCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.CalculateStrategy;
import kd.epm.far.business.common.dataset.calculate.dto.MutilValueInputDto;
import kd.epm.far.business.common.dataset.calculate.input.MutilValueInput;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetMutilExpressionHelper;
import kd.epm.far.business.far.model.AnalysisDataHandler;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;

public class MutilValueCalculate
implements IDataSetCalculate {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(MutilValueCalculate.class);
    private Long caclId;
    private DynamicObject dataset;
    private MutilValueInputDto input;
    private Map<Long, String> singleExpMap = Maps.newHashMap();
    private Map<String, String> expressionMap = Maps.newHashMap();

    public MutilValueCalculate(Long caclId, DynamicObject dataset) {
        this.caclId = caclId;
        this.dataset = dataset;
    }

    public Object getResult() {
        Long datasetId = this.input.getDatasetId();
        DynamicObject dataset = DatasetDataReader.getDataSet(datasetId);
        Long modelId = dataset.getLong("discmodel.id");
        DynamicObject[] excelCellList = this.getCalList(datasetId);
        LinkedHashMap singleMap = new LinkedHashMap(10);
        for (DynamicObject dyn : excelCellList) {
            String id = dyn.getString("id");
            String formulatype = dyn.getString("formulatype");
            if ("1".equals(formulatype)) {
                singleMap.put(id, null);
                continue;
            }
            if (!"2".equals(formulatype)) continue;
            this.expressionMap.put(id, dyn.getString("formulatext"));
        }
        DatasetMutilExpressionHelper.ICaculateOperation caculateOperation = singleDatasetId -> {
            DynamicObject singleDyn = DatasetDataReader.getDataSet(singleDatasetId);
            IDataSetCalculate strategy = CalculateStrategy.getStrategy(this.caclId, singleDyn, false);
            return strategy.getResult(this.input.getParams(), this.input.getDimDefaultMembers(), null, null);
        };
        Map<String, Object> returnMultiMap = DatasetMutilExpressionHelper.calculate(modelId, this.expressionMap, caculateOperation);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(excelCellList.length);
        for (DynamicObject dyn : excelCellList) {
            String id = dyn.getString("id");
            String formulatype = dyn.getString("formulatype");
            String number = dyn.getString("number");
            Long singleDatasetId2 = dyn.getLong("single.dataset.id");
            if ("1".equals(formulatype)) {
                Object singleResult = singleMap.get(id);
                if (singleResult != null) continue;
                singleResult = CalculateStrategy.getStrategy(this.caclId, DatasetDataReader.getDataSet(singleDatasetId2), false).getResult(this.input.getParams(), this.input.getDimDefaultMembers(), null, null);
                result.put(number, singleResult);
                continue;
            }
            result.put(number, returnMultiMap.get(id));
        }
        return result;
    }

    @Override
    public Object getResult(Map<String, Object> varParams, Map<String, Set<String>> dimParams, AnalysisDataHandler handler, Map<String, String> fillProperty) {
        this.beforeCalculate(varParams, dimParams);
        Object calculate = this.getResult();
        return this.afterCalculate(calculate);
    }

    @Override
    public void beforeCalculate(Object ... params) {
        this.input = new MutilValueInput().create(this.dataset, params);
    }

    @Override
    public Object afterCalculate(Object ... params) {
        Map result = (Map)params[0];
        for (Map.Entry entry : result.entrySet()) {
            String value = entry.getValue().toString();
            if (!value.contains("E") && !value.contains("e")) continue;
            try {
                entry.setValue(new BigDecimal(new BigDecimal(value).toPlainString()));
            }
            catch (Exception e) {
                logger.info("transform exception");
            }
        }
        return result;
    }

    @Override
    public Map<Long, String> getOriException() {
        DynamicObject[] dys;
        for (DynamicObject dyn : dys = this.getCalList(this.dataset.getLong("id"))) {
            String[] singleNumbers;
            Long modelId = dyn.getLong("dataset.discmodel.id");
            String formulatype = dyn.getString("formulatype");
            if ("1".equals(formulatype)) {
                Long id = dyn.getLong("single.dataset.id");
                DynamicObject singleDS = DatasetDataReader.getSingleDS(LongUtil.toLong((Object)id));
                this.singleExpMap.put(id, singleDS.getString("expression"));
                continue;
            }
            if (!"2".equals(formulatype)) continue;
            String formulaText = dyn.getString("formulatext");
            this.expressionMap.put(dyn.getString("id"), formulaText);
            for (String number : singleNumbers = formulaText.split("[+\\-*/()]")) {
                if (!number.matches(".*[a-zA-Z].*")) continue;
                QFilter filter = new QFilter("dataset.discmodel", "=", (Object)modelId).and("dataset.number", "=", (Object)number.trim());
                Collection<DynamicObject> singleDatasets = DatasetDataReader.getSingleDSs(new QFilter[]{filter});
                if (singleDatasets.isEmpty()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u503c\u6570\u636e\u96c6 \u201c%1$s\u201d \u4e0d\u5b58\u5728\u3002", (String)"MutilValueCalculate_2", (String)"epm-far-business", (Object[])new Object[0]), number));
                }
                Iterator<DynamicObject> iterator = singleDatasets.iterator();
                DynamicObject singleDS = iterator.next();
                Long id = singleDS.getLong("dataset.id");
                this.singleExpMap.put(id, singleDS.getString("expression"));
            }
        }
        return this.singleExpMap;
    }

    @Override
    public void setHasAllDim(Set<String> hasAllDim) {
    }

    private DynamicObject[] getCalList(Long mulId) {
        QFilter qfilter = new QFilter("dataset.id", "=", (Object)mulId);
        DynamicObject[] dyns = DatasetDataReader.getMultiDataSetValues(new QFilter[]{qfilter}).toArray(new DynamicObject[0]);
        return dyns;
    }
}

