/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.dto;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.bcm.BCMDataReader;
import kd.epm.far.business.common.dataset.calculate.input.AbstractInput;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.common.common.enums.DimTypesEnum;

public class TemplateInput
extends AbstractInput {
    private Map<String, String> dimMap;
    private Long templateId;
    private String entendNumber;
    private List<String> orgs;
    private DatasetDataVo datasetDataVo;
    private String data;

    public TemplateInput create(DatasetDto dto, Object ... params) {
        Long modelId = dto.getDataSrcId();
        DynamicObject bcmModel = BCMDataReader.getModel(modelId);
        String showNumber = bcmModel.getString("shownumber");
        String expression = dto.getExpression();
        expression = this.handleVars(expression, (Map)params[0]);
        expression = this.handleRange(modelId, expression);
        expression = this.handleCur(showNumber, expression, (Map)params[1]);
        this.data = dto.getData();
        this.datasetDataVo = (DatasetDataVo)JSON.parseObject((String)this.data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
        this.templateId = this.datasetDataVo.getTemplate().getTemplateId();
        if (!StringUtils.equals((CharSequence)this.datasetDataVo.getTemplate().getArea(), (CharSequence)"hasDim")) {
            this.entendNumber = this.datasetDataVo.getTemplate().getArea();
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId, DisModelTypeEnum.CM.getType());
        List<DimensionInfo> dimList = modelStrategyEx.getDim().getDimList();
        Map<String, String> collect = dimList.stream().collect(Collectors.toMap(DimensionInfo::getShortNumber, DimensionInfo::getNumber));
        this.orgs = Lists.newArrayListWithExpectedSize((int)16);
        this.dimMap = Maps.newHashMapWithExpectedSize((int)16);
        String[] arrays = null;
        ArrayList dim2MemList = Lists.newArrayList((Object[])expression.split(","));
        for (String s : dim2MemList) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            arrays = DatasetExpressionHelper.splitDimAndMemb(s);
            String left = collect.get(arrays[0]);
            String right = arrays[1];
            String para = right.startsWith("{") && right.endsWith("}") ? right.substring(1, right.length() - 1) : right;
            List<String> members = Arrays.asList(para.split(";"));
            if (Objects.equals(DimTypesEnum.ENTITY.getNumber(), left)) {
                this.orgs.addAll(members);
                continue;
            }
            if (members.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u53c2\u6570\u6682\u4e0d\u652f\u6301\u591a\u9009\u3002", (String)"TemplateInput_1", (String)"epm-far-business", (Object[])new Object[0]));
            }
            this.dimMap.put(collect.get(arrays[0]), para);
        }
        return this;
    }

    public Map<String, String> getDimMap() {
        return this.dimMap;
    }

    public void setDimMap(Map<String, String> dimMap) {
        this.dimMap = dimMap;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public List<String> getOrgs() {
        return this.orgs;
    }

    public void setOrgs(List<String> orgs) {
        this.orgs = orgs;
    }

    public String getEntendNumber() {
        return this.entendNumber;
    }

    public void setEntendNumber(String entendNumber) {
        this.entendNumber = entendNumber;
    }
}

