/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.input;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.epm.far.business.bcm.BCMDimensionHelper;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.common.dataset.calculate.cal.DataSetExtService;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.dataset.util.DmPeriodAndFyUtil;
import kd.epm.far.business.common.enums.FormulaExceptionEnum;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.common.common.enums.RangeEnum;
import org.apache.commons.lang.StringUtils;

public class AbstractInput {
    private static final Pattern EXPRESSION_CHECK_MULTI_MUMBER_REGEX = Pattern.compile("\\{(.*?)\\}");

    protected String handleCur(String shownumber, String formulaExpression, Map<String, Set<String>> memberMap) {
        if (StringUtils.isEmpty((String)formulaExpression)) {
            return formulaExpression;
        }
        String[] dims = formulaExpression.split(",");
        ArrayList<String> dimsList = new ArrayList<String>(16);
        String cur = "";
        Object offset = 0;
        for (String dim : dims) {
            String[] dimMember = DatasetExpressionHelper.splitDimAndMemb(dim);
            if (dimMember.length < 2) {
                throw new KDException(BosErrorCode.paramError, new Object[]{String.format(FormulaExceptionEnum.FORMULA_EXPRESSION_ERROR.getName(), dim)});
            }
            String right = dimMember[1];
            String dimNumber = dimMember[0].toUpperCase();
            String para = right.startsWith("{") && right.endsWith("}") ? right.substring(1, right.length() - 1) : right;
            List<String> members = Arrays.asList(para.split(";"));
            ArrayList<String> dimvaluemembers = new ArrayList<String>(members.size());
            for (String member : members) {
                if (DatasetSpecialVarHelper.isEqualsCurVar(member)) {
                    if (memberMap != null && memberMap.containsKey(dimNumber)) {
                        dimMember[1] = memberMap.get(dimNumber).iterator().next();
                        dimvaluemembers.add(dimMember[1]);
                        continue;
                    }
                    throw new KDException(BosErrorCode.paramError, new Object[]{String.format(FormulaExceptionEnum.DIM_NO_DEFAULT_MEMBER.getName(), dimMember[0])});
                }
                if (DatasetSpecialVarHelper.isContainCurVar(member) && DmPeriodAndFyUtil.validCur(member).booleanValue()) {
                    if (Objects.equals(dimMember[0], "FY") || Objects.equals(dimMember[0], "P")) {
                        Object off = DmPeriodAndFyUtil.getCurOffset(member);
                        if (off instanceof Integer) {
                            offset = off;
                        }
                        if (memberMap == null || !memberMap.containsKey(dimMember[0])) {
                            throw new KDException(BosErrorCode.paramError, new Object[]{String.format(FormulaExceptionEnum.DIM_NO_DEFAULT_MEMBER.getName(), dimMember[0])});
                        }
                    } else {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e2d\u7684\u7ef4\u5ea6\u6210\u5458\u201c%s\u201d \u3002", (String)"DataSetTurnFormulaUtil_2", (String)"epm-far-business", (Object[])new Object[0]), dimMember[0]));
                    }
                    cur = memberMap.get(dimMember[0]).iterator().next();
                    dimvaluemembers.add(DmPeriodAndFyUtil.getPeriodOrFyByOffset(shownumber, dimMember[0], cur, offset));
                    continue;
                }
                if (DatasetSpecialVarHelper.isEqualsCursVar(member)) {
                    if (memberMap != null && memberMap.containsKey(dimNumber)) {
                        Set<String> curs = memberMap.get(dimNumber);
                        dimvaluemembers.addAll(curs);
                        continue;
                    }
                    throw new KDException(BosErrorCode.paramError, new Object[]{String.format(FormulaExceptionEnum.DIM_NO_DEFAULT_MEMBER.getName(), dimMember[0])});
                }
                dimvaluemembers.add(member);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(dimMember[0]);
            sb.append(".");
            if (dimvaluemembers.size() > 1) {
                sb.append("{");
                sb.append(Joiner.on((String)";").join(dimvaluemembers));
                sb.append("}");
            } else {
                sb.append((String)dimvaluemembers.get(0));
            }
            dimsList.add(sb.toString());
        }
        String newexpression = Joiner.on((String)",").join(dimsList);
        return newexpression;
    }

    protected String handleRange(Long modelId, String formula) {
        if (kd.bos.util.StringUtils.isEmpty((String)formula)) {
            return formula;
        }
        List<String> list = this.matchStr(formula, EXPRESSION_CHECK_MULTI_MUMBER_REGEX);
        if (list.isEmpty()) {
            return formula;
        }
        HashMap needReplaceMap = Maps.newHashMap();
        for (String string : list) {
            if (!string.contains(".")) continue;
            String[] split = string.split(";");
            int index = this.getFirstIndex(formula, ";" + string) + 1;
            if (index == 0) {
                index = this.getFirstIndex(formula, "{" + string) + 1;
            }
            int firstIndex = formula.substring(0, index).lastIndexOf(",");
            String dim = formula.substring(firstIndex + 1, index - 2);
            dim = dim.replace('\"', ' ').trim();
            String dimNumber = DimTypesEnum.getDimNumber((String)dim, (long)modelId);
            for (String s : split) {
                if (!s.contains(".") || s.endsWith(".")) continue;
                String firstInfo = s.substring(0, s.lastIndexOf("."));
                String lastInfo = s.substring(s.lastIndexOf(".") + 1);
                RangeEnum rangeEnum = RangeEnum.getRangeByNumber((String)lastInfo);
                if (rangeEnum == null) continue;
                Set<String> result = BCMMsServiceHelper.batchGetMemberNumbers(BCMDimensionHelper.findModelNumberById(modelId), dimNumber, firstInfo, RangeEnum.getRangeByNumberOrName((String)lastInfo));
                String replaceStr = String.join((CharSequence)";", result);
                if (StringUtils.isEmpty((String)replaceStr)) {
                    if (split.length == 1) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6210\u5458\u3002", (String)"DataSetTurnFormulaUtil_3", (String)"epm-far-business", (Object[])new Object[0]));
                    }
                    char c = formula.charAt(this.getFirstIndex(formula, s) + s.length());
                    if (Objects.equals(Character.valueOf(c), Character.valueOf(';'))) {
                        needReplaceMap.put(s + ";", replaceStr);
                        continue;
                    }
                }
                needReplaceMap.put(s, replaceStr);
            }
        }
        for (Map.Entry entry : needReplaceMap.entrySet()) {
            formula = formula.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return formula;
    }

    protected int getFirstIndex(String oldStr, String childStr) {
        int i;
        int oldLength = oldStr.length();
        int childLength = childStr.length();
        if (childLength == 0) {
            return 0;
        }
        int[] pi = new int[childLength];
        int j = 0;
        for (i = 1; i < childLength; ++i) {
            while (j > 0 && childStr.charAt(i) != childStr.charAt(j)) {
                j = pi[j - 1];
            }
            if (childStr.charAt(i) == childStr.charAt(j)) {
                // empty if block
            }
            pi[i] = ++j;
        }
        j = 0;
        for (i = 0; i < oldLength; ++i) {
            while (j > 0 && oldStr.charAt(i) != childStr.charAt(j)) {
                j = pi[j - 1];
            }
            if (oldStr.charAt(i) == childStr.charAt(j)) {
                ++j;
            }
            if (j != childLength) continue;
            return i - childLength + 1;
        }
        return -1;
    }

    protected List<String> matchStr(String str, Pattern pattern) {
        Matcher matcher = pattern.matcher(str);
        ArrayList<String> list = new ArrayList<String>(8);
        while (matcher.find()) {
            String findStr = matcher.group();
            list.add(findStr.substring(1, findStr.length() - 1));
        }
        return list;
    }

    protected String handleVars(String expression, Map<String, Object> params) {
        return AbstractInput.handleAllVars(expression, params);
    }

    public static String handleAllVars(String expression, Map<String, Object> params) {
        Pattern VARIABLE_REGEX = Pattern.compile("\\$[a-zA-Z0-9_\\-]+\\$");
        Matcher m = VARIABLE_REGEX.matcher(expression);
        String replacedFormula = expression;
        DatasetExpressionHelper.checkDimRepeatExpression(replacedFormula, null);
        while (m.find()) {
            String replacedString = expression.substring(m.start(), m.end());
            String varNumber = expression.substring(m.start() + 1, m.end() - 1);
            boolean isReplace = false;
            if (params.containsKey(varNumber)) {
                replacedFormula = replacedFormula.replace(replacedString, params.get(varNumber).toString());
                isReplace = true;
            }
            if (!isReplace) continue;
            DatasetExpressionHelper.checkDimRepeatExpression(replacedFormula, "$" + varNumber + "$");
        }
        return replacedFormula;
    }

    protected String getFormulaReplaceVars(Long datasetId, String formulaExpression, Map<String, Object> params, Long chapterId) {
        Pattern VARIABLE_REGEX = Pattern.compile("\\$[a-zA-Z0-9_\\-]+\\$");
        boolean replaceFlag = !CollectionUtils.isEmpty(params);
        Map<String, Object> dsVars = null;
        if (CollectionUtils.isEmpty(params)) {
            DataSetExtService dataSetExtService = new DataSetExtService();
            dsVars = dataSetExtService.getDataSetVars(Collections.singletonList(datasetId), chapterId);
        } else {
            dsVars = params;
        }
        Matcher m = VARIABLE_REGEX.matcher(formulaExpression);
        String replacedFormula = formulaExpression;
        DatasetExpressionHelper.checkDimRepeatExpression(replacedFormula, null);
        while (m.find()) {
            String replacedString = formulaExpression.substring(m.start(), m.end());
            String varNumber = formulaExpression.substring(m.start() + 1, m.end() - 1);
            boolean isReplace = false;
            if (replaceFlag) {
                replacedFormula = replacedFormula.replace(replacedString, params.get(varNumber).toString());
                isReplace = true;
            } else if (dsVars.containsKey(varNumber)) {
                replacedFormula = replacedFormula.replace(replacedString, dsVars.get(varNumber).toString());
                isReplace = true;
            }
            if (!isReplace) continue;
            DatasetExpressionHelper.checkDimRepeatExpression(replacedFormula, "$" + varNumber + "$");
        }
        return replacedFormula;
    }

    protected String fillMissedParams(Long modelId, String defValue, String expression) {
        Map<String, String> formulaDim2member = this.getDimMapbyFormula(expression);
        Set<String> dimKeys = formulaDim2member.keySet();
        String cube = BCMDimensionHelper.findModelNumberById(modelId);
        Map<String, String> shortNumber2Num = BCMDimensionHelper.getDimensionShortNumber2NumberMap(cube);
        for (Map.Entry<String, String> num : shortNumber2Num.entrySet()) {
            DynamicObject dim;
            String entity;
            String number;
            String shortnumber = num.getKey();
            if (dimKeys.contains(shortnumber) || !kd.bos.util.StringUtils.isNotEmpty((String)(number = DatasetServiceHelper.getDefaultMemberNumber(modelId, defValue, shortnumber, entity = BCMDimensionHelper.getDimMembEntityNumByDimNum(num.getValue()), (dim = BCMDimensionHelper.getDimByNumber(num.getValue(), modelId, "bcm_dimension")).getLong("id"))))) continue;
            formulaDim2member.put(shortnumber, number);
        }
        return formulaDim2member.entrySet().stream().map(s -> (String)s.getKey() + "." + (String)s.getValue()).collect(Collectors.joining(","));
    }

    protected Map<String, String> getDimMapbyFormula(String formulatext) {
        LinkedHashMap<String, String> formulaDim2member = new LinkedHashMap<String, String>(16);
        String[] dim2MemArr = formulatext.split(",");
        try {
            for (String item : dim2MemArr) {
                String[] splitArr = DatasetExpressionHelper.splitDimAndMemb(item);
                if (splitArr.length != 2) continue;
                formulaDim2member.put(splitArr[0], splitArr[1]);
            }
        }
        catch (Exception e) {
            return new HashMap<String, String>(0);
        }
        return formulaDim2member;
    }

    protected String filterFormulaStringForExModel(String expression) {
        return expression;
    }
}

