/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.input;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaBaseInputDto;
import kd.epm.far.business.common.dataset.calculate.input.AbstractInput;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.enums.DataSetCalculateTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.eb.EBDataReader;
import kd.epm.far.business.fidm.util.TypeUtils;

public class EbMutiLineInput
extends AbstractInput {
    public FormulaBaseInputDto create(DatasetDto dto, Object ... params) {
        Long modelId = dto.getDataSrcId();
        DynamicObject model = EBDataReader.getModel(modelId);
        String showNumber = model.getString("shownumber");
        String expression = dto.getExpression();
        expression = this.handleVars(expression, (Map)params[0]);
        expression = this.handleCur(showNumber, expression, (Map)params[1]);
        String groupby = dto.getGroupBy();
        String orderBy = dto.getOrderBy();
        String OneOrZero = dto.getAsc();
        Integer top = dto.getTop();
        FormulaBaseInputDto input = new FormulaBaseInputDto(showNumber, modelId, expression, DataSetCalculateTypeEnum.SingleValue.getType());
        input.setGroupList(DatasetExpressionHelper.stringToList(groupby));
        input.setOrderList(DatasetExpressionHelper.stringToList(orderBy));
        input.setIsAsc("1".equalsIgnoreCase(OneOrZero));
        input.setTop(TypeUtils.convertValueToInt(top));
        input.setDatasetId(dto.getId());
        input.setModelType(DisModelTypeEnum.EB.getType());
        String data = dto.getData();
        if (StringUtils.isNotEmpty((String)data)) {
            input.setData(data);
            input.setDatasetDataVo((DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]));
        }
        return input;
    }
}

