/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.input;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaBaseInputDto;
import kd.epm.far.business.common.dataset.calculate.input.AbstractInput;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.DataSetCalculateTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.eb.EBDataReader;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.eb.dto.EbDim;

public class EbSingleValueInput
extends AbstractInput {
    public FormulaBaseInputDto create(DatasetDto dto, Object ... params) {
        Long modelId = dto.getDataSrcId();
        DynamicObject model = EBDataReader.getModel(modelId);
        String showNumber = model.getString("shownumber");
        String expression = dto.getExpression();
        expression = this.handleVars(expression, (Map)params[0]);
        expression = this.handleCur(showNumber, expression, (Map)params[1]);
        String defValue = dto.getDefValue();
        expression = this.fillMissedEbParams(modelId, dto.getEbDataset(), defValue, expression);
        FormulaBaseInputDto input = new FormulaBaseInputDto(showNumber, modelId, expression, DataSetCalculateTypeEnum.SingleValue.getType());
        input.setDatasetId(dto.getId());
        input.setModelType(DisModelTypeEnum.EB.getType());
        String data = dto.getData();
        if (StringUtils.isNotEmpty((String)data)) {
            input.setData(data);
            input.setDatasetDataVo((DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]));
        }
        return input;
    }

    private String fillMissedEbParams(Long modelId, String ebDataset, String defValue, String expression) {
        Map<String, String> formulaDim2member = this.getDimMapbyFormula(expression);
        Set<String> dimKeys = formulaDim2member.keySet();
        List<EbDim> dim = EbServiceHelper.getDim(modelId, ebDataset);
        Map<String, EbDim> ebDimMap = dim.stream().collect(Collectors.toMap(EbDim::getShortNumber, v -> v, (k1, k2) -> k1));
        for (Map.Entry<String, EbDim> ebDim : ebDimMap.entrySet()) {
            String number;
            String shortnumber = ebDim.getKey();
            EbDim value = ebDim.getValue();
            if (dimKeys.contains(shortnumber) || !StringUtils.isNotEmpty((String)(number = DatasetServiceHelper.getDefaultMemberNumber(modelId, defValue, shortnumber, value.getMemberModel(), value.getId())))) continue;
            formulaDim2member.put(shortnumber, number);
        }
        return formulaDim2member.entrySet().stream().map(s -> (String)s.getKey() + "." + (String)s.getValue()).collect(Collectors.joining(","));
    }
}

