/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.input;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.far.business.bcm.BCMDataReader;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaBaseInputDto;
import kd.epm.far.business.common.dataset.calculate.input.AbstractInput;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.enums.DataSetCalculateTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.fidm.util.TypeUtils;

public class MutiLineInputInput
extends AbstractInput {
    public FormulaBaseInputDto create(DatasetDto dto, Object ... params) {
        Long modelId = dto.getDataSrcId();
        DynamicObject bcmModel = BCMDataReader.getModel(modelId);
        String showNumber = bcmModel.getString("shownumber");
        String expression = dto.getExpression();
        expression = this.handleVars(expression, (Map)params[0]);
        expression = this.handleRange(modelId, expression);
        expression = this.handleCur(showNumber, expression, (Map)params[1]);
        String groupby = dto.getGroupBy();
        String orderBy = dto.getOrderBy();
        String OneOrZero = dto.getAsc();
        Integer top = dto.getTop();
        String data = dto.getData();
        FormulaBaseInputDto input = new FormulaBaseInputDto(showNumber, modelId, expression, DataSetCalculateTypeEnum.MultiLine.getType());
        input.setGroupList(DatasetExpressionHelper.stringToList(groupby));
        input.setOrderList(DatasetExpressionHelper.stringToList(orderBy));
        input.setIsAsc("1".equalsIgnoreCase(OneOrZero));
        input.setTop(TypeUtils.convertValueToInt(top));
        input.setDatasetId(dto.getId());
        input.setData(data);
        if (StringUtils.isNotBlank((CharSequence)data)) {
            input.setDatasetDataVo((DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]));
        }
        input.setModelType(DisModelTypeEnum.getModelType(dto.getDataSrcType(), modelId).getType());
        input.setComponentId(dto.getComponentId());
        input.setMoneyList(Lists.newArrayList((Object[])new String[]{"FMONEY"}));
        return input;
    }
}

