/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.calculate.input;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.far.business.bcm.BCMDataReader;
import kd.epm.far.business.common.dataset.calculate.dto.FormulaBaseInputDto;
import kd.epm.far.business.common.dataset.calculate.input.AbstractInput;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.enums.DataSetCalculateTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import org.apache.commons.lang.StringUtils;

public class SingleValueExInputInput
extends AbstractInput {
    public FormulaBaseInputDto create(DatasetDto dto, Object ... params) {
        Long modelId = dto.getDataSrcId();
        DynamicObject bcmModel = BCMDataReader.getModel(modelId);
        String showNumber = bcmModel.getString("shownumber");
        String expression = this.filterFormulaStringForExModel(dto.getExpression());
        String groupby = this.filterFormulaStringForExModel(dto.getGroupBy());
        String orderby = this.filterFormulaStringForExModel(dto.getOrderBy());
        String extendsmodelnumber = dto.getExtendsModelNumber();
        expression = this.handleVars(expression, (Map)params[0]);
        expression = this.handleRange(modelId, expression);
        expression = this.handleCur(showNumber, expression, (Map)params[1]);
        FormulaBaseInputDto input = new FormulaBaseInputDto(showNumber, modelId, expression, DataSetCalculateTypeEnum.SingleValueEx.getType());
        input.setGroupList(DatasetExpressionHelper.stringToList(groupby));
        input.setOrderList(DatasetExpressionHelper.stringToList(orderby));
        String value = dto.getValue();
        input.setFmoney(value);
        String data = dto.getData();
        if (StringUtils.isNotEmpty((String)data)) {
            DatasetDataVo vo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
            List<DatasetPropertyVo> datasetPropertyVoList = vo.getColumns();
            List<String> columnList = datasetPropertyVoList.stream().filter(property -> "extend".equals(property.getSource())).map(datasetPropertyVo -> datasetPropertyVo.getId()).collect(Collectors.toList());
            if (columnList.size() > 0) {
                input.setMoneyList(columnList);
            } else {
                input.setMoneyList(DatasetExpressionHelper.stringToList(value));
            }
        } else {
            input.setMoneyList(DatasetExpressionHelper.stringToList(value));
        }
        input.setExtendsModelNumber(extendsmodelnumber);
        input.setDatasetId(dto.getId());
        input.setData(data);
        input.setModelType(DisModelTypeEnum.getModelType(dto.getDataSrcType(), modelId).getType());
        return input;
    }

    public FormulaBaseInputDto create(Long datasetId, Map<String, Object> params, Map<String, Set<String>> dimDefaultMembers, Long chapterId) {
        DynamicObject singleDyn = DatasetDataReader.getSingleDS(datasetId);
        Long modelId = singleDyn.getLong("datasrcid");
        DynamicObject bcmModel = BCMDataReader.getModel(modelId);
        String showNumber = bcmModel.getString("shownumber");
        String expression = this.filterFormulaStringForExModel(singleDyn.getString("expression"));
        String value = singleDyn.getString("value");
        String groupby = this.filterFormulaStringForExModel(singleDyn.getString("groupby"));
        String orderby = this.filterFormulaStringForExModel(singleDyn.getString("orderby"));
        String extendsmodelnumber = singleDyn.getString("extendsmodelnumber");
        expression = this.getFormulaReplaceVars(datasetId, expression, params, chapterId);
        expression = this.handleRange(modelId, expression);
        expression = this.handleCur(showNumber, expression, dimDefaultMembers);
        FormulaBaseInputDto input = new FormulaBaseInputDto(showNumber, modelId, expression, DataSetCalculateTypeEnum.SingleValueEx.getType());
        input.setGroupList(DatasetExpressionHelper.stringToList(groupby));
        input.setOrderList(DatasetExpressionHelper.stringToList(orderby));
        input.setMoneyList(DatasetExpressionHelper.stringToList(value));
        input.setExtendsModelNumber(extendsmodelnumber);
        input.setDatasetId(datasetId);
        return input;
    }
}

