/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.dto;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.epm.far.business.common.dataset.dto.ColumnTypeEnum;
import kd.epm.far.business.common.dataset.dto.DatasetFilterVo;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.far.calculate.CalculateHelper;
import kd.epm.far.common.common.enums.FieldTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DatasetPropertyVo
implements Serializable {
    private String id;
    private String number;
    private Integer type;
    private String source;
    private List<DatasetFilterVo> filters;
    private String name;
    private String propertyNumber;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public List<DatasetFilterVo> getFilters() {
        return this.filters;
    }

    public void setFilters(List<DatasetFilterVo> filters) {
        this.filters = filters;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPropertyNumber() {
        return this.propertyNumber;
    }

    public void setPropertyNumber(String propertyNumber) {
        this.propertyNumber = propertyNumber;
    }

    public boolean isRootAttribute() {
        return Objects.isNull(this.propertyNumber) || Objects.equals(this.number, this.propertyNumber);
    }

    public String getKey() {
        if (Objects.equals(ColumnTypeEnum.ATTRIBUTE_COLUMN.getCode(), this.type)) {
            if (Objects.isNull(this.propertyNumber) || Objects.equals(this.number, this.propertyNumber)) {
                return this.source + "-Property-" + this.number;
            }
            return this.source + "-Property-" + this.propertyNumber;
        }
        if (Objects.equals(ColumnTypeEnum.FIXED_COLUMN.getCode(), this.type)) {
            return this.source + "-" + this.number;
        }
        return this.number;
    }

    public QFilter getFilter(String key, String fieldTypeEnum) {
        if (CollectionUtils.isEmpty(this.filters)) {
            return new QFilter("1", "=", (Object)1);
        }
        QFilter returnFilter = null;
        List<QFilter> qfilterList = this.getQfilterList(key, fieldTypeEnum);
        if (CollectionUtils.isEmpty(qfilterList)) {
            return new QFilter("1", "=", (Object)1);
        }
        returnFilter = qfilterList.get(0);
        if (qfilterList.size() == 1) {
            return returnFilter;
        }
        for (int i = 1; i < qfilterList.size(); ++i) {
            returnFilter.or(qfilterList.get(i));
        }
        return returnFilter;
    }

    private List<QFilter> getQfilterList(String key, String fieldTypeEnum) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)this.filters.size());
        HashSet inFilter = Sets.newHashSetWithExpectedSize((int)16);
        boolean isString = FieldTypeEnum.isString((String)fieldTypeEnum);
        for (DatasetFilterVo filter : this.filters) {
            if (isString) {
                if (StringUtils.equals((String)"in", (String)filter.getCondition())) {
                    inFilter.addAll(Arrays.stream(filter.getValue().split(";")).collect(Collectors.toSet()));
                    continue;
                }
                if (StringUtils.equals((String)"like", (String)filter.getCondition())) {
                    list.add(new QFilter(key, "like", (Object)("%" + filter.getValue() + "%")));
                    continue;
                }
                if (!StringUtils.equals((String)"=", (String)filter.getCondition())) continue;
                inFilter.add(filter.getValue());
                continue;
            }
            if (!CalculateHelper.checkNumber(filter.getValue())) continue;
            if (DatasetUtil.conditions.contains(filter.getCondition())) {
                list.add(new QFilter(key, filter.getCondition(), (Object)new BigDecimal(filter.getValue())));
                continue;
            }
            if (!StringUtils.equals((String)"=", (String)filter.getCondition())) continue;
            inFilter.add(new BigDecimal(filter.getValue()));
        }
        if (CollectionUtils.isNotEmpty((Collection)inFilter)) {
            list.add(new QFilter(key, "in", (Object)inFilter));
        }
        return list;
    }

    public String toString() {
        return "DatasetPropertyVo{number='" + this.number + '\'' + ", type=" + this.type + ", source='" + this.source + '\'' + ", filters=" + this.filters + '}';
    }
}

