/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.filter;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.bcm.dto.BCMMemberTreeNode;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.FidmDataTypeEnum;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSHelper;
import kd.epm.far.business.common.expression.dto.calc.DataSetCaclColumn;
import kd.epm.far.business.common.expression.dto.calc.DatasetCalcInfo;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.util.ResultInfoEx;
import kd.epm.far.business.fidm.util.TypeUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;

public class DatasetFilterHelper {
    public static final String COLUMNTYPE_DIM = "1";
    public static final String COLUMNTYPE_MONEY = "2";
    public static final String COLTYPE = "col_type";
    public static final String PARAM_DATASETID = "datasetId";
    public static final String PARAM_FILTER = "filter";
    private static final Log log = LogFactory.getLog(DatasetFilterHelper.class);
    private static final char SPLITSTR = ' ';
    private static final char LINEEND = '\n';

    public static void openEdit(IFormView view, IFormPlugin plugin, Long modelId, Long datasetId, String filterSerial) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fidm_dsfilter_entry");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setParentPageId(view.getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack(plugin, "fidm_dsfilter_entry"));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        formShowParameter.setCustomParam("dmmodelid", (Object)modelId);
        formShowParameter.setCustomParam(PARAM_DATASETID, (Object)datasetId);
        formShowParameter.setCustomParam(PARAM_FILTER, (Object)filterSerial);
        view.showForm(formShowParameter);
    }

    public static List<Map<String, Object>> invokeDatasetFilterColumn(Long modelId, Long datasetId) {
        DatasetDto dto = DatasetUtil.getSingleDataSetDto(datasetId);
        return DatasetUtil.getColumnsByExpression(dto);
    }

    private static Map<String, Object> getMeasureMap(String dimNumber, String memberNumber, Long modelId) {
        BCMMemberTreeNode memberByNumber = BCMMemberReader.findMemberByNumber(BCMMemberReader.findModelNumberById(modelId), dimNumber, memberNumber);
        String name = BCMMemberTreeNode.NotFoundTreeNode.equals(memberByNumber) ? memberNumber : memberByNumber.getName();
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put("number", dimNumber + "='" + memberNumber + "'");
        map.put("name", String.format(ResManager.loadKDString((String)"\u5ea6\u91cf\u503c- %s", (String)"AnalysisServiceHelper_7", (String)"epm-far-business", (Object[])new Object[0]), name));
        map.put("id", memberNumber);
        map.put("type", "DM");
        map.put(COLTYPE, COLUMNTYPE_MONEY);
        return map;
    }

    public static List<Map<String, Object>> invokeDatasetFilterColumn(Long modelId, Long datasetId, boolean ignoreOrderby) {
        List<Map<String, Object>> sourceColumnMapList = new DatasetServiceHelper().getDimList(datasetId, true);
        ArrayList<Map<String, Object>> columnMapList = new ArrayList<Map<String, Object>>(sourceColumnMapList.size());
        for (Map<String, Object> item : sourceColumnMapList) {
            Map findDim = columnMapList.stream().filter(m -> m.get("number").toString().equals(item.get("number").toString())).findAny().orElse(null);
            if (!Objects.isNull(findDim)) continue;
            columnMapList.add(item);
        }
        if (CollectionUtils.isNotEmpty(columnMapList)) {
            columnMapList.forEach(e -> {
                String type = (String)e.get("type");
                if (Objects.equals(type, FidmDataTypeEnum.DM.getType()) || Objects.equals(type, FidmDataTypeEnum.LEM.getType()) || Objects.equals(type, FidmDataTypeEnum.REM.getType())) {
                    e.put(COLTYPE, COLUMNTYPE_MONEY);
                    if (StringUtils.isEmpty((String)((String)e.get("id")))) {
                        e.put("id", e.get("number"));
                    }
                } else {
                    e.put(COLTYPE, COLUMNTYPE_DIM);
                }
            });
        }
        Long realModelId = modelId;
        DynamicObject dyn = DatasetDataReader.getSingleDS(datasetId, false);
        if (dyn != null) {
            Long datasrcid;
            String datasrctype = dyn.getString("datasrctype");
            if ((DataSrcTypeEnum.CURRENT_MODEL.getType().equals(datasrctype) || DataSrcTypeEnum.MERGE_MODEL.getType().equals(datasrctype) || DataSrcTypeEnum.COMPONENT.getType().equals(datasrctype) || DataSrcTypeEnum.RPT_MODEL.getType().equals(datasrctype)) && (datasrcid = Long.valueOf(dyn.getLong("datasrcid"))) != null && datasrcid > 0L) {
                realModelId = dyn.getLong("datasrcid");
            }
        }
        DatasetFilterHelper.rowTransferHandler(columnMapList, datasetId, realModelId);
        DatasetUtil.buildManage(columnMapList, dyn);
        DatasetUtil.buildRename(columnMapList, dyn);
        return columnMapList;
    }

    private static void rowTransferHandler(List<Map<String, Object>> columnList, Long datasetId, Long modelId) {
        QFilter qFilter = new QFilter("dataset", "=", (Object)datasetId);
        DynamicObject dataSetSingle = DatasetDataReader.getSingleDS(datasetId, false);
        if (Objects.isNull(dataSetSingle) || StringUtils.isEmpty((String)dataSetSingle.getString("dimnum"))) {
            return;
        }
        String dimNum = dataSetSingle.getString("dimnum");
        if (StringUtils.isEmpty((String)dimNum)) {
            return;
        }
        String memberNums = dataSetSingle.getString("membernum");
        List memberNumList = (List)SerializationUtils.fromJsonString((String)memberNums, List.class);
        Iterator<Map<String, Object>> iterator = columnList.iterator();
        ArrayList measureList = Lists.newArrayList();
        while (iterator.hasNext()) {
            Map<String, Object> next = iterator.next();
            String number = (String)next.get("number");
            if (Objects.equals(dimNum, number)) {
                for (String memberNum : memberNumList) {
                    measureList.add(DatasetFilterHelper.getMeasureMap(dimNum, memberNum, modelId));
                }
                iterator.remove();
                continue;
            }
            if (!Objects.equals("FMONEY", number)) continue;
            iterator.remove();
        }
        columnList.addAll(measureList);
    }

    public static List<Map<String, Object>> invokeDatasetFilterColumn(Long modelId, Long datasetId, String type) {
        List<Map<String, Object>> columnMapList = DatasetFilterHelper.invokeDatasetFilterColumn(modelId, datasetId).stream().filter(e -> Objects.equals(e.get(COLTYPE), type)).collect(Collectors.toList());
        return columnMapList;
    }

    public static Set<String> getMoneyKeySet(Long modelId, Long datasetId) {
        List<Map<String, Object>> columnMapList = DatasetFilterHelper.invokeDatasetFilterColumn(modelId, datasetId, COLUMNTYPE_MONEY);
        return columnMapList.stream().map(e -> (String)e.get("number")).collect(Collectors.toSet());
    }

    public static Long getDatasrcId(Long datasetId) {
        Long datasrcid = null;
        DynamicObject dyn = DatasetDataReader.getSingleDS(datasetId, false);
        if (Objects.nonNull(dyn)) {
            datasrcid = dyn.getLong("datasrcid");
        }
        return datasrcid;
    }

    public static String getFilterView(Long dmModelId, Long datasetId, List<DatasetFilterItem> filterList) {
        StringBuilder filterStr = new StringBuilder();
        ResultInfoEx<DatasetCalcInfo> resultInfo = ExpressionDSHelper.getDatasetDtoById(dmModelId, datasetId);
        if (!resultInfo.isSuccess().booleanValue()) {
            return filterStr.toString();
        }
        DatasetCalcInfo datasetCalcInfo = resultInfo.getData();
        ModelStrategyEx modelStrategyEx = ExpressionDSHelper.getModelStrategyEx(datasetCalcInfo);
        ArrayList<DimensionInfo> dimensionInfos = new ArrayList(10);
        if (modelStrategyEx != null) {
            dimensionInfos = modelStrategyEx.getDim().getDimList();
        }
        for (int i = 0; i < filterList.size(); ++i) {
            DimensionInfo dimensionInfo;
            DatasetFilterItem filterItem = filterList.get(i);
            DataSetCaclColumn column = datasetCalcInfo.getColumns().stream().filter(m -> m.getNumber().equalsIgnoreCase(filterItem.getDimensionNumber())).findFirst().orElse(null);
            if (column == null) continue;
            String memberNumber = filterItem.getMemberNumber();
            String memberName = filterItem.getValue();
            String columnNumber = column.getNumber();
            String columnName = column.getName();
            String linkeName = DatasetFilterHelper.getName(filterItem.getLink());
            if (modelStrategyEx != null && !TypeUtils.containsIgnore(datasetCalcInfo.getMoneySet(), filterItem.getDimensionNumber()) && modelStrategyEx != null && StringUtils.isNotEmpty((String)memberNumber) && (dimensionInfo = DimensionUtils.getDimByNumber(dimensionInfos, columnNumber)) != null) {
                columnName = dimensionInfo.getName();
                DimMemberInfo memberInfo = modelStrategyEx.getDimMember().findMemberByNumber(dimensionInfo.getNumber(), memberNumber, false);
                if (memberInfo != null) {
                    memberName = memberInfo.getName();
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(columnName);
            sb.append(' ');
            sb.append(DatasetFilterHelper.getName(filterItem.getCondition()));
            sb.append(' ');
            sb.append(memberName);
            if (i != filterList.size() - 1) {
                sb.append(' ');
                sb.append(linkeName);
                sb.append('\n');
            }
            filterStr.append((CharSequence)sb);
        }
        return filterStr.toString();
    }

    public static String getName(String key) {
        String name = "";
        switch (key) {
            case "=": {
                name = ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"DatasetFilterEntryPlugin_5", (String)"epm-far-business", (Object[])new Object[0]);
                break;
            }
            case "!=": {
                name = ResManager.loadKDString((String)"\u4e0d\u7b49\u4e8e", (String)"DatasetFilterEntryPlugin_6", (String)"epm-far-business", (Object[])new Object[0]);
                break;
            }
            case ">": {
                name = ResManager.loadKDString((String)"\u5927\u4e8e", (String)"DatasetFilterEntryPlugin_7", (String)"epm-far-business", (Object[])new Object[0]);
                break;
            }
            case ">=": {
                name = ResManager.loadKDString((String)"\u5927\u4e8e\u7b49\u4e8e", (String)"DatasetFilterEntryPlugin_8", (String)"epm-far-business", (Object[])new Object[0]);
                break;
            }
            case "<": {
                name = ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"DatasetFilterEntryPlugin_9", (String)"epm-far-business", (Object[])new Object[0]);
                break;
            }
            case "<=": {
                name = ResManager.loadKDString((String)"\u5c0f\u4e8e\u7b49\u4e8e", (String)"DatasetFilterEntryPlugin_10", (String)"epm-far-business", (Object[])new Object[0]);
                break;
            }
            case "is null": {
                name = ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"DatasetFilterEntryPlugin_11", (String)"epm-far-business", (Object[])new Object[0]);
                break;
            }
            case "is not null": {
                name = ResManager.loadKDString((String)"\u4e0d\u4e3a\u7a7a", (String)"DatasetFilterEntryPlugin_12", (String)"epm-far-business", (Object[])new Object[0]);
                break;
            }
            case "and": {
                name = ResManager.loadKDString((String)"\u5e76\u4e14", (String)"DatasetFilterEntryPlugin_13", (String)"epm-far-business", (Object[])new Object[0]);
            }
        }
        return name;
    }
}

