/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.formulaengine;

import java.util.List;
import kd.epm.far.business.common.dataset.formulaengine.IDataFormula;
import kd.epm.far.business.common.dataset.formulaengine.exception.FormulaError;
import kd.epm.far.business.common.dataset.formulaengine.exception.InvalidFormulaException;
import kd.epm.far.business.common.dataset.formulaengine.paramhandler.AbsParamHandler;
import kd.epm.far.business.common.dataset.formulaengine.paramhandler.CmExParamHandlerImp;
import kd.epm.far.business.common.dataset.formulaengine.paramhandler.CmParamHandlerImp;
import kd.epm.far.business.common.dataset.formulaengine.paramhandler.EPMVoucherParamHandlerImp;
import kd.epm.far.business.common.dataset.formulaengine.paramhandler.EbParamHandlerImp;
import kd.epm.far.business.common.dataset.formulaengine.paramhandler.ISCParamHandlerImp;
import kd.epm.far.business.common.dataset.formulaengine.paramhandler.RptParamHandlerImp;
import kd.epm.far.business.common.dataset.formulaengine.util.FormulaEnumType;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class FormulaStrategy
implements IDataFormula {
    private final WatchLogger logger = BcmLogFactory.getWatchLogInstance(this.getClass());

    public AbsParamHandler getStrategy(String paramJson) throws InvalidFormulaException, Exception {
        AbsParamHandler absParamHandler = null;
        try {
            List<String> params = this.beforeResolve(paramJson);
            FormulaEnumType dataType = FormulaEnumType.getFormulaEnumByNumber(this.removeDoubleQuotes(params.get(0)));
            switch (dataType) {
                case CM: 
                case CM_MUTI: {
                    absParamHandler = new CmParamHandlerImp(params);
                    break;
                }
                case RPT: 
                case RPT_MUTI: {
                    absParamHandler = new RptParamHandlerImp(params);
                    break;
                }
                case CM_EXT: 
                case CM_EXT_MUTI: {
                    absParamHandler = new CmExParamHandlerImp(params);
                    break;
                }
                case EB: 
                case EB_MUTI: {
                    absParamHandler = new EbParamHandlerImp(params);
                    break;
                }
                case ISC: 
                case ISC_MUTI: {
                    absParamHandler = new ISCParamHandlerImp(params);
                    break;
                }
                case EPDM: 
                case EPDM_MUTI: {
                    absParamHandler = new EPMVoucherParamHandlerImp(params);
                    break;
                }
                default: {
                    throw new InvalidFormulaException(FormulaError.CODE_201.getCode(), String.format(FormulaError.CODE_201.getMsg(), dataType.getNumber()));
                }
            }
        }
        catch (InvalidFormulaException e) {
            this.logger.error(String.format("FormulaStrategy.getStrategy-InvalidFormulaException--%s", e));
            throw new InvalidFormulaException(e);
        }
        catch (Exception e) {
            this.logger.error(String.format("FormulaStrategy.getStrategy-Exception--%s", e));
            throw new InvalidFormulaException(FormulaError.CODE_299.getCode(), e);
        }
        return absParamHandler;
    }
}

