/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.formulaengine;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.far.business.common.dataset.formulaengine.exception.FormulaError;
import kd.epm.far.business.common.dataset.formulaengine.exception.InvalidFormulaException;

public interface IDataFormula {
    default public List<String> beforeResolve(String paramJson) {
        this.beforeCheckValida(paramJson);
        int len = paramJson.length();
        ArrayList<String> chunks = new ArrayList<String>(len);
        boolean inDoubleQuotes = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int nextIdx;
            char c = paramJson.charAt(i);
            int n = nextIdx = i < len - 1 ? i + 1 : i;
            if (c == '\\' && i < len - 1) {
                sb.append(c).append(paramJson.charAt(++i));
                continue;
            }
            if (c == '\"') {
                inDoubleQuotes = !inDoubleQuotes;
                sb.append(c);
                continue;
            }
            if (c == ',' && !inDoubleQuotes && paramJson.charAt(nextIdx) == '\"') {
                chunks.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (c == ',' && (inDoubleQuotes && paramJson.charAt(nextIdx) == '\"' || !inDoubleQuotes && paramJson.charAt(nextIdx) != '\"')) {
                throw new InvalidFormulaException(FormulaError.CODE_203.getCode(), String.format(FormulaError.CODE_203.getMsg(), i, sb.toString()));
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            chunks.add(sb.toString());
        }
        this.afterCheckValida(chunks);
        return chunks;
    }

    default public void beforeCheckValida(String sourceKey) {
        if (StringUtils.isEmpty((CharSequence)sourceKey)) {
            throw new InvalidFormulaException(FormulaError.CODE_202.getCode(), FormulaError.CODE_202.getMsg());
        }
        if (!sourceKey.startsWith("\"")) {
            throw new InvalidFormulaException(FormulaError.CODE_203.getCode(), String.format(FormulaError.CODE_203.getMsg(), 1, sourceKey));
        }
        if (!sourceKey.endsWith("\"")) {
            throw new InvalidFormulaException(FormulaError.CODE_203.getCode(), String.format(FormulaError.CODE_203.getMsg(), sourceKey.length(), sourceKey));
        }
    }

    default public void afterCheckValida(List<String> chunks) {
        if (chunks.isEmpty()) {
            throw new InvalidFormulaException(FormulaError.CODE_204.getCode(), FormulaError.CODE_204.getMsg());
        }
        for (String chunk : chunks) {
            this.beforeCheckValida(chunk);
        }
    }

    default public String removeDoubleQuotes(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new InvalidFormulaException(FormulaError.CODE_205.getCode(), FormulaError.CODE_205.getMsg());
        }
        return key.replaceAll("^\"|\"$", "");
    }
}

