/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.formulaengine.paramhandler;

import java.util.ArrayList;
import java.util.List;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.formulaengine.exception.FormulaError;
import kd.epm.far.business.common.dataset.formulaengine.exception.InvalidFormulaException;
import kd.epm.far.business.common.dataset.formulaengine.processor.abscommon.IParamProcessor;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public abstract class AbsParamHandler {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(AbsParamHandler.class);
    List<String> params;
    DatasetDto dto = new DatasetDto();
    List<IParamProcessor> processors = new ArrayList<IParamProcessor>(12);

    abstract void registerProcessors();

    public AbsParamHandler(List<String> params) {
        this.params = params;
        this.buildBaseData();
        this.registerProcessors();
    }

    public DatasetDto getObject() throws Exception {
        long startTime = System.currentTimeMillis();
        logger.info(String.format("Far--AbsParamHandler--getObject--paramStr: %s", this.params.toString()));
        try {
            this.checkProcessors();
            for (int i = 1; i < this.params.size() && i <= this.processors.size(); ++i) {
                this.processors.get(i - 1).process(this.params.get(i), this.dto);
            }
        }
        catch (InvalidFormulaException e) {
            logger.error(String.format("AbsParamHandler.getObject-InvalidFormulaException--%s", e));
            throw new InvalidFormulaException(e);
        }
        catch (Exception e) {
            logger.error(String.format("AbsParamHandler.getObject-Exception--%s", e));
            throw new InvalidFormulaException(FormulaError.CODE_299.getCode(), e);
        }
        logger.info("Far--------AbsParamHandler----------costtimes:" + (System.currentTimeMillis() - startTime));
        return this.dto;
    }

    public Object getRes() throws Exception {
        return DatasetUtil.getResult(this.getObject());
    }

    public void checkProcessors() {
        if (this.params == null || this.params.isEmpty()) {
            throw new InvalidFormulaException(FormulaError.CODE_218.getCode(), FormulaError.CODE_218.getMsg());
        }
    }

    public void buildBaseData() {
    }
}

