/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.formulaengine.processor.abscommon;

import com.alibaba.fastjson.JSON;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetMetadataVo;
import kd.epm.far.business.common.dataset.dto.DatasetVoucherVo;
import kd.epm.far.business.common.dataset.formulaengine.exception.FormulaError;
import kd.epm.far.business.common.dataset.formulaengine.exception.InvalidFormulaException;
import kd.epm.far.business.common.dataset.formulaengine.processor.abscommon.IParamProcessor;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.epm.enums.VoucherModelTypeEnum;
import kd.epm.far.common.common.util.LongUtil;

public class BaseDataProcessor
implements IParamProcessor {
    @Override
    public void process(String param, DatasetDto dto) {
        String newParam = this.resolveParam(param);
        String dataSrcType = dto.getDataSrcType();
        DataSrcTypeEnum typeEnum = DataSrcTypeEnum.getByType(dataSrcType);
        switch (typeEnum) {
            case MERGE_MODEL: 
            case RPT_MODEL: 
            case EB_MODEL: {
                String filterStrByAppType = this.getFilterStrByAppType(dataSrcType);
                DynamicObject dyna = BusinessDataServiceHelper.loadSingle((String)DataSrcTypeEnum.getByType(dataSrcType).getFormId(), (String)"id", (QFilter[])new QFilter[]{new QFilter(filterStrByAppType, "=", (Object)newParam)});
                if (dyna == null) {
                    throw new InvalidFormulaException(FormulaError.CODE_206.getCode(), String.format(FormulaError.CODE_206.getMsg(), newParam));
                }
                dto.setDataSrcId(dyna.getLong("id"));
                dto.setDataSrcNumber(newParam);
                break;
            }
            case ISC_METADATA: {
                DatasetMetadataVo.MetadataTypeEnum metaEnumByNumber = DatasetMetadataVo.MetadataTypeEnum.getMetaEnumByNumber(newParam);
                if (metaEnumByNumber == null) {
                    throw new InvalidFormulaException(FormulaError.CODE_207.getCode(), String.format(FormulaError.CODE_207.getMsg(), newParam));
                }
                dto.setMetadataType(metaEnumByNumber.getType());
                break;
            }
            case EPM_VOUCHER: {
                try {
                    Long voucherId = LongUtil.toLong((Object)newParam);
                    DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epdm_dm", (String)"number,type.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)voucherId)});
                    dto.setVoucherId(voucherId);
                    dto.setVoucherNumber(dynamicObject.getString("number"));
                    String type = dynamicObject.getString("type.number");
                    VoucherModelTypeEnum voucherType = VoucherModelTypeEnum.getByNumber(type);
                    dto.setVoucherType(voucherType.getIndex());
                    DatasetVoucherVo datasetVoucherVo = new DatasetVoucherVo();
                    datasetVoucherVo.setId(voucherId);
                    datasetVoucherVo.setVoucherType(voucherType.getIndex());
                    datasetVoucherVo.setVoucherNumber(dto.getVoucherNumber());
                    DatasetDataVo datasetDataVo = new DatasetDataVo();
                    datasetDataVo.setDatasetVoucherVo(datasetVoucherVo);
                    dto.setData(JSON.toJSONString((Object)datasetDataVo));
                    break;
                }
                catch (Exception e) {
                    throw new InvalidFormulaException(FormulaError.CODE_220.getCode(), String.format(FormulaError.CODE_220.getMsg(), newParam), e);
                }
            }
        }
    }

    public String getFilterStrByAppType(String type) {
        if ("1".equals(type) || "6".equals(type)) {
            return "shownumber";
        }
        return "shownumber";
    }
}

