/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.formulaengine.processor.abscommon;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.far.business.common.dataset.dto.ColumnTypeEnum;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetFilterVo;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.formulaengine.dto.ColTypeEnum;
import kd.epm.far.business.common.dataset.formulaengine.dto.ColumnInfoVo;
import kd.epm.far.business.common.dataset.formulaengine.exception.FormulaError;
import kd.epm.far.business.common.dataset.formulaengine.exception.InvalidFormulaException;
import kd.epm.far.business.common.dataset.formulaengine.processor.abscommon.IParamProcessor;
import kd.epm.far.business.common.dataset.formulaengine.util.QCPUtils;
import kd.epm.far.common.common.Pair;

public abstract class FilterProcessor
implements IParamProcessor {
    public Map<String, ColumnInfoVo> colsMapInfo = new HashMap<String, ColumnInfoVo>(12);

    @Override
    public void process(String param, DatasetDto dto) {
        this.beforeCheck(param);
        String newParams = this.removeDoubleQuotes(param);
        this.initColsInfo(dto);
        Map<String, String> filterChunks = this.resolveFilterChunks(newParams);
        this.checkFilterChunks(filterChunks, dto);
        this.buildFilters(filterChunks, dto);
    }

    public abstract void initColsInfo(DatasetDto var1);

    public void buildFilters(Map<String, String> filters, DatasetDto dto) {
        StringBuilder sb = new StringBuilder();
        DatasetDataVo datasetDataVo = new DatasetDataVo();
        ArrayList<DatasetPropertyVo> propertyVos = new ArrayList<DatasetPropertyVo>();
        for (Map.Entry<String, String> entry : filters.entrySet()) {
            String sourcePrefix = entry.getKey();
            String sourceSuffix = entry.getValue();
            Pair<String, String> propertyPrefix = this.getPropertyPrefix(sourcePrefix);
            ColumnInfoVo columnInfoVo = this.colsMapInfo.get(propertyPrefix.p1);
            if (columnInfoVo != null) {
                if (this.isProperty(sourcePrefix, columnInfoVo)) {
                    this.buildProperty(propertyVos, sourceSuffix, propertyPrefix);
                    continue;
                }
                this.buildExpression(sb, sourcePrefix, sourceSuffix);
                continue;
            }
            throw new InvalidFormulaException(FormulaError.CODE_209.getCode(), String.format(FormulaError.CODE_209.getMsg(), propertyPrefix.p1, propertyPrefix.p2));
        }
        String expression = sb.toString().replaceAll(",$", "");
        datasetDataVo.setColumns(propertyVos);
        dto.setExpression(expression);
        dto.setTempExpression(expression);
        dto.setData(JSON.toJSONString((Object)datasetDataVo));
        this.exFillData(dto);
    }

    protected void buildExpression(StringBuilder sb, String sourcePrefix, String sourceSuffix) {
        String handlePrefix = this.getDecodeStr(sourcePrefix);
        String handleSuffix = this.handleExpression(sourceSuffix);
        if (!handlePrefix.isEmpty() && !handleSuffix.isEmpty()) {
            sb.append(handlePrefix).append(".").append("*".equals(handleSuffix) ? "$All" : handleSuffix).append(",");
        }
    }

    protected void buildProperty(List<DatasetPropertyVo> vos, String sourceSuffix, Pair<String, String> propertyPrefix) {
        DatasetPropertyVo datasetPropertyVo = this.getDatasetPropertyVo(propertyPrefix);
        List<DatasetFilterVo> filterVos = this.getDatasetFilterVos(sourceSuffix);
        datasetPropertyVo.setFilters(filterVos);
        vos.add(datasetPropertyVo);
    }

    protected void exFillData(DatasetDto dto) {
    }

    protected List<DatasetFilterVo> getDatasetFilterVos(String sourceSuffix) {
        ArrayList<DatasetFilterVo> filterVos = new ArrayList<DatasetFilterVo>(12);
        List<Pair<String, String>> conditions = this.handleConditions(sourceSuffix);
        for (Pair<String, String> v : conditions) {
            if (StringUtils.isEmpty((CharSequence)((CharSequence)v.p1))) continue;
            if (StringUtils.isEmpty((CharSequence)((CharSequence)v.p2))) {
                throw new InvalidFormulaException(FormulaError.CODE_210.getCode(), String.format(FormulaError.CODE_210.getMsg(), v.p1, sourceSuffix));
            }
            filterVos.add(new DatasetFilterVo((String)v.p2, (String)v.p1));
        }
        return filterVos;
    }

    protected DatasetPropertyVo getDatasetPropertyVo(Pair<String, String> propertyPrefix) {
        DatasetPropertyVo datasetPropertyVo = new DatasetPropertyVo();
        if (ColTypeEnum.DIM.getType().equals(this.colsMapInfo.get(propertyPrefix.p1).getCustom())) {
            datasetPropertyVo.setNumber((String)propertyPrefix.p2);
            datasetPropertyVo.setType(this.getColumnTypeCode(propertyPrefix));
            datasetPropertyVo.setSource(this.colsMapInfo.get(propertyPrefix.p1).getNumber());
        } else if (ColTypeEnum.DIM_EX.getType().equals(this.colsMapInfo.get(propertyPrefix.p1).getCustom())) {
            datasetPropertyVo.setId((String)propertyPrefix.p1);
            datasetPropertyVo.setNumber((String)propertyPrefix.p1);
            datasetPropertyVo.setType(ColumnTypeEnum.MEASURE.getCode());
            datasetPropertyVo.setSource("extend");
        } else if (ColTypeEnum.ISC.getType().equals(this.colsMapInfo.get(propertyPrefix.p1).getCustom())) {
            datasetPropertyVo.setId((String)propertyPrefix.p1);
            datasetPropertyVo.setName((String)propertyPrefix.p1);
            datasetPropertyVo.setNumber((String)propertyPrefix.p1);
            datasetPropertyVo.setSource("metadata");
        }
        return datasetPropertyVo;
    }

    public Integer getColumnTypeCode(Pair<String, String> propertyPrefix) {
        if ("name".equals(((String)propertyPrefix.p2).toLowerCase(Locale.ENGLISH)) || "number".equals(((String)propertyPrefix.p2).toLowerCase(Locale.ENGLISH))) {
            return ColumnTypeEnum.FIXED_COLUMN.getCode();
        }
        return ColumnTypeEnum.ATTRIBUTE_COLUMN.getCode();
    }

    public void checkFilterChunks(Map<String, String> filterChunks, DatasetDto dto) {
    }

    public String getDecodeStr(String key) {
        String removeSquareBrackets = this.removeSquareBrackets(key);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < removeSquareBrackets.length(); ++i) {
            char c = removeSquareBrackets.charAt(i);
            if (c == '\\' && i < removeSquareBrackets.length() - 1) {
                sb.append(removeSquareBrackets.charAt(++i));
                continue;
            }
            if (SYSTEM_KEYS.contains(String.valueOf(c))) continue;
            sb.append(removeSquareBrackets.charAt(i));
        }
        return sb.toString();
    }

    public String removeSquareBrackets(String key) {
        return key.replaceAll("^\\[|\\]$", "");
    }

    public boolean hasSquareBrackets(String key) {
        return key.startsWith("[") && key.endsWith("]");
    }

    public boolean isProperty(String key, ColumnInfoVo columnInfoVo) {
        if (key.startsWith("[") && key.endsWith("]")) {
            for (int i = 0; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (c == '\\') {
                    ++i;
                    continue;
                }
                if (c != '.') continue;
                return true;
            }
        }
        return columnInfoVo.getCustom().equals("2") || columnInfoVo.getCustom().equals("3");
    }

    protected Pair<String, String> getPropertyPrefix(String key) {
        String preDimNum = "";
        String tailFields = "";
        boolean inSQ = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '\\' && i < key.length() - 1) {
                sb.append(key.charAt(++i));
                continue;
            }
            if (c == '[') {
                inSQ = true;
                continue;
            }
            if (c == ']') {
                inSQ = false;
                continue;
            }
            if (c == '.' && inSQ) {
                preDimNum = sb.toString();
                continue;
            }
            if (SYSTEM_KEYS.contains(String.valueOf(c))) continue;
            sb.append(key.charAt(i));
        }
        if (sb.length() > preDimNum.length()) {
            tailFields = sb.toString().substring(preDimNum.length());
        }
        if (StringUtils.isEmpty((CharSequence)preDimNum)) {
            preDimNum = tailFields;
        }
        return new Pair((Object)preDimNum, (Object)tailFields);
    }

    public String getExFields(String key) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '\\' && i < key.length() - 1) {
                sb.append(key.charAt(++i));
                continue;
            }
            if (c == '[' || c == ']') continue;
            sb.append(key.charAt(i));
        }
        return sb.toString();
    }

    public Map<String, String> resolveFilterChunks(String filterStr) {
        String realFilterStr = filterStr.replaceAll("^\"|\"$", "");
        HashMap<String, String> chunkMaps = new HashMap<String, String>(12);
        char[] charArray = realFilterStr.toCharArray();
        int len = charArray.length;
        StringBuilder sb = new StringBuilder();
        StringBuilder head = new StringBuilder();
        StringBuilder tail = new StringBuilder();
        boolean inSquareBrackets = false;
        boolean inCurlyBraces = false;
        for (int i = 0; i < len; ++i) {
            char c = charArray[i];
            if (c == '\\' && i < len - 1) {
                sb.append(c).append(charArray[++i]);
                continue;
            }
            if (c == '{') {
                sb.append(c);
                inCurlyBraces = true;
                continue;
            }
            if (c == '}') {
                sb.append(c);
                inCurlyBraces = false;
                continue;
            }
            if (c == '[') {
                sb.append(c);
                inSquareBrackets = true;
                continue;
            }
            if (c == ']') {
                sb.append(c);
                inSquareBrackets = false;
                continue;
            }
            if (c == '.' && !inCurlyBraces && !inSquareBrackets) {
                head.append((CharSequence)sb);
                continue;
            }
            if (c == ',' && !inCurlyBraces && !inSquareBrackets) {
                boolean notEmpty = head.length() > 0;
                chunkMaps.put(notEmpty ? head.toString() : sb.toString(), notEmpty ? tail.append(sb.toString().substring(head.toString().length())).toString() : tail.toString());
                sb.setLength(0);
                head.setLength(0);
                tail.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            boolean notEmpty = head.length() > 0;
            chunkMaps.put(notEmpty ? head.toString() : sb.toString(), notEmpty ? tail.append(sb.toString().substring(head.toString().length())).toString() : tail.toString());
        }
        return chunkMaps;
    }

    public String prefixType(String prefix) {
        if (prefix.startsWith("[") && prefix.endsWith("]")) {
            for (int i = 0; i < prefix.length(); ++i) {
                char c = prefix.charAt(i);
                if (c == '\\') {
                    ++i;
                    continue;
                }
                if (c != '.') continue;
                return "1";
            }
            return "2";
        }
        return "3";
    }

    public List<Pair<String, String>> handleConditions(String suffix) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Pair<String, String>> filters = new ArrayList<Pair<String, String>>(12);
        boolean inSquareBrackets = false;
        boolean singleFilters = true;
        if (suffix.startsWith("{") && suffix.endsWith("}")) {
            singleFilters = false;
        }
        String calType = "";
        for (int i = 0; i < suffix.length(); ++i) {
            char c = suffix.charAt(i);
            if (c == '\\' && i < suffix.length() - 1) {
                sb.append(suffix.charAt(++i));
                continue;
            }
            if (c == '{') {
                inSquareBrackets = true;
                continue;
            }
            if (c == '}') {
                inSquareBrackets = false;
                continue;
            }
            if (OPERATOR_KEYS.contains(String.valueOf(c)) && (inSquareBrackets || singleFilters)) {
                calType = String.valueOf(c);
                if (i >= suffix.length() - 1 || !OPERATOR_KEYS.contains(String.valueOf(suffix.charAt(i + 1)))) continue;
                this.checkNextOperateKey(String.valueOf(c), String.valueOf(suffix.charAt(i + 1)));
                calType = calType + String.valueOf(suffix.charAt(++i));
                continue;
            }
            if (c == ',' && inSquareBrackets) {
                filters.add((Pair<String, String>)new Pair((Object)sb.toString(), (Object)QCPUtils.getSigns(calType)));
                calType = "";
                sb.setLength(0);
                continue;
            }
            if (SYSTEM_KEYS.contains(String.valueOf(c))) continue;
            sb.append(c);
        }
        if (sb.length() > 0) {
            filters.add((Pair<String, String>)new Pair((Object)sb.toString(), (Object)QCPUtils.getSigns(calType)));
        }
        return filters;
    }

    protected void checkNextOperateKey(String pre, String next) {
        if (StringUtils.equals((CharSequence)pre, (CharSequence)next)) {
            throw new InvalidFormulaException(FormulaError.CODE_210.getCode(), String.format(FormulaError.CODE_210.getMsg(), pre + next, pre + next));
        }
        if (!OPERATOR_KEYS.contains(pre + next)) {
            throw new InvalidFormulaException(FormulaError.CODE_210.getCode(), String.format(FormulaError.CODE_210.getMsg(), pre + next, pre + next));
        }
    }

    public String handleExpression(String suffix) {
        StringBuilder sb = new StringBuilder();
        boolean inSquareBrackets = false;
        for (int i = 0; i < suffix.length(); ++i) {
            char c = suffix.charAt(i);
            if (c == '\\' && i < suffix.length() - 1) {
                sb.append(suffix.charAt(++i));
                continue;
            }
            if (c == '[') {
                inSquareBrackets = true;
                continue;
            }
            if (c == ']') {
                inSquareBrackets = false;
                continue;
            }
            if (c == ',' && !inSquareBrackets) {
                sb.append(';');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

