/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.formulaengine.processor.abscommon;

import java.util.Arrays;
import java.util.List;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.formulaengine.exception.FormulaError;
import kd.epm.far.business.common.dataset.formulaengine.exception.InvalidFormulaException;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public interface IParamProcessor {
    public static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, IParamProcessor.class);
    public static final List<String> SYSTEM_KEYS = Arrays.asList("{", "}", "[", "]", ".", ",", "\"", "*");
    public static final List<String> OPERATOR_KEYS = Arrays.asList("<", ">", "=", "<>", ">=", "<=", "%");

    public void process(String var1, DatasetDto var2);

    default public void beforeCheck(String paramStr) {
        if (!this.checkParamStr(paramStr)) {
            throw new InvalidFormulaException(FormulaError.CODE_205.getCode(), FormulaError.CODE_205.getMsg());
        }
    }

    default public boolean checkParamStr(String paramStr) {
        return paramStr.startsWith("\"") && paramStr.endsWith("\"");
    }

    default public String removeDoubleQuotes(String paramStr) {
        return paramStr.replaceAll("^\"|\"$", "");
    }

    default public String resolveParam(String sourcekey) {
        String sk = this.removeDoubleQuotes(sourcekey);
        StringBuilder sb = new StringBuilder();
        int len = sk.length();
        for (int i = 0; i < len; ++i) {
            char c = sk.charAt(i);
            if (c == '\\' && i < len - 1) {
                sb.append(sk.charAt(++i));
                continue;
            }
            sb.append(sk.charAt(i));
        }
        return sb.toString();
    }
}

