/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.formulaengine.processor.cm.filter;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.business.common.dataset.dto.ColumnTypeEnum;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.formulaengine.dto.ColTypeEnum;
import kd.epm.far.business.common.dataset.formulaengine.dto.ColumnInfoVo;
import kd.epm.far.business.common.dataset.formulaengine.exception.FormulaError;
import kd.epm.far.business.common.dataset.formulaengine.exception.InvalidFormulaException;
import kd.epm.far.business.common.dataset.formulaengine.processor.abscommon.FilterProcessor;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.common.common.Pair;

public class CmExFilterProcessor
extends FilterProcessor {
    @Override
    public void initColsInfo(DatasetDto dto) {
        Long dataSrcId = dto.getDataSrcId();
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dataSrcId, DisModelTypeEnum.CM.getType());
        List<DimensionInfo> dimList = modelStrategyEx.getDim().getDimList();
        for (DimensionInfo v2 : dimList) {
            this.colsMapInfo.put(v2.getShortNumber(), new ColumnInfoVo(v2.getId(), v2.getNumber(), v2.getShortNumber(), v2.getEntityName(), ColTypeEnum.DIM.getType()));
        }
        DynamicObject[] extModelField = BusinessDataServiceHelper.load((String)"bcm_extmodelfield", (String)"id,extmodelid,extfield,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)dto.getExtendsModelId())}, (String)"sequence,extfield.number");
        if (extModelField == null) {
            throw new InvalidFormulaException(FormulaError.CODE_208.getCode(), String.format(FormulaError.CODE_208.getMsg(), dto.getExtendsModelNumber()));
        }
        Arrays.stream(extModelField).forEach(v -> this.colsMapInfo.put(v.getString("extfield.number"), new ColumnInfoVo(v.getLong("extfield.id"), v.getString("extfield.number"), v.getString("extfield.number"), "bcm_extmodelfield", ColTypeEnum.DIM_EX.getType())));
    }

    private DynamicObject[] getExtModelDim(Long extendsModelId) {
        DynamicObject[] extmodeldim = BusinessDataServiceHelper.load((String)"bcm_extmodeldim", (String)"id,extmodelid,dimension,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)extendsModelId)}, (String)"sequence");
        return extmodeldim;
    }

    @Override
    protected DatasetPropertyVo getDatasetPropertyVo(Pair<String, String> propertyPrefix) {
        DatasetPropertyVo datasetPropertyVo = new DatasetPropertyVo();
        if (((ColumnInfoVo)this.colsMapInfo.get(propertyPrefix.p1)).getCustom().equals("1")) {
            datasetPropertyVo.setNumber((String)propertyPrefix.p2);
            datasetPropertyVo.setType(this.getColumnTypeCode(propertyPrefix));
            datasetPropertyVo.setSource(((ColumnInfoVo)this.colsMapInfo.get(propertyPrefix.p1)).getNumber());
        } else if (((ColumnInfoVo)this.colsMapInfo.get(propertyPrefix.p1)).getCustom().equals("2")) {
            datasetPropertyVo.setId((String)propertyPrefix.p1);
            datasetPropertyVo.setNumber((String)propertyPrefix.p1);
            datasetPropertyVo.setType(ColumnTypeEnum.MEASURE.getCode());
            datasetPropertyVo.setSource("extend");
        }
        return datasetPropertyVo;
    }

    @Override
    public String prefixType(String prefix) {
        ColumnInfoVo columnInfoVo;
        if (prefix.startsWith("[") && prefix.endsWith("]")) {
            for (int i = 0; i < prefix.length(); ++i) {
                char c = prefix.charAt(i);
                if (c == '\\') {
                    ++i;
                    continue;
                }
                if (c != '.') continue;
                return "1";
            }
        }
        if ((columnInfoVo = (ColumnInfoVo)this.colsMapInfo.get(this.getExFields(prefix))) != null && "bcm_extmodelfield".equals(columnInfoVo.getEntityName())) {
            return "3";
        }
        return "2";
    }
}

