/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.formulaengine.processor.cm.metric;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.business.common.dataset.dto.ColumnTypeEnum;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.formulaengine.exception.FormulaError;
import kd.epm.far.business.common.dataset.formulaengine.exception.InvalidFormulaException;
import kd.epm.far.business.common.dataset.formulaengine.processor.abscommon.MetricValueProcessor;

public class CmEXMetricValueProcessor
extends MetricValueProcessor {
    @Override
    public void process(String param, DatasetDto dto) {
        super.process(param, dto);
        List<String> values = this.resolveValue(this.removeDoubleQuotes(param));
        String data = dto.getData();
        List<String> exCols = this.getExCols(dto);
        DatasetDataVo datasetDataVo = new DatasetDataVo();
        if (!StringUtils.isEmpty((CharSequence)data)) {
            datasetDataVo = (DatasetDataVo)JSONObject.parseObject((String)data, DatasetDataVo.class);
        }
        List<Object> columnPs = datasetDataVo == null || datasetDataVo.getColumns() == null ? new ArrayList(12) : datasetDataVo.getColumns();
        ArrayList columns = new ArrayList(12);
        if (!columnPs.isEmpty()) {
            List collect = columnPs.stream().map(v -> v.getNumber()).collect(Collectors.toList());
            columns.addAll(collect);
        }
        for (String value : values) {
            if (columns.contains(value) || !exCols.contains(value)) continue;
            DatasetPropertyVo datasetPropertyVo = new DatasetPropertyVo();
            datasetPropertyVo.setId(value);
            datasetPropertyVo.setNumber(value);
            datasetPropertyVo.setType(ColumnTypeEnum.MEASURE.getCode());
            datasetPropertyVo.setSource("extend");
            columnPs.add(datasetPropertyVo);
        }
        dto.setData(JSONObject.toJSONString((Object)datasetDataVo));
    }

    public List<String> getExCols(DatasetDto dto) {
        ArrayList<String> exCols = new ArrayList<String>(12);
        DynamicObject[] extModelField = BusinessDataServiceHelper.load((String)"bcm_extmodelfield", (String)"id,extmodelid,extfield,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)dto.getExtendsModelId())}, (String)"sequence,extfield.number");
        if (extModelField == null) {
            throw new InvalidFormulaException(FormulaError.CODE_208.getCode(), String.format(FormulaError.CODE_208.getMsg(), dto.getExtendsModelNumber()));
        }
        Arrays.stream(extModelField).forEach(v -> exCols.add(v.getString("extfield.number")));
        return exCols;
    }
}

