/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.formulaengine.processor.eb;

import java.util.List;
import java.util.stream.Collectors;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.formulaengine.exception.FormulaError;
import kd.epm.far.business.common.dataset.formulaengine.exception.InvalidFormulaException;
import kd.epm.far.business.common.dataset.formulaengine.processor.abscommon.IParamProcessor;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.eb.dto.EbDataset;

public class EbDataSetProcessor
implements IParamProcessor {
    @Override
    public void process(String param, DatasetDto dto) {
        String resolveParam = this.resolveParam(param);
        List<EbDataset> datasets = EbServiceHelper.getDataset(dto.getDataSrcNumber());
        List collect = datasets.stream().map(v -> v.getNumber()).collect(Collectors.toList());
        if (collect == null || collect.isEmpty()) {
            throw new InvalidFormulaException(FormulaError.CODE_215.getCode(), String.format(FormulaError.CODE_215.getMsg(), dto.getDataSrcNumber()));
        }
        if (!collect.contains(resolveParam)) {
            throw new InvalidFormulaException(FormulaError.CODE_216.getCode(), String.format(FormulaError.CODE_216.getMsg(), dto.getDataSrcNumber(), resolveParam));
        }
        dto.setEbDataset(this.resolveParam(param));
    }
}

