/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.formulaengine.processor.epm;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.dto.DatasetVoucherVo;
import kd.epm.far.business.common.dataset.formulaengine.dto.ColTypeEnum;
import kd.epm.far.business.common.dataset.formulaengine.dto.ColumnInfoVo;
import kd.epm.far.business.common.dataset.formulaengine.exception.FormulaError;
import kd.epm.far.business.common.dataset.formulaengine.exception.InvalidFormulaException;
import kd.epm.far.business.common.dataset.formulaengine.processor.abscommon.FilterProcessor;
import kd.epm.far.business.epm.EPMServiceHelper;
import kd.epm.far.business.epm.dto.EPMVoucherFieldVo;
import kd.epm.far.common.common.Pair;

public class EPMFilterProcessor
extends FilterProcessor {
    @Override
    public void initColsInfo(DatasetDto dto) {
        try {
            Map<String, String> fieldTypeEnum = EPMFilterProcessor.getFieldTypeEnum(dto);
            for (String key : fieldTypeEnum.keySet()) {
                this.colsMapInfo.put(key, new ColumnInfoVo(0L, key, key, "epdm_dm", ColTypeEnum.ISC.getType()));
            }
        }
        catch (Exception e) {
            throw new InvalidFormulaException(FormulaError.CODE_212.getCode(), FormulaError.CODE_212.getMsg(), e);
        }
    }

    public static Map<String, String> getFieldTypeEnum(DatasetDto dto) {
        List<EPMVoucherFieldVo> field = EPMServiceHelper.getField(dto.getVoucherId());
        return field.stream().collect(Collectors.toMap(EPMVoucherFieldVo::getNumber, EPMVoucherFieldVo::getType, (k1, k2) -> k1));
    }

    @Override
    protected void exFillData(DatasetDto dto) {
        String data = dto.getData();
        if (StringUtils.isEmpty((CharSequence)data)) {
            throw new InvalidFormulaException(FormulaError.CODE_211.getCode(), FormulaError.CODE_211.getMsg());
        }
        DatasetDataVo datasetDataVo = (DatasetDataVo)JSONObject.parseObject((String)data, DatasetDataVo.class);
        DatasetVoucherVo datasetVoucherVo = new DatasetVoucherVo(dto.getVoucherType(), dto.getVoucherNumber());
        datasetVoucherVo.setId(dto.getVoucherId());
        datasetDataVo.setDatasetVoucherVo(datasetVoucherVo);
        dto.setData(JSONObject.toJSONString((Object)datasetDataVo));
    }

    @Override
    protected DatasetPropertyVo getDatasetPropertyVo(Pair<String, String> propertyPrefix) {
        DatasetPropertyVo datasetPropertyVo = new DatasetPropertyVo();
        datasetPropertyVo.setId((String)propertyPrefix.p1);
        datasetPropertyVo.setName((String)propertyPrefix.p1);
        datasetPropertyVo.setNumber((String)propertyPrefix.p1);
        datasetPropertyVo.setSource("metadata");
        return datasetPropertyVo;
    }

    @Override
    protected Pair<String, String> getPropertyPrefix(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return new Pair((Object)"", (Object)"");
        }
        String newKey = key.replaceAll("^\\[|\\]$", "");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < newKey.length(); ++i) {
            char c = newKey.charAt(i);
            if (c == '\\' && i < newKey.length() - 1) {
                sb.append(newKey.charAt(++i));
                continue;
            }
            sb.append(newKey.charAt(i));
        }
        return new Pair((Object)sb.toString(), (Object)"");
    }
}

