/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.formulaengine.processor.epm;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.formulaengine.processor.abscommon.MetricValueProcessor;
import kd.epm.far.business.common.dataset.formulaengine.processor.epm.EPMFilterProcessor;

public class EPMValueProcessor
extends MetricValueProcessor {
    @Override
    public void process(String param, DatasetDto dto) {
        super.process(param, dto);
        List<String> values = this.resolveValue(this.removeDoubleQuotes(param));
        String data = dto.getData();
        List<String> fields = this.getFields(dto);
        DatasetDataVo datasetDataVo = new DatasetDataVo();
        if (!StringUtils.isEmpty((CharSequence)data)) {
            datasetDataVo = (DatasetDataVo)JSONObject.parseObject((String)data, DatasetDataVo.class);
        }
        List<Object> columnPs = datasetDataVo == null || datasetDataVo.getColumns() == null ? new ArrayList(12) : datasetDataVo.getColumns();
        ArrayList columns = new ArrayList(12);
        if (!columnPs.isEmpty()) {
            List collect = columnPs.stream().map(v -> v.getNumber()).collect(Collectors.toList());
            columns.addAll(collect);
        }
        for (String value : values) {
            if (columns.contains(value) || !fields.contains(value)) continue;
            DatasetPropertyVo datasetPropertyVo = new DatasetPropertyVo();
            datasetPropertyVo.setId(value);
            datasetPropertyVo.setName(value);
            datasetPropertyVo.setNumber(value);
            datasetPropertyVo.setSource("metadata");
            columnPs.add(datasetPropertyVo);
        }
        dto.setData(JSONObject.toJSONString((Object)datasetDataVo));
    }

    public List<String> getFields(DatasetDto dto) {
        return new ArrayList<String>(EPMFilterProcessor.getFieldTypeEnum(dto).keySet());
    }
}

