/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.formulaengine.processor.isc.filter;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetMetadataVo;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.formulaengine.dto.ColTypeEnum;
import kd.epm.far.business.common.dataset.formulaengine.dto.ColumnInfoVo;
import kd.epm.far.business.common.dataset.formulaengine.exception.FormulaError;
import kd.epm.far.business.common.dataset.formulaengine.exception.InvalidFormulaException;
import kd.epm.far.business.common.dataset.formulaengine.processor.abscommon.FilterProcessor;
import kd.epm.far.common.common.Pair;

public class ISCFilterProcessor
extends FilterProcessor {
    private static final String PROP_ENTRYENTITY = "prop_entryentity";
    private static final String PROP_NAME = "prop_name";
    private static final String DATA_TYPE = "data_type";
    private static final String DATA_SCHEMA = "data_schema";

    @Override
    public void initColsInfo(DatasetDto dto) {
        Long metadataId = dto.getMetadataId();
        try {
            Map<String, String> fieldTypeEnum = ISCFilterProcessor.getFieldTypeEnum(metadataId);
            for (Map.Entry<String, String> entry : fieldTypeEnum.entrySet()) {
                String key = entry.getKey();
                this.colsMapInfo.put(key, new ColumnInfoVo(0L, key, key, "isc_metadata_schema", ColTypeEnum.ISC.getType()));
            }
        }
        catch (Exception e) {
            throw new InvalidFormulaException(FormulaError.CODE_212.getCode(), FormulaError.CODE_212.getMsg(), e);
        }
    }

    @Override
    protected void exFillData(DatasetDto dto) {
        String data = dto.getData();
        if (StringUtils.isEmpty((CharSequence)data)) {
            throw new InvalidFormulaException(FormulaError.CODE_211.getCode(), FormulaError.CODE_211.getMsg());
        }
        DatasetDataVo datasetDataVo = (DatasetDataVo)JSONObject.parseObject((String)data, DatasetDataVo.class);
        datasetDataVo.setMetadata(new DatasetMetadataVo(dto.getMetadataId(), dto.getMetadataType()));
        dto.setData(JSONObject.toJSONString((Object)datasetDataVo));
    }

    @Override
    protected DatasetPropertyVo getDatasetPropertyVo(Pair<String, String> propertyPrefix) {
        DatasetPropertyVo datasetPropertyVo = new DatasetPropertyVo();
        datasetPropertyVo.setId((String)propertyPrefix.p1);
        datasetPropertyVo.setName((String)propertyPrefix.p1);
        datasetPropertyVo.setNumber((String)propertyPrefix.p1);
        datasetPropertyVo.setSource("metadata");
        return datasetPropertyVo;
    }

    public static Map<String, String> getFieldTypeEnum(Long iscMetadataId) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)12);
        DynamicObject integrateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)iscMetadataId, (String)"isc_metadata_schema");
        DynamicObjectCollection entryentityCollection = integrateObject.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject propEntryEntity : entryentityCollection) {
            DynamicObject childIntegrateObject;
            String propName = propEntryEntity.getString(PROP_NAME);
            String propDataType = propEntryEntity.getString(DATA_TYPE);
            String propDataSchema = propEntryEntity.getString(DATA_SCHEMA);
            map.put(propName, propDataType);
            if (!"REF".equals(propDataType) || (childIntegrateObject = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_metadata_schema", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)propDataSchema)})) == null) continue;
            DynamicObjectCollection childEntryentityCollection = childIntegrateObject.getDynamicObjectCollection(PROP_ENTRYENTITY);
            childEntryentityCollection.forEach(childPropEntryEntity -> {
                String childPropName = childPropEntryEntity.getString(PROP_NAME);
                String childPropDataType = childPropEntryEntity.getString(DATA_TYPE);
                String childField = propName + "." + childPropName;
                map.put(childField, childPropDataType);
            });
        }
        return map;
    }

    @Override
    protected Pair<String, String> getPropertyPrefix(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return new Pair((Object)"", (Object)"");
        }
        String newKey = key.replaceAll("^\\[|\\]$", "");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < newKey.length(); ++i) {
            char c = newKey.charAt(i);
            if (c == '\\' && i < newKey.length() - 1) {
                sb.append(newKey.charAt(++i));
                continue;
            }
            sb.append(newKey.charAt(i));
        }
        return new Pair((Object)sb.toString(), (Object)"");
    }
}

