/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.operatestrategy;

import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.operatestrategy.IDataSetOperate;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;

public class GuideDataSetOperate
implements IDataSetOperate {
    @Override
    public DatasetDto buildDataSetDto(DatasetDto datasetDto, OperationStatus status, long datasetId, Boolean isCopy) {
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)"fidm_dataset", (String)"id,name,number,discmodel.id");
        QFilter qFilter = new QFilter("dataset", "=", (Object)datasetId);
        DynamicObject dataSetSingleEntity = QueryServiceHelper.queryOne((String)"fidm_dataset_single", (String)"datasrctype,datasrcid,extendsmodelid,extendsmodelnumber,expression,value,defvalue,groupby,orderby,asc,top,dimnum,component.id,membernum,ebdataset", (QFilter[])qFilter.toArray());
        if (dyn == null || dataSetSingleEntity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\u3002", (String)"DatasetSingleNewPlugin_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (Boolean.TRUE.equals(isCopy)) {
            datasetDto.setNumber(dyn.getString("number") + "_copy");
            datasetDto.setName(DatasetServiceHelper.addPostfix(dyn.getLocaleString("name"), "_copy"));
        } else {
            datasetDto.setId(dyn.getLong("id"));
            datasetDto.setNumber(dyn.getString("number"));
            Object name = dyn.get("name");
            if (name instanceof Map) {
                datasetDto.setName(LocaleString.fromMap((Map)((Map)name)));
            } else {
                datasetDto.setName(name.toString());
            }
        }
        this.buildSrcType(datasetDto, dataSetSingleEntity);
        datasetDto.setDataSrcId(dataSetSingleEntity.getLong("datasrcid"));
        datasetDto.setExtendsModelId(dataSetSingleEntity.getLong("extendsmodelid"));
        datasetDto.setComponentId(dataSetSingleEntity.getLong("component.id"));
        datasetDto.setExtendsModelNumber(dataSetSingleEntity.getString("extendsmodelnumber"));
        datasetDto.setExpression(dataSetSingleEntity.getString("expression"));
        datasetDto.setValue(dataSetSingleEntity.getString("value"));
        datasetDto.setDefValue(dataSetSingleEntity.getString("defvalue"));
        datasetDto.setGroupBy(dataSetSingleEntity.getString("groupby"));
        datasetDto.setOrderBy(dataSetSingleEntity.getString("orderby"));
        datasetDto.setAsc(dataSetSingleEntity.getString("asc"));
        datasetDto.setTop(dataSetSingleEntity.getInt("top"));
        datasetDto.setDimNum(dataSetSingleEntity.getString("dimnum"));
        datasetDto.setMemberNum(dataSetSingleEntity.getString("membernum"));
        datasetDto.setEbDataset(dataSetSingleEntity.getString("ebdataset"));
        return datasetDto;
    }

    @Override
    public void buildSrcType(DatasetDto datasetDto, DynamicObject dataSetSingleEntity) {
        String datasrcType = dataSetSingleEntity.getString("datasrctype");
        if (Objects.nonNull(datasrcType)) {
            Long databaseSrcId = dataSetSingleEntity.getLong("datasrcid");
            Long dataSrcId = datasetDto.getDataSrcId();
            if ("4".equals(datasrcType) || "5".equals(datasrcType)) {
                datasetDto.setDataSrcType(datasrcType);
            } else if (dataSrcId.equals(databaseSrcId)) {
                datasetDto.setDataSrcType(DataSrcTypeEnum.CURRENT_MODEL.getType());
            } else {
                datasetDto.setDataSrcType(datasrcType);
            }
        }
    }

    @Override
    public void buildNewDataSetDto(DatasetDto datasetDto, OperationStatus status) {
        if (Objects.isNull(status) || !status.equals((Object)OperationStatus.EDIT)) {
            datasetDto.setDataSrcType(DataSrcTypeEnum.CURRENT_MODEL.getType());
        }
    }
}

