/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.operatestrategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetMetadataVo;
import kd.epm.far.business.common.dataset.dto.DatasetVoucherVo;
import kd.epm.far.business.common.dataset.operatestrategy.IDataSetOperate;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;

public class QueryDataSetOperate
implements IDataSetOperate {
    @Override
    public DatasetDto buildDataSetDto(DatasetDto datasetDto, OperationStatus status, long datasetId, Boolean isCopy) {
        DynamicObject dataSetEntity = BusinessDataServiceHelper.loadSingleFromCache((Object)datasetId, (String)"fidm_dataset", (String)"id,name,number,discmodel.id,type");
        DynamicObject dataSetSingleEntity = this.getDataSetDynamicObject(datasetId, "dataset", "fidm_dataset_single", "datasrctype,datasrcid,extendsmodelid,extendsmodelnumber,expression,value,defvalue,groupby,orderby,asc,top,dimnum,component.id,membernum,ebdataset,data");
        if (dataSetEntity == null || dataSetSingleEntity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\u3002", (String)"DatasetSingleNewPlugin_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        Long dataSetSrcId = dataSetSingleEntity.getLong("datasrcid");
        datasetDto.setDataSrcId(dataSetSrcId);
        datasetDto.setType(dataSetEntity.getString("type"));
        if (Objects.isNull(status) || !status.equals((Object)OperationStatus.EDIT)) {
            this.buildNewDataSetDto(datasetDto, status);
            return datasetDto;
        }
        if (Boolean.TRUE.equals(isCopy)) {
            datasetDto.setNumber(dataSetEntity.getString("number") + "_copy");
            datasetDto.setName(DatasetServiceHelper.addPostfix(dataSetEntity.getLocaleString("name"), "_copy"));
        } else {
            datasetDto.setId(dataSetEntity.getLong("id"));
            datasetDto.setNumber(dataSetEntity.getString("number"));
            Object name = dataSetEntity.get("name");
            if (name instanceof Map) {
                datasetDto.setName(LocaleString.fromMap((Map)((Map)name)));
            } else {
                datasetDto.setName(name.toString());
            }
        }
        this.buildSrcType(datasetDto, dataSetSingleEntity);
        String dataSrcType = dataSetSingleEntity.getString("datasrctype");
        if (DataSrcTypeEnum.ISC_METADATA.getType().equals(dataSrcType) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(dataSrcType) || DataSrcTypeEnum.BCM_ISC_METADATA.getType().equals(dataSrcType)) {
            String data = dataSetSingleEntity.getString("data");
            DatasetDataVo datasetDataVo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
            if (Objects.nonNull(datasetDataVo)) {
                DatasetVoucherVo datasetVoucherVo;
                DatasetMetadataVo datasetMetadataVo = datasetDataVo.getMetadata();
                if (Objects.nonNull(datasetMetadataVo)) {
                    Long metadataId = datasetMetadataVo.getMetadataId();
                    String metadataType = datasetMetadataVo.getMetadataType();
                    datasetDto.setMetadataType(metadataType);
                    datasetDto.setMetadataId(metadataId);
                }
                if (Objects.nonNull(datasetVoucherVo = datasetDataVo.getDatasetVoucherVo())) {
                    datasetDto.setVoucherId(datasetVoucherVo.getId());
                    datasetDto.setVoucherNumber(datasetVoucherVo.getVoucherNumber());
                    datasetDto.setVoucherType(datasetVoucherVo.getVoucherType());
                }
                datasetDto.setValue(dataSetSingleEntity.getString("value"));
            }
            if (StringUtils.isNotEmpty((String)dataSetSingleEntity.getString("expression"))) {
                datasetDto.setExpression(dataSetSingleEntity.getString("expression"));
            }
        } else if (DataSrcTypeEnum.CM_TEMPLATE.getType().equals(dataSrcType)) {
            String data = dataSetSingleEntity.getString("data");
            DatasetDataVo datasetDataVo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
            datasetDto.setTemplateId(datasetDataVo.getTemplate().getTemplateId());
            datasetDto.setArea(datasetDataVo.getTemplate().getArea());
            datasetDto.setExpression(dataSetSingleEntity.getString("expression"));
            datasetDto.setExtendsModelId(dataSetSingleEntity.getLong("extendsmodelid"));
            datasetDto.setExtendsModelNumber(dataSetSingleEntity.getString("extendsmodelnumber"));
            datasetDto.setValue(dataSetSingleEntity.getString("value"));
        } else {
            datasetDto.setValue("FMONEY");
            datasetDto.setDetails(datasetDto.buildDetails());
            datasetDto.setDefValue("3");
            datasetDto.setExtendsModelId(dataSetSingleEntity.getLong("extendsmodelid"));
            datasetDto.setComponentId(dataSetSingleEntity.getLong("component.id"));
            datasetDto.setExtendsModelNumber(dataSetSingleEntity.getString("extendsmodelnumber"));
            datasetDto.setExpression(dataSetSingleEntity.getString("expression"));
            datasetDto.setValue(dataSetSingleEntity.getString("value"));
            datasetDto.setDefValue(dataSetSingleEntity.getString("defvalue"));
            datasetDto.setDimNum(dataSetSingleEntity.getString("dimnum"));
            datasetDto.setMemberNum(dataSetSingleEntity.getString("membernum"));
            datasetDto.setEbDataset(dataSetSingleEntity.getString("ebdataset"));
        }
        datasetDto.setDataSrcId(dataSetSingleEntity.getLong("datasrcid"));
        datasetDto.setGroupBy(dataSetSingleEntity.getString("groupby"));
        datasetDto.setOrderBy(dataSetSingleEntity.getString("orderby"));
        datasetDto.setAsc(dataSetSingleEntity.getString("asc"));
        datasetDto.setTop(dataSetSingleEntity.getInt("top"));
        datasetDto.setData(dataSetSingleEntity.getString("data"));
        return datasetDto;
    }

    @Override
    public void buildNewDataSetDto(DatasetDto datasetDto, OperationStatus status) {
    }

    @Override
    public void buildSrcType(DatasetDto datasetDto, DynamicObject dataSetSingleEntity) {
        String dataSrcType = dataSetSingleEntity.getString("datasrctype");
        if (DataSrcTypeEnum.CURRENT_MODEL.getType().equals(dataSrcType)) {
            Long dataSrcId = datasetDto.getDataSrcId();
            DynamicObject dynamicObject = this.getDataSetDynamicObject(dataSrcId, "id", "fidm_model", "modeltype");
            String modelType = dynamicObject.getString("modeltype");
            if (DisModelTypeEnum.CM.getType().equals(modelType)) {
                dataSrcType = DataSrcTypeEnum.MERGE_MODEL.getType();
            } else if (DisModelTypeEnum.EB.getType().equals(modelType)) {
                dataSrcType = DataSrcTypeEnum.EB_MODEL.getType();
            } else if (DisModelTypeEnum.RPT.getType().equals(modelType)) {
                dataSrcType = DataSrcTypeEnum.RPT_MODEL.getType();
            }
            datasetDto.setDataSrcType(dataSrcType);
        } else if (DataSrcTypeEnum.MERGE_MODEL.getType().equals(dataSrcType) || DataSrcTypeEnum.RPT_MODEL.getType().equals(dataSrcType) || DataSrcTypeEnum.EB_MODEL.getType().equals(dataSrcType) || DataSrcTypeEnum.ISC_METADATA.getType().equals(dataSrcType) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(dataSrcType) || DataSrcTypeEnum.CM_TEMPLATE.getType().equals(dataSrcType)) {
            datasetDto.setDataSrcType(dataSrcType);
        } else if (DataSrcTypeEnum.BCM_ISC_METADATA.getType().equals(dataSrcType)) {
            datasetDto.setDataSrcType(dataSrcType);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5c55\u793a\u5c5e\u6027\u53ea\u652f\u6301\u5408\u5e76\u3001\u8d22\u52a1\u3001\u9884\u7b97\u4f53\u7cfb", (String)"DatasetSingleNewPlugin_60", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }
}

