/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.common.dataset.dto.DatasetCheckExpParam;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.enums.DimTypesEnum;

public class DatasetCheckUtil {
    private static final String MONEY = "FMONEY";
    private static final Set<String> extendsDims = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getShortNumber(), DimTypesEnum.YEAR.getShortNumber(), DimTypesEnum.PERIOD.getShortNumber(), DimTypesEnum.ENTITY.getShortNumber(), DimTypesEnum.CURRENCY.getShortNumber(), DimTypesEnum.PROCESS.getShortNumber(), DimTypesEnum.AUDITTRIAL.getShortNumber()});

    private static void checkNotBlank(String s, String msg) {
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new KDBizException(msg);
        }
    }

    public static void valid(DatasetDto dto, boolean isShowExtends) {
        String[] array;
        ModelStrategyEx modelStrategyEx;
        String expression = dto.getExpression();
        String type = dto.getType();
        DatasetCheckUtil.checkNotBlank(dto.getType(), ResManager.loadKDString((String)"\u201c\u6570\u636e\u96c6\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_4", (String)"epm-far-business", (Object[])new Object[0]));
        DatasetCheckUtil.checkNotBlank(dto.getNumber(), ResManager.loadKDString((String)"\u201c\u6570\u636e\u96c6\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_5", (String)"epm-far-business", (Object[])new Object[0]));
        if (dto.getName() == null || StringUtils.isBlank((Object)dto.getName())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u6570\u636e\u96c6\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_6", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DatasetCheckUtil.checkNotBlank(dto.getDataSrcType(), ResManager.loadKDString((String)"\u201c\u6570\u636e\u6765\u6e90\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_7", (String)"epm-far-business", (Object[])new Object[0]));
        if (dto.getDataSrcId() == null || dto.getDataSrcId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u53d6\u6570\u6765\u6e90\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_8", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (DataSrcTypeEnum.ISC_METADATA.getType().equals(dto.getDataSrcType())) {
            return;
        }
        DatasetCheckUtil.checkNotBlank(expression, ResManager.loadKDString((String)"\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_9", (String)"epm-far-business", (Object[])new Object[0]));
        if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(type)) {
            DatasetCheckUtil.checkNotBlank(dto.getDefValue(), ResManager.loadKDString((String)"\u201c\u7f3a\u7701\u503c\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_10", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (DataSetTypeEnum.MULTIPLE_ROW.getType().equals(type) && StringUtils.isNotBlank((CharSequence)dto.getDefValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u591a\u884c\u6570\u636e\u96c6\u4e0d\u53ef\u586b\u5199\u201c\u7f3a\u7701\u503c\u201d\u3002", (String)"DatasetSingleNewPlugin_12", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (dto.getTop() != null && dto.getTop() < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u524d\u51e0\u6570\u636e\u201d\u5fc5\u987b\u662f\u6b63\u6574\u6570\u3002", (String)"DatasetSingleNewPlugin_17", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DatasetCheckUtil.checkNotBlank(dto.getValue(), ResManager.loadKDString((String)"\u201c\u5ea6\u91cf\u503c\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_27", (String)"epm-far-business", (Object[])new Object[0]));
        if (isShowExtends && (dto.getExtendsModelId() == null || dto.getExtendsModelId() == 0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u62d3\u5c55\u6a21\u578b\u201d\u3002", (String)"DatasetSingleNewPlugin_19", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (!isShowExtends && !MONEY.equals(dto.getValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5ea6\u91cf\u503c\u201d\u5fc5\u987b\u662fFMONEY\u3002", (String)"DatasetSingleNewPlugin_28", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if ("1".equals(type) && dto.getValue().contains(",")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5ea6\u91cf\u503c\u201d\u53ea\u80fd\u6709\u4e00\u4e2a\u503c\u3002", (String)"DatasetSingleNewPlugin_29", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (expression.length() > 2000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc72000\u3002", (String)"DatasetSingleNewPlugin_20", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (dto.getValue().length() > 1000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5ea6\u91cf\u503c\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc71000\u3002", (String)"DatasetSingleNewPlugin_21", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (dto.getGroupBy().length() > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5206\u7ec4\u5b57\u6bb5\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"DatasetSingleNewPlugin_22", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (dto.getOrderBy().length() > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u6392\u5e8f\u5b57\u6bb5\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"DatasetSingleNewPlugin_23", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (Objects.equals((Object)DisModelTypeEnum.getModelType(dto.getDataSrcType(), dto.getDataSrcId()), (Object)DisModelTypeEnum.EB) && StringUtils.isBlank((CharSequence)dto.getEbDataset())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u6570\u636e\u96c6\u3002", (String)"DatasetSingleEditPlugin_8", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (Objects.nonNull(dto.getDiscmodelId())) {
            modelStrategyEx = new ModelStrategyEx(dto.getDiscmodelId());
        } else {
            DisModelTypeEnum modelType = DisModelTypeEnum.getModelType(dto.getDataSrcType(), dto.getDataSrcId());
            modelStrategyEx = new ModelStrategyEx(dto.getDataSrcId(), modelType.getType());
        }
        String modelsourcetype = modelStrategyEx.getDim().getDimEntity();
        if (StringUtils.isNotBlank((CharSequence)dto.getDimNum())) {
            if (StringUtils.isBlank((CharSequence)dto.getMemberNum())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5217\u7ef4\u6210\u5458\u3002", (String)"DatasetSingleEditPlugin_7", (String)"epm-far-business", (Object[])new Object[0]));
            }
            String[] split = dto.getMemberNum().replaceAll("[\"\\[\\]]", "").split(",");
            if (split.length > 5) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5217\u7ef4\u6210\u5458\u6700\u591a\u9009\u62e95\u4e2a\u3002", (String)"DatasetSingleEditPlugin_6", (String)"epm-far-business", (Object[])new Object[0]));
            }
            String dimNumber = dto.getDimNum();
            for (String memberNum : split) {
                modelStrategyEx.getDimMember().findMemberByNumber(dimNumber, memberNum);
            }
        }
        if (StringUtils.isBlank((CharSequence)dto.getDimNum()) && StringUtils.isNotBlank((CharSequence)dto.getMemberNum())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5217\u7ef4\u5b57\u6bb5\u3002", (String)"DatasetSingleNewPlugin_62", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String modelNumber = DatasetExpressionHelper.getDatasetSrcModelNumber(dto.getDataSrcType(), dto.getDataSrcId());
        DatasetCheckExpParam param = new DatasetCheckExpParam();
        param.setExpression(expression).setModelSourceType(modelsourcetype).setModelId(dto.getDiscmodelId()).setDataSrcType(dto.getDataSrcType()).setDataSrcId(dto.getDataSrcId()).setShowTips(true).setModelNumber(modelNumber).setEbDataset(dto.getEbDataset()).setChapterId(dto.getChapterId()).setStyle(dto.getStyle());
        DatasetExpressionHelper.checkExpression(param);
        DatasetExpressionHelper.checkDimRepeatExpression(expression, null);
        if (isShowExtends) {
            List<String> dims = DatasetExpressionHelper.getExpressionDimList(expression, dto.getDiscmodelId(), dto.getChapterId());
            Set<String> extendsDims = DatasetCheckUtil.getExtendsDims(dto.getExtendsModelId());
            if (!extendsDims.containsAll(dims)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u516c\u5f0f\u4e2d\u5b58\u5728\u975e\u5f53\u524d\u62d3\u5c55\u7ef4\u6a21\u578b\u7684\u7ef4\u5ea6\u3002", (String)"DatasetSingleEditPlugin_9", (String)"epm-far-business", (Object[])new Object[0]));
            }
            DatasetUtil.getHasAllDim(expression, true);
        }
        if ((array = DatasetExpressionHelper.getReplacedVar(param.getExpression(), param.getModelId(), param.getVarParams(), dto.getChapterId()).split(",")).length == 0) {
            return;
        }
        ArrayList lists = Lists.newArrayListWithExpectedSize((int)array.length);
        for (String ele : array) {
            if (!ele.contains(".")) continue;
            String[] pairs = DatasetExpressionHelper.splitDimAndMemb(ele);
            lists.add(pairs[0]);
        }
        DatasetCheckUtil.checkExist(lists, dto.getGroupBy(), "group", dto.getValue());
        DatasetCheckUtil.checkExistGroup(dto);
        DatasetCheckUtil.checkExist(lists, dto.getOrderBy(), "order", dto.getValue());
    }

    public static Set<String> getExtendsDims(Long extendId) {
        Set<String> returnSet = DatasetCheckUtil.getBaseExtendsDims();
        returnSet.addAll(DatasetCheckUtil.getOtherExtendsDims(extendId));
        return returnSet;
    }

    public static Set<String> getBaseExtendsDims() {
        return Sets.newHashSet(extendsDims);
    }

    public static Set<String> getOtherExtendsDims(Long extendId) {
        DynamicObject[] extmodeldim = BusinessDataServiceHelper.load((String)"bcm_extmodeldim", (String)"id,extmodelid,dimension,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)extendId)}, (String)"sequence");
        if (Objects.isNull(extmodeldim)) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        HashSet returnSet = Sets.newHashSetWithExpectedSize((int)extmodeldim.length);
        for (DynamicObject dim : extmodeldim) {
            long dimId = dim.getLong("dimension.id");
            DynamicObject dimDy = BCMMemberReader.getDimensionDynById(dimId);
            if (!Objects.nonNull(dimDy)) continue;
            returnSet.add(dimDy.getString("shortnumber"));
        }
        return returnSet;
    }

    private static void checkExistGroup(DatasetDto dto) {
        String groupBy = dto.getGroupBy();
        String orderBy = dto.getOrderBy();
        String value = dto.getValue();
        if (StringUtils.isBlank((CharSequence)groupBy) || StringUtils.isBlank((CharSequence)orderBy)) {
            return;
        }
        String[] groupbys = groupBy.split(",");
        String[] orderBys = orderBy.split(",");
        String[] valueArray = value.split(",");
        Set collect = Arrays.stream(groupbys).collect(Collectors.toSet());
        Set valueCollect = Arrays.stream(valueArray).collect(Collectors.toSet());
        for (String g : orderBys) {
            if (StringUtils.isEmpty((CharSequence)g) || "fmoney".equals(g) || valueCollect.size() > 0 && valueCollect.contains(g) || collect.contains(g)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6392\u5e8f\u5b57\u6bb5%1$s \u4e0d\u5728\u5206\u7ec4\u5b57\u6bb5%2$s\u4e2d \u3002", (String)"DatasetSingleNewPlugin_43", (String)"epm-far-business", (Object[])new Object[0]), g, groupBy));
        }
    }

    private static void checkExist(List<String> lists, String expression, String source, String value) {
        String[] expressions;
        if (StringUtils.isBlank((CharSequence)expression)) {
            return;
        }
        HashSet set = Sets.newHashSetWithExpectedSize((int)lists.size());
        for (String s : expressions = expression.split(",")) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            if (set.contains(s)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e2d\u7684%1$s \u7684 %2$s\u91cd\u590d\u3002", (String)"DatasetSingleNewPlugin_58", (String)"epm-far-business", (Object[])new Object[0]), expression, s));
            }
            lists.add("SE");
            if (!lists.contains(s)) {
                if ("order".equals(source)) {
                    String[] valueArray = value.split(",");
                    Set valueCollect = Arrays.stream(valueArray).collect(Collectors.toSet());
                    if ("fmoney".equals(s) || valueCollect.size() > 0 && valueCollect.contains(s)) {
                        set.add(s);
                        continue;
                    }
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u201c\u5206\u7ec4\u5b57\u6bb5/\u6392\u5e8f\u5b57\u6bb5\u201d%1$s\uff0c\u8bf7\u786e\u8ba4\u8be5\u7ef4\u5ea6\u5728\u7ef4\u5ea6\u7ec4\u5408\u4e2d\u3002", (String)"DatasetSingleNewPlugin_59", (String)"epm-far-business", (Object[])new Object[0]), expression, s));
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u201c\u5206\u7ec4\u5b57\u6bb5/\u6392\u5e8f\u5b57\u6bb5\u201d%1$s\uff0c\u8bf7\u786e\u8ba4\u8be5\u7ef4\u5ea6\u5728\u7ef4\u5ea6\u7ec4\u5408\u4e2d\u3002", (String)"DatasetSingleNewPlugin_59", (String)"epm-far-business", (Object[])new Object[0]), expression, s));
            }
            set.add(s);
        }
    }
}

