/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.common.common.util.LongUtil;

public class DatasetDataReader {
    private static final Log logger = LogFactory.getLog(DatasetDataReader.class);
    private static final String DM_MODEL_PROPERTIES = "id,name,number,status,modeltype,model.id,modelsourcetype,modifytime,creator";
    private static final String DATASET_PROPERTIES = "id,number,name,type,status,chapterid,discmodel.id,discmodel.modelsourcetype,scope,currentstyle,category.id";
    private static final String DATASET_SINGLE_PROPERTIES = "datasrctype,datasrcid,extendsmodelid,extendsmodelnumber,expression,value,defvalue,orderby,groupby,top,asc,dataset.id,dataset.discmodel.id,dataset.type,dataset.name,dataset.currentstyle,component.id,dimnum,membernum,ebdataset,data,renameentity,renameentity.renamenumber,renameentity.renamename,renameentity.seq,joinentity,joinentity.seq,joinentity.joinsource,joinentity.joinnumber,joinentity.joinfield,joinentity.selectfields,calculateentity,calculateentity.calnumber,calculateentity.seq,calculateentity.calname,calculateentity.calexpression";
    private static final String DMMULTIVALUE_PROPERTIES = "id,number,name,formulatype,formulatext,dataset.discmodel.id,dataset.discmodel.modelsourcetype,single.id,single.dataset.id,single.dataset.name";

    public static DynamicObject getModel(Long dmModelId) {
        return DatasetDataReader.getModel(dmModelId, true);
    }

    public static DynamicObject getModel(Long dmModelId, boolean showException) {
        if (!LongUtil.isvalidLong((Object)dmModelId)) {
            return null;
        }
        DynamicObject dmModel = BusinessDataServiceHelper.loadSingleFromCache((Object)dmModelId, (String)"fidm_model", (String)DM_MODEL_PROPERTIES);
        if (showException && dmModel == null) {
            logger.error("dm modelId id not exist:" + dmModelId);
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DMDataReader_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return dmModel;
    }

    public static DisModelTypeEnum getTypeBySingleDatasetId(Long datasetId) {
        DynamicObject singleDS = DatasetDataReader.getSingleDS(datasetId);
        if (Objects.isNull(singleDS)) {
            logger.error("dm dataset single id not exist:" + datasetId);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u516c\u5f0f\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DMDataReader_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return DisModelTypeEnum.getModelType(singleDS.getString("datasrctype"), singleDS.getLong("datasrcid"));
    }

    public static DynamicObject getDataSet(Long dsId) {
        return DatasetDataReader.getDataSet(dsId, true);
    }

    public static DynamicObject getDataSet(Long dsId, boolean showException) {
        DynamicObject ds = null;
        if (!LongUtil.isvalidLong((Object)dsId)) {
            return ds;
        }
        ds = BusinessDataServiceHelper.loadSingleFromCache((Object)dsId, (String)"fidm_dataset", (String)DATASET_PROPERTIES);
        if (showException && ds == null) {
            logger.error("dm dataset id not exist:" + dsId);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DMDataReader_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return ds;
    }

    public static DynamicObject[] getDataSets(List<Long> dsIds) {
        DynamicObject[] list = new DynamicObject[]{};
        if (dsIds == null || dsIds.size() == 0) {
            return list;
        }
        QFilter qfilter = new QFilter("id", "in", dsIds);
        list = BusinessDataServiceHelper.loadFromCache((String)"fidm_dataset", (String)DATASET_PROPERTIES, (QFilter[])new QFilter[]{qfilter}).values().toArray(new DynamicObject[0]);
        return list;
    }

    public static DynamicObject getSingleDS(Long dsId) {
        return DatasetDataReader.getSingleDS(dsId, true);
    }

    public static DynamicObject getSingleDS(Long dsId, boolean showException) {
        if (!LongUtil.isvalidLong((Object)dsId)) {
            return null;
        }
        QFilter qfilter = new QFilter("dataset", "=", (Object)dsId);
        DynamicObject ds = BusinessDataServiceHelper.loadSingleFromCache((String)"fidm_dataset_single", (String)DATASET_SINGLE_PROPERTIES, (QFilter[])new QFilter[]{qfilter});
        if (showException && ds == null) {
            logger.error("dm dataset single id not exist:" + dsId);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u516c\u5f0f\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DMDataReader_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return ds;
    }

    public static Collection<DynamicObject> getSingleDSs(QFilter[] qFilters) {
        Collection<Object> list = new ArrayList<DynamicObject>(2);
        if (qFilters == null || qFilters.length == 0) {
            return list;
        }
        list = BusinessDataServiceHelper.loadFromCache((String)"fidm_dataset_single", (String)DATASET_SINGLE_PROPERTIES, (QFilter[])qFilters).values();
        return list;
    }

    public static DynamicObject getMultiDataSetValue(Long id, boolean showException) {
        DynamicObject ds = null;
        if (!LongUtil.isvalidLong((Object)id)) {
            return ds;
        }
        QFilter qfilter = new QFilter("id", "=", (Object)id);
        ds = BusinessDataServiceHelper.loadSingleFromCache((String)"fidm_dataset_multivalue", (String)DMMULTIVALUE_PROPERTIES, (QFilter[])new QFilter[]{qfilter});
        if (showException && ds == null) {
            logger.error("dm dataset multi id not exist:" + id);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u591a\u503c\u516c\u5f0f\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DMDataReader_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return ds;
    }

    public static Collection<DynamicObject> getMultiDataSetValues(QFilter[] qFilters) {
        Collection<Object> list = new ArrayList<DynamicObject>(2);
        if (qFilters == null || qFilters.length == 0) {
            return list;
        }
        list = BusinessDataServiceHelper.loadFromCache((String)"fidm_dataset_multivalue", (String)DMMULTIVALUE_PROPERTIES, (QFilter[])qFilters, (String)"desq asc").values();
        return list;
    }

    public static Collection<DynamicObject> getVariables(QFilter[] qFilters) {
        Collection<Object> list = new ArrayList<DynamicObject>(2);
        if (qFilters == null || qFilters.length == 0) {
            return list;
        }
        list = BusinessDataServiceHelper.loadFromCache((String)"fidm_disc_variable", (String)"id,number,chapterid,name,valuetype,defaultvalue,dimmembertype,scope,disc_dim,entryentity.enum_number,entryentity.enum_name,entryentity.isdefault,model", (QFilter[])qFilters).values();
        return list;
    }

    public static Collection<DynamicObject> getDataSetVars(QFilter[] qFilters) {
        Collection<Object> list = new ArrayList<DynamicObject>(2);
        if (qFilters == null || qFilters.length == 0) {
            return list;
        }
        list = BusinessDataServiceHelper.loadFromCache((String)"fidm_dataset_variable", (String)"variable.id,variable.number,variable.scope", (QFilter[])qFilters).values();
        return list;
    }
}

