/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.eb.dto.EbDim;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.enums.DataTypeEnum;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.common.common.util.QFBuilder;

public class DatasetDimService {
    private static final Set<String> extendsDims = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getShortNumber(), DimTypesEnum.YEAR.getShortNumber(), DimTypesEnum.PERIOD.getShortNumber(), DimTypesEnum.ENTITY.getShortNumber(), DimTypesEnum.CURRENCY.getShortNumber(), DimTypesEnum.PROCESS.getShortNumber(), DimTypesEnum.AUDITTRIAL.getShortNumber()});
    private static final Set<String> extendsDimNumbers = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber()});

    public Tuple<Long, String, Map<String, String>> getShortNumbers(String modelSourceType, String datasrctype, Long modelId, String isdetail) {
        return this.getShortNumbers(datasrctype, modelId, isdetail, "");
    }

    public Tuple<Long, String, Map<String, String>> getShortNumbers(String datasetSrcType, Long modelId, String isdetail, String datasetNumber) {
        LinkedHashMap<String, String> shortNumber2Num = new LinkedHashMap<String, String>(16);
        String entityname = "bcm_dimension";
        Long sourceModelId = 0L;
        DataSrcTypeEnum srcType = DataSrcTypeEnum.getByType(datasetSrcType);
        if (srcType == null) {
            return new Tuple((Object)sourceModelId, (Object)entityname, shortNumber2Num);
        }
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType(datasetSrcType, modelId);
        switch (modelType) {
            case CM: 
            case RPT: {
                String cube = BCMMemberReader.findModelNumberById(modelId);
                if (Objects.equals("1", isdetail)) {
                    shortNumber2Num.putAll(BCMMemberReader.getDimensionNumber2nameMap(cube));
                } else {
                    shortNumber2Num.putAll(BCMMemberReader.getDimensionShortNumber2NumberMap(cube));
                }
                sourceModelId = modelId;
                break;
            }
            case EB: {
                List<EbDim> dim = EbServiceHelper.getDim(EbServiceHelper.getModel(modelId).getString("shownumber"), datasetNumber);
                dim.forEach(ebDim -> {
                    if (Objects.equals("1", isdetail)) {
                        shortNumber2Num.put(ebDim.getShortNumber(), ebDim.getNumber() + ";" + ebDim.getName() + ";" + ebDim.getId() + ";");
                    } else {
                        shortNumber2Num.put(ebDim.getShortNumber(), ebDim.getNumber());
                    }
                });
                sourceModelId = modelId;
                entityname = "epm_dimension";
                break;
            }
        }
        Tuple result = new Tuple((Object)sourceModelId, (Object)entityname, shortNumber2Num);
        return result;
    }

    public Map<String, String> getExtendsFields(String dataSrcType, Long modelId, Long extendsmodelid, String isdetail) {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>(8);
        if (modelId == 0L || extendsmodelid == 0L) {
            return data;
        }
        if (DataSrcTypeEnum.MERGE_MODEL.getType().equals(dataSrcType) || DataSrcTypeEnum.RPT_MODEL.getType().equals(dataSrcType) || DataSrcTypeEnum.CM_TEMPLATE.getType().equals(dataSrcType) || DataSrcTypeEnum.CURRENT_MODEL.getType().equals(dataSrcType)) {
            QFBuilder qb = new QFBuilder("extmodelid", "=", (Object)extendsmodelid);
            Collection extmodelfield = BusinessDataServiceHelper.loadFromCache((String)"bcm_extmodelfield", (String)"id,extfield.id,extfield.datatype,extfield.number,extfield.name", (QFilter[])qb.toArray()).values();
            if (Objects.equals("1", isdetail)) {
                return extmodelfield.stream().collect(Collectors.toMap(s -> s.getString("extfield.number"), s -> {
                    if (Objects.nonNull(s.getLocaleString("extfield.name")) && Objects.nonNull(s.getLocaleString("extfield.name").getLocaleValue())) {
                        return s.getLocaleString("extfield.name").getLocaleValue() + ";" + s.getString("extfield.datatype");
                    }
                    return s.getString("extfield.name") + ";" + s.getString("extfield.datatype");
                }));
            }
            return extmodelfield.stream().collect(Collectors.toMap(s -> s.getString("extfield.number"), s -> {
                if (Objects.nonNull(s.getLocaleString("extfield.name")) && Objects.nonNull(s.getLocaleString("extfield.name").getLocaleValue())) {
                    return s.getLocaleString("extfield.name").getLocaleValue();
                }
                return s.getString("extfield.name");
            }));
        }
        if ("3".equals(dataSrcType)) {
            throw new KDBizException("INTEGRATION_SCHEME/INTEGRATED_DATA_SOURCE NOT IMPLEMENTS");
        }
        return data;
    }

    private List<Tuple<String, String, String>> dynamicObjects2Tuple(DynamicObjectCollection array) {
        ArrayList<Tuple<String, String, String>> data = new ArrayList<Tuple<String, String, String>>(8);
        if (Objects.isNull(array)) {
            return data;
        }
        for (DynamicObject one : array) {
            Tuple s = new Tuple((Object)one.getString("number"), (Object)one.getString("name"), (Object)one.getString("id"));
            data.add((Tuple<String, String, String>)s);
        }
        return data;
    }

    public List<Tuple<String, String, String>> getExtendsModel(String dataSrcType, Long modelId) {
        ArrayList<Tuple<String, String, String>> data = new ArrayList<Tuple<String, String, String>>(8);
        if (modelId == 0L) {
            return data;
        }
        if (DataSrcTypeEnum.MERGE_MODEL.getType().equals(dataSrcType) || DataSrcTypeEnum.RPT_MODEL.getType().equals(dataSrcType) || DataSrcTypeEnum.CURRENT_MODEL.getType().equals(dataSrcType) || DataSrcTypeEnum.CM_TEMPLATE.getType().equals(dataSrcType)) {
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and(new QFilter("extendsgroup.grouptype", "!=", (Object)"3"));
            DynamicObjectCollection array = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id,name,number", (QFilter[])qFilter.toArray(), (String)"number");
            return this.dynamicObjects2Tuple(array);
        }
        if (DataSrcTypeEnum.INTEGRATED_DATA_SOURCE.getType().equals(dataSrcType)) {
            throw new KDBizException("INTEGRATION_SCHEME/INTEGRATED_DATA_SOURCE NOT IMPLEMENTS");
        }
        return data;
    }

    public List<Tuple<String, String, String>> getExtendsFieldstTuple(String dataSrcType, Long modelId, Long extendsmodelid) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)8);
        if (modelId == 0L || extendsmodelid == 0L) {
            return list;
        }
        HashSet caltype = Sets.newHashSet((Object[])new String[]{DataTypeEnum.DEFAULT.getOIndex(), DataTypeEnum.CURRENCY.getOIndex(), DataTypeEnum.UNCURRENCY.getOIndex(), DataTypeEnum.PROPORTION.getOIndex()});
        if (DataSrcTypeEnum.MERGE_MODEL.getType().equals(dataSrcType) || DataSrcTypeEnum.RPT_MODEL.getType().equals(dataSrcType) || DataSrcTypeEnum.CM_TEMPLATE.getType().equals(dataSrcType) || DataSrcTypeEnum.CURRENT_MODEL.getType().equals(dataSrcType)) {
            QFBuilder qb = new QFBuilder("extmodelid", "=", (Object)extendsmodelid);
            Collection extmodelfield = BusinessDataServiceHelper.loadFromCache((String)"bcm_extmodelfield", (String)"id,extfield.id,extfield.datatype,extfield.number,extfield.name", (QFilter[])qb.toArray()).values();
            for (DynamicObject one : extmodelfield) {
                String extFieldType = one.getString("extfield.datatype");
                String reutnType = "text";
                if (caltype.contains(extFieldType)) {
                    reutnType = "number";
                }
                Tuple s = new Tuple((Object)one.getString("extfield.number"), (Object)one.getString("extfield.name"), (Object)reutnType);
                list.add(s);
            }
        }
        return list;
    }

    public Set<String> getExtendsDimNumbers(Long extendId) {
        HashSet returnSet = Sets.newHashSet(extendsDimNumbers);
        DynamicObject[] extmodeldim = BusinessDataServiceHelper.load((String)"bcm_extmodeldim", (String)"id,extmodelid,dimension,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)extendId)}, (String)"sequence");
        if (Objects.isNull(extmodeldim)) {
            return returnSet;
        }
        for (DynamicObject dim : extmodeldim) {
            long dimId = dim.getLong("dimension.id");
            DynamicObject dimDy = BCMMemberReader.getDimensionDynById(dimId);
            if (!Objects.nonNull(dimDy)) continue;
            returnSet.add(dimDy.getString("number"));
        }
        return returnSet;
    }

    public Set<String> getExtendsDims(Long extendId) {
        HashSet returnSet = Sets.newHashSet(extendsDims);
        DynamicObject[] extmodeldim = BusinessDataServiceHelper.load((String)"bcm_extmodeldim", (String)"id,extmodelid,dimension,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)extendId)}, (String)"sequence");
        if (Objects.isNull(extmodeldim)) {
            return returnSet;
        }
        for (DynamicObject dim : extmodeldim) {
            long dimId = dim.getLong("dimension.id");
            DynamicObject dimDy = BCMMemberReader.getDimensionDynById(dimId);
            if (!Objects.nonNull(dimDy)) continue;
            returnSet.add(dimDy.getString("shortnumber"));
        }
        return returnSet;
    }
}

