/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.bcm.dto.BCMMemberTreeNode;
import kd.epm.far.business.common.dataset.dto.DatasetCheckExpParam;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetDimService;
import kd.epm.far.business.common.dataset.util.DatasetMemberHelper;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.dataset.util.DmPeriodAndFyUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DatasetStyleEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.strategy.ModelStrategy;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.far.DimDefaultValueHelper;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.enums.DimEntityNumEnum;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.util.LongUtil;
import org.apache.commons.lang3.StringUtils;

public class DatasetExpressionHelper {
    protected static final char DIM_MEMB_SEPARATOR = '.';
    private static final String ORG_RELA_SIGN = "_";
    private static final Pattern EXPRESSION_CHECK_MULTI_MUMBER_REGEX = Pattern.compile("\\{(.*?)\\}");
    public static final Set<String> RANGE_NUMBER_SET = Sets.newHashSet((Object[])new String[]{RangeEnum.VALUE_10.getNumber(), RangeEnum.VALUE_20.getNumber(), RangeEnum.VALUE_30.getNumber(), RangeEnum.VALUE_40.getNumber(), RangeEnum.VALUE_50.getNumber(), RangeEnum.VALUE_60.getNumber(), RangeEnum.VALUE_70.getNumber(), RangeEnum.VALUE_90.getNumber(), RangeEnum.VALUE_110.getNumber()});
    private static final List<String> presetProcess = Lists.newArrayList((Object[])new String[]{"CCTotal", "CCADJ", "CC", "EJE", "PRPT", "CADJ", "ARPT", "ADJ", "Rpt", "IRpt", "RAdj"});
    private static String validexp = "^(?!_)[A-Za-z0-9-_.,;{}$\\+\\-]+$";
    private static final Pattern VARIABLE_REGEX = Pattern.compile("\\$[a-zA-Z0-9_\\-]+\\$");

    public static void checkExpression(Long dmModelId, Long datasetId, Long datasetMutiId, Map<String, Object> varParams) {
        DynamicObject dataSet = DatasetDataReader.getDataSet(datasetId);
        if (Objects.isNull(dataSet)) {
            return;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        ModelInfo fidmmodel = modelStrategyEx.getModel().getModelInfo();
        String modelsourcetype = modelStrategyEx.getDim().getDimEntity();
        Long datasrcid = fidmmodel.getModelId();
        DatasetCheckExpParam param = new DatasetCheckExpParam();
        if (dataSet.getString("type").equalsIgnoreCase("3")) {
            if (Objects.isNull(datasetMutiId) || datasetMutiId <= 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u591a\u503c\u6570\u636e\u96c6\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetExpressionHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
            }
            DynamicObject datasetMuti = DatasetDataReader.getMultiDataSetValue(datasetMutiId, true);
            if ("1".equals(datasetMuti.getString("formulatype"))) {
                Long singleDatasetId = datasetMuti.getLong("single.dataset.id");
                String singleDatasetName = datasetMuti.getString("single.dataset.name");
                DynamicObject singleDyn = DatasetDataReader.getSingleDS(singleDatasetId, false);
                if (Objects.isNull(singleDyn)) {
                    return;
                }
                String oriExpression = singleDyn.getString("expression");
                String datasrctype = singleDyn.getString("datasrctype");
                datasrcid = singleDyn.getLong("datasrcid");
                try {
                    String modelNumber = DatasetExpressionHelper.getDatasetSrcModelNumber(datasrctype, datasrcid);
                    param.setExpression(oriExpression).setModelSourceType(modelsourcetype).setModelId(dmModelId).setDataSrcType(datasrctype).setDataSrcId(datasrcid).setShowTips(false).setVarParams(varParams).setModelNumber(modelNumber).setEbDataset(singleDyn.getString("ebdataset")).setChapterId(dataSet.getLong("chapterid"));
                    DatasetExpressionHelper.checkExpression(param);
                }
                catch (KDBizException kdEx) {
                    throw new KDBizException(singleDatasetName + ":" + kdEx.getMessage());
                }
            }
        } else {
            DynamicObject singleDyn = DatasetDataReader.getSingleDS(datasetId, false);
            if (Objects.isNull(singleDyn)) {
                return;
            }
            String oriExpression = singleDyn.getString("expression");
            String datasrctype = singleDyn.getString("datasrctype");
            Long datasrcidEx = singleDyn.getLong("datasrcid");
            if (Objects.nonNull(datasrcidEx) && datasrcidEx > 0L) {
                datasrcid = datasrcidEx;
            }
            String modelNumber = DatasetExpressionHelper.getDatasetSrcModelNumber(datasrctype, datasrcid);
            param.setExpression(oriExpression).setModelSourceType(modelsourcetype).setModelId(dmModelId).setDataSrcType(datasrctype).setDataSrcId(datasrcid).setShowTips(false).setVarParams(varParams).setModelNumber(modelNumber).setEbDataset(singleDyn.getString("ebdataset")).setChapterId(dataSet.getLong("chapterid"));
            DatasetExpressionHelper.checkExpression(param);
        }
    }

    public static String getDatasetSrcModelNumber(String dataSrcType, Long srcId) {
        DynamicObject model = ModelStrategy.getStrategy(DisModelTypeEnum.getModelType(dataSrcType, srcId)).getModel(srcId);
        return model.getString("shownumber");
    }

    public static void checkExpression(Long dmModelId, Long datasetId) {
        DatasetExpressionHelper.checkExpression(dmModelId, datasetId, null);
    }

    public static void checkExpression(Long dmModelId, Long datasetId, Map<String, Object> varParams) {
        DynamicObject dataSet = DatasetDataReader.getDataSet(datasetId);
        if (Objects.isNull(dataSet)) {
            return;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        ModelInfo fidmmodel = modelStrategyEx.getModel().getModelInfo();
        String modelsourcetype = modelStrategyEx.getDim().getDimEntity();
        Long datasrcid = fidmmodel.getModelId();
        DatasetCheckExpParam param = new DatasetCheckExpParam();
        if (dataSet.getString("type").equalsIgnoreCase("3")) {
            DynamicObject[] dyns;
            for (DynamicObject dyn : dyns = DatasetDataReader.getMultiDataSetValues(new QFilter[]{new QFilter("dataset", "=", (Object)datasetId)}).toArray(new DynamicObject[0])) {
                if (!"1".equals(dyn.getString("formulatype"))) continue;
                Long singleDatasetId = dyn.getLong("single.dataset.id");
                String singleDatasetName = dyn.getString("single.dataset.name");
                DynamicObject singleDyn = DatasetDataReader.getSingleDS(singleDatasetId, false);
                if (Objects.isNull(singleDyn)) continue;
                String oriExpression = singleDyn.getString("expression");
                String datasrctype = singleDyn.getString("datasrctype");
                if (DataSrcTypeEnum.ISC_METADATA.getType().equals(datasrctype)) continue;
                datasrcid = singleDyn.getLong("datasrcid");
                try {
                    String modelNumber = DatasetExpressionHelper.getDatasetSrcModelNumber(datasrctype, datasrcid);
                    param.setExpression(oriExpression).setModelSourceType(modelsourcetype).setModelId(dmModelId).setDataSrcType(datasrctype).setDataSrcId(datasrcid).setShowTips(false).setVarParams(varParams).setModelNumber(modelNumber).setEbDataset(singleDyn.getString("ebdataset")).setChapterId(dataSet.getLong("chapterid"));
                    DatasetExpressionHelper.checkExpression(param);
                }
                catch (KDBizException kdEx) {
                    throw new KDBizException(singleDatasetName + ":" + kdEx.getMessage());
                }
            }
        } else {
            DynamicObject singleDyn = DatasetDataReader.getSingleDS(datasetId, false);
            if (Objects.isNull(singleDyn)) {
                return;
            }
            String datasrctype = singleDyn.getString("datasrctype");
            if (DataSrcTypeEnum.ISC_METADATA.getType().equals(datasrctype) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(datasrctype)) {
                return;
            }
            String oriExpression = singleDyn.getString("expression");
            Long datasrcidEx = singleDyn.getLong("datasrcid");
            if (Objects.nonNull(datasrcidEx) && datasrcidEx > 0L) {
                datasrcid = datasrcidEx;
            }
            String modelNumber = DatasetExpressionHelper.getDatasetSrcModelNumber(datasrctype, datasrcid);
            param.setExpression(oriExpression).setModelSourceType(modelsourcetype).setModelId(dmModelId).setDataSrcType(datasrctype).setDataSrcId(datasrcid).setShowTips(false).setVarParams(varParams).setModelNumber(modelNumber).setEbDataset(singleDyn.getString("ebdataset")).setChapterId(dataSet.getLong("chapterid"));
            DatasetExpressionHelper.checkExpression(param);
        }
    }

    public static List<String> getVarList(String expression) {
        ArrayList returnList = Lists.newArrayListWithExpectedSize((int)16);
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return returnList;
        }
        Matcher var = VARIABLE_REGEX.matcher(expression);
        while (var.find()) {
            String varNumber = expression.substring(var.start() + 1, var.end() - 1);
            returnList.add(varNumber);
        }
        return returnList;
    }

    public static void checkExpression(DatasetCheckExpParam param) {
        String expression = DatasetExpressionHelper.getReplacedVar(param.getExpression(), param.getModelId(), param.getVarParams(), param.getChapterId());
        Pattern p = Pattern.compile(validexp);
        Matcher m = p.matcher(expression);
        if (!m.matches()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e0d\u80fd\u5305\u542b`\u3002\uff0c\u3001\uff1f\u7b49\u7279\u6b8a\u5b57\u7b26\u3002", (String)"DatasetSingleNewPlugin_24", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String[] expressions = expression.split(",");
        if (expressions != null && expressions.length > 0) {
            for (String exp : expressions) {
                if (!exp.contains(".") && exp.contains("}") && !exp.contains("{")) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e2d\u7684\u7ef4\u5ea6\u6210\u5458 %s\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5305\u542b;\u5206\u9694\u7b26 \u3002", (String)"DatasetSingleNewPlugin_61", (String)"epm-far-business", (Object[])new Object[0]), exp));
                }
                if (!exp.contains(".")) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e2d\u7684\u7ef4\u5ea6\u6210\u5458 %s\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5305\u542b.\u5206\u9694\u7b26 \u3002", (String)"DatasetSingleNewPlugin_25", (String)"epm-far-business", (Object[])new Object[0]), exp));
                }
                if (!exp.startsWith(".") && !exp.endsWith(".")) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e2d\u7684\u7ef4\u5ea6\u6210\u5458\u201c%s\u201d \u3002", (String)"DatasetSingleNewPlugin_26", (String)"epm-far-business", (Object[])new Object[0]), exp));
            }
        }
        if (!expression.contains(".AllYear") && expression.contains(".All")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b \u201c.All\u201d\uff0c\u60a8\u60f3\u8981\u4f7f\u7528\u7684\u662f \u201c$All\u201d\uff1f", (String)"DatasetSingleNewPlugin_32", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (expression.contains(".ALL")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b \u201c.ALL\u201d\uff0c\u60a8\u60f3\u8981\u4f7f\u7528\u7684\u662f \u201c$ALL\u201d\uff1f", (String)"DatasetSingleNewPlugin_37", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (expression.contains(".all")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b \u201c.all\u201d\uff0c\u60a8\u60f3\u8981\u4f7f\u7528\u7684\u662f \u201c$all\u201d\uff1f", (String)"DatasetSingleNewPlugin_33", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (Objects.equals((Object)DisModelTypeEnum.EB, (Object)DisModelTypeEnum.getModelType(param.getDataSrcType(), param.getDataSrcId()))) {
            DatasetExpressionHelper.checkValidEbDims(expression, param.getModelNumber(), param.getEbDataset(), param.getModelId(), param.getStyle());
        } else {
            DatasetExpressionHelper.checkValidDims(expression, param.getModelSourceType(), param.getDataSrcType(), param.getDataSrcId(), param.getShowTips(), param.getStyle());
            DatasetExpressionHelper.checkMultiMumber(expression);
        }
    }

    private static void checkValidEbDims(String expression, String modelNumber, String ebDataset, Long modelId, String style) {
        List<Map<String, String>> memberListByExpression = DatasetExpressionHelper.getMemberListByExpression(expression);
        for (Map<String, String> map : memberListByExpression) {
            if (DatasetSpecialVarHelper.isEqualsCursVar(map.get("memberNumber")) && DatasetStyleEnum.GUIDE.getType().equals(style)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5411\u5bfc\u5f0f\u6570\u636e\u96c6\u4e0d\u652f\u6301\u7ef4\u5ea6\u8303\u56f4$Curs\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"DatasetSingleNewPlugin_63", (String)"epm-far-business", (Object[])new Object[0]));
            }
            if (!DatasetSpecialVarHelper.isEqualsCurVar(map.get("memberNumber")) && !DatasetSpecialVarHelper.isEqualsCursVar(map.get("memberNumber"))) continue;
            String memberNumber = DimDefaultValueHelper.getDefaultValue(map.get("dimNumber"), modelId, DisModelTypeEnum.EB, ebDataset).getDefaultValue();
            map.put("memberNumber", memberNumber);
        }
        EbServiceHelper.batchGetMembers(modelNumber, ebDataset, memberListByExpression);
    }

    public static List<Map<String, String>> getMemberListByExpression(String expression) {
        String[] dims = expression.split(",");
        ArrayList list = Lists.newArrayList();
        for (String dim : dims) {
            String[] split;
            String[] dimMember = DatasetExpressionHelper.splitDimAndMemb(dim);
            String right = dimMember[1];
            String para = right.startsWith("{") && right.endsWith("}") ? right.substring(1, right.length() - 1) : right;
            for (String s : split = para.split(";")) {
                HashMap map = Maps.newHashMap();
                map.put("dimNumber", dimMember[0]);
                if (s.contains(".")) {
                    String[] members = s.split("\\.");
                    RangeEnum rangeByNumber = RangeEnum.getRangeByNumber((String)members[members.length - 1]);
                    if (Objects.nonNull(rangeByNumber)) {
                        map.put("range", String.valueOf(rangeByNumber.getValue()));
                        String replace = s.replace("." + members[members.length - 1], "");
                        map.put("memberNumber", replace);
                    } else {
                        map.put("memberNumber", s);
                    }
                } else {
                    map.put("memberNumber", s);
                }
                list.add(map);
            }
        }
        return list;
    }

    public static void checkValidDims(String expression, String modelsourcetype, String datasrctype, Long modelId, boolean isShowTips, String style) {
        Tuple<Long, String, Map<String, String>> result = new DatasetDimService().getShortNumbers(modelsourcetype, datasrctype, modelId, "");
        Map shortNumber2Num = (Map)result.p3;
        DatasetExpressionHelper.checkValidDims(expression, isShowTips, shortNumber2Num, style);
    }

    public static String getReplacedVar(String formula, Long fidmmodelId, Map<String, Object> varParams, Long chapterId) {
        return DatasetExpressionHelper.getReplacedVar(formula, fidmmodelId, varParams, true, false, chapterId);
    }

    public static String getReplacedVar(String formula, Long fidmmodelId, Map<String, Object> varParams, boolean isCheckVar, boolean addToVars, Long chapterId) {
        String originFormula;
        if (StringUtils.isEmpty((CharSequence)formula) || !LongUtil.isvalidLong((Object)fidmmodelId)) {
            return formula;
        }
        Pattern VARIABLE_REGEX = Pattern.compile("\\$[a-zA-Z0-9_\\-]+\\$");
        Map<String, Object> dsVars = new DatasetMemberHelper().queryDatasetsVariable(fidmmodelId, chapterId);
        if (Objects.nonNull(varParams)) {
            for (Map.Entry<String, Object> entry : varParams.entrySet()) {
                if (!addToVars && !dsVars.containsKey(entry.getKey())) continue;
                dsVars.put(entry.getKey(), entry.getValue());
            }
        }
        Matcher m = VARIABLE_REGEX.matcher(formula);
        String replacedFormula = originFormula = formula;
        while (m.find()) {
            String originNumber;
            String replacedString = originNumber = formula.substring(m.start(), m.end());
            String varNumber = formula.substring(m.start() + 1, m.end() - 1);
            if (isCheckVar) {
                if (!dsVars.containsKey(varNumber)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e2d\u7684\u53d8\u91cf %s\uff0c\u8bf7\u786e\u8ba4\u8be5\u53d8\u91cf\u5b58\u5728 \u3002", (String)"DatasetSingleNewPlugin_31", (String)"epm-far-business", (Object[])new Object[0]), replacedString));
                }
                replacedFormula = replacedFormula.replace(replacedString, dsVars.get(varNumber).toString());
                continue;
            }
            if (!dsVars.containsKey(varNumber)) continue;
            replacedFormula = replacedFormula.replace(replacedString, dsVars.get(varNumber).toString());
        }
        return replacedFormula;
    }

    public static void checkValidDims(String expression, boolean isShowTips, Map<String, String> shortNumber2Num, String style) {
        String[] expressions = expression.split(",");
        ArrayList<String> entitys = new ArrayList<String>(8);
        ArrayList<String> currencys = new ArrayList<String>(8);
        ArrayList<String> processs = new ArrayList<String>(8);
        for (String exp : expressions) {
            String[] memSplitArr;
            String[] values = DatasetExpressionHelper.splitDimAndMemb(exp);
            if (!shortNumber2Num.containsKey(values[0])) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e2d\u7684\u7ef4\u5ea6 %s\uff0c\u8bf7\u786e\u8ba4\u8be5\u7ef4\u5ea6\u5728\u4f53\u7cfb\u4e2d \u3002", (String)"DatasetSingleNewPlugin_30", (String)"epm-far-business", (Object[])new Object[0]), values[0]));
            }
            if (values[1].startsWith("{") && values[1].endsWith("}")) {
                values[1] = values[1].substring(1, values[1].length() - 1);
            }
            for (String memItem : memSplitArr = values[1].split(";")) {
                if (DatasetSpecialVarHelper.isEqualsCurVar(memItem)) continue;
                if (DatasetSpecialVarHelper.isEqualsCursVar(memItem)) {
                    if (!DatasetStyleEnum.GUIDE.getType().equals(style)) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5411\u5bfc\u5f0f\u6570\u636e\u96c6\u4e0d\u652f\u6301\u7ef4\u5ea6\u8303\u56f4$Curs\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"DatasetSingleNewPlugin_63", (String)"epm-far-business", (Object[])new Object[0]));
                }
                if (DatasetSpecialVarHelper.isContainCurVar(memItem)) {
                    if (!DmPeriodAndFyUtil.validCur(memItem).booleanValue()) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e2d\u7684\u6210\u5458 %s\uff0c\u8bf7\u786e\u8ba4$cur\u683c\u5f0f\u3002", (String)"DatasetSingleNewPlugin_47", (String)"epm-far-business", (Object[])new Object[0]), values[1]));
                    }
                    if (!Objects.equals(values[0], "FY") && !Objects.equals(values[0], "P")) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e2d$cur\u504f\u79fb\u516c\u5f0f\u4ec5\u652f\u6301\u8d22\u5e74\u671f\u95f4\u3002", (String)"DatasetExpressionHelper_2", (String)"epm-far-business", (Object[])new Object[0]), values[1]));
                    }
                }
                if ("E".equalsIgnoreCase(values[0])) {
                    entitys.add(memItem);
                    continue;
                }
                if ("C".equalsIgnoreCase(values[0])) {
                    currencys.add(memItem);
                    continue;
                }
                if (!"BP".equalsIgnoreCase(values[0])) continue;
                processs.add(memItem);
            }
        }
        if (isShowTips) {
            DatasetExpressionHelper.checkDcParentChildPattern(entitys, currencys, processs);
        }
    }

    public static void checkMultiMumber(String expression) {
        List<String> multiMumberList = DatasetExpressionHelper.findMultiMumber(expression);
        if (multiMumberList == null || multiMumberList.isEmpty()) {
            return;
        }
        for (String multiMumber : multiMumberList) {
            if (multiMumber == null || multiMumber.isEmpty() || !multiMumber.contains(",")) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u6cd5\u5b57\u7b26\u201c,\u201d\uff0c\u60a8\u60f3\u8981\u4f7f\u7528\u7684\u662f\u201c;\u201d\u3002", (String)"DatasetSingleNewPlugin_36", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static void checkDcParentChildPattern(List<String> entitys, List<String> currencys, List<String> processs) {
        if (!currencys.contains("DC") && !currencys.contains("PC")) {
            return;
        }
        if (currencys.contains("DC") && processs.size() == 0) {
            String errInfo = ResManager.loadKDString((String)"\u5f53\u524d\u516c\u5f0f\u4e2d\u8fc7\u7a0b\u7ef4\u5ea6\u7f3a\u5931\u9ed8\u8ba4\u67e5\u8be2\u6240\u6709\u660e\u7ec6\u8fc7\u7a0b\u6570\u636e\uff1b\u4f46\u662f\u516c\u5f0f\u4e2d\u5e01\u79cdDC\u548c\u67d0\u4e9b\u8fc7\u7a0b\u7ec4\u5408\u9700\u8981\u7ec4\u7ec7\u7236_\u5b50\u683c\u5f0f\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5\u786e\u8ba4,\u5982\u679c\u4e0d\u5f71\u54cd\u8bf7\u5ffd\u7565\u3002", (String)"DatasetSingleNewPlugin_51", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("tips", errInfo), new Object[0]);
        }
        Boolean flag = entitys.stream().anyMatch(s -> !s.contains(ORG_RELA_SIGN));
        if (flag.booleanValue() && (currencys.contains("PC") || currencys.contains("DC") && (processs.size() == 0 || processs.stream().anyMatch(s -> presetProcess.contains(s) || DatasetSpecialVarHelper.isEqualsAllVar(s))))) {
            String errInfo = ResManager.loadKDString((String)"\u5f53\u5e01\u79cd\u5b58\u5728DC\u4e14\u8fc7\u7a0b\u4e3a\u975eERpt\u53ca\u5176\u5b50\u6210\u5458\u6216\u8005\u5e01\u79cd\u5b58\u5728PC\u65f6\u9700\u8981\u7236_\u5b50\u683c\u5f0f,\u5426\u5219\u4f1a\u53d6\u4e0d\u5230\u8be5\u7ec4\u7ec7\u7684DC\u5e01\u79cd\u6570\u636e\uff0c\u5982\u679c\u4e0d\u5f71\u54cd\u8bf7\u5ffd\u7565\u3002", (String)"DatasetSingleNewPlugin_50", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("tips", errInfo), new Object[0]);
        }
    }

    public static void checkValidRange(String multiMumber) {
        String[] split;
        for (String s : split = multiMumber.split(";")) {
            if (!s.contains(".")) continue;
            String[] memberAndRange = s.split("\\.");
            if (memberAndRange.length != 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5b9a\u4e49\u683c\u5f0f\u6709\u8bef\u3002", (String)"DatasetSingleNewPlugin_45", (String)"epm-far-business", (Object[])new Object[0]));
            }
            if (RANGE_NUMBER_SET.contains(memberAndRange[1])) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6b63\u786e\u7684\u8303\u56f4\u3002", (String)"DatasetSingleNewPlugin_46", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static List<String> findMultiMumber(String expression) {
        Matcher matcher = EXPRESSION_CHECK_MULTI_MUMBER_REGEX.matcher(expression);
        ArrayList<String> list = new ArrayList<String>(8);
        while (matcher.find()) {
            String findStr = matcher.group();
            list.add(findStr.substring(1, findStr.length() - 1));
        }
        return list;
    }

    public static List<String> getExpressionDimList(String originExp, Long modelId, Long chapterId) {
        String exp = DatasetExpressionHelper.getReplacedVar(originExp, modelId, null, false, false, chapterId);
        String[] array = exp.split(",");
        if (array == null || array.length <= 0) {
            return new ArrayList<String>(8);
        }
        ArrayList<String> list = new ArrayList<String>(8);
        for (String ele : array) {
            if (!ele.contains(".")) continue;
            String[] pairs = DatasetExpressionHelper.splitDimAndMemb(ele);
            list.add(pairs[0]);
        }
        return list;
    }

    public static void checkDimRepeatExpression(String expression, String varNumber) {
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return;
        }
        String[] dims = expression.split(",");
        HashSet dimSet = Sets.newHashSetWithExpectedSize((int)dims.length);
        for (String dim : dims) {
            String dimStr;
            int first = dim.trim().indexOf(46);
            if (first == -1 || dimSet.add(dimStr = dim.trim().substring(0, first))) continue;
            String varValue = StringUtils.isEmpty((CharSequence)varNumber) ? dim : varNumber + "(" + dim + ")";
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0e\u7ef4\u5ea6\u53d8\u91cf\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u96c6\u8bbe\u7f6e\u3002", (String)"DataSetTurnFormulaUtil_5", (String)"epm-far-business", (Object[])new Object[0]), varValue));
        }
    }

    public static String[] splitDimAndMemb(String param) {
        int first = (param = param.trim()).indexOf(46);
        if (first == -1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230 %s \u7ef4\u5ea6\u6210\u5458\u3002", (String)"DatasetExpressionHelper_3", (String)"epm-far-business", (Object[])new Object[0]), param));
        }
        String dim = param.substring(0, first);
        String member = param.substring(first + 1);
        return new String[]{dim, member};
    }

    public static List<String> stringToList(String data) {
        ArrayList<String> list = new ArrayList<String>(2);
        if (kd.bos.util.StringUtils.isEmpty((String)data)) {
            return list;
        }
        return Lists.newArrayList((Object[])data.split(","));
    }

    public static void buildMemberMap(String shortNumber, String member, Map<String, String> map, String modelNum, String dimNum, String purpose) {
        map.put("shortNumber", shortNumber);
        map.put("range", "");
        map.put("rangename", "");
        map.put("dimnumber", dimNum);
        if (member.contains("$")) {
            if (member.endsWith("$")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5305\u542b\u5176\u4ed6\u53d8\u91cf\u6210\u5458\u65e0\u6cd5\u89e3\u6790", (String)"DataSetDimGuidePlugin_5", (String)"epm-far-business", (Object[])new Object[0]));
            }
            if (DatasetSpecialVarHelper.isStartWithCursVar(member)) {
                map.put("name", ResManager.loadKDString((String)"\u8303\u56f4\u6210\u5458", (String)"DataSetDimGuidePlugin_9", (String)"epm-far-business", (Object[])new Object[0]));
            } else if (DatasetSpecialVarHelper.isStartWithCurVar(member)) {
                map.put("name", ResManager.loadKDString((String)"\u5f53\u524d\u6210\u5458", (String)"DataSetDimGuidePlugin_3", (String)"epm-far-business", (Object[])new Object[0]));
            } else if (DatasetSpecialVarHelper.isEqualsAllVar(member)) {
                map.put("name", ResManager.loadKDString((String)"\u5168\u90e8\u6210\u5458", (String)"DataSetDimGuidePlugin_4", (String)"epm-far-business", (Object[])new Object[0]));
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u5305\u542b\u5176\u4ed6\u53d8\u91cf\u6210\u5458\u65e0\u6cd5\u89e3\u6790", (String)"DataSetDimGuidePlugin_5", (String)"epm-far-business", (Object[])new Object[0]));
            }
            if (member.length() > 4) {
                map.put("number", member.substring(0, 4));
                map.put("range", member.substring(4));
                map.put("rangename", member.substring(4));
            } else {
                map.put("number", member);
            }
        } else {
            String[] split3 = member.split("\\.");
            Boolean notRange = Boolean.TRUE;
            if (split3.length > 1) {
                String firstInfo = member.substring(0, member.lastIndexOf("."));
                String lastInfo = member.substring(member.lastIndexOf(".") + 1);
                RangeEnum rangeEnum = RangeEnum.getRangeByNumber((String)lastInfo);
                if (rangeEnum == null) {
                    split3[0] = member;
                    notRange = Boolean.FALSE;
                } else if (split3.length > 2) {
                    split3[0] = firstInfo;
                    split3[1] = lastInfo;
                }
            }
            if (member.endsWith(".")) {
                split3[0] = member;
                notRange = Boolean.FALSE;
            }
            map.put("number", split3[0]);
            try {
                BCMMemberTreeNode findMember = BCMMemberReader.findMemberByNumber(modelNum, dimNum, split3[0]);
                if (findMember == null || BCMMemberTreeNode.NotFoundTreeNode.equals(findMember)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5305\u542b\u65e0\u6cd5\u89e3\u6790\u7684\u7ef4\u5ea6\u6210\u5458", (String)"DataSetDimGuidePlugin_6", (String)"epm-far-business", (Object[])new Object[0]));
                }
                String memberName = findMember.getName();
                map.put("name", memberName);
                if (ExpressoinPurpose.DIMANALYSIS.toString().equals(purpose)) {
                    String entityNumber = DimEntityNumEnum.getEntieyNumByNumber((String)dimNum);
                    map.put("dimension", entityNumber);
                    map.put("id", String.valueOf(findMember.getId()));
                    map.put("dseq", String.valueOf(findMember.getdSeq()));
                    String memeberNumber = findMember.getNumber();
                    map.put("number", memeberNumber);
                    map.put("label", memeberNumber + " " + memberName);
                }
                if (split3.length > 1 && notRange.booleanValue()) {
                    String range = split3[1];
                    RangeEnum rangeEnum = RangeEnum.getRangeByNumberOrName((String)range);
                    map.put("rangename", rangeEnum.getName());
                    if (!Objects.equals(RangeEnum.VALUE_10, rangeEnum)) {
                        map.put("range", rangeEnum.getNumber());
                    }
                } else if (ExpressoinPurpose.DIMANALYSIS.toString().equals(purpose)) {
                    map.put("range", RangeEnum.VALUE_10.getNumber());
                    map.put("rangename", RangeEnum.VALUE_10.getName());
                } else {
                    map.put("rangename", RangeEnum.VALUE_10.getName());
                }
            }
            catch (Exception ex) {
                map.put("name", split3[0]);
                map.put("rangename", RangeEnum.VALUE_10.getName());
            }
        }
    }

    public static enum ExpressoinPurpose {
        DIMANALYSIS,
        DATASETFORMULA;

    }
}

