/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.util;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;
import org.apache.commons.collections.map.MultiKeyMap;

public class DatasetMemberHelper {
    public static final String ORG_RELA_SIGN = "_";

    private static Object getVarValue(DynamicObject s) {
        String value = null;
        switch (s.getString("valuetype")) {
            case "4": {
                if (!Objects.nonNull(s.get("dimmembertype")) || !Objects.nonNull(s.get("defaultvalue"))) break;
                String entity = s.getString("dimmembertype");
                String defaultvalue = s.getString("defaultvalue");
                DynamicObject mem = BusinessDataServiceHelper.loadSingle((Object)LongUtil.toLong((Object)defaultvalue), (String)entity);
                if (!Objects.nonNull(mem)) break;
                value = mem.getString("number");
                break;
            }
            default: {
                if (!Objects.nonNull(s.get("defaultvalue"))) break;
                value = s.getString("defaultvalue");
            }
        }
        return value;
    }

    public static List<LinkedHashMap<String, Object>> menberWithName(List<LinkedHashMap<String, Object>> originresult, Long modelId, Long extendsmodelid) {
        if (Objects.isNull(originresult)) {
            return new ArrayList<LinkedHashMap<String, Object>>();
        }
        List<DimensionInfo> dimList = new ModelStrategyEx(modelId, DisModelTypeEnum.CM.getType()).getDim().getDimList();
        HashMap<String, String> fiedNumbers = new HashMap<String, String>(8);
        if (LongUtil.isvalidLong((Object)extendsmodelid)) {
            QFilter fieldFilter = new QFilter("extmodelid", "=", (Object)extendsmodelid);
            DynamicObjectCollection fieldCols = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)"extfield,extfield.number,extfield.name", (QFilter[])new QFilter[]{fieldFilter});
            fieldCols.forEach(s -> fiedNumbers.put(s.getString("extfield.number"), s.getString("extfield.name")));
        }
        HashMultimap dim2MembMap = HashMultimap.create();
        originresult.stream().flatMap(m -> m.entrySet().stream()).forEach(s -> {
            if (!("money".equals(((String)s.getKey()).toLowerCase(Locale.ENGLISH)) || "fmoney".equals(((String)s.getKey()).toLowerCase(Locale.ENGLISH)) || fiedNumbers.containsKey(s.getKey()))) {
                dim2MembMap.put(s.getKey(), (Object)(Objects.isNull(s.getValue()) ? "" : s.getValue().toString()));
            }
        });
        Map dim2members = dim2MembMap.asMap();
        MultiKeyMap map = new MultiKeyMap();
        dim2members.forEach((key, value) -> {
            DimensionInfo dimInfo = DimensionUtils.getDimByNumber(dimList, StringUtils.equals((CharSequence)"SourceEntity", (CharSequence)key) ? "Entity" : key);
            if (dimInfo != null) {
                QFBuilder qf = new QFBuilder("number", "in", value);
                HashSet<String> numbers = new HashSet<String>(value.size());
                if ("Entity".equalsIgnoreCase((String)key)) {
                    for (String s2 : value) {
                        if (s2.contains(ORG_RELA_SIGN)) {
                            int index = s2.indexOf(ORG_RELA_SIGN);
                            numbers.add(s2.substring(index + 1));
                            continue;
                        }
                        numbers.add(s2);
                    }
                    qf = new QFBuilder("number", "in", numbers);
                }
                qf.and("dimension", "=", (Object)dimInfo.getId());
                qf.and("model", "=", (Object)modelId);
                DynamicObjectCollection allmembers = QueryServiceHelper.query((String)dimInfo.getEntityName(), (String)"id,number,name", (QFilter[])qf.toArray());
                allmembers.forEach(s -> map.put(key, (Object)s.getString("number"), (Object)s.getString("name")));
            }
        });
        return DatasetMemberHelper.replaceValues(originresult, map, fiedNumbers);
    }

    public static List<Map<String, Object>> menberWithoutName(List<Map<String, Object>> originresult) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(originresult.size());
        for (Map<String, Object> data : originresult) {
            LinkedHashMap map = new LinkedHashMap(data.size());
            data.forEach((key, value) -> {
                if (!"money".equals(key.toLowerCase(Locale.ENGLISH)) && !"fmoney".equals(key.toLowerCase(Locale.ENGLISH)) && value.toString().contains(";")) {
                    String[] splited = value.toString().split(";");
                    map.put(key, splited[0]);
                } else {
                    map.put(key, value);
                }
            });
            result.add(map);
        }
        return result;
    }

    private static List<LinkedHashMap<String, Object>> replaceValues(List<LinkedHashMap<String, Object>> originresult, MultiKeyMap map, HashMap<String, String> fiedNumbers) {
        ArrayList<LinkedHashMap<String, Object>> result = new ArrayList<LinkedHashMap<String, Object>>(originresult.size());
        for (Map map2 : originresult) {
            LinkedHashMap replacedData = new LinkedHashMap(map2.size());
            map2.forEach((key, value) -> {
                Object originvalue = value;
                if ("Entity".equalsIgnoreCase((String)key) && value.toString().contains(ORG_RELA_SIGN)) {
                    int index = value.toString().indexOf(ORG_RELA_SIGN);
                    value = value.toString().substring(index + 1);
                }
                if ("money".equals(key.toLowerCase(Locale.ENGLISH)) || "fmoney".equals(key.toLowerCase(Locale.ENGLISH)) || fiedNumbers.containsKey(key)) {
                    replacedData.put(key, originvalue);
                } else if (key.contains("=")) {
                    replacedData.put(key, originvalue);
                } else if (Objects.nonNull(map.get(key, value))) {
                    replacedData.put(key, originvalue + ";" + map.get(key, value));
                } else {
                    replacedData.put(key, originvalue + ";" + originvalue);
                }
            });
            result.add(replacedData);
        }
        return result;
    }

    public Map<String, Object> queryDatasetsVariable(Collection<Long> datasetIds, Long chapterId) {
        Map<String, Object> numbermap = new HashMap<String, Object>(2);
        if (CollectionUtils.isEmpty(datasetIds)) {
            return numbermap;
        }
        QFilter qFilter = new QFilter("dataset", "in", datasetIds);
        Collection<DynamicObject> entrys = DatasetDataReader.getDataSetVars(qFilter.toArray());
        if (entrys == null || entrys.size() <= 0) {
            return numbermap;
        }
        List varIds = entrys.stream().map(entry -> entry.getLong("variable.id")).collect(Collectors.toList());
        if (varIds.size() > 0) {
            QFilter filter = new QFilter("id", "in", varIds);
            Collection<DynamicObject> dyns = DatasetDataReader.getVariables(filter.toArray());
            numbermap = dyns.stream().collect(Collectors.toMap(s -> s.getString("number"), DatasetMemberHelper::getVarValue, (s1, s2) -> s2));
        }
        if (Objects.nonNull(chapterId) && !CollectionUtils.isEmpty(numbermap)) {
            QFilter qt = new QFilter("scope", "=", (Object)"2").and(new QFilter("chapterid", "=", (Object)chapterId));
            Collection<DynamicObject> dys = DatasetDataReader.getVariables(qt.toArray());
            for (DynamicObject dy : dys) {
                if (!numbermap.containsKey(dy.getString("number"))) continue;
                numbermap.put(dy.getString("number"), DatasetMemberHelper.getVarValue(dy));
            }
        }
        return numbermap;
    }

    public Map<String, Object> queryDatasetsVariable(Long modelId, Long chapterId) {
        if (!LongUtil.isvalidLong((Object)modelId)) {
            return new HashMap<String, Object>();
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        List<DimensionInfo> allDimensions = modelStrategyEx.getDim().getDimList();
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        if (LongUtil.isvalidLong((Object)chapterId)) {
            filter.and(new QFilter("chapterid", "in", Arrays.asList(chapterId, 0L)));
        } else {
            filter.and(new QFilter("scope", "=", (Object)"1"));
        }
        DynamicObject[] dyns = DatasetDataReader.getVariables(filter.toArray()).toArray(new DynamicObject[0]);
        Map<String, Object> numbermap = Arrays.stream(dyns).sorted(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return Long.compare(o1.getLong("chapterid"), o2.getLong("chapterid"));
            }
        }).collect(Collectors.toMap(s -> s.getString("number"), s -> {
            String value = null;
            switch (s.getString("valuetype")) {
                case "4": {
                    DimensionInfo dim;
                    if (!Objects.nonNull(s.get("dimmembertype")) || !Objects.nonNull(s.get("defaultvalue"))) break;
                    String entity = s.getString("dimmembertype");
                    String defaultvalue = s.getString("defaultvalue");
                    DimMemberInfo memberInfo = modelStrategyEx.getDimMember().findMemberById(entity, LongUtil.toLong((Object)defaultvalue));
                    if (memberInfo == null || !Objects.nonNull(dim = DimensionUtils.getDimByEntity(allDimensions, entity))) break;
                    String shortNumber = dim.getShortNumber();
                    value = shortNumber + "." + memberInfo.getNumber();
                    break;
                }
                default: {
                    if (!Objects.nonNull(s.get("defaultvalue"))) break;
                    value = s.getString("defaultvalue");
                }
            }
            return value;
        }, (s1, s2) -> s2));
        return numbermap;
    }
}

