/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.epm.far.business.common.dataset.dto.DatasetCalculateVo;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.far.calculate.CalculateHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DatasetMutilExpressionHelper {
    protected static final String Single_DS_EXCEL_COLUNM = "A";
    protected static final String Mutil_DS_EXCEL_COLUNM = "B";
    protected static final String SINGLE_FORMULAR_TEMP = "&&&&&&&&";
    private static final BigDecimal VALUE = new BigDecimal("3.141592");

    public static void checkExpression(Long modelId, String expression, Set<String> singleDatasetNum) {
        DatasetMutilExpressionHelper.checkSingleDatasetInMultiExpressionSelected(singleDatasetNum, expression);
        HashMap<String, String> expressionMap = new HashMap<String, String>(2);
        expressionMap.put("1", expression);
        DatasetMutilExpressionHelper.calculate(modelId, expressionMap, null);
    }

    public static void checkExpression(String expression, Set<String> columns, Set<String> measures) {
        DatasetCalculateVo calculateVo = new DatasetCalculateVo();
        calculateVo.setNumber("calculateNumber");
        calculateVo.setExpression(expression);
        HashMap map = Maps.newHashMapWithExpectedSize((int)(columns.size() + measures.size()));
        columns.forEach(t -> map.put(t, Single_DS_EXCEL_COLUNM));
        measures.forEach(t -> map.put(t, VALUE));
        DatasetMutilExpressionHelper.calculate(Lists.newArrayList((Object[])new DatasetCalculateVo[]{calculateVo}), map);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> calculate(List<DatasetCalculateVo> list, Map<String, Object> params) {
        LinkedHashMap<String, ExcelCellEntity> columnsMap = new LinkedHashMap<String, ExcelCellEntity>(10);
        LinkedHashMap<String, ExcelCellEntity> expressionMap = new LinkedHashMap<String, ExcelCellEntity>(10);
        int singleIndex = 1;
        for (DatasetCalculateVo vo : list) {
            ExcelCellEntity mulilEntity = new ExcelCellEntity();
            mulilEntity.lineNumber = vo.getNumber();
            mulilEntity.formulatype = "2";
            mulilEntity.formulatext = vo.getExpression();
            expressionMap.put(mulilEntity.lineNumber, mulilEntity);
        }
        int mutilIndex = 1;
        if (expressionMap.size() > 0) {
            List<Object> columnsList = Lists.newArrayListWithExpectedSize((int)params.size());
            HashMap newParams = Maps.newHashMapWithExpectedSize((int)params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String number = entry.getKey();
                Object value = entry.getValue();
                if (number.contains("=")) {
                    String[] split = number.split("=");
                    number = split[1].substring(1, split[1].length() - 1);
                    columnsList.add(number);
                } else {
                    columnsList.add(number);
                }
                newParams.put(number, value);
            }
            columnsList = columnsList.stream().sorted((first, second) -> second.length() - first.length()).collect(Collectors.toList());
            for (Map.Entry<String, Object> entry : expressionMap.entrySet()) {
                ExcelCellEntity multiEntity = (ExcelCellEntity)entry.getValue();
                String formulatext = multiEntity.formulatext;
                for (String string : columnsList) {
                    if (!formulatext.contains(string)) continue;
                    if (!columnsMap.containsKey(string)) {
                        ExcelCellEntity entity = new ExcelCellEntity();
                        entity.formulatype = "1";
                        entity.singleDatasetNumber = string;
                        entity.formulatext = string;
                        entity.excelCellLocationIndex = singleIndex;
                        entity.excelFormulatext = Mutil_DS_EXCEL_COLUNM + singleIndex;
                        entity.excelValue = newParams.get(string);
                        ++singleIndex;
                        columnsMap.put(string, entity);
                    }
                    int excelCellLocationIndex = ((ExcelCellEntity)columnsMap.get((Object)string)).excelCellLocationIndex;
                    formulatext = formulatext.replace(string, SINGLE_FORMULAR_TEMP + excelCellLocationIndex + SINGLE_FORMULAR_TEMP);
                }
                multiEntity.excelFormulatext = DatasetMutilExpressionHelper.getExcelFormulatext(formulatext, columnsMap.size());
                multiEntity.excelCellLocationIndex = mutilIndex++;
            }
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("calulate");
        for (Map.Entry column : columnsMap.entrySet()) {
            XSSFCell cell;
            XSSFRow row = sheet.getRow(((ExcelCellEntity)column.getValue()).excelCellLocationIndex - 1);
            if (row == null) {
                row = sheet.createRow(((ExcelCellEntity)column.getValue()).excelCellLocationIndex - 1);
            }
            if ((cell = row.getCell(0)) == null) {
                cell = row.createCell(0, CellType.NUMERIC);
            }
            if (CalculateHelper.checkNumber(((ExcelCellEntity)column.getValue()).excelValue.toString())) {
                cell.setCellValue(TypeUtils.convertValueToDoule(((ExcelCellEntity)column.getValue()).excelValue).doubleValue());
                continue;
            }
            if (((ExcelCellEntity)column.getValue()).excelValue == null) {
                cell.setCellValue("");
                continue;
            }
            cell.setCellValue(((ExcelCellEntity)column.getValue()).excelValue.toString());
        }
        for (Map.Entry multi : expressionMap.entrySet()) {
            void var13_22;
            XSSFCell xSSFCell;
            ExcelCellEntity multiEntity = (ExcelCellEntity)multi.getValue();
            XSSFRow row = sheet.getRow(multiEntity.excelCellLocationIndex - 1);
            if (row == null) {
                row = sheet.createRow(multiEntity.excelCellLocationIndex - 1);
            }
            if ((xSSFCell = row.getCell(1)) == null) {
                XSSFCell xSSFCell2 = row.createCell(1, CellType.FORMULA);
            }
            try {
                var13_22.setCellFormula(multiEntity.excelFormulatext);
            }
            catch (Exception ex) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f[%1$s]\u8ba1\u7b97\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MutilValueCalculate_0", (String)"epm-far-business", (Object[])new Object[0]), multiEntity.formulatext));
            }
            CellValue cellVal = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator().evaluate((Cell)var13_22);
            if (cellVal == null) {
                multiEntity.excelValue = new BigDecimal(0);
            } else if (cellVal.getCellType() == CellType.NUMERIC) {
                multiEntity.excelValue = TypeUtils.convertValueToDecimal(String.valueOf(cellVal.getNumberValue())).toPlainString();
            } else if (cellVal.getCellType() == CellType.ERROR) {
                if (Objects.equals(cellVal.getErrorValue(), (byte)7)) {
                    multiEntity.excelValue = cellVal.formatAsString();
                }
                if (Objects.equals(cellVal.getErrorValue(), (byte)15)) {
                    multiEntity.excelValue = cellVal.formatAsString();
                }
            } else {
                multiEntity.excelValue = cellVal.getCellType() == CellType.STRING ? cellVal.getStringValue() : (cellVal.getCellType() == CellType.BOOLEAN ? cellVal.getBooleanValue() + "" : new BigDecimal(0));
            }
            returnMap.put(multiEntity.lineNumber, multiEntity.excelValue);
        }
        return returnMap;
    }

    public static Map<String, Object> calculate(Long modelId, Map<String, String> expressionMap, ICaculateOperation valFunction) {
        LinkedHashMap<Long, ExcelCellEntity> singleMap = new LinkedHashMap<Long, ExcelCellEntity>(10);
        LinkedHashMap<String, ExcelCellEntity> mutilMap = new LinkedHashMap<String, ExcelCellEntity>(10);
        int singleIndex = 1;
        for (Map.Entry<String, String> expression : expressionMap.entrySet()) {
            ExcelCellEntity mulilEntity = new ExcelCellEntity();
            mulilEntity.lineNumber = expression.getKey();
            mulilEntity.formulatype = "2";
            mulilEntity.formulatext = expression.getValue();
            mutilMap.put(mulilEntity.lineNumber, mulilEntity);
        }
        int mutilIndex = 1;
        if (mutilMap.size() > 0) {
            Map<String, DynamicObject> numberidmaps = DatasetMutilExpressionHelper.getAllSingleDsMap(modelId);
            String[] singleNumberList = numberidmaps.keySet().toArray(new String[0]);
            Arrays.sort(singleNumberList, (first, second) -> second.length() - first.length());
            for (Map.Entry mutil : mutilMap.entrySet()) {
                ExcelCellEntity multiEntity = (ExcelCellEntity)mutil.getValue();
                String formulatext = multiEntity.formulatext;
                for (String singleNumber : singleNumberList) {
                    if (!formulatext.contains(singleNumber)) continue;
                    DynamicObject singleDs = numberidmaps.get(singleNumber);
                    Long singleId = singleDs.getLong("dataset.id");
                    if (!singleMap.containsKey(singleId)) {
                        ExcelCellEntity entity = new ExcelCellEntity();
                        entity.formulatype = "1";
                        entity.singleDatasetId = singleId;
                        entity.singleDatasetNumber = singleDs.getString("dataset.number");
                        entity.formulatext = singleDs.getString("dataset.number");
                        entity.excelCellLocationIndex = singleIndex;
                        entity.excelFormulatext = Mutil_DS_EXCEL_COLUNM + singleIndex;
                        ++singleIndex;
                        singleMap.put(singleId, entity);
                    }
                    int excelCellLocationIndex = ((ExcelCellEntity)singleMap.get((Object)singleId)).excelCellLocationIndex;
                    formulatext = formulatext.replace(singleNumber, SINGLE_FORMULAR_TEMP + excelCellLocationIndex + SINGLE_FORMULAR_TEMP);
                }
                multiEntity.excelFormulatext = DatasetMutilExpressionHelper.getExcelFormulatext(formulatext, singleMap.size());
                multiEntity.excelCellLocationIndex = mutilIndex++;
            }
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        for (Map.Entry entry : singleMap.entrySet()) {
            Object val = new BigDecimal(0);
            if (valFunction != null) {
                val = valFunction.getSingleValue((Long)entry.getKey());
            }
            ((ExcelCellEntity)entry.getValue()).excelValue = val;
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet xSSFSheet = workbook.createSheet("calulate");
        for (Map.Entry single : singleMap.entrySet()) {
            XSSFCell cell;
            XSSFRow row = xSSFSheet.getRow(((ExcelCellEntity)single.getValue()).excelCellLocationIndex - 1);
            if (row == null) {
                row = xSSFSheet.createRow(((ExcelCellEntity)single.getValue()).excelCellLocationIndex - 1);
            }
            if ((cell = row.getCell(0)) == null) {
                cell = row.createCell(0, CellType.NUMERIC);
            }
            if (CalculateHelper.checkNumber(((ExcelCellEntity)single.getValue()).excelValue.toString())) {
                cell.setCellValue(TypeUtils.convertValueToDoule(((ExcelCellEntity)single.getValue()).excelValue).doubleValue());
                continue;
            }
            cell.setCellValue(((ExcelCellEntity)single.getValue()).excelValue.toString());
        }
        for (Map.Entry multi : mutilMap.entrySet()) {
            XSSFCell cell;
            ExcelCellEntity multiEntity = (ExcelCellEntity)multi.getValue();
            XSSFRow row = xSSFSheet.getRow(multiEntity.excelCellLocationIndex - 1);
            if (row == null) {
                row = xSSFSheet.createRow(multiEntity.excelCellLocationIndex - 1);
            }
            if ((cell = row.getCell(1)) == null) {
                cell = row.createCell(1, CellType.FORMULA);
            }
            try {
                cell.setCellFormula(multiEntity.excelFormulatext);
            }
            catch (Exception ex) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f[%1$s]\u8ba1\u7b97\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MutilValueCalculate_0", (String)"epm-far-business", (Object[])new Object[0]), multiEntity.formulatext));
            }
            CellValue cellVal = xSSFSheet.getWorkbook().getCreationHelper().createFormulaEvaluator().evaluate((Cell)cell);
            multiEntity.excelValue = cellVal == null ? new BigDecimal(0) : (cellVal.getCellType() == CellType.NUMERIC ? TypeUtils.convertValueToDecimal(String.valueOf(cellVal.getNumberValue())) : (cellVal.getCellType() == CellType.ERROR ? (Objects.equals(cellVal.getErrorValue(), (byte)7) && valFunction == null ? new BigDecimal(0) : cellVal.formatAsString()) : (cellVal.getCellType() == CellType.STRING ? cellVal.getStringValue() : new BigDecimal(0))));
            returnMap.put(multiEntity.lineNumber, multiEntity.excelValue);
        }
        return returnMap;
    }

    public static void checkSingleDatasetInMultiExpressionSelected(Set<String> singleDatasetNumberSet, String formulaText) {
        String[] singleNumbers;
        for (String number : singleNumbers = formulaText.split("[+\\-*/()]")) {
            if (!number.matches(".*[a-zA-Z].*") || singleDatasetNumberSet.contains(number.trim())) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\"\u591a\u503c\u516c\u5f0f\" %1$s \u4e2d\u7684 \"\u5355\u503c\u516c\u5f0f\" %2$s \u5fc5\u987b\u6dfb\u52a0\u5230\u5206\u5f55\u4e2d\u3002", (String)"MutilValueCalculate_1", (String)"epm-far-business", (Object[])new Object[0]), formulaText, number));
        }
    }

    private static String getExcelFormulatext(String formulatext, int singleIndex) {
        for (int i = 1; i < singleIndex + 1; ++i) {
            formulatext = formulatext.replace(SINGLE_FORMULAR_TEMP + i + SINGLE_FORMULAR_TEMP, Single_DS_EXCEL_COLUNM + i);
        }
        return formulatext;
    }

    private static Map<String, DynamicObject> getAllSingleDsMap(Long modelId) {
        QFilter qf = new QFilter("dataset.discmodel", "=", (Object)modelId).and("dataset.type", "=", (Object)"1");
        Collection<DynamicObject> singledsList = DatasetDataReader.getSingleDSs(new QFilter[]{qf});
        HashMap<String, DynamicObject> numberidmaps = new HashMap<String, DynamicObject>(singledsList.size());
        singledsList.forEach(s -> numberidmaps.put(s.getString("dataset.number").trim(), (DynamicObject)s));
        return numberidmaps;
    }

    public static interface ICaculateOperation {
        public Object getSingleValue(Long var1);
    }

    public static class ExcelCellEntity {
        public String lineNumber;
        public String formulatype;
        public Long singleDatasetId;
        public String singleDatasetNumber;
        public String formulatext;
        public String excelFormulatext;
        public int excelCellLocationIndex;
        public Object excelValue;
    }
}

