/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.bcm.dto.ReportDimResult;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import org.apache.commons.collections.CollectionUtils;

public class DatasetRowHelper {
    public static List<LinkedHashMap<String, Object>> rowTransferHandler(DatasetDto dto, List<LinkedHashMap<String, Object>> result, boolean isShowNumber) {
        if (CollectionUtils.isEmpty(result)) {
            return result;
        }
        if (Objects.isNull(dto)) {
            return result;
        }
        String dimNum = dto.getDimNum();
        if (StringUtils.isBlank((CharSequence)dimNum)) {
            return result;
        }
        String memberNum = dto.getMemberNum();
        if (StringUtils.isBlank((CharSequence)memberNum)) {
            return result;
        }
        List memberList = (List)SerializationUtils.fromJsonString((String)memberNum, List.class);
        if (CollectionUtils.isEmpty((Collection)memberList)) {
            return result;
        }
        HashSet allColumns = Sets.newHashSet();
        allColumns.addAll(result.get(0).keySet());
        if (!allColumns.contains(dimNum)) {
            return result;
        }
        allColumns.remove(dimNum);
        allColumns.remove("FMONEY");
        LinkedHashMap returnMap = Maps.newLinkedHashMap();
        List<String> addColumns = result.stream().filter(s -> Objects.nonNull(s.get(dimNum))).map(s -> (String)s.get(dimNum)).distinct().collect(Collectors.toList());
        if (!isShowNumber) {
            addColumns = result.stream().filter(s -> Objects.nonNull(s.get(dimNum))).map(s -> {
                String memberNumber = (String)s.get(dimNum);
                if (memberNumber.split(";").length > 0) {
                    memberNumber = memberNumber.split(";")[0];
                }
                return dimNum + "='" + memberNumber + "'";
            }).distinct().collect(Collectors.toList());
        }
        addColumns = DatasetRowHelper.filterAddColumns(addColumns, memberList);
        for (LinkedHashMap<String, Object> data : result) {
            String[] split;
            String column = (String)data.get(dimNum);
            Object value = data.get("FMONEY");
            if (StringUtils.isEmpty((CharSequence)column) || Objects.isNull(value) || !memberList.contains((split = column.split(";"))[0])) continue;
            StringBuilder keyBuilder = new StringBuilder();
            data.remove(dimNum);
            data.remove("FMONEY");
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                if (!allColumns.contains(entry.getKey())) continue;
                keyBuilder.append(entry.getValue());
            }
            LinkedHashMap map = (LinkedHashMap)returnMap.get(keyBuilder.toString());
            if (!isShowNumber) {
                String memberNumber = column;
                if (column.split(";").length > 0) {
                    memberNumber = column.split(";")[0];
                }
                column = dimNum + "='" + memberNumber + "'";
            }
            if (map == null) {
                for (String addColumn : addColumns) {
                    data.put(addColumn, null);
                }
                data.put(column, value);
                returnMap.put(keyBuilder.toString(), data);
                continue;
            }
            map.put(column, value);
        }
        return new ArrayList<LinkedHashMap<String, Object>>(returnMap.values());
    }

    private static List<String> filterAddColumns(List<String> addColumns, List<String> memberList) {
        if (CollectionUtils.isEmpty(addColumns) || CollectionUtils.isEmpty(memberList)) {
            return addColumns;
        }
        return addColumns.stream().filter(t -> DatasetRowHelper.needTransfer(t, memberList)).collect(Collectors.toList());
    }

    private static boolean needTransfer(String t, List<String> memberList) {
        if (t.contains("=")) {
            String[] split = t.split("=");
            return memberList.contains(split[1].substring(1, split[1].length() - 1));
        }
        String[] split = t.split(";");
        return memberList.contains(split[0]);
    }

    public static List<Map<String, Object>> filterByReportSetion(List<Map<String, Object>> result, Long componentId) {
        if (Objects.isNull(result)) {
            return result;
        }
        ReportDimResult reportDimResult = BCMMsServiceHelper.reportDimResultQueryData(componentId);
        List<Map<String, Object>> resultList = result;
        return resultList.stream().filter(t -> {
            StringBuilder sb = new StringBuilder();
            for (String dimKey : reportDimResult.getDimKeys()) {
                String s = t.getOrDefault(dimKey, "");
                sb.append(s.split(";")[0]).append("#");
            }
            return reportDimResult.getDimValues().contains(sb.toString());
        }).collect(Collectors.toList());
    }
}

