/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.dataset.dto.ColumnTypeEnum;
import kd.epm.far.business.common.dataset.dto.DataSet;
import kd.epm.far.business.common.dataset.dto.DataSetMultiValue;
import kd.epm.far.business.common.dataset.dto.DatasetCalculateVo;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetEntityVo;
import kd.epm.far.business.common.dataset.dto.DatasetJoinVo;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.dto.DatasetRenameVo;
import kd.epm.far.business.common.dataset.dto.DatasetVarAndDim;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetDimService;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DatasetStyleEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.FidmDataTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.common.variable.VariableService;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.business.fidm.design.DisclosureDesignHelper;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.enums.DataTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;

public class DatasetServiceHelper {
    private static final Log log = LogFactory.getLog(DatasetServiceHelper.class);
    private static final Pattern EXPRESSION_REGEX = Pattern.compile("'(.*?)'");
    private static final Pattern VARIABLE_REGEX = Pattern.compile("\\$[a-zA-Z0-9_\\-]+\\$");
    private static final String MODELID = "discmodel";
    private static final String closedcallback_add_dataset = "closedcallback_add_dataset";
    private static final String callbackid_delDataSet_confirm = "callbackid_delDataSet_confirm";
    private static final String DATASET_PREVIEW_CLOSE = "dataset_preview_close";
    private static final String DATASET_PREVIEW_PIVOT_CLOSE = "dataset_preview_pivot_close";
    private static final String RDS_CHAR_DOLLAR = "RDS_CHAR_DOLLAR";
    private static final String FIDMMODEL = "fidmmodel";
    private static final Pattern DATASET_NUMBER_REGEX = Pattern.compile("^[a-zA-Z0-9_]+$");
    private static final Pattern DATASET_MUST_CONTAIN_REGEX = Pattern.compile("^[0-9]+$");
    private DatasetDimService fidmDimService = new DatasetDimService();
    private static final String SELECT_FIELDS = "dataset,datasrctype,datasrcid,extendsmodelid,extendsmodelnumber,expression,value,defvalue,groupby,orderby,asc,top,dimnum,component.id,membernum,ebdataset,data,renameentity,renameentity.renamenumber,renameentity.renamename,renameentity.seq,joinentity,joinentity.seq,joinentity.joinsource,joinentity.joinnumber,joinentity.joinfield,joinentity.selectfields,calculateentity,calculateentity.calnumber,calculateentity.seq,calculateentity.calname,calculateentity.calexpression";

    public static List<Map<String, String>> getTreeList(Long modelId, String appNum) {
        return DatasetServiceHelper.getDBTreeList(modelId, "1", null, appNum);
    }

    public static List<Map<String, String>> getChapterTreeList(Long modelId, Long chapterId, String appNum) {
        return DatasetServiceHelper.getDBTreeList(modelId, "2", chapterId, appNum);
    }

    private static List<Map<String, String>> getDBTreeList(Long modelId, String scope, Long chapterId, String appNum) {
        DynamicObjectCollection dyns = DatasetServiceHelper.getDataSetFromDB(modelId, scope, chapterId, appNum);
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(dyns.size());
        for (DynamicObject dyn : dyns) {
            HashMap<String, String> treeNode = new HashMap<String, String>();
            treeNode.put("id", dyn.get("id").toString());
            treeNode.put("number", dyn.getString("number"));
            treeNode.put("name", dyn.getString("name"));
            treeNode.put("parentid", dyn.getString("type"));
            if ("1".equals(scope) || "2".equals(scope)) {
                treeNode.put("datasettype", scope);
            }
            treeList.add(treeNode);
        }
        return treeList;
    }

    private static DynamicObjectCollection getDataSetFromDB(Long modelId, String scope, Long chapterId, String appNum) {
        QFilter filter = new QFilter(MODELID, "=", (Object)(Objects.nonNull(modelId) ? modelId : 0L));
        filter.and("scope", "=", (Object)scope);
        if (chapterId != null) {
            filter.and("chapterid", "=", (Object)chapterId);
        }
        DatasetServiceHelper.addDataSetF7Filter(filter, modelId, RequestContext.get().getCurrUserId(), appNum);
        return QueryServiceHelper.query((String)"fidm_dataset", (String)"id,name,number,type", (QFilter[])new QFilter[]{filter});
    }

    public static QFilter getAllDataSetAndChapterDataSetQFilter(Long modelId, Long chapterId, String appNum) {
        QFilter filter = new QFilter(MODELID, "=", (Object)(Objects.nonNull(modelId) ? modelId : 0L));
        QFilter filter_1 = new QFilter("scope", "=", (Object)"1");
        QFilter filter_2 = new QFilter("scope", "=", (Object)"2");
        filter_2.and("chapterid", "=", (Object)chapterId);
        filter_1.or(filter_2);
        DatasetServiceHelper.addDataSetF7Filter(filter_1, modelId, RequestContext.get().getCurrUserId(), appNum);
        return filter.and(filter_1);
    }

    public static DynamicObject getDataSetById(Long datasetId) {
        QFilter filter = new QFilter("id", "=", (Object)datasetId);
        return QueryServiceHelper.queryOne((String)"fidm_dataset", (String)"id,status,name,number,type,discmodel,chapterId,scope", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObjectCollection getDatasetsByNumber(long modelId, List<String> numbers, long chapterId) {
        if (numbers == null || numbers.isEmpty()) {
            return null;
        }
        QFilter qFilter = new QFilter(MODELID, "=", (Object)modelId);
        qFilter.and("number", "in", numbers);
        if (chapterId == 0L) {
            qFilter.and("scope", "=", (Object)"1");
        } else {
            QFilter filter1 = new QFilter("scope", "=", (Object)"1");
            QFilter filter2 = new QFilter("scope", "=", (Object)"2");
            filter2.and("chapterid", "=", (Object)chapterId);
            qFilter.and(filter2.or(filter1));
        }
        return QueryServiceHelper.query((String)"fidm_dataset", (String)"id,name,number,type", (QFilter[])qFilter.toArray());
    }

    public static Boolean isMultiRowDataset(Long datasetId) {
        DynamicObject datasetDyn = DatasetDataReader.getDataSet(datasetId, false);
        if (Objects.nonNull(datasetDyn) && Objects.equals("2", datasetDyn.getString("type"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean deleteDataSet(Set<Long> ids) {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            DeleteServiceHelper.delete((String)"fidm_dataset", (QFilter[])new QFBuilder("id", "in", ids).toArray());
            QFilter[] qFilters = new QFBuilder("dataset", "in", ids).toArray();
            DeleteServiceHelper.delete((String)"fidm_dataset_single", (QFilter[])qFilters);
            DeleteServiceHelper.delete((String)"fidm_dataset_multivalue", (QFilter[])qFilters);
            DeleteServiceHelper.delete((String)"fidm_dataset_variable", (QFilter[])qFilters);
            QFilter permFilter = new QFilter("entityid", "in", ids);
            permFilter.and("entityname", "=", (Object)"fidm_dataset");
            DeleteServiceHelper.delete((String)"bcm_permclass_entity", (QFilter[])new QFilter[]{permFilter});
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("deleteDataSet error", (Throwable)e);
            tx.markRollback();
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public static boolean deleteDataSetByChapter(Long chapterId) {
        QFilter filter = new QFilter("chapterid", "=", (Object)chapterId);
        DynamicObjectCollection delList = QueryServiceHelper.query((String)"fidm_dataset", (String)"id,number,name,chapterid", (QFilter[])new QFilter[]{filter});
        Set<Long> delIds = delList.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(delIds)) {
            return true;
        }
        return DatasetServiceHelper.deleteDataSet(delIds);
    }

    public static void openAddNewDataSetView(IFormView view, IFormPlugin plugin, String modelId, Long chapterId) {
        DatasetServiceHelper.openAddNewDataSetView(view, plugin, modelId, chapterId, Boolean.FALSE);
    }

    public static void openAddNewDataSetView(IFormView view, IFormPlugin plugin, String modelId, Long chapterId, boolean isFar) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setParentPageId(view.getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack(plugin, closedcallback_add_dataset));
        fsp.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u96c6", (String)"DatasetListPlugin_3", (String)"epm-far-business", (Object[])new Object[0]));
        fsp.setFormId("fidm_selectaddchaptertype");
        fsp.setCustomParam("DISC_MODEL_ID", (Object)modelId);
        fsp.setCustomParam("scope", (Object)"2");
        fsp.setCustomParam("chapterid", (Object)chapterId);
        fsp.setCustomParam("isFar", (Object)isFar);
        fsp.setCustomParam("dmmodelid", (Object)modelId);
        view.showForm(fsp);
    }

    public static void openEditDataSetView(IFormView view, IFormPlugin plugin, Long id, String entityName) {
        DatasetServiceHelper.openEditDataSetView(view, plugin, id, entityName, false);
    }

    public static void openEditDataSetView(IFormView view, IFormPlugin plugin, Long id, String entityName, boolean isFar) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName, (String)"discmodel.id,type,chapterid");
        if (obj == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"DatasetListPlugin_12", (String)"epm-far-business", (Object[])new Object[0]));
            return;
        }
        String type = obj.getString("type");
        if (isFar && !Objects.equals(DataSetTypeEnum.MULTIPLE_VALUED.getType(), type)) {
            DatasetDto dto = new DatasetDto();
            dto.setId(id);
            FormShowParameter popFormShow = DatasetUtil.getPopFormShow(dto, Boolean.TRUE);
            view.showForm(popFormShow);
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        if ("1".equals(type) || "2".equals(type)) {
            fsp.setFormId("fidm_dataset_single_edit");
        } else {
            fsp.setFormId("fidm_dataset_multivalue_n");
        }
        fsp.setParentPageId(view.getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91\u6570\u636e\u96c6", (String)"DatasetListPlugin_8", (String)"epm-far-business", (Object[])new Object[0]));
        fsp.setCloseCallBack(new CloseCallBack(plugin, closedcallback_add_dataset));
        fsp.setStatus(OperationStatus.EDIT);
        fsp.setCustomParam("dataset_id", (Object)("" + id));
        fsp.setCustomParam("dmmodelid", (Object)("" + obj.getString("discmodel.id")));
        fsp.setCustomParam("dataset", (Object)view.getPageCache().get("chapterDataSetPerm"));
        fsp.setCustomParam("scope", (Object)"2");
        fsp.setCustomParam("chapterid", (Object)obj.getLong("chapterid"));
        fsp.setCustomParam("type", (Object)type);
        view.showForm(fsp);
    }

    public static void showDelDataSetConfirmView(IFormView view, IFormPlugin plugin, String focusId) {
        if (focusId == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8282\u70b9\u3002", (String)"DatasetListPlugin_9", (String)"epm-far-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"fidm_modulerepository", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("datasetid", "=", (Object)Long.parseLong(focusId))});
        if (Objects.nonNull(dyn)) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u6570\u636e\u96c6\uff0c\u5df2\u88ab\u53ef\u89c6\u5316\u7ec4\u4ef6\u201c%s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetListPlugin_18", (String)"epm-far-business", (Object[])new Object[0]), dyn.getString("name")));
            return;
        }
        if ("0".equals(focusId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetListPlugin_10", (String)"epm-far-business", (Object[])new Object[0]));
            return;
        }
        Long id = Long.parseLong(focusId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fidm_dataset", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (dynamicObject == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"DatasetListPlugin_12", (String)"epm-far-business", (Object[])new Object[0]));
            return;
        }
        view.showConfirm(String.format(ResManager.loadKDString((String)"\u60a8\u6b63\u5728\u5220\u9664\u7f16\u7801\u4e3a\u201c%1$s\u201d\uff0c\u540d\u79f0\u4e3a\u201c%2$s\u201d\u7684\u7ae0\u8282\u6570\u636e\u96c6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DatasetListPlugin_13", (String)"epm-far-business", (Object[])new Object[0]), dynamicObject.getString("number"), dynamicObject.getString("name")), MessageBoxOptions.YesNo, new ConfirmCallBackListener(callbackid_delDataSet_confirm, plugin));
    }

    public static long[] copyChapterDataset(Long fromDatasetId, Long toChapterId) {
        if (fromDatasetId == null || toChapterId == null || fromDatasetId == 0L || toChapterId == 0L) {
            return null;
        }
        QFilter filter = new QFilter("id", "=", (Object)fromDatasetId);
        DynamicObject[] datasetDyns = (DynamicObject[])QueryServiceHelper.query((String)"fidm_dataset", (String)"id,type,name,number,scope,chapterid,discmodel.id", (QFilter[])filter.toArray()).toArray((Object[])new DynamicObject[0]);
        if (datasetDyns == null || datasetDyns.length <= 0) {
            return null;
        }
        if (!"1".equals(datasetDyns[0].get("scope")) && "3".equals(datasetDyns[0].getString("type"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u590d\u5236\u201c\u591a\u503c\u201d\u7c7b\u578b\u7684\u6570\u636e\u96c6\u3002", (String)"DatasetServiceHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return DatasetServiceHelper.doCopyChapterDatasets(datasetDyns, toChapterId);
    }

    private static long[] doCopyChapterDatasets(DynamicObject[] datasetDyns, Long toChapterId) {
        if (datasetDyns == null || datasetDyns.length <= 0) {
            return null;
        }
        long[] toDatasetIds = new long[datasetDyns.length];
        HashMap<Long, DynamicObject> datasetMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : datasetDyns) {
            if (!"2".equals(dynamicObject.getString("scope"))) {
                return new long[]{dynamicObject.getLong("id")};
            }
            if ("3".equals(dynamicObject.getString("type"))) continue;
            datasetMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        QFilter qFilter = new QFilter("dataset", "in", datasetMap.keySet());
        DynamicObject[] entrys = (DynamicObject[])QueryServiceHelper.query((String)"fidm_dataset_single", (String)"dataset,datasrctype,datasrcid,extendsmodelid,extendsmodelnumber,expression,value,defvalue,groupby,orderby,asc,top", (QFilter[])qFilter.toArray()).toArray((Object[])new DynamicObject[0]);
        HashMap<Long, DynamicObject> datasetEntryMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject entry : entrys) {
            datasetEntryMap.put(entry.getLong("dataset.id"), entry);
        }
        try (TXHandle tXHandle = TX.required();){
            try {
                DynamicObject[] allChapterVariable = DatasetServiceHelper.queryDatasetVariable(datasetMap.keySet(), "2");
                if (allChapterVariable != null && allChapterVariable.length > 0) {
                    DynamicObject[] toChapterVariables = VariableService.queryChapterVariables(toChapterId);
                    Set<Object> toChapterVariableNums = new HashSet(16);
                    if (toChapterVariables != null && toChapterVariables.length > 0) {
                        toChapterVariableNums = Stream.of(toChapterVariables).map(e -> e.getString("number")).collect(Collectors.toSet());
                    }
                    HashSet<Long> needCopyVariableIds = new HashSet<Long>(16);
                    for (DynamicObject dyn : allChapterVariable) {
                        if (toChapterVariableNums.contains(dyn.getString("number"))) continue;
                        needCopyVariableIds.add(dyn.getLong("id"));
                    }
                    VariableService.copyChapterVariables(toChapterId, needCopyVariableIds.toArray(new Long[needCopyVariableIds.size()]));
                }
                int index = 0;
                for (Map.Entry entrySet : datasetMap.entrySet()) {
                    Long datasetId = (Long)entrySet.getKey();
                    DatasetDto datasetDto = DatasetServiceHelper.buildDatasetDto((DynamicObject)datasetMap.get(datasetId), (DynamicObject)datasetEntryMap.get(datasetId));
                    datasetDto.setChapterId(toChapterId);
                    toDatasetIds[index++] = DatasetServiceHelper.addDataset(datasetDto);
                }
            }
            catch (Exception e2) {
                tXHandle.markRollback();
                throw new KDBizException(e2.getMessage());
            }
            long[] lArray = toDatasetIds;
            return lArray;
        }
    }

    private static DatasetDto buildDatasetDto(DynamicObject dataset, DynamicObject entry) {
        DatasetDto dto = new DatasetDto();
        dto.setDiscmodelId(dataset.getLong("discmodel.id"));
        dto.setType(dataset.getString("type"));
        dto.setNumber(dataset.getString("number"));
        Object name = dataset.get("name");
        if (name instanceof Map) {
            dto.setName(LocaleString.fromMap((Map)((Map)name)));
        } else {
            dto.setName(name.toString());
        }
        dto.setScope(dataset.getString("scope"));
        dto.setChapterId(dataset.getLong("chapterid"));
        dto.setDataSrcType(entry.getString("datasrctype"));
        dto.setDataSrcId(entry.getLong("datasrcid"));
        dto.setExtendsModelId(entry.getLong("extendsmodelid"));
        dto.setExtendsModelNumber(entry.getString("extendsmodelnumber"));
        dto.setExpression(entry.getString("expression"));
        dto.setValue(entry.getString("value"));
        dto.setDefValue(entry.getString("defvalue"));
        dto.setGroupBy(entry.getString("groupby"));
        dto.setOrderBy(entry.getString("orderby"));
        dto.setAsc(entry.getString("asc"));
        dto.setTop(entry.getInt("top"));
        dto.setDataSrcNumber(entry.getString("datasrcnumber"));
        dto.setEbDataset(entry.getString("ebdataset"));
        return dto;
    }

    public static long addDataset(DatasetDto dto) {
        return DatasetServiceHelper.addDataset(dto, null);
    }

    public static void editDataset(DatasetDto dto, IDataModel dataModel) {
        DynamicObject dataSet = BusinessDataServiceHelper.loadSingle((Object)dto.getId(), (String)"fidm_dataset", (String)"id,scope,name,number,modifier,modifytime,currentstyle");
        QFilter qFilter = new QFilter("dataset", "=", (Object)dto.getId());
        DynamicObject entry = BusinessDataServiceHelper.loadSingle((String)"fidm_dataset_single", (String)SELECT_FIELDS, (QFilter[])qFilter.toArray());
        if (dataSet != null && entry != null) {
            dataSet.set("number", (Object)dto.getNumber());
            if (dto.getName() != null && !kd.bos.util.StringUtils.isEmpty((String)dto.getName().toString())) {
                dataSet.set("name", dto.getName());
            }
            dataSet.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
            dataSet.set("modifytime", (Object)TimeServiceHelper.now());
            dataSet.set("currentstyle", (Object)dto.getStyle());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataSet});
            if (LongUtil.isvalidLong((Object)dto.getPermClassId()) && Objects.nonNull(dataModel)) {
                PermClassEntityHelper.saveDiscPermClass(dataModel, "fidm_dataset", dataSet.getLong("id"), dto.getDiscmodelId(), OperationStatus.EDIT, FIDMMODEL, "");
            }
            entry.set("datasrctype", (Object)dto.getDataSrcType());
            entry.set("datasrcid", (Object)dto.getDataSrcId());
            entry.set("extendsmodelid", (Object)dto.getExtendsModelId());
            entry.set("component", (Object)dto.getComponentId());
            entry.set("dimnum", (Object)dto.getDimNum());
            entry.set("membernum", (Object)dto.getMemberNum());
            entry.set("ebdataset", (Object)dto.getEbDataset());
            if (StringUtils.isNotBlank((CharSequence)dto.getData())) {
                String data = dto.getData();
                if (Objects.nonNull(data)) {
                    DatasetDataVo vo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
                    Boolean existDataSetVo = DatasetUtil.checkDataSetVoExist(vo);
                    if (existDataSetVo.booleanValue()) {
                        entry.set("data", (Object)data);
                    } else {
                        entry.set("data", null);
                    }
                } else {
                    entry.set("data", null);
                }
            }
            if (LongUtil.isvalidLong((Object)dto.getExtendsModelId())) {
                entry.set("extendsmodelnumber", (Object)dto.getExtendsModelNumber());
            } else {
                entry.set("extendsmodelnumber", (Object)"");
            }
            entry.set("expression", (Object)dto.getExpression());
            entry.set("value", (Object)dto.getValue());
            if ("1".equals(dto.getType())) {
                entry.set("defvalue", (Object)dto.getDefValue());
            } else {
                entry.set("groupby", (Object)DatasetServiceHelper.formatMultiSelectStr(dto.getGroupBy()));
                entry.set("orderby", (Object)DatasetServiceHelper.formatMultiSelectStr(dto.getOrderBy()));
                entry.set("top", (Object)dto.getTop());
                entry.set("asc", (Object)dto.getAsc());
            }
            DatasetServiceHelper.buildEntryEntity(dto.getManageVo(), entry);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entry});
        }
    }

    private static void buildEntryEntity(DatasetEntityVo saveVo, DynamicObject entry) {
        List<DatasetRenameVo> list;
        List<DatasetJoinVo> joinVos;
        if (Objects.isNull(saveVo)) {
            return;
        }
        DynamicObjectCollection calculatEentity = entry.getDynamicObjectCollection("calculateentity");
        calculatEentity.clear();
        DynamicObjectCollection joinEntity = entry.getDynamicObjectCollection("joinentity");
        joinEntity.clear();
        DynamicObjectCollection renameEntity = entry.getDynamicObjectCollection("renameentity");
        renameEntity.clear();
        List<DatasetCalculateVo> calculateVos = saveVo.getCalculateVos();
        if (CollectionUtils.isNotEmpty(calculateVos)) {
            for (DatasetCalculateVo datasetCalculateVo : calculateVos) {
                DynamicObject dy = calculatEentity.addNew();
                dy.set("calnumber", (Object)datasetCalculateVo.getNumber());
                dy.set("calname", datasetCalculateVo.getName());
                dy.set("seq", (Object)datasetCalculateVo.getSeq());
                dy.set("calexpression", (Object)datasetCalculateVo.getExpression());
            }
        }
        if (CollectionUtils.isNotEmpty(joinVos = saveVo.getJoinVos())) {
            for (DatasetJoinVo joinVo : joinVos) {
                DynamicObject dy = joinEntity.addNew();
                dy.set("seq", (Object)joinVo.getSeq());
                dy.set("joinsource", (Object)joinVo.getEntityName());
                dy.set("joinnumber", (Object)joinVo.getJoinNumber());
                dy.set("joinfield", (Object)joinVo.getOnField());
                dy.set("selectfields", (Object)joinVo.getSelectFieldStr());
            }
        }
        if (CollectionUtils.isNotEmpty(list = saveVo.getRenameVos())) {
            for (DatasetRenameVo renameVo : list) {
                DynamicObject dy = renameEntity.addNew();
                dy.set("renamename", renameVo.getName());
                dy.set("renamenumber", (Object)renameVo.getNumber());
            }
        }
    }

    public static long addDataset(DatasetDto dto, IDataModel dataModel) {
        if (dto.getDiscmodelId() == null || dto.getScope() == null || dto.getType() == null) {
            return 0L;
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            DatasetDataVo vo;
            Boolean existDataSetVo;
            String data;
            DynamicObject dataSet = BusinessDataServiceHelper.newDynamicObject((String)"fidm_dataset");
            dataSet.set(MODELID, (Object)dto.getDiscmodelId());
            dataSet.set("type", (Object)dto.getType());
            dataSet.set("number", (Object)dto.getNumber());
            dataSet.set("name", dto.getName());
            dataSet.set("status", (Object)"1");
            dataSet.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
            dataSet.set("createtime", (Object)TimeServiceHelper.now());
            dataSet.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
            dataSet.set("modifytime", (Object)TimeServiceHelper.now());
            dataSet.set("scope", (Object)dto.getScope());
            dataSet.set("chapterid", (Object)dto.getChapterId());
            dataSet.set("currentstyle", (Object)dto.getStyle());
            dataSet.set("datasrctype", (Object)dto.getDataSrcType());
            dataSet.set("category", (Object)dto.getCategoryId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataSet});
            if (dataModel != null) {
                PermClassEntityHelper.savePermClass(dataModel, "fidm_dataset", dataSet.getLong("id"), dto.getDiscmodelId(), OperationStatus.ADDNEW, FIDMMODEL);
            }
            DynamicObject singleDyn = BusinessDataServiceHelper.newDynamicObject((String)"fidm_dataset_single");
            singleDyn.set("dataset", (Object)dataSet.getLong("id"));
            singleDyn.set("datasrctype", (Object)dto.getDataSrcType());
            singleDyn.set("datasrcid", (Object)dto.getDataSrcId());
            singleDyn.set("dimnum", (Object)dto.getDimNum());
            singleDyn.set("membernum", (Object)dto.getMemberNum());
            if (LongUtil.isvalidLong((Object)dto.getExtendsModelId())) {
                singleDyn.set("extendsmodelid", (Object)dto.getExtendsModelId());
                singleDyn.set("extendsmodelnumber", (Object)dto.getExtendsModelNumber());
            }
            singleDyn.set("component", (Object)dto.getComponentId());
            singleDyn.set("expression", (Object)dto.getExpression());
            singleDyn.set("datasrcnumber", (Object)dto.getDataSrcNumber());
            singleDyn.set("value", (Object)dto.getValue());
            singleDyn.set("ebdataset", (Object)dto.getEbDataset());
            if (StringUtils.isNotBlank((CharSequence)dto.getData()) && Objects.nonNull(data = dto.getData()) && (existDataSetVo = DatasetUtil.checkDataSetVoExist(vo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]))).booleanValue()) {
                singleDyn.set("data", (Object)data);
            }
            if ("1".equals(dto.getType())) {
                singleDyn.set("defvalue", (Object)dto.getDefValue());
            } else {
                singleDyn.set("groupby", (Object)DatasetServiceHelper.formatMultiSelectStr(dto.getGroupBy()));
                singleDyn.set("orderby", (Object)DatasetServiceHelper.formatMultiSelectStr(dto.getOrderBy()));
                singleDyn.set("top", (Object)dto.getTop());
                singleDyn.set("asc", (Object)dto.getAsc());
            }
            DatasetServiceHelper.buildEntryEntity(dto.getManageVo(), singleDyn);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{singleDyn});
            DatasetServiceHelper.addDatasetVar(dto, dataSet.getLong("id"), null);
            long l = dataSet.getLong("id");
            return l;
        }
        catch (Throwable e) {
            try {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static String formatMultiSelectStr(String by) {
        String[] a;
        if (StringUtils.isEmpty((CharSequence)by)) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>(8);
        for (String one : a = by.split(",")) {
            if (!StringUtils.isNotEmpty((CharSequence)one)) continue;
            list.add(one);
        }
        return String.join((CharSequence)",", list);
    }

    public static List<DynamicObject> addDatasetVar(DatasetDto dto, long datasetId, DynamicObjectCollection varSourceDyns) {
        boolean saveImmediate = Objects.isNull(varSourceDyns);
        Set<String> variableSet = DatasetServiceHelper.extractVariables(dto);
        if (variableSet.isEmpty()) {
            return null;
        }
        if (Objects.nonNull(varSourceDyns)) {
            varSourceDyns = varSourceDyns.stream().filter(dynamicObject -> variableSet.contains(dynamicObject.getString("number"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        }
        QFilter qFilter = new QFilter("model", "=", (Object)dto.getDiscmodelId());
        if ("1".equals(dto.getScope())) {
            qFilter.and("scope", "=", (Object)"1");
        } else if ("2".equals(dto.getScope())) {
            QFilter filter1 = new QFilter("scope", "=", (Object)"1");
            QFilter filter2 = new QFilter("scope", "=", (Object)"2");
            filter2.and("chapterid", "=", (Object)dto.getChapterId());
            qFilter.and(filter1.or(filter2));
        }
        qFilter.and("number", "in", variableSet);
        if (Objects.isNull(varSourceDyns)) {
            varSourceDyns = QueryServiceHelper.query((String)"fidm_disc_variable", (String)"id,name,number", (QFilter[])qFilter.toArray(), (String)"scope desc");
        } else {
            varSourceDyns.addAll((Collection)QueryServiceHelper.query((String)"fidm_disc_variable", (String)"id,name,number", (QFilter[])qFilter.toArray(), (String)"scope desc"));
        }
        if (varSourceDyns == null || varSourceDyns.size() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u4ee5\u4f7f\u7528\u7684\u53d8\u91cf\u3002", (String)"DatasetSingleNewPlugin_15", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ArrayList<DynamicObject> varDyns = new ArrayList<DynamicObject>(varSourceDyns.size());
        for (DynamicObject varD : varSourceDyns) {
            DynamicObject find = varDyns.stream().filter(m -> m.getString("number").equals(varD.getString("number"))).findAny().orElse(null);
            if (find != null) continue;
            varDyns.add(varD);
        }
        if (variableSet.size() != varDyns.size()) {
            Set queryNumbers = varDyns.stream().map(varDyn -> varDyn.getString("number")).collect(Collectors.toSet());
            for (String variable : variableSet) {
                if (!StringUtils.isEmpty((CharSequence)variable) && queryNumbers.contains(variable)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u53d8\u91cf %s \u662f\u5426\u53ef\u7528\u3002", (String)"DatasetSingleNewPlugin_16", (String)"epm-far-business", (Object[])new Object[0]), variable));
            }
        }
        ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(varDyns.size());
        for (DynamicObject varDyn2 : varDyns) {
            DynamicObject datasetVariable = BusinessDataServiceHelper.newDynamicObject((String)"fidm_dataset_variable");
            datasetVariable.set("dataset", (Object)datasetId);
            datasetVariable.set("variable", (Object)varDyn2.getLong("id"));
            dyns.add(datasetVariable);
        }
        if (saveImmediate) {
            SaveServiceHelper.save((DynamicObject[])dyns.toArray(new DynamicObject[0]));
            return null;
        }
        return dyns;
    }

    public static Set<String> extractVariables(DatasetDto dto) {
        HashSet<String> variableSet = new HashSet<String>(8);
        List<String> expressionList = DatasetServiceHelper.findExpressionRegex(dto.buildDetails());
        if (expressionList != null && !expressionList.isEmpty()) {
            for (String exp : expressionList) {
                List<String> variables = DatasetServiceHelper.findVariables(exp);
                variableSet.addAll(variables);
            }
        }
        return variableSet;
    }

    public static List<Map<String, Object>> getDatasetVariableList(Long datasetId) {
        return DatasetServiceHelper.getDatasetVariableList(datasetId, 0L);
    }

    public static List<Map<String, Object>> getDatasetVariableList(Long datasetId, Long chapterId) {
        DynamicObject[] dyns = DatasetServiceHelper.queryDatasetVariable(datasetId, null, chapterId);
        if (dyns == null || dyns.length <= 0) {
            return Collections.emptyList();
        }
        long modelId = dyns[0].getLong("model.id");
        List<DimensionInfo> allDimensions = new ModelStrategyEx(modelId).getDim().getDimList();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(dyns.length);
        for (DynamicObject dyn : dyns) {
            String defaultvalueid = null;
            String value = dyn.getString("defaultvalue");
            if ("4".equals(dyn.getString("valuetype")) && Objects.nonNull(dyn.get("dimmembertype")) && Objects.nonNull(dyn.get("defaultvalue"))) {
                DimensionInfo dim;
                String entity = dyn.getString("dimmembertype");
                DynamicObject mem = BusinessDataServiceHelper.loadSingleFromCache((Object)LongUtil.toLong((Object)dyn.getString("defaultvalue")), (String)entity);
                if (Objects.nonNull(mem) && Objects.nonNull(dim = DimensionUtils.getDimById(allDimensions, mem.getLong("dimension.id")))) {
                    defaultvalueid = dyn.getString("defaultvalue");
                    String shortNumber = dim.getShortNumber();
                    value = shortNumber + "." + mem.getString("number");
                }
            }
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("number", dyn.getString("number"));
            map.put("name", dyn.getString("name"));
            map.put("valuetype", dyn.getString("valuetype"));
            map.put("defaultvalue", value);
            map.put("dimmembertype", dyn.getString("dimmembertype"));
            map.put("disc_dim", dyn.getString("disc_dim"));
            map.put("entryentity", (String)dyn.getDynamicObjectCollection("entryentity"));
            map.put("defaultvalueid", defaultvalueid);
            list.add(map);
        }
        return list;
    }

    public static DynamicObject[] queryDatasetVariable(Long datasetId, String scope, Long chapterId) {
        if (datasetId == null) {
            return null;
        }
        HashSet<Long> datasetIds = new HashSet<Long>(4);
        datasetIds.add(datasetId);
        return DatasetServiceHelper.queryDatasetVariable(datasetIds, scope, chapterId);
    }

    public static DynamicObject[] queryDatasetVariable(Set<Long> datasetIds, String scope) {
        return DatasetServiceHelper.queryDatasetVariable(datasetIds, scope, (Long)0L);
    }

    public static DynamicObject[] queryDatasetVariable(Set<Long> datasetIds, String scope, Long chapterId) {
        Collection<DynamicObject> chapterDyns;
        Collection<DynamicObject> dyns;
        if (datasetIds == null || datasetIds.size() <= 0) {
            return null;
        }
        QFilter qFilter = new QFilter("dataset", "in", datasetIds);
        Collection<DynamicObject> entrys = DatasetDataReader.getDataSetVars(qFilter.toArray());
        if (entrys == null || entrys.size() <= 0) {
            return null;
        }
        List varIds = entrys.stream().map(entry -> entry.getLong("variable.id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", varIds);
        if (scope != null && !scope.isEmpty()) {
            filter.and("scope", "=", (Object)scope);
        }
        if ((dyns = DatasetDataReader.getVariables(filter.toArray())) == null || dyns.size() <= 0) {
            return null;
        }
        if (chapterId != null && chapterId > 0L && (chapterDyns = DatasetDataReader.getVariables(new QFilter("chapterid", "=", (Object)chapterId).toArray())) != null && chapterDyns.size() > 0) {
            ArrayList<DynamicObject> newDyns = new ArrayList<DynamicObject>(dyns.size());
            for (DynamicObject cur : dyns) {
                DynamicObject find = chapterDyns.stream().filter(m -> m.getString("number").equals(cur.getString("number"))).findAny().orElse(null);
                if (find == null) {
                    newDyns.add(cur);
                    continue;
                }
                newDyns.add(find);
            }
            return newDyns.toArray(new DynamicObject[0]);
        }
        return dyns.toArray(new DynamicObject[0]);
    }

    private static List<String> getMembers(String memberStr) {
        if (StringUtils.isEmpty((CharSequence)memberStr)) {
            return Collections.emptyList();
        }
        if (memberStr.startsWith("{") && memberStr.endsWith("}")) {
            memberStr = memberStr.substring(1, memberStr.length() - 1);
        }
        String[] realDimValArr = memberStr.split(";");
        ArrayList<String> members = new ArrayList<String>(realDimValArr.length);
        for (String member : realDimValArr) {
            members.add(member);
        }
        return members;
    }

    public static String variableResolveOf(String exp, Long datasetId) {
        DynamicObject dataSet = DatasetDataReader.getDataSet(datasetId);
        List<Map<String, Object>> datasetVariableList = DatasetServiceHelper.getDatasetVariableList(datasetId, dataSet.getLong("chapterid"));
        return DatasetServiceHelper.variableResolveOf(exp, datasetVariableList);
    }

    public static String variableResolveOf(String exp, List<Map<String, Object>> datasetVariableList) {
        if (StringUtils.isEmpty((CharSequence)exp)) {
            return "";
        }
        if (datasetVariableList == null || datasetVariableList.isEmpty()) {
            return exp;
        }
        HashMap<String, String> allDataMap = new HashMap<String, String>(16);
        for (Map<String, Object> map : datasetVariableList) {
            allDataMap.put(map.get("number").toString(), map.get("defaultvalue").toString());
        }
        StringBuffer sb = new StringBuffer();
        Matcher matcher = VARIABLE_REGEX.matcher(exp);
        while (matcher.find()) {
            String findStr = matcher.group();
            String replacement = (String)allDataMap.get(findStr.substring(1, findStr.length() - 1));
            if (replacement == null || replacement.isEmpty()) continue;
            if (replacement.contains("$")) {
                replacement = replacement.replaceAll("\\$", RDS_CHAR_DOLLAR);
            }
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString().replaceAll(RDS_CHAR_DOLLAR, "\\$");
    }

    public static List<String> findExpressionRegex(String s) {
        Matcher matcher = EXPRESSION_REGEX.matcher(s);
        ArrayList<String> list = new ArrayList<String>(8);
        while (matcher.find()) {
            String findStr = matcher.group();
            list.add(findStr.substring(1, findStr.length() - 1));
        }
        return list;
    }

    public static List<String> findVariables(String s) {
        Matcher matcher = VARIABLE_REGEX.matcher(s);
        ArrayList<String> list = new ArrayList<String>(8);
        while (matcher.find()) {
            String findStr = matcher.group();
            list.add(findStr.substring(1, findStr.length() - 1));
        }
        return list;
    }

    public static void checkDatasetNumber(String number, long modelId, long datasetId) {
        boolean exists;
        DatasetServiceHelper.checkDatasetNumberFormat(number);
        QFilter qFilter = new QFilter(MODELID, "=", (Object)modelId);
        qFilter.and("number", "=", (Object)number);
        if (datasetId != 0L) {
            qFilter.and("id", "!=", (Object)datasetId);
        }
        if (exists = QueryServiceHelper.exists((String)"fidm_dataset", (QFilter[])qFilter.toArray())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801 %s \u5df2\u5b58\u5728\u3002", (String)"DatasetServiceHelper_3", (String)"epm-far-business", (Object[])new Object[0]), number));
        }
    }

    public static void checkDatasetNumberWithGB(String number, long modelId, long datasetId) {
        boolean exists;
        DatasetServiceHelper.checkDatasetNumberFormat(number);
        QFilter qFilter = new QFilter(MODELID, "=", (Object)modelId);
        qFilter.and("number", "=", (Object)number);
        qFilter.and("scope", "=", (Object)"1");
        if (datasetId != 0L) {
            qFilter.and("id", "!=", (Object)datasetId);
        }
        if (exists = QueryServiceHelper.exists((String)"fidm_dataset", (QFilter[])qFilter.toArray())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801 %s \u5df2\u5b58\u5728\u3002", (String)"DatasetServiceHelper_3", (String)"epm-far-business", (Object[])new Object[0]), number));
        }
    }

    public static void checkDatasetNumberFormat(String number) {
        if (number.startsWith(".") || number.startsWith("_") || number.contains("..")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u3001\u534a\u89d2\u4e0b\u5212\u7ebf\uff0c\u4e0d\u80fd\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u3001\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\u3002", (String)"DatasetServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        Matcher matcher = DATASET_MUST_CONTAIN_REGEX.matcher(number);
        if (matcher.matches()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u5305\u542b\u534a\u89d2\u5b57\u6bcd\u6216\u534a\u89d2\u4e0b\u5212\u7ebf\u3002", (String)"DatasetServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
        Matcher matcher2 = DATASET_NUMBER_REGEX.matcher(number);
        if (!matcher2.matches()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u3001\u534a\u89d2\u4e0b\u5212\u7ebf\uff0c\u4e0d\u80fd\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u3001\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\u3002", (String)"DatasetServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static Object addPostfix(ILocaleString detail, String postfix) {
        detail.forEach((k, v) -> detail.put(k, (Object)(v + postfix)));
        return detail;
    }

    public static void openPreviewPage(IFormView view, IFormPlugin plugin, long modelId, long datasetId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("fidm_previewds");
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.setCustomParam("dataset_id", (Object)datasetId);
        fsp.setCustomParam("dmmodelid", (Object)("" + modelId));
        fsp.setParentPageId(view.getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack(plugin, DATASET_PREVIEW_CLOSE));
        view.showForm(fsp);
    }

    public static void openPreviewPage(IFormView view, IFormPlugin plugin, DatasetDto dto) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("fidm_previewds");
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.setCustomParam("datasetDto", (Object)SerializationUtils.toJsonString((Object)dto));
        fsp.setCustomParam("dmmodelid", (Object)(Objects.isNull(dto.getDiscmodelId()) ? "" : dto.getDiscmodelId().toString()));
        fsp.setParentPageId(view.getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack(plugin, DATASET_PREVIEW_CLOSE));
        view.showForm(fsp);
    }

    public static void openPivotPreviewPage(IFormView view, IFormPlugin plugin, long modelId, long datasetId, String openType) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("fidm_previewds_pivot");
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.setCustomParam("dataset_id", (Object)datasetId);
        fsp.setCustomParam("dmmodelid", (Object)("" + modelId));
        fsp.setCustomParam("open_type", (Object)openType);
        fsp.setParentPageId(view.getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack(plugin, DATASET_PREVIEW_PIVOT_CLOSE));
        view.showForm(fsp);
    }

    public static void openPreviewPageWithoutPopup(IFormView view, IFormPlugin plugin, long modelId, long datasetId, JSONObject eventJson) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("fidm_previewds");
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.setCustomParam("dataset_id", (Object)datasetId);
        fsp.setCustomParam("dmmodelid", (Object)("" + modelId));
        fsp.setCustomParam("EVENT_DATA_JOINT_SEARCH", (Object)eventJson);
        fsp.setParentPageId(view.getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack(plugin, "CALL_BACK_DATA_JOINT_SEARCH"));
        view.showForm(fsp);
    }

    public static void addDataSetF7Filter(QFilter qFilter, Long modelId, Long userId, String appNum) {
        HashSet noPermsDataSet = new HashSet(16);
        if (Objects.equals(ApplicationTypeEnum.FAR.getAppnum(), appNum)) {
            noPermsDataSet.addAll(PermClassEntityHelper.getFARPermissionMap("fidm_dataset", modelId, userId).get((Object)"1"));
        } else {
            noPermsDataSet.addAll(PermClassEntityHelper.getFIDMPermissionMap("fidm_dataset", modelId, userId).get((Object)"1"));
        }
        qFilter.and(new QFilter("id", "not in", noPermsDataSet));
    }

    public static DatasetVarAndDim getDimVars(DatasetDto dto) {
        HashSet cur = Sets.newHashSetWithExpectedSize((int)2);
        HashSet curs = Sets.newHashSetWithExpectedSize((int)2);
        if (DatasetSpecialVarHelper.isContainCurVar(dto.getExpression())) {
            String[] exps;
            for (String exp : exps = dto.getExpression().split(",")) {
                if (!DatasetServiceHelper.isDimContainKeyword(exp)) continue;
                String shortNumber = exp.substring(0, exp.indexOf(46)).trim().toUpperCase(Locale.ENGLISH);
                if (Objects.nonNull(dto) && Objects.nonNull(dto.getDataSrcType())) {
                    String sourceFrom = dto.getDataSrcType();
                    if (DataSrcTypeEnum.ISC_METADATA.getType().equals(sourceFrom)) {
                        shortNumber = exp.substring(0, exp.indexOf(46)).trim();
                    }
                }
                if (DatasetSpecialVarHelper.isContainCursVar(exp)) {
                    if (curs.contains(shortNumber)) continue;
                    curs.add(shortNumber);
                    continue;
                }
                if (!DatasetSpecialVarHelper.isContainCurVar(exp) || cur.contains(shortNumber)) continue;
                cur.add(shortNumber);
            }
        }
        return new DatasetVarAndDim(Collections.emptyList(), new ArrayList<String>(cur), new ArrayList<String>(curs));
    }

    public static DatasetVarAndDim getVarAndDimVar(long dmModeId, long datasetId, long chapterId, boolean isShowKDBizException) {
        return DatasetServiceHelper.getVarAndDimVar(dmModeId, datasetId, chapterId, isShowKDBizException, false);
    }

    public static DatasetVarAndDim getVarAndDimVar(long dmModeId, long datasetId, long chapterId, boolean isShowKDBizException, boolean isISC) {
        List variableList = new ArrayList(32);
        List expressionList = new ArrayList(10);
        try {
            DynamicObject dataset = DatasetDataReader.getDataSet(datasetId, false);
            if (dataset == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u6570\u636e\u96c6\u201c%s\u201d\u3002", (String)"DataSetPreviewPlugin_1", (String)"epm-far-business", (Object[])new Object[0]), datasetId));
            }
            String type = dataset.getString("type");
            if ("1".equals(type) || "2".equals(type)) {
                Map<String, Object> singleResult = DatasetServiceHelper.getInitSingleValueData(datasetId, chapterId);
                variableList = (List)singleResult.get("variableList");
                expressionList = (List)singleResult.get("expressionList");
            } else if ("3".equals(type)) {
                Map<String, Object> multiResult = DatasetServiceHelper.getInitMultiValueData(dmModeId, datasetId, chapterId);
                variableList = (List)multiResult.get("variableList");
                expressionList = (List)multiResult.get("expressionList");
            }
        }
        catch (KDBizException ex) {
            if (isShowKDBizException) {
                throw ex;
            }
            variableList = new ArrayList(32);
            expressionList = new ArrayList(32);
        }
        HashSet cur = Sets.newHashSetWithExpectedSize((int)2);
        HashSet curs = Sets.newHashSetWithExpectedSize((int)2);
        String expression = String.join((CharSequence)",", expressionList);
        if (DatasetSpecialVarHelper.isContainCurVar(expression)) {
            String[] exps;
            for (String exp : exps = expression.split(",")) {
                if (!DatasetServiceHelper.isDimContainKeyword(exp)) continue;
                String shortNumber = exp.substring(0, exp.indexOf(46)).trim().toUpperCase(Locale.ENGLISH);
                if (isISC) {
                    shortNumber = exp.substring(0, exp.indexOf(46)).trim();
                }
                if (DatasetSpecialVarHelper.isContainCursVar(exp)) {
                    if (curs.contains(shortNumber)) continue;
                    curs.add(shortNumber);
                    continue;
                }
                if (!DatasetSpecialVarHelper.isContainCurVar(exp) || cur.contains(shortNumber)) continue;
                cur.add(shortNumber);
            }
        }
        curs.removeAll(cur);
        ArrayList<String> curShortNumberList = new ArrayList<String>(cur);
        ArrayList<String> cursShortNumberList = new ArrayList<String>(curs);
        ArrayList<Map<String, Object>> retVariableList = new ArrayList<Map<String, Object>>(32);
        for (Map variable : variableList) {
            Map findVar = retVariableList.stream().filter(x -> Objects.equals(x.get("number").toString(), variable.get("number"))).findAny().orElse(null);
            if (!Objects.isNull(findVar)) continue;
            retVariableList.add(variable);
        }
        return new DatasetVarAndDim(retVariableList, curShortNumberList, cursShortNumberList);
    }

    public static Map<String, Object> getVarAndDimVars(long dmModeId, long datasetId, long chapterId, boolean isShowKDBizException) {
        List variableList = new ArrayList(32);
        List expressionList = new ArrayList(10);
        try {
            DynamicObject dataset = DatasetDataReader.getDataSet(datasetId, false);
            if (dataset == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u6570\u636e\u96c6\u201c%s\u201d\u3002", (String)"DataSetPreviewPlugin_1", (String)"epm-far-business", (Object[])new Object[0]), datasetId));
            }
            String type = dataset.getString("type");
            if ("1".equals(type) || "2".equals(type)) {
                Map<String, Object> singleResult = DatasetServiceHelper.getInitSingleValueData(datasetId, chapterId);
                variableList = (List)singleResult.get("variableList");
                expressionList = (List)singleResult.get("expressionList");
            } else if ("3".equals(type)) {
                Map<String, Object> multiResult = DatasetServiceHelper.getInitMultiValueData(dmModeId, datasetId, chapterId);
                variableList = (List)multiResult.get("variableList");
                expressionList = (List)multiResult.get("expressionList");
            }
        }
        catch (KDBizException ex) {
            if (isShowKDBizException) {
                throw ex;
            }
            variableList = new ArrayList(32);
            expressionList = new ArrayList(32);
        }
        ArrayList<String> shortNumberList = new ArrayList<String>(2);
        HashSet cur = Sets.newHashSetWithExpectedSize((int)2);
        HashSet curs = Sets.newHashSetWithExpectedSize((int)2);
        String expression = String.join((CharSequence)",", expressionList);
        if (DatasetSpecialVarHelper.isContainCurVar(expression)) {
            String[] exps;
            for (String exp : exps = expression.split(",")) {
                if (!DatasetServiceHelper.isDimContainKeyword(exp)) continue;
                String shortNumber = exp.substring(0, exp.indexOf(46)).trim().toUpperCase(Locale.ENGLISH);
                if (DatasetSpecialVarHelper.isContainCursVar(exp)) {
                    if (curs.contains(shortNumber)) continue;
                    curs.add(shortNumber);
                    continue;
                }
                if (!DatasetSpecialVarHelper.isContainCurVar(exp) || cur.contains(shortNumber)) continue;
                cur.add(shortNumber);
                shortNumberList.add(shortNumber);
            }
        }
        curs.removeAll(cur);
        ArrayList curShortNumberList = new ArrayList(cur);
        ArrayList cursShortNumberList = new ArrayList(curs);
        ArrayList<Map> retVariableList = new ArrayList<Map>(32);
        for (Map variable : variableList) {
            Map findVar = retVariableList.stream().filter(x -> Objects.equals(x.get("number").toString(), variable.get("number"))).findAny().orElse(null);
            if (!Objects.isNull(findVar)) continue;
            retVariableList.add(variable);
        }
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>(2);
        ret.put("variableList", retVariableList);
        ret.put("shortNumberList", shortNumberList);
        ret.put("curShortNumberList", curShortNumberList);
        ret.put("cursShortNumberList", cursShortNumberList);
        return ret;
    }

    private static Map<String, Object> getInitSingleValueData(long datasetId, Long chapterId) {
        ArrayList<String> expressionList = new ArrayList<String>(32);
        List<Map<String, Object>> variableList = DatasetServiceHelper.getDatasetVariableList(datasetId, chapterId);
        String expression = DatasetServiceHelper.getExpression(datasetId, variableList);
        if (DatasetSpecialVarHelper.isContainCurVar(expression)) {
            expressionList.add(expression);
        }
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>(2);
        ret.put("variableList", variableList);
        ret.put("expressionList", expressionList);
        return ret;
    }

    private static Map<String, Object> getInitMultiValueData(long dmModeId, long datasetId, long chapterId) {
        ArrayList<Map<String, Object>> variableList = new ArrayList<Map<String, Object>>(32);
        ArrayList<String> expressionList = new ArrayList<String>(32);
        QFilter qFilter = new QFilter("dataset", "=", (Object)datasetId);
        DynamicObject[] multiValueEntrys = DatasetDataReader.getMultiDataSetValues(qFilter.toArray()).toArray(new DynamicObject[0]);
        if (multiValueEntrys == null || multiValueEntrys.length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u9884\u89c8\u6570\u636e\u3002", (String)"DataSetPreviewPlugin_7", (String)"epm-far-business", (Object[])new Object[0]));
        }
        for (DynamicObject multiValueEntry : multiValueEntrys) {
            List<String> datasetNumberList;
            String formulaType = multiValueEntry.getString("formulatype");
            if ("1".equals(formulaType)) {
                String expression;
                List<Map<String, Object>> varList = DatasetServiceHelper.getDatasetVariableList(multiValueEntry.getLong("single.dataset.id"), chapterId);
                if (varList != null && !varList.isEmpty()) {
                    variableList.addAll(varList);
                }
                if (!DatasetSpecialVarHelper.isContainCurVar(expression = DatasetServiceHelper.getExpression(multiValueEntry.getLong("single.dataset.id"), varList))) continue;
                expressionList.add(expression);
                continue;
            }
            if (!"2".equals(formulaType) || (datasetNumberList = DatasetServiceHelper.extractVariablesFrom(multiValueEntry.getString("formulatext"))) == null || datasetNumberList.isEmpty()) continue;
            DynamicObjectCollection dyns = DatasetServiceHelper.getDatasetsByNumber(dmModeId, datasetNumberList, chapterId);
            if (dyns == null || dyns.size() == 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u6570\u636e\u96c6\u7f16\u7801 \u201c%s\u201d\u3002", (String)"DataSetPreviewPlugin_9", (String)"epm-far-business", (Object[])new Object[0]), datasetNumberList);
                throw new KDBizException(msg);
            }
            if (dyns.size() != datasetNumberList.size()) {
                Set queryNumbers = dyns.stream().map(dyn -> dyn.getString("number")).collect(Collectors.toSet());
                for (String datasetNumber : datasetNumberList) {
                    if (!StringUtils.isEmpty((CharSequence)datasetNumber) && queryNumbers.contains(datasetNumber)) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6570\u636e\u96c6\u201c%s\u201d\u662f\u5426\u53ef\u7528\u3002", (String)"DataSetPreviewPlugin_10", (String)"epm-far-business", (Object[])new Object[0]), datasetNumber));
                }
            }
            for (DynamicObject dyn2 : dyns) {
                String expression;
                List<Map<String, Object>> varList = DatasetServiceHelper.getDatasetVariableList(dyn2.getLong("id"), chapterId);
                if (varList != null && !varList.isEmpty()) {
                    variableList.addAll(varList);
                }
                if (!DatasetSpecialVarHelper.isContainCurVar(expression = DatasetServiceHelper.getExpression(dyn2.getLong("id"), varList))) continue;
                expressionList.add(expression);
            }
        }
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>(2);
        ret.put("variableList", variableList);
        ret.put("expressionList", expressionList);
        return ret;
    }

    private static String getExpression(long datasetId, List<Map<String, Object>> variableList) {
        DynamicObject entry = DatasetDataReader.getSingleDS(datasetId);
        String expression = entry.getString("expression");
        return DatasetServiceHelper.variableResolveOf(expression, variableList);
    }

    private static boolean isDimContainKeyword(String expression) {
        if (expression == null) {
            return false;
        }
        if (expression.indexOf(46) < 0) {
            return false;
        }
        String[] dimstr = DatasetExpressionHelper.splitDimAndMemb(expression);
        String values = dimstr[1];
        String para = values.startsWith("{") && values.endsWith("}") ? values.substring(1, values.length() - 1) : values;
        List<String> members = Arrays.asList(para.split(";"));
        return members.stream().anyMatch(s -> DatasetSpecialVarHelper.isContainCurVar(s.toLowerCase()));
    }

    private static List<String> extractVariablesFrom(String expression) {
        if (expression == null) {
            return Collections.emptyList();
        }
        String[] arr = expression.split("[+-/<>=!=\\|\\*\\^()&]+");
        ArrayList<String> varList = new ArrayList<String>(16);
        for (String s : arr) {
            try {
                s = s.trim();
                DatasetServiceHelper.checkDatasetNumberFormat(s);
                varList.add(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return varList;
    }

    public List<Map<String, Object>> getDimList(Long datasetId) {
        return this.getDimList(datasetId, false);
    }

    public List<Map<String, Object>> getDimList(Long datasetId, boolean needGroupMember) {
        HashSet caltype = Sets.newHashSet((Object[])new String[]{DataTypeEnum.DEFAULT.getOIndex(), DataTypeEnum.CURRENCY.getOIndex(), DataTypeEnum.UNCURRENCY.getOIndex(), DataTypeEnum.PROPORTION.getOIndex()});
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(8);
        if (datasetId == null) {
            return Collections.emptyList();
        }
        DynamicObject dataset = DatasetDataReader.getDataSet(datasetId, false);
        if (dataset == null) {
            return Collections.emptyList();
        }
        String modelSourceType = dataset.getString("discmodel.modelsourcetype");
        DynamicObject dyn = DatasetDataReader.getSingleDS(datasetId);
        String datasrctype = dyn.getString("datasrctype");
        Long modelId = dyn.getLong("datasrcid");
        StringBuilder basesb = new StringBuilder();
        StringBuilder extsb = new StringBuilder();
        Tuple<Long, String, Map<String, String>> data = this.fidmDimService.getShortNumbers(datasrctype, modelId, "1", dyn.getString("ebdataset"));
        if (LongUtil.isvalidLong((Object)data.p1)) {
            basesb.append("L");
            extsb.append("L");
        } else {
            basesb.append("R");
            extsb.append("R");
        }
        if ("epm_dimension".equals(data.p2)) {
            basesb.append("B");
        } else {
            basesb.append("C");
        }
        String groupBy = dyn.getString("groupby");
        String value = dyn.getString("value");
        String expression = dyn.getString("expression");
        String propertyData = dyn.getString("data");
        List<DatasetPropertyVo> list = null;
        Set<String> hideColumns = null;
        if (StringUtils.isNotBlank((CharSequence)propertyData)) {
            DatasetDataVo vo = (DatasetDataVo)JSON.parseObject((String)propertyData, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
            list = vo.getColumns();
            hideColumns = vo.getHideColumns();
        }
        HashMap dimMap = Maps.newHashMapWithExpectedSize((int)16);
        if (StringUtils.isNotEmpty((CharSequence)expression)) {
            expression = DatasetServiceHelper.variableResolveOf(expression, datasetId);
            List<String> dims = DatasetUtil.split(expression);
            Set<Object> dimset = StringUtils.isNotEmpty((CharSequence)groupBy) ? Sets.newHashSet(DatasetUtil.split(groupBy)) : ((Map)data.p3).keySet();
            Iterator<Object> iterator = dims.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String[] a = DatasetExpressionHelper.splitDimAndMemb(string);
                String key = a[0];
                if (!dimset.contains(key)) continue;
                String info = (String)((Map)data.p3).get(key);
                String[] ds = info.split(";");
                if (CollectionUtils.isNotEmpty(hideColumns) && hideColumns.contains(ds[0])) continue;
                LinkedHashMap<String, Object> one = new LinkedHashMap<String, Object>(4);
                one.put("number", ds[0]);
                one.put("id", ds[2]);
                one.put("name", ds[1]);
                one.put("type", basesb + "D");
                if (needGroupMember) {
                    one.put("member", DatasetServiceHelper.getMembers(a[1]));
                }
                dimMap.put(ds[0], ds[1]);
                result.add(one);
            }
        }
        if (list != null && list.size() > 0) {
            for (DatasetPropertyVo propertyVo : list) {
                if (Objects.equals(ColumnTypeEnum.MEASURE.getCode(), propertyVo.getType())) continue;
                LinkedHashMap<String, String> property = new LinkedHashMap<String, String>(4);
                property.put("type", basesb + "D");
                if (Objects.equals(ColumnTypeEnum.FIXED_COLUMN.getCode(), propertyVo.getType())) {
                    property.put("number", propertyVo.getSource() + "-" + propertyVo.getNumber());
                    property.put("name", (String)dimMap.get(propertyVo.getSource()) + "-" + propertyVo.getName());
                } else {
                    property.put("number", propertyVo.getSource() + "-Property-" + propertyVo.getNumber());
                    property.put("name", String.format(ResManager.loadKDString((String)"%1$s-%2$s", (String)"DatasetServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]), dimMap.get(propertyVo.getSource()), propertyVo.getName()));
                }
                if (CollectionUtils.isNotEmpty(hideColumns) && hideColumns.contains(property.get("number").toString())) continue;
                result.add(property);
            }
        }
        if (LongUtil.isvalidLong((Object)dyn.getLong("extendsmodelid"))) {
            extsb.append("E");
            List<String> vals = DatasetUtil.split(value);
            Map<String, String> extdata = this.fidmDimService.getExtendsFields(datasrctype, modelId, dyn.getLong("extendsmodelid"), "1");
            for (Map.Entry entry : extdata.entrySet()) {
                if (!vals.contains(entry.getKey())) continue;
                LinkedHashMap one = new LinkedHashMap(4);
                if (!((String)entry.getValue()).contains(";") || CollectionUtils.isNotEmpty(hideColumns) && hideColumns.contains(entry.getKey())) continue;
                String[] a = ((String)entry.getValue()).split(";");
                one.put("number", entry.getKey());
                one.put("name", a[0]);
                if (caltype.contains(a[1])) {
                    one.put("type", extsb + "M");
                    result.add(one);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)groupBy)) continue;
                one.put("type", extsb + "T");
                result.add(one);
            }
        } else {
            LinkedHashMap<String, String> one = new LinkedHashMap<String, String>(4);
            one.put("number", "FMONEY");
            one.put("name", ResManager.loadKDString((String)"\u5ea6\u91cf\u503c", (String)"DatasetSingleNewPlugin_41", (String)"epm-far-business", (Object[])new Object[0]));
            one.put("id", "");
            one.put("type", FidmDataTypeEnum.DM.getType());
            result.add(one);
        }
        return result;
    }

    public List<Map<String, Object>> getDimListWithMemberName(Long datasetId, boolean needGroupMember, long datasetSrcModelId) {
        String[] a;
        Long modelId;
        HashSet caltype = Sets.newHashSet((Object[])new String[]{DataTypeEnum.DEFAULT.getOIndex(), DataTypeEnum.CURRENCY.getOIndex(), DataTypeEnum.UNCURRENCY.getOIndex(), DataTypeEnum.PROPORTION.getOIndex()});
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(8);
        if (datasetId == null) {
            return Collections.emptyList();
        }
        DynamicObject dataset = DatasetDataReader.getDataSet(datasetId, false);
        if (dataset == null) {
            return Collections.emptyList();
        }
        DynamicObject dyn = DatasetDataReader.getSingleDS(datasetId);
        String datasrctype = dyn.getString("datasrctype");
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType(datasrctype, modelId = Long.valueOf(dyn.getLong("datasrcid")));
        if (modelType == DisModelTypeEnum.EB) {
            return new ArrayList<Map<String, Object>>();
        }
        StringBuilder basesb = new StringBuilder();
        StringBuilder extsb = new StringBuilder();
        Tuple<Long, String, Map<String, String>> data = this.fidmDimService.getShortNumbers(datasrctype, modelId, "1", dyn.getString("ebdataset"));
        if (LongUtil.isvalidLong((Object)data.p1)) {
            basesb.append("L");
            extsb.append("L");
        } else {
            basesb.append("R");
            extsb.append("R");
        }
        if ("epm_dimension".equals(data.p2)) {
            basesb.append("B");
        } else {
            basesb.append("C");
        }
        String groupBy = dyn.getString("groupby");
        String value = dyn.getString("value");
        String expression = dyn.getString("expression");
        if (StringUtils.isNotEmpty((CharSequence)expression)) {
            expression = DatasetServiceHelper.variableResolveOf(expression, datasetId);
            List<String> dims = DatasetUtil.split(expression);
            Set<Object> dimset = StringUtils.isNotEmpty((CharSequence)groupBy) ? Sets.newHashSet(DatasetUtil.split(groupBy)) : ((Map)data.p3).keySet();
            HashMap dimNumberToMap = Maps.newHashMapWithExpectedSize((int)dims.size());
            for (String s : dims) {
                Map<String, String> mapNumberToName;
                String key;
                if (!s.contains(".") || !dimset.contains(key = (a = DatasetExpressionHelper.splitDimAndMemb(s))[0])) continue;
                Map<String, String> one = new LinkedHashMap(4);
                String info = (String)((Map)data.p3).get(key);
                String[] ds = info.split(";");
                String dimNumber = ds[0];
                if (Objects.isNull(dimNumberToMap.get(dimNumber))) {
                    dimNumberToMap.put(dimNumber, one);
                    one.put("number", ds[0]);
                    one.put("id", ds[2]);
                    one.put("name", ds[1]);
                    one.put("type", new StringBuffer().append((CharSequence)basesb).append("D").toString());
                    if (!needGroupMember || (mapNumberToName = DatasetServiceHelper.getMembersNumToName(a[1], datasetSrcModelId, ds[0])).isEmpty()) continue;
                    one.put("member", (String)((Object)mapNumberToName));
                    result.add(one);
                    continue;
                }
                one = (Map)dimNumberToMap.get(dimNumber);
                mapNumberToName = DatasetServiceHelper.getMembersNumToName(a[1], datasetSrcModelId, dimNumber);
                if (mapNumberToName.isEmpty()) continue;
                one.put("member", (String)((Object)mapNumberToName));
            }
        }
        if (LongUtil.isvalidLong((Object)dyn.getLong("extendsmodelid"))) {
            extsb.append("E");
            List<String> vals = DatasetUtil.split(value);
            Map<String, String> extdata = this.fidmDimService.getExtendsFields(datasrctype, modelId, dyn.getLong("extendsmodelid"), "1");
            for (Map.Entry<String, String> s : extdata.entrySet()) {
                if (!vals.contains(s.getKey())) continue;
                LinkedHashMap<String, String> one = new LinkedHashMap<String, String>(4);
                if (!s.getValue().contains(";")) continue;
                a = s.getValue().split(";");
                one.put("number", s.getKey());
                one.put("name", a[0]);
                if (caltype.contains(a[1])) {
                    one.put("type", extsb + "M");
                } else {
                    one.put("type", extsb + "T");
                }
                result.add(one);
            }
        } else {
            LinkedHashMap<String, String> one = new LinkedHashMap<String, String>(4);
            one.put("number", "FMONEY");
            one.put("name", ResManager.loadKDString((String)"\u5ea6\u91cf\u503c", (String)"DatasetSingleNewPlugin_41", (String)"epm-far-business", (Object[])new Object[0]));
            one.put("id", "");
            one.put("type", FidmDataTypeEnum.DM.getType());
            result.add(one);
        }
        return result;
    }

    private static Map<String, String> getMembersNumToName(String memberStr, long datasetSrcModelId, String dimNumber) {
        if (StringUtils.isEmpty((CharSequence)memberStr)) {
            return Collections.emptyMap();
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(datasetSrcModelId);
        if (memberStr.startsWith("{") && memberStr.endsWith("}")) {
            memberStr = memberStr.substring(1, memberStr.length() - 1);
        }
        String[] realDimValArr = memberStr.split(";");
        LinkedHashMap members = Maps.newLinkedHashMapWithExpectedSize((int)realDimValArr.length);
        for (String member : realDimValArr) {
            if (DatasetSpecialVarHelper.isContain(member)) continue;
            DimMemberInfo memberInfo = null;
            try {
                memberInfo = modelStrategyEx.getDimMember().findMemberByNumber(dimNumber, member);
                members.put(member, memberInfo.getName());
            }
            catch (Exception e) {
                if (!member.contains(".")) {
                    throw new KDBizException(e.getMessage());
                }
                int i = member.lastIndexOf(46);
                String dimMemberNum = member.substring(0, i);
                memberInfo = modelStrategyEx.getDimMember().findMemberByNumber(dimNumber, dimMemberNum);
                members.put(dimMemberNum, memberInfo.getName());
            }
        }
        return members;
    }

    public static List<DataSet> getDataSets(long modelId, long chapterId, String name, List<DataSetTypeEnum> types, List<String> statuses, List<String> dataSrcTypes) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(7);
        qFilters.add(PermissionHelper.getReadAndWritePermFilter(modelId, "fidm_dataset"));
        qFilters.add(new QFilter(MODELID, "=", (Object)modelId));
        qFilters.add(new QFilter("chapterid", "=", (Object)chapterId));
        if (StringUtils.isNotBlank((CharSequence)name)) {
            qFilters.add(new QFilter("name", "like", (Object)("%" + name + "%")));
        }
        if (types != null) {
            qFilters.add(new QFilter("type", "in", types.stream().map(DataSetTypeEnum::getType).collect(Collectors.toList())));
            if (types.isEmpty()) {
                return new ArrayList<DataSet>(0);
            }
        }
        if (statuses != null) {
            qFilters.add(new QFilter("status", "in", statuses));
            if (statuses.isEmpty()) {
                return new ArrayList<DataSet>(0);
            }
        }
        QFilter permFilter = PermissionHelper.getReadAndWritePermFilter(modelId, "fidm_dataset");
        qFilters.add(permFilter);
        DynamicObjectCollection dataSetDatas = QueryServiceHelper.query((String)"fidm_dataset", (String)"id,number,name,chapterid,type,status,scope,creator.name,createtime,modifier.name,modifytime", (QFilter[])qFilters.toArray(new QFilter[0]));
        return DatasetServiceHelper.getDataSetModels(modelId, (DynamicObject[])dataSetDatas.toArray((Object[])new DynamicObject[0]), chapterId, dataSrcTypes);
    }

    public static DataSet getDataSet(long modelId, long dataSetId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(7);
        qFilters.add(PermissionHelper.getReadAndWritePermFilter(modelId, "fidm_dataset"));
        qFilters.add(new QFilter(MODELID, "=", (Object)modelId));
        qFilters.add(new QFilter("id", "=", (Object)dataSetId));
        DynamicObjectCollection dataSetDatas = QueryServiceHelper.query((String)"fidm_dataset", (String)"id,number,name,chapterid,type,status,scope,creator.name,createtime,modifier.name,modifytime", (QFilter[])qFilters.toArray(new QFilter[0]));
        List<DataSet> dataSets = DatasetServiceHelper.getDataSetModels(modelId, (DynamicObject[])dataSetDatas.toArray((Object[])new DynamicObject[0]), 0L, null);
        return dataSets.isEmpty() ? null : dataSets.get(0);
    }

    public static List<DataSet> getDataSets(long modelId, List<Long> dataSetIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(7);
        qFilters.add(PermissionHelper.getReadAndWritePermFilter(modelId, "fidm_dataset"));
        qFilters.add(new QFilter(MODELID, "=", (Object)modelId));
        qFilters.add(new QFilter("id", "in", dataSetIds));
        DynamicObjectCollection dataSetDatas = QueryServiceHelper.query((String)"fidm_dataset", (String)"id,number,name,chapterid,type,status,scope,creator.name,createtime,modifier.name,modifytime", (QFilter[])qFilters.toArray(new QFilter[0]));
        return DatasetServiceHelper.getDataSetModels(modelId, (DynamicObject[])dataSetDatas.toArray((Object[])new DynamicObject[0]), 0L, null);
    }

    private static List<DataSet> getDataSetModels(long modelId, DynamicObject[] dys, long chapterId, List<String> dataSrcTypes) {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>(dys.length);
        List ids = Arrays.stream(dys).map(d -> d.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection dyTypes = QueryServiceHelper.query((String)"fidm_dataset_single", (String)"dataset,datasrctype,ebdataset", (QFilter[])new QFilter("dataset", "in", ids).toArray());
        for (DynamicObject dy : dys) {
            DataSet dataSet = new DataSet();
            dataSet.setId(dy.getLong("id"));
            dataSet.setNumber(dy.getString("number"));
            dataSet.setName(dy.getString("name"));
            dataSet.setChapterId(dy.getLong("chapterid"));
            dataSet.setType(dy.getString("type"));
            dataSet.setStatus(dy.getBoolean("status"));
            dataSet.setScope(dy.getString("scope"));
            dataSet.setCreator(dy.getString("creator.name"));
            dataSet.setCreateTime(dy.getDate("createtime"));
            dataSet.setModifier(dy.getString("modifier.name"));
            dataSet.setModifyTime(dy.getDate("modifytime"));
            DynamicObject dyType = dyTypes.stream().filter(d -> d.getLong("dataset") == dataSet.getId()).findFirst().orElse(null);
            if (dyType != null) {
                dataSet.setEbDataSetNumber(dyType.getString("ebdataset"));
                String type = dyType.getString("datasrctype").trim();
                if (!"3".equals(dataSet.getType()) && dataSrcTypes != null && !dataSrcTypes.contains(type)) continue;
                DataSrcTypeEnum typeEnum = DataSrcTypeEnum.getByType(type);
                if (typeEnum != null) {
                    dataSet.setDataSrcType(typeEnum.getType());
                    dataSet.setDataSrcTypeName(typeEnum.getName());
                }
            }
            if (chapterId > 0L) {
                JSONObject json = DisclosureDesignHelper.createDataSouceNode(modelId, chapterId, dataSet.getId());
                dataSet.setParams(JSON.toJSONStringWithDateFormat((Object)json, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]));
            }
            dataSets.add(dataSet);
        }
        return dataSets;
    }

    public static ResultInfo setDataSetStatus(long modelId, List<Long> dataSetIds, boolean enable) {
        DynamicObject[] dys = BusinessDataServiceHelper.load((Object[])dataSetIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fidm_dataset"));
        List ids = Arrays.stream(dys).map(x -> x.getLong("id")).collect(Collectors.toList());
        ResultInfo output = new ResultInfo();
        output.setSuccess(false);
        output.setData(new ArrayList(0));
        if (ids.isEmpty() || ids.size() < dataSetIds.size()) {
            output.setData(DatasetServiceHelper.getDataSetModels(modelId, dys, 0L, null));
            output.setMessage(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5df2\u4e0d\u5b58\u5728\u3002", (String)"DatasetServiceHelper_6", (String)"epm-far-business", (Object[])new Object[0]));
            return output;
        }
        long userId = RequestContext.get().getCurrUserId();
        String userName = RequestContext.get().getUserName();
        Date now = TimeServiceHelper.now();
        boolean isModelManager = MemberPermHelper.isDiscModelAdmin(modelId, ApplicationTypeEnum.FIDM.getAppnum());
        ArrayList<String> errorMsgs = new ArrayList<String>(ids.size());
        List<Object> hasWriteIds = new ArrayList(6);
        if (!isModelManager) {
            hasWriteIds = PermissionHelper.getWritePermData(modelId, "fidm_dataset");
        }
        for (DynamicObject dy : dys) {
            if (isModelManager || hasWriteIds.contains(dy.getLong("id"))) {
                dy.set("status", (Object)(enable ? "1" : "0"));
                dy.set("modifier", (Object)userId);
                dy.set("modifytime", (Object)now);
                continue;
            }
            errorMsgs.add(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u96c6\u201c%1$s\u201d\u7684\u5199\u6743\u9650\u3002", (String)"DatasetServiceHelper_7", (String)"epm-far-business", (Object[])new Object[0]), dy.getString("name")));
        }
        if (!errorMsgs.isEmpty()) {
            output.setMessage(String.join((CharSequence)"", errorMsgs));
            return output;
        }
        SaveServiceHelper.save((DynamicObject[])dys);
        List<DataSet> dataSets = DatasetServiceHelper.getDataSetModels(modelId, dys, 0L, null);
        for (DataSet ds : dataSets) {
            ds.setModifier(userName);
        }
        output.setData(dataSets);
        output.setSuccess(true);
        return output;
    }

    public static String checkDelete(long modelId, DynamicObject dataSet) {
        if (dataSet == null) {
            return ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5df2\u4e0d\u5b58\u5728\u3002", (String)"DatasetServiceHelper_6", (String)"epm-far-business", (Object[])new Object[0]);
        }
        long dataSetId = dataSet.getLong("id");
        String dataSetName = dataSet.getString("name");
        boolean status = dataSet.getBoolean("status");
        if (!PermissionHelper.hasWritePerm(modelId, "fidm_dataset", dataSetId)) {
            return String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u96c6\u201c%1$s\u201d\u7684\u5199\u6743\u9650\u3002", (String)"FidmDataSetAction_13", (String)"epm-far-business", (Object[])new Object[0]), dataSetName);
        }
        if (status) {
            return String.format(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u7684\u6570\u636e\u96c6\u4e0d\u53ef\u5220\u9664\u3002", (String)"DatasetServiceHelper_8", (String)"epm-far-business", (Object[])new Object[0]), dataSetName);
        }
        DynamicObject multiDataSet = QueryServiceHelper.queryOne((String)"fidm_dataset_multivalue", (String)"id,dataset.name", (QFilter[])new QFilter("single.dataset", "=", (Object)dataSetId).toArray());
        if (multiDataSet != null) {
            return String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u201c%1$s\u201d\u88ab\u591a\u503c\u6570\u636e\u96c6\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetServiceHelper_9", (String)"epm-far-business", (Object[])new Object[0]), dataSetName, multiDataSet.getString("dataset.name"));
        }
        DynamicObject module = QueryServiceHelper.queryOne((String)"fidm_modulerepository", (String)"id,number,name,catalog.id", (QFilter[])new QFilter[]{new QFilter("datasetid", "=", (Object)dataSetId)});
        if (module == null) {
            return kd.bos.util.StringUtils.getEmpty();
        }
        long moduleCatalogId = module.getLong("catalog.id");
        if (moduleCatalogId > 0L && QueryServiceHelper.exists((String)"fidm_modulecatalog", (Object)moduleCatalogId)) {
            return String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u201c%1$s\u201d\u88ab\u7ec4\u4ef6\u5e93\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetServiceHelper_10", (String)"epm-far-business", (Object[])new Object[0]), dataSetName);
        }
        long moduleId = module.getLong("id");
        DynamicObject chapter = QueryServiceHelper.queryOne((String)"fidm_chapter", (String)"id,name,number,entryentity,template.id,template.name,template.templatecatalog.catalogtype,group.id", (QFilter[])new QFilter[]{new QFilter("entryentity.module", "=", (Object)moduleId)});
        if (chapter == null || chapter.getLong("id") <= 0L) {
            return ResManager.loadKDString((String)"\u8be5\u6570\u636e\u96c6\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetServiceHelper_11", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (chapter.getLong("template.id") > 0L) {
            String catalogtype = chapter.getString("template.templatecatalog.catalogtype");
            if (AppCatalogTypeEnum.FIDM_CATALOG.getType().equals(catalogtype)) {
                return String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u201c%1$s\u201d\u88ab\u62a5\u544a\u6a21\u677f\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetServiceHelper_12", (String)"epm-far-business", (Object[])new Object[0]), dataSetName, chapter.getString("template.name"));
            }
            if (AppCatalogTypeEnum.FAR_CATALOG.getType().equals(catalogtype)) {
                return String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u201c%1$s\u201d\u88ab\u5206\u6790\u8bbe\u8ba1\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetServiceHelper_13", (String)"epm-far-business", (Object[])new Object[0]), dataSetName, chapter.getString("template.name"));
            }
        }
        if (chapter.getLong("group.id") > 0L) {
            return String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u201c%1$s\u201d\u88ab\u7ae0\u8282\u5e93\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetServiceHelper_14", (String)"epm-far-business", (Object[])new Object[0]), dataSetName, chapter.getString("name"));
        }
        DynamicObject report = QueryServiceHelper.queryOne((String)"fidm_report", (String)"id,name,entryentity,entryentity.chapter", (QFilter[])new QFilter[]{new QFilter("entryentity.chapter", "=", (Object)chapter.getLong("id"))});
        if (report != null) {
            return String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u201c%1$s\u201d\u88ab\u6211\u7684\u62a5\u544a\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetServiceHelper_15", (String)"epm-far-business", (Object[])new Object[0]), dataSetName, report.getString("name"));
        }
        return kd.bos.util.StringUtils.getEmpty();
    }

    public static List<DataSetMultiValue> getDataSetMultiValue(long modelId, long dataSetId) {
        QFilter qFilter = new QFilter("dataset", "=", (Object)dataSetId);
        DynamicObjectCollection multiValues = QueryServiceHelper.query((String)"fidm_dataset_multivalue", (String)"id,number,name,formulatype,formulatext,single.id,desq", (QFilter[])qFilter.toArray());
        ArrayList<DataSetMultiValue> values = new ArrayList<DataSetMultiValue>(multiValues.size());
        for (DynamicObject multi : multiValues) {
            DataSetMultiValue value = new DataSetMultiValue();
            value.setId(multi.getLong("id"));
            value.setNumber(multi.getString("number"));
            value.setName(multi.getString("name"));
            value.setFormulaType(multi.getString("formulatype"));
            value.setFormulaText(multi.getString("formulatext"));
            value.setDataSetSingleId(multi.getLong("single.id"));
            value.setDseq(multi.getInt("desq"));
            values.add(value);
        }
        return values;
    }

    public static long getDatasetId(JSONObject itemObject) {
        long dataSetId = 0L;
        JSONObject dataset = itemObject.getJSONObject("dataset");
        if (Objects.nonNull(dataset)) {
            dataSetId = itemObject.getJSONObject("dataset").getLong("id");
        }
        return dataSetId;
    }

    public static String getDataSourceTypeOfSingleDS(long datasetId, long discModelId) {
        DynamicObject discModel = DatasetDataReader.getModel(discModelId);
        return DatasetServiceHelper.getDataSourceTypeOfSingleDS(datasetId, discModel);
    }

    public static String getDataSourceTypeOfSingleDS(long datasetId, DynamicObject discModel) {
        DynamicObject singleDS = DatasetDataReader.getSingleDS(datasetId);
        String dataSrcType = singleDS.getString("datasrctype");
        if (DataSrcTypeEnum.CURRENT_MODEL.getType().equals(dataSrcType)) {
            DynamicObject sourceModel = discModel.getDynamicObject("model");
            return sourceModel.getDataEntityType().getName();
        }
        DataSrcTypeEnum typeEnum = DataSrcTypeEnum.getByType(dataSrcType);
        if (Objects.nonNull((Object)typeEnum)) {
            return typeEnum.getFormId();
        }
        return "NotSupportedSourceType";
    }

    public static long getDataSrcIdByDatasetOfSingleDS(long datasetId) {
        DynamicObject singleDS = DatasetDataReader.getSingleDS(datasetId);
        return singleDS.getLong("datasrcid");
    }

    public static DatasetStyleEnum getDatasetStyle(long datasetId) {
        DynamicObject datatset = DatasetDataReader.getDataSet(datasetId);
        return DatasetStyleEnum.getByType(datatset.getString("currentstyle"));
    }

    public static String getDefaultMemberNumber(Long modelId, String defValue, String shortnumber, String entity, Long dimId) {
        if ("1".equals(defValue)) {
            String number = shortnumber + "None";
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("model.id", "=", (Object)modelId);
            qfBuilder.add("number", "=", (Object)number);
            qfBuilder.add("dimension", "=", (Object)dimId);
            if (QueryServiceHelper.exists((String)entity, (QFilter[])qfBuilder.toArray())) {
                return number;
            }
            qfBuilder = new QFBuilder();
            qfBuilder.add("model.id", "=", (Object)modelId);
            qfBuilder.add("dimension", "=", (Object)dimId);
            qfBuilder.add("parent", "=", (Object)0L);
            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)"id,number", (QFilter[])qfBuilder.toArray());
            if (Objects.nonNull(obj)) {
                return obj.getString("number");
            }
            return "";
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model.id", "=", (Object)modelId);
        qfBuilder.add("dimension", "=", (Object)dimId);
        qfBuilder.add("parent", "=", (Object)0L);
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)"id,number", (QFilter[])qfBuilder.toArray());
        if (Objects.nonNull(obj)) {
            return obj.getString("number");
        }
        String number = shortnumber + "None";
        qfBuilder = new QFBuilder();
        qfBuilder.add("modMel.id", "=", (Object)modelId);
        qfBuilder.add("dimension", "=", (Object)dimId);
        qfBuilder.add("number", "=", (Object)number);
        if (QueryServiceHelper.exists((String)entity, (QFilter[])qfBuilder.toArray())) {
            return number;
        }
        return "";
    }
}

