/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.bcm.dto.BCMMemberTreeNode;
import kd.epm.far.business.common.dataset.calculate.base.AbsDataSet;
import kd.epm.far.business.common.dataset.calculate.base.IDataSetCalculate;
import kd.epm.far.business.common.dataset.calculate.cal.CalculateStrategy;
import kd.epm.far.business.common.dataset.calculate.input.AbstractInput;
import kd.epm.far.business.common.dataset.dto.ColumnTypeEnum;
import kd.epm.far.business.common.dataset.dto.DatasetCalculateVo;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetEntityVo;
import kd.epm.far.business.common.dataset.dto.DatasetFilterVo;
import kd.epm.far.business.common.dataset.dto.DatasetJoinVo;
import kd.epm.far.business.common.dataset.dto.DatasetMetadataVo;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.dto.DatasetRenameVo;
import kd.epm.far.business.common.dataset.dto.DatasetTemplateVo;
import kd.epm.far.business.common.dataset.dto.DatasetVoucherVo;
import kd.epm.far.business.common.dataset.dto.SourceEntityVo;
import kd.epm.far.business.common.dataset.util.DatasetCheckUtil;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetDimService;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.dataset.util.DmPeriodAndFyUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DatasetStyleEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.FidmDataTypeEnum;
import kd.epm.far.business.common.enums.FormulaExceptionEnum;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.strategy.IModel;
import kd.epm.far.business.common.strategy.ModelStrategy;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.eb.dto.EbMember;
import kd.epm.far.business.far.calculate.CalculateHelper;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.enums.DataTypeEnum;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DatasetUtil {
    public static final Set<String> conditions = Sets.newHashSet((Object[])new String[]{">", "<", ">=", "<="});
    public static final Set<String> caltype = Sets.newHashSet((Object[])new String[]{DataTypeEnum.DEFAULT.getOIndex(), DataTypeEnum.CURRENCY.getOIndex(), DataTypeEnum.UNCURRENCY.getOIndex(), DataTypeEnum.PROPORTION.getOIndex()});

    public static Boolean isMetadtaSrcType(DatasetDto dataSetDto) {
        Long metadataId = dataSetDto.getMetadataId();
        return LongUtil.isvalidLong((Object)metadataId) || StringUtils.isNotEmpty((CharSequence)dataSetDto.getVoucherNumber());
    }

    private static void addMetadataDataSetProperty(String data, List<String> groupByList, StringBuilder basesb, List<String> valueList, List<Map<String, Object>> result, Map<String, String> nameMap) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)data)) {
            DatasetDataVo vo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
            Set<Object> hideColmuns = Collections.emptySet();
            if (Objects.isNull(vo)) {
                return;
            }
            if (Objects.nonNull(vo.getHideColumns())) {
                hideColmuns = vo.getHideColumns();
            }
            if (Objects.nonNull(vo.getColumns())) {
                List<DatasetPropertyVo> list = vo.getColumns();
                for (DatasetPropertyVo datasetPropertyVo : list) {
                    String id = datasetPropertyVo.getId();
                    String number = datasetPropertyVo.getNumber();
                    if (hideColmuns.contains(number)) continue;
                    if (groupByList.size() > 0) {
                        if (!groupByList.contains(number) && !valueList.contains(number)) continue;
                        DatasetUtil.setMetaColumnAndFmoney(datasetPropertyVo, basesb, valueList, id, number, result, nameMap);
                        continue;
                    }
                    DatasetUtil.setMetaColumnAndFmoney(datasetPropertyVo, basesb, valueList, id, number, result, nameMap);
                }
            }
        }
    }

    public static List<Map<String, Object>> getColumnsByExpression(DatasetDto dto) {
        return DatasetUtil.getColumnsByExpression(dto, false);
    }

    public static List<Map<String, Object>> getColumnsByExpression(DatasetDto dto, boolean isOriColumn) {
        HashSet groupSet;
        String groupBy;
        HashMap nameMap = Maps.newHashMapWithExpectedSize((int)16);
        if (DataSrcTypeEnum.BCM_ISC_METADATA.getType().equals(dto.getDataSrcType()) || DataSrcTypeEnum.ISC_METADATA.getType().equals(dto.getDataSrcType()) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(dto.getDataSrcType())) {
            return DatasetUtil.getColumnsByCustom(dto, isOriColumn);
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)16);
        if (!LongUtil.isvalidLong((Object)dto.getDataSrcId()) || StringUtils.isBlank((CharSequence)dto.getDataSrcType()) || StringUtils.isBlank((CharSequence)dto.getExpression())) {
            return result;
        }
        String ex = DatasetUtil.replaceExpressionVar(dto);
        dto.setExpression(ex);
        dto.setTempExpression(ex);
        StringBuilder basesb = new StringBuilder();
        StringBuilder extsb = new StringBuilder();
        DatasetDimService fidmDimService = new DatasetDimService();
        Tuple<Long, String, Map<String, String>> data = fidmDimService.getShortNumbers(dto.getDataSrcType(), dto.getDataSrcId(), "1", dto.getEbDataset());
        if (LongUtil.isvalidLong((Object)data.p1)) {
            basesb.append("L");
            extsb.append("L");
        } else {
            basesb.append("R");
            extsb.append("R");
        }
        if ("epm_dimension".equals(data.p2)) {
            basesb.append("B");
        } else {
            basesb.append("C");
        }
        String expression = dto.getExpression();
        String string = groupBy = isOriColumn ? "" : dto.getGroupBy();
        if (StringUtils.isNotEmpty((CharSequence)groupBy)) {
            groupSet = Sets.newHashSet(DatasetUtil.split(groupBy));
        } else {
            groupSet = Sets.newHashSet(((Map)data.p3).keySet());
            if (dto.isHasSourceOrg() || DatasetUtil.hasOrgDim(dto.getData())) {
                groupSet.add("SourceEntity");
            }
        }
        DatasetDataVo vo = null;
        if (StringUtils.isNotBlank((CharSequence)dto.getData())) {
            vo = (DatasetDataVo)JSON.parseObject((String)dto.getData(), (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
        }
        if (!isOriColumn && DataSetTypeEnum.MULTIPLE_ROW.getType().equals(dto.getType())) {
            DatasetUtil.buildEntryEntityVo(dto, nameMap);
        }
        HashMap dimMap = Maps.newHashMapWithExpectedSize((int)16);
        DatasetUtil.addColumns(vo, result, basesb, data, expression, groupSet, dimMap, nameMap);
        DatasetUtil.addSourceOrg(result, dto, groupSet, dimMap, nameMap);
        DatasetUtil.addPoperty(vo, result, (Map)data.p3, groupSet, nameMap);
        DatasetUtil.addFmoney(vo, dto, result, extsb, fidmDimService, nameMap);
        if (!isOriColumn) {
            DatasetUtil.addTransformRow(dto.getDimNum(), dto.getMemberNum(), dto.getDataSrcId(), result, nameMap, dto.getEbDataset());
            DatasetUtil.addCalculate(dto, result, nameMap);
            DatasetUtil.addJoin(dto, result, nameMap);
        }
        if (DataSrcTypeEnum.CM_TEMPLATE.getType().equals(dto.getDataSrcType()) && "hasDim".equals(dto.getArea())) {
            Map p3 = (Map)data.p3;
            for (String column : groupSet) {
                String[] split = ((String)p3.get(column)).split(";");
                if (split.length < 2) continue;
                Set<String> hideColumns = vo.getHideColumns();
                String number = split[0];
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(hideColumns) && hideColumns.contains(number)) continue;
                String name = split[1];
                if (!result.stream().noneMatch(t -> number.equals(t.get("number")))) continue;
                LinkedHashMap<String, String> one = new LinkedHashMap<String, String>(3);
                one.put("number", number);
                one.put("id", number);
                one.put("name", name);
                if (nameMap.containsKey(column)) {
                    nameMap.put("name", nameMap.get(number));
                }
                one.put("type", "LCD");
                one.put("col_type", "1");
                result.add(one);
            }
        }
        return result;
    }

    private static void buildEntryEntityVo(DatasetDto dto, Map<String, String> nameMap) {
        if (!LongUtil.isvalidLong((Object)dto.getId())) {
            return;
        }
        DynamicObject singleDS = DatasetDataReader.getSingleDS(dto.getId());
        DynamicObjectCollection renameEntity = singleDS.getDynamicObjectCollection("renameentity");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)renameEntity)) {
            for (DynamicObject dy : renameEntity) {
                ILocaleString localeString = dy.getLocaleString("renamename");
                String name = null;
                if (Objects.nonNull(localeString)) {
                    name = localeString.getLocaleValue();
                }
                nameMap.put(dy.getString("renamenumber"), name);
            }
        }
    }

    public static DatasetRenameVo getRenameVo(DynamicObject dy) {
        DatasetRenameVo renameVo = new DatasetRenameVo();
        renameVo.setNumber(dy.getString("renamenumber"));
        renameVo.setName(dy.getString("renamename"));
        return renameVo;
    }

    public static DatasetCalculateVo getCalculateVo(DynamicObject dy) {
        DatasetCalculateVo calculateVo = new DatasetCalculateVo();
        calculateVo.setNumber(dy.getString("calnumber"));
        calculateVo.setExpression(dy.getString("calexpression"));
        String calname = dy.getString("calname");
        calculateVo.setName(calname);
        return calculateVo;
    }

    public static DatasetJoinVo getJoinVo(DynamicObject dy) {
        DatasetJoinVo joinVo = new DatasetJoinVo();
        joinVo.setJoinNumber(dy.getString("joinnumber"));
        joinVo.setEntityName(dy.getString("joinsource"));
        joinVo.setOnField(dy.getString("joinfield"));
        String selectfields = dy.getString("selectfields");
        joinVo.setSelectFieldStr(selectfields);
        if (StringUtils.isNotEmpty((CharSequence)selectfields)) {
            joinVo.setSelectFields(Sets.newHashSet((Object[])dy.getString("selectfields").split(",")));
        }
        return joinVo;
    }

    private static void addJoin(DatasetDto dto, List<Map<String, Object>> result, Map<String, String> nameMap) {
        if (Objects.isNull(dto.getManageVo())) {
            return;
        }
        DatasetEntityVo saveVo = dto.getManageVo();
        List<DatasetJoinVo> joinVos = saveVo.getJoinVos();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(joinVos)) {
            return;
        }
        for (DatasetJoinVo joinVo : joinVos) {
            Set<String> selectFields = joinVo.getSelectFields();
            MainEntityType dataEntityType = DatasetUtil.getEntityType(joinVo.getEntityName());
            Map allFields = dataEntityType.getAllFields();
            for (String selectField : selectFields) {
                LinkedHashMap<String, String> one = new LinkedHashMap<String, String>(4);
                one.put("number", joinVo.getEntityName() + "." + selectField);
                one.put("id", joinVo.getEntityName() + "." + selectField);
                IDataEntityProperty property = (IDataEntityProperty)allFields.get(selectField);
                String name = property.getDisplayName().toString();
                if (nameMap.containsKey(joinVo.getEntityName() + "." + selectField)) {
                    name = nameMap.get(joinVo.getEntityName() + "." + selectField);
                }
                String dataType = FidmDataTypeEnum.LET.type;
                one.put("col_type", "1");
                if (property instanceof DecimalProp || property instanceof LongProp) {
                    dataType = FidmDataTypeEnum.DM.type;
                    one.put("col_type", "2");
                }
                one.put("name", name);
                one.put("type", dataType);
                result.add(one);
            }
        }
    }

    private static void addCalculate(DatasetDto dto, List<Map<String, Object>> result, Map<String, String> nameMap) {
        if (Objects.isNull(dto.getManageVo())) {
            return;
        }
        DatasetEntityVo saveVo = dto.getManageVo();
        List<DatasetCalculateVo> calculateVos = saveVo.getCalculateVos();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(calculateVos)) {
            return;
        }
        for (DatasetCalculateVo calculateVo : calculateVos) {
            LinkedHashMap<String, String> one = new LinkedHashMap<String, String>(4);
            one.put("number", calculateVo.getNumber());
            String name = calculateVo.getName().toString();
            if (nameMap.containsKey(calculateVo.getNumber()) && StringUtils.isNotBlank((CharSequence)nameMap.get(calculateVo.getNumber()))) {
                name = nameMap.get(calculateVo.getNumber());
            }
            one.put("id", calculateVo.getNumber());
            one.put("name", name);
            one.put("type", FidmDataTypeEnum.DM.type);
            one.put("col_type", "2");
            result.add(one);
        }
    }

    public static Set<String> getMetadataMoneyKey(Long datasetId) {
        Set<Object> moneyKeySet = Sets.newHashSetWithExpectedSize((int)2);
        DynamicObject datasetSingle = DatasetDataReader.getSingleDS(datasetId, false);
        if (Objects.nonNull(datasetSingle)) {
            DynamicObjectCollection joinEntity;
            DynamicObjectCollection calculateEntity;
            String value = datasetSingle.getString("value");
            if (kd.bos.util.StringUtils.isNotEmpty((String)value)) {
                String[] all = value.split(",");
                moneyKeySet = Arrays.stream(all).filter(s -> kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)s) && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)s.trim())).collect(Collectors.toSet());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(calculateEntity = datasetSingle.getDynamicObjectCollection("calculateentity")))) {
                for (DynamicObject dy : calculateEntity) {
                    moneyKeySet.add(dy.getString("calnumber"));
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(joinEntity = datasetSingle.getDynamicObjectCollection("joinentity")))) {
                for (DynamicObject dy : joinEntity) {
                    String entityName = dy.getString("joinsource");
                    MainEntityType dataEntityType = DatasetUtil.getEntityType(entityName);
                    Map allFields = dataEntityType.getAllFields();
                    String selectfields = dy.getString("selectfields");
                    for (String selectField : selectfields.split(",")) {
                        IDataEntityProperty property = (IDataEntityProperty)allFields.get(selectField);
                        if (!(property instanceof DecimalProp) && !(property instanceof LongProp)) continue;
                        moneyKeySet.add(entityName + "." + selectField);
                    }
                }
            }
        }
        return moneyKeySet;
    }

    public static List<Map<String, Object>> getColumnsByCustom(Long datasetId) {
        DatasetDto dto = DatasetUtil.getSingleDataSetDto(datasetId);
        return DatasetUtil.getColumnsByExpression(dto, false);
    }

    public static MainEntityType getEntityType(String number) {
        try {
            return EntityMetadataCache.getDataEntityType((String)number);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u5931\u8d25,\u8bf7\u68c0\u67e5\u201c%s\u201d\u57fa\u7840\u8d44\u6599\u3002", (String)"DataSetUtil_03", (String)"epm-far-business", (Object[])new Object[0]), number));
        }
    }

    public static List<Map<String, Object>> getColumnsByCustom(DatasetDto datasetSingle, boolean isOriColumn) {
        ArrayList result = Lists.newArrayListWithCapacity((int)16);
        StringBuilder basesb = new StringBuilder();
        basesb.append("L");
        basesb.append("C");
        HashMap nameMap = Maps.newHashMapWithExpectedSize((int)16);
        String value = datasetSingle.getValue();
        List<Object> valueList = Lists.newArrayListWithExpectedSize((int)2);
        if (kd.bos.util.StringUtils.isNotEmpty((String)value)) {
            String[] values = value.split(",");
            valueList = Arrays.stream(values).filter(s -> StringUtils.isNotEmpty((CharSequence)s) && StringUtils.isNotEmpty((CharSequence)s.trim())).collect(Collectors.toList());
        }
        String data = datasetSingle.getData();
        String groupBy = isOriColumn ? "" : datasetSingle.getGroupBy();
        List<String> groupByList = DatasetUtil.getDataSetGroupBy(groupBy);
        if (!isOriColumn && DataSetTypeEnum.MULTIPLE_ROW.getType().equals(datasetSingle.getType())) {
            DatasetUtil.buildEntryEntityVo(datasetSingle, nameMap);
        }
        DatasetUtil.addMetadataDataSetProperty(data, groupByList, basesb, valueList, result, nameMap);
        if (!isOriColumn) {
            DatasetUtil.addCalculate(datasetSingle, result, nameMap);
            DatasetUtil.addJoin(datasetSingle, result, nameMap);
        }
        return result;
    }

    public static void buildRename(List<Map<String, Object>> columnMapList, DynamicObject dyn) {
        if (Objects.isNull(dyn)) {
            return;
        }
        DynamicObjectCollection renameEntity = dyn.getDynamicObjectCollection("renameentity");
        HashMap nameMap = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isNotEmpty((Collection)renameEntity)) {
            for (DynamicObject dy : renameEntity) {
                String number = dy.getString("renamenumber");
                ILocaleString localeString = dy.getLocaleString("renamename");
                String name = null;
                if (Objects.nonNull(localeString)) {
                    name = localeString.getLocaleValue();
                }
                nameMap.put(number, name);
            }
        }
        for (Map<String, Object> map : columnMapList) {
            String value = (String)nameMap.get(map.get("number").toString());
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            map.put("name", value);
        }
    }

    public static void buildManage(List<Map<String, Object>> columnMapList, DynamicObject dyn) {
        DynamicObjectCollection calculateEntity;
        if (Objects.isNull(dyn)) {
            return;
        }
        DynamicObjectCollection joinEntity = dyn.getDynamicObjectCollection("joinentity");
        if (CollectionUtils.isNotEmpty((Collection)joinEntity)) {
            for (DynamicObject dy : joinEntity) {
                String[] selectfields;
                String source = dy.getString("joinsource");
                MainEntityType dataEntityType = DatasetUtil.getEntityType(source);
                Map allFields = dataEntityType.getAllFields();
                for (String selectfield : selectfields = dy.getString("selectfields").split(",")) {
                    if (!allFields.containsKey(selectfield)) continue;
                    IDataEntityProperty property = (IDataEntityProperty)allFields.get(selectfield);
                    HashMap map = Maps.newHashMapWithExpectedSize((int)5);
                    map.put("number", source + "." + selectfield);
                    map.put("name", ((IDataEntityProperty)allFields.get(selectfield)).getDisplayName().getLocaleValue());
                    map.put("id", source + "." + selectfield);
                    String dataType = FidmDataTypeEnum.LET.type;
                    if (property instanceof DecimalProp || property instanceof LongProp) {
                        dataType = FidmDataTypeEnum.DM.type;
                    }
                    map.put("type", dataType);
                    map.put("col_type", "1");
                    columnMapList.add(map);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(calculateEntity = dyn.getDynamicObjectCollection("calculateentity")))) {
            for (DynamicObject dy : calculateEntity) {
                String number = dy.getString("calnumber");
                String name = dy.getLocaleString("calname").getLocaleValue();
                HashMap map = Maps.newHashMapWithExpectedSize((int)5);
                map.put("number", number);
                map.put("name", name);
                map.put("id", number);
                map.put("type", "DM");
                map.put("col_type", "2");
                columnMapList.add(map);
            }
        }
    }

    private static List<String> getDataSetGroupBy(String groupBy) {
        List<Object> groupByList = Lists.newArrayListWithExpectedSize((int)2);
        if (kd.bos.util.StringUtils.isNotEmpty((String)groupBy)) {
            String[] all = groupBy.split(",");
            groupByList = Arrays.asList(all);
        }
        return groupByList;
    }

    private static void setMetaColumnAndFmoney(DatasetPropertyVo datasetPropertyVo, StringBuilder basesb, List<String> valueList, String id, String number, List<Map<String, Object>> result, Map<String, String> nameMap) {
        String name = datasetPropertyVo.getName();
        String type = basesb + "D";
        String colType = "1";
        if (valueList.contains(number)) {
            type = FidmDataTypeEnum.DM.getType();
            colType = "2";
        }
        LinkedHashMap<String, String> one = new LinkedHashMap<String, String>(4);
        one.put("id", id);
        if (nameMap.containsKey(number)) {
            name = nameMap.getOrDefault(number, name);
        }
        one.put("name", name);
        one.put("number", number);
        one.put("type", type);
        one.put("col_type", colType);
        result.add(one);
    }

    public static void addTransformRow(String dimNum, String memberNums, Long dataSrcId, List<Map<String, Object>> result, Map<String, String> nameMap, String ebDataset) {
        if (StringUtils.isEmpty((CharSequence)dimNum) || StringUtils.isEmpty((CharSequence)memberNums)) {
            return;
        }
        List memberNumList = (List)SerializationUtils.fromJsonString((String)memberNums, List.class);
        Iterator<Map<String, Object>> iterator = result.iterator();
        ArrayList measureList = Lists.newArrayListWithExpectedSize((int)16);
        while (iterator.hasNext()) {
            Map<String, Object> next = iterator.next();
            String number = (String)next.get("number");
            if (Objects.equals(dimNum, number)) {
                for (String memberNum : memberNumList) {
                    measureList.add(DatasetUtil.getMeasureMap(dimNum, memberNum, dataSrcId, nameMap, ebDataset));
                }
                iterator.remove();
                continue;
            }
            if (!Objects.equals("FMONEY", number)) continue;
            iterator.remove();
        }
        result.addAll(measureList);
    }

    private static void addFmoney(DatasetDataVo vo, DatasetDto dto, List<Map<String, Object>> result, StringBuilder extsb, DatasetDimService fidmDimService, Map<String, String> nameMap) {
        Set<Object> hideColumns = Collections.emptySet();
        if (Objects.nonNull(vo)) {
            hideColumns = vo.getHideColumns();
        }
        if (LongUtil.isvalidLong((Object)dto.getExtendsModelId())) {
            String value = dto.getValue();
            extsb.append("E");
            List<String> vals = DatasetUtil.split(value);
            Map<String, String> extdata = fidmDimService.getExtendsFields(dto.getDataSrcType(), dto.getDataSrcId(), dto.getExtendsModelId(), "1");
            for (Map.Entry<String, String> s : extdata.entrySet()) {
                if (!vals.contains(s.getKey())) continue;
                LinkedHashMap<String, String> one = new LinkedHashMap<String, String>(4);
                if (!s.getValue().contains(";")) continue;
                String[] a = s.getValue().split(";");
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(hideColumns) && hideColumns.contains(s.getKey())) continue;
                one.put("number", s.getKey());
                one.put("name", a[0]);
                if (nameMap.containsKey(s.getKey())) {
                    one.put("name", nameMap.get(s.getKey()));
                }
                if (caltype.contains(a[1])) {
                    one.put("type", extsb + "M");
                    one.put("col_type", "2");
                    result.add(one);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getGroupBy())) continue;
                one.put("type", extsb + "T");
                one.put("col_type", "1");
                result.add(one);
            }
        } else {
            LinkedHashMap<String, String> one = new LinkedHashMap<String, String>(4);
            one.put("number", "FMONEY");
            one.put("name", ResManager.loadKDString((String)"\u5ea6\u91cf\u503c", (String)"DatasetSingleNewPlugin_41", (String)"epm-far-business", (Object[])new Object[0]));
            if (nameMap.containsKey("FMONEY")) {
                one.put("name", nameMap.get("FMONEY"));
            }
            one.put("id", "");
            one.put("col_type", "2");
            one.put("type", FidmDataTypeEnum.DM.getType());
            result.add(one);
        }
    }

    private static void addPoperty(DatasetDataVo vo, List<Map<String, Object>> result, Map<String, String> originDimMap, Set<String> groupSet, Map<String, String> nameMap) {
        if (Objects.isNull(vo)) {
            return;
        }
        List<DatasetPropertyVo> list = vo.getColumns();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return;
        }
        Set<String> hideColumns = vo.getHideColumns();
        for (DatasetPropertyVo propertyVo : list) {
            HashMap dimMap = Maps.newHashMapWithExpectedSize((int)originDimMap.size());
            originDimMap.forEach((key, value) -> {
                String[] dimInfo = value.split(";");
                dimMap.put(dimInfo[0], new Pair((Object)dimInfo[1], key));
            });
            if (Objects.equals(ColumnTypeEnum.MEASURE.getCode(), propertyVo.getType()) || Objects.isNull(dimMap.get(propertyVo.getSource())) || !groupSet.contains(((Pair)dimMap.get((Object)propertyVo.getSource())).p2)) continue;
            LinkedHashMap<String, String> property = new LinkedHashMap<String, String>(4);
            property.put("type", FidmDataTypeEnum.LET.type);
            property.put("col_type", "1");
            if (Objects.equals(ColumnTypeEnum.FIXED_COLUMN.getCode(), propertyVo.getType())) {
                property.put("id", propertyVo.getSource() + "-" + propertyVo.getNumber());
                property.put("number", propertyVo.getSource() + "-" + propertyVo.getNumber());
                property.put("name", (String)((Pair)dimMap.get((Object)propertyVo.getSource())).p1 + "-" + propertyVo.getName());
                if (nameMap.containsKey(propertyVo.getSource() + "-" + propertyVo.getNumber())) {
                    property.put("name", nameMap.get(propertyVo.getSource() + "-" + propertyVo.getNumber()));
                }
                property.put("source", propertyVo.getSource());
            } else {
                property.put("id", propertyVo.getKey());
                property.put("number", propertyVo.getKey());
                property.put("name", String.format(ResManager.loadKDString((String)"%1$s-%2$s", (String)"DatasetServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]), ((Pair)dimMap.get((Object)propertyVo.getSource())).p1, propertyVo.getName()));
                if (nameMap.containsKey(propertyVo.getSource() + "-Property-" + propertyVo.getNumber())) {
                    property.put("name", nameMap.get(propertyVo.getSource() + "-Property-" + propertyVo.getNumber()));
                }
                property.put("source", propertyVo.getSource());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(hideColumns) && hideColumns.contains(property.get("number").toString())) continue;
            result.add(property);
        }
    }

    private static void addColumns(DatasetDataVo vo, List<Map<String, Object>> result, StringBuilder basesb, Tuple<Long, String, Map<String, String>> data, String expression, Set<String> dimset, Map<String, String> dimMap, Map<String, String> nameMap) {
        Set<Object> hideColmuns = Collections.emptySet();
        if (Objects.nonNull(vo)) {
            hideColmuns = vo.getHideColumns();
        }
        List<String> dims = DatasetUtil.split(expression);
        for (String s : dims) {
            String[] a = DatasetExpressionHelper.splitDimAndMemb(s);
            String key = a[0];
            if (!dimset.contains(key)) continue;
            String info = (String)((Map)data.p3).get(key);
            String[] ds = info.split(";");
            LinkedHashMap<String, String> one = new LinkedHashMap<String, String>(4);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(hideColmuns) && hideColmuns.contains(ds[0])) continue;
            one.put("number", ds[0]);
            one.put("id", ds[2]);
            one.put("name", ds[1]);
            if (nameMap.containsKey(ds[0])) {
                one.put("name", nameMap.get(ds[0]));
            }
            one.put("type", basesb + "D");
            one.put("col_type", "1");
            dimMap.put(ds[0], ds[1]);
            result.add(one);
        }
    }

    private static void addSourceOrg(List<Map<String, Object>> result, DatasetDto dto, Set<String> dimset, Map<String, String> dimMap, Map<String, String> nameMap) {
        if (dto == null) {
            return;
        }
        if (!dimset.contains("SourceEntity")) {
            return;
        }
        if (dto.isHasSourceOrg() || DatasetUtil.hasOrgDim(dto.getData())) {
            dimMap.put("SourceEntity", ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"SourceEntity", (String)"epm-far-business", (Object[])new Object[0]));
            LinkedHashMap<String, String> one = new LinkedHashMap<String, String>(4);
            one.put("id", "SourceEntity");
            one.put("number", "SourceEntity");
            one.put("name", ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"SourceEntity", (String)"epm-far-business", (Object[])new Object[0]));
            if (nameMap.containsKey("SourceEntity")) {
                nameMap.put("name", nameMap.get("SourceEntity"));
            }
            one.put("type", "LCD");
            one.put("col_type", "1");
            result.add(one);
        } else if (DatasetUtil.hasOrg(dto.getData())) {
            dimMap.put("SourceEntity", ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"SourceEntity", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static boolean hasOrg(String data) {
        DatasetDataVo datasetDataVo;
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)data) && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)data) && (datasetDataVo = (DatasetDataVo)JSONObject.parseObject((String)data, DatasetDataVo.class)) != null) {
            List collect;
            if (datasetDataVo.getSourceEntityVo() != null) {
                return true;
            }
            List<DatasetPropertyVo> columns = datasetDataVo.getColumns();
            if (columns != null && !columns.isEmpty() && !(collect = columns.stream().filter(v -> "SourceEntity".equals(v.getSource())).collect(Collectors.toList())).isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasOrgDim(String data) {
        DatasetDataVo datasetDataVo;
        return !kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)data) && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)data) && (datasetDataVo = (DatasetDataVo)JSONObject.parseObject((String)data, DatasetDataVo.class)) != null && datasetDataVo.getSourceEntityVo() != null;
    }

    private static Map<String, Object> getMeasureMap(String dimNumber, String memberNumber, Long modelId, Map<String, String> nameMap, String ebDataset) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        if (StringUtils.isNotEmpty((CharSequence)ebDataset)) {
            DynamicObject model = EbServiceHelper.getModel(modelId);
            List<EbMember> member = EbServiceHelper.getMember(model.getString("shownumber"), ebDataset, dimNumber, memberNumber, RangeEnum.VALUE_10);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(member)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7ef4\u5ea6\u6210\u5458\"%s\"\u3002", (String)"DatasetUtil_0", (String)"epm-far-business", (Object[])new Object[0]), member));
            }
            map.put("number", dimNumber + "='" + memberNumber + "'");
            map.put("name", member.get(0).getName());
            if (nameMap.containsKey(dimNumber + "='" + memberNumber + "'")) {
                map.put("name", nameMap.get(dimNumber + "='" + memberNumber + "'"));
            }
            map.put("id", memberNumber);
            map.put("type", "DM");
            map.put("col_type", "2");
            return map;
        }
        BCMMemberTreeNode memberByNumber = BCMMemberReader.findMemberByNumber(BCMMemberReader.findModelNumberById(modelId), dimNumber, memberNumber);
        String name = BCMMemberTreeNode.NotFoundTreeNode.equals(memberByNumber) ? memberNumber : memberByNumber.getName();
        map.put("number", dimNumber + "='" + memberNumber + "'");
        map.put("name", name);
        if (nameMap.containsKey(dimNumber + "='" + memberNumber + "'")) {
            map.put("name", nameMap.get(dimNumber + "='" + memberNumber + "'"));
        }
        map.put("id", memberNumber);
        map.put("type", "DM");
        map.put("col_type", "2");
        return map;
    }

    public static String buildExpression(Map<String, List<Map<String, String>>> dim, Map<String, Set<String>> allCurKeys, boolean rangeWithNumber) {
        Set<String> curKey = Objects.nonNull(allCurKeys) ? allCurKeys.get("cur") : null;
        Set<String> cursKey = Objects.nonNull(allCurKeys) ? allCurKeys.get("curs") : null;
        StringBuilder ex = new StringBuilder();
        for (Map.Entry<String, List<Map<String, String>>> entry : dim.entrySet()) {
            String key = entry.getKey();
            ex.append(key);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(curKey) && curKey.contains(key)) {
                ex.append(".").append("$Cur").append(",");
                continue;
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(cursKey) && cursKey.contains(key)) {
                ex.append(".").append("$Curs").append(",");
                continue;
            }
            List<Map<String, String>> value = entry.getValue();
            if (value.isEmpty()) {
                ex.append(".").append("$All").append(",");
                continue;
            }
            if (value.size() == 1 && kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)value.get(0).get("range"))) {
                ex.append(".").append(value.get(0).get("number"));
            } else {
                ex.append(".").append("{");
                for (Map<String, String> dy : value) {
                    ex.append(dy.get("number"));
                    if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)dy.get("range"))) {
                        if (!dy.get("number").contains("$")) {
                            ex.append(".");
                        }
                        if (rangeWithNumber) {
                            ex.append(dy.get("range"));
                        } else {
                            ex.append(RangeEnum.getRangeByVal((int)Integer.parseInt(dy.get("range"))).getNumber());
                        }
                    }
                    ex.append(";");
                }
                ex.deleteCharAt(ex.length() - 1);
                ex.append("}");
            }
            ex.append(",");
        }
        if (ex.length() != 0 && ',' == ex.charAt(ex.length() - 1)) {
            ex.deleteCharAt(ex.length() - 1);
        }
        return ex.toString();
    }

    public static void buildDetails(DatasetDto dto) {
        String details;
        String type = dto.getType();
        String expression = dto.getTempExpression();
        String value = dto.getValue();
        DatasetDataVo datasetDataVo = null;
        if (!StringUtils.isEmpty((CharSequence)dto.getData())) {
            datasetDataVo = (DatasetDataVo)JSON.parseObject((String)dto.getData(), (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
            StringBuilder sb = new StringBuilder();
            SourceEntityVo sourceEntityVo = datasetDataVo.getSourceEntityVo();
            if (sourceEntityVo != null) {
                sb.append(",").append(DatasetUtil.buildSEStr("SE", sourceEntityVo.getMembers()));
            } else if (DatasetUtil.hasOrg(dto.getData())) {
                sb.append(",").append(DatasetUtil.buildSEStr("SE", null));
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(datasetDataVo.getColumns())) {
                sb.append(",");
                for (DatasetPropertyVo column : datasetDataVo.getColumns()) {
                    sb.append(column.getSource()).append("-").append(column.getNumber());
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(column.getFilters())) {
                        sb.append(".{");
                        for (DatasetFilterVo filter : column.getFilters()) {
                            if (StringUtils.equals((CharSequence)"like", (CharSequence)filter.getCondition())) {
                                sb.append("%").append(filter.getValue()).append(",");
                                continue;
                            }
                            if (StringUtils.equals((CharSequence)"in", (CharSequence)filter.getCondition()) || StringUtils.equals((CharSequence)"=", (CharSequence)filter.getCondition())) {
                                sb.append(filter.getValue()).append(",");
                                continue;
                            }
                            sb.append(filter.getCondition()).append(" ").append(filter.getValue()).append(",");
                        }
                        sb.deleteCharAt(sb.length() - 1);
                        sb.append("}");
                    }
                    sb.append(",");
                }
                String substring = sb.substring(0, sb.length() - 1);
                expression = expression + substring;
            }
        }
        if (Objects.equals(type, DataSetTypeEnum.SINGLE_VALUED.getType())) {
            String defValue = dto.getDefValueName();
            details = String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408='%1$s', \u5ea6\u91cf\u503c='%2$s', \u7f3a\u7701\u503c='%3$s'", (String)"DatasetDto_0", (String)"epm-far-business", (Object[])new Object[0]), expression, value, defValue);
        } else {
            String groupBy = dto.getGroupBy();
            String orderBy = dto.getOrderBy();
            if ("fmoney".equals(orderBy)) {
                orderBy = orderBy.toUpperCase(Locale.ENGLISH);
            }
            String top = Objects.isNull(dto.getTop()) ? "" : dto.getTop().toString();
            details = String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408='%1$s', \u5ea6\u91cf\u503c='%2$s', \u5206\u7ec4\u5b57\u6bb5='%3$s', \u6392\u5e8f\u5b57\u6bb5='%4$s', \u524d\u51e0\u6570\u636e='%5$s'", (String)"DatasetDto_1", (String)"epm-far-business", (Object[])new Object[0]), expression, value, groupBy, orderBy, top);
        }
        if (datasetDataVo == null || datasetDataVo.getSerializedParam() == null) {
            dto.setDetails(details);
            return;
        }
        String propertyString = String.format(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6='%1$s'", (String)"DatasetDto_4", (String)"epm-far-business", (Object[])new Object[0]), datasetDataVo.getSerializedParam());
        dto.setDetails(details + "," + propertyString);
    }

    public static String buildSEStr(String entity, List<DimMemberInfo> dims) {
        if (dims == null || dims.isEmpty()) {
            return entity + ".$ALL";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(entity).append(".");
        if (dims.size() > 1) {
            sb.append("{");
        }
        for (int i = 0; i < dims.size(); ++i) {
            DimMemberInfo dim = dims.get(i);
            String number = dim.getNumber();
            sb.append(number);
            int range = dim.getRange();
            if (range != 0 && range != 10) {
                sb.append(".").append(RangeEnum.getRangeByVal((int)range).getNumber());
            }
            if (i == dims.size() - 1) continue;
            sb.append(";");
        }
        if (dims.size() > 1) {
            sb.append("}");
        }
        return sb.toString();
    }

    public static Object getResult(DatasetDto dataSet) {
        return DatasetUtil.getResultByPreview(dataSet, Boolean.TRUE);
    }

    public static List<String> split(String s) {
        String[] array = s.split(",");
        if (array == null || array.length <= 0) {
            return new ArrayList<String>(8);
        }
        ArrayList<String> list = new ArrayList<String>(8);
        for (String ele : array) {
            list.add(ele.trim());
        }
        return list;
    }

    public static void checkCondition(DatasetDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getData())) {
            return;
        }
        DatasetDataVo datasetDataVo = (DatasetDataVo)JSON.parseObject((String)dto.getData(), (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(datasetDataVo.getColumns())) {
            return;
        }
        for (DatasetPropertyVo column : datasetDataVo.getColumns()) {
            if (org.apache.commons.collections.CollectionUtils.isEmpty(column.getFilters())) continue;
            for (DatasetFilterVo filter : column.getFilters()) {
                DatasetUtil.checkFilter(filter);
            }
        }
    }

    public static DatasetDto getSingleDataSetDto(Long singleId) {
        DynamicObject singleDS = DatasetDataReader.getSingleDS(singleId);
        DynamicObject dataSet = DatasetDataReader.getDataSet(singleId, true);
        DatasetDto dto = new DatasetDto();
        dto.setNumber(singleDS.getString("dataset.number"));
        dto.setName(singleDS.get("dataset.name"));
        dto.setNameStr(singleDS.get("dataset.name").toString());
        dto.setId(singleDS.getLong("dataset.id"));
        dto.setDiscmodelId(singleDS.getLong("dataset.discmodel.id"));
        dto.setScope(dataSet.getString("scope"));
        dto.setChapterId(dataSet.getLong("chapterid"));
        dto.setType(singleDS.getString("dataset.type"));
        dto.setStyle(singleDS.getString("dataset.currentstyle"));
        dto.setDataSrcType(singleDS.getString("datasrctype"));
        dto.setDataSrcId(singleDS.getLong("datasrcid"));
        dto.setExtendsModelId(singleDS.getLong("extendsmodelid"));
        dto.setExtendsModelNumber(singleDS.getString("extendsmodelnumber"));
        dto.setValue(singleDS.getString("value"));
        dto.setDefValue(singleDS.getString("defvalue"));
        dto.setOrderBy(singleDS.getString("orderby"));
        dto.setGroupBy(singleDS.getString("groupby"));
        dto.setTop(singleDS.getInt("top"));
        dto.setAsc(singleDS.getString("asc"));
        dto.setComponentId(singleDS.getLong("component.id"));
        dto.setDimNum(singleDS.getString("dimnum"));
        dto.setMemberNum(singleDS.getString("membernum"));
        dto.setEbDataset(singleDS.getString("ebdataset"));
        dto.setData(singleDS.getString("data"));
        dto.setExpression(singleDS.getString("expression"));
        DatasetUtil.addDtoProperty(dto);
        DatasetUtil.addManageVo(dto, singleDS);
        return dto;
    }

    public static void addManageVo(DatasetDto dto, DynamicObject singleDS) {
        DynamicObjectCollection renameentity;
        DynamicObjectCollection calculateEntity;
        DatasetEntityVo manageVo = new DatasetEntityVo();
        dto.setManageVo(manageVo);
        DynamicObjectCollection joinEntity = singleDS.getDynamicObjectCollection("joinentity");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)joinEntity)) {
            ArrayList joinList = Lists.newArrayListWithExpectedSize((int)joinEntity.size());
            for (Object dy : joinEntity) {
                joinList.add(DatasetUtil.getJoinVo((DynamicObject)dy));
            }
            manageVo.setJoinVos(joinList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(calculateEntity = singleDS.getDynamicObjectCollection("calculateentity")))) {
            ArrayList calculateList = Lists.newArrayListWithExpectedSize((int)calculateEntity.size());
            for (DynamicObject dy : calculateEntity) {
                calculateList.add(DatasetUtil.getCalculateVo(dy));
            }
            manageVo.setCalculateVos(calculateList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(renameentity = singleDS.getDynamicObjectCollection("renameentity")))) {
            ArrayList renameVoList = Lists.newArrayListWithExpectedSize((int)renameentity.size());
            for (DynamicObject dy : renameentity) {
                renameVoList.add(DatasetUtil.getRenameVo(dy));
            }
            manageVo.setRenameVos(renameVoList);
        }
    }

    public static void addDtoProperty(DatasetDto dto) {
        DatasetVoucherVo voucherVo;
        DatasetTemplateVo template;
        DatasetMetadataVo datasetMetadataVo;
        String dataSrcType = dto.getDataSrcType();
        String data = dto.getData();
        if (StringUtils.isBlank((CharSequence)data)) {
            return;
        }
        DatasetDataVo datasetDataVo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
        if (Objects.isNull(datasetDataVo)) {
            return;
        }
        if (DataSrcTypeEnum.ISC_METADATA.getType().equals(dataSrcType) && Objects.nonNull(datasetMetadataVo = datasetDataVo.getMetadata())) {
            Long metadataId = datasetMetadataVo.getMetadataId();
            String metadataType = datasetMetadataVo.getMetadataType();
            dto.setMetadataType(metadataType);
            dto.setMetadataId(metadataId);
        }
        if (DataSrcTypeEnum.CM_TEMPLATE.getType().equals(dataSrcType) && Objects.nonNull(template = datasetDataVo.getTemplate())) {
            dto.setTemplateId(template.getTemplateId());
            dto.setArea(template.getArea());
        }
        if (DataSrcTypeEnum.EPM_VOUCHER.getType().equals(dataSrcType) && Objects.nonNull(voucherVo = datasetDataVo.getDatasetVoucherVo())) {
            dto.setVoucherNumber(voucherVo.getVoucherNumber());
            dto.setVoucherType(voucherVo.getVoucherType());
        }
    }

    public static void checkFilter(DatasetFilterVo filter) {
        if (!conditions.contains(filter.getCondition())) {
            return;
        }
        if (!CalculateHelper.checkNumber(filter.getValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6bd4\u8f83\u8fd0\u7b97\u7b26\u53ea\u652f\u6301\u6570\u503c\u7c7b\u578b,\u8bf7\u8c03\u6574\u91cd\u8bd5\u3002", (String)"DataSetInfoPlugin_01", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static Object getResultByPreview(DatasetDto dataSet, boolean fromPreview) {
        String newExpresion = DatasetUtil.replaceExpressionVar(dataSet);
        dataSet.setExpression(newExpresion);
        DataSetTypeEnum typeEnum = DataSetTypeEnum.getEnumByType(dataSet.getType());
        IDataSetCalculate strategy = CalculateStrategy.getStrategy(GlobalIdUtil.genGlobalLongId(), dataSet, fromPreview, typeEnum);
        strategy.setHasAllDim(DatasetUtil.getHasAllDim(dataSet.getTempExpression(), LongUtil.isvalidLong((Object)dataSet.getExtendsModelId())));
        strategy.setHasSourceOrg(dataSet.isHasSourceOrg());
        return strategy.getResult(null, null, null, null);
    }

    public static Set<String> getHasAllDim(String expression, boolean isExntend) {
        HashSet returnSet = Sets.newHashSetWithExpectedSize((int)16);
        if (!DatasetSpecialVarHelper.isContain(expression)) {
            return returnSet;
        }
        String[] exps = expression.split(",");
        Set<String> baseExtendsDims = DatasetCheckUtil.getBaseExtendsDims();
        for (String exp : exps) {
            if (!DatasetUtil.isDimContainKeyword(exp, "$all")) continue;
            String shortNumber = exp.substring(0, exp.indexOf(46)).trim().toUpperCase(Locale.ENGLISH);
            if (isExntend && baseExtendsDims.contains(shortNumber)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u67e5\u8be2\u7ef4\u5ea6\"%s\"\u6682\u4e0d\u652f\u6301$All\u3002", (String)"DatasetUtil_1", (String)"epm-far-business", (Object[])new Object[0]), shortNumber));
            }
            returnSet.add(shortNumber);
        }
        return returnSet;
    }

    private static boolean isDimContainKeyword(String expression, String keyword) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return false;
        }
        if (expression.indexOf(46) < 0) {
            return false;
        }
        String[] dimStr = DatasetExpressionHelper.splitDimAndMemb(expression);
        String values = dimStr[1];
        String para = values.startsWith("{") && values.endsWith("}") ? values.substring(1, values.length() - 1) : values;
        List<String> members = Arrays.asList(para.split(";"));
        return members.stream().anyMatch(s -> DatasetSpecialVarHelper.isContain(s, keyword));
    }

    public static Boolean checkDataSetVoExist(DatasetDataVo vo) {
        if (Objects.isNull(vo)) {
            return Boolean.FALSE;
        }
        List<DatasetPropertyVo> columns = vo.getColumns();
        if (Objects.nonNull(columns) && columns.size() > 0) {
            return Boolean.TRUE;
        }
        QFilter qFilter = vo.getSerializedParam();
        if (Objects.nonNull(qFilter)) {
            return Boolean.TRUE;
        }
        DatasetMetadataVo datasetMetadataVo = vo.getMetadata();
        if (Objects.nonNull(datasetMetadataVo) && LongUtil.isvalidLong((Object)datasetMetadataVo.getMetadataId())) {
            return Boolean.TRUE;
        }
        DatasetTemplateVo datasetTemplateVo = vo.getTemplate();
        if (Objects.nonNull(datasetTemplateVo) && LongUtil.isvalidLong((Object)datasetTemplateVo.getTemplateId())) {
            return Boolean.TRUE;
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(vo.getHideColumns())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isMetadataDataSet(Long datasetId) {
        String dataSetSrc = "";
        DynamicObject datasetSingle = DatasetDataReader.getSingleDS(datasetId, false);
        if (Objects.nonNull(datasetSingle)) {
            dataSetSrc = datasetSingle.getString("datasrctype");
        }
        if (DataSrcTypeEnum.BCM_ISC_METADATA.getType().equals(dataSetSrc) || DataSrcTypeEnum.ISC_METADATA.getType().equals(dataSetSrc) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(dataSetSrc)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static FormShowParameter getPopFormShow(DatasetDto dto, boolean needPermClass) {
        OperationStatus status;
        Assert.notNull((Object)dto);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("fidm_dataset_pop");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        if (LongUtil.isvalidLong((Object)dto.getId())) {
            IModel strategy;
            Assert.notNull((Object)dto.getId());
            dto = DatasetUtil.getSingleDataSetDto(dto.getId());
            if (!Objects.equals(dto.getStyle(), DatasetStyleEnum.QUERY.getType())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u96c6\u4e0d\u53ef\u7528\u5f39\u51fa\u5f0f\u6253\u5f00\u3002", (String)"DatasetUtil_2", (String)"epm-far-business", (Object[])new Object[0]));
            }
            status = OperationStatus.EDIT;
            DisModelTypeEnum modelType = DisModelTypeEnum.getModelType(dto.getDataSrcType(), dto.getDataSrcId());
            if (DisModelTypeEnum.METADATA != modelType && !(strategy = ModelStrategy.getStrategy(modelType)).isUser(dto.getDataSrcId())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u6570\u636e\u6765\u6e90\u4f53\u7cfb\u6743\u9650,\u65e0\u6cd5\u64cd\u4f5c\u8be5\u6570\u636e\u96c6\u3002", (String)"IFarModel_02", (String)"epm-far-business", (Object[])new Object[0]));
            }
        } else {
            Assert.notNull((Object)dto.getType());
            Assert.notNull((Object)dto.getDataSrcType());
            Assert.notNull((Object)dto.getDataSrcId());
            Assert.notNull((Object)dto.getChapterId());
            status = OperationStatus.ADDNEW;
        }
        fsp.setStatus(status);
        dto.setScope("2");
        dto.setStyle(DatasetStyleEnum.QUERY.getType());
        fsp.setCustomParam("datasetDto", (Object)SerializationUtils.toJsonString((Object)dto));
        fsp.setCustomParam("needPermClass", (Object)needPermClass);
        return fsp;
    }

    public static String replaceExpressionVar(DatasetDto dto) {
        HashMap varParams = Maps.newHashMapWithExpectedSize((int)16);
        String expression = dto.getExpression();
        AbsDataSet.extractVarParams(dto.getExpression(), varParams);
        if (!varParams.isEmpty()) {
            Long discmodelId = dto.getDiscmodelId();
            AbsDataSet.extractDBHandler(discmodelId, dto.getChapterId(), varParams);
            expression = AbstractInput.handleAllVars(dto.getExpression(), varParams);
        }
        return expression;
    }

    public static String replaceExpressionDimVar(String shownumber, String formulaExpression, Map<String, Set<String>> memberMap) {
        if (StringUtils.isEmpty((CharSequence)formulaExpression)) {
            return formulaExpression;
        }
        String[] dims = formulaExpression.split(",");
        ArrayList<String> dimsList = new ArrayList<String>(16);
        String cur = "";
        Object offset = 0;
        for (String dim : dims) {
            String[] dimMember;
            try {
                dimMember = DatasetExpressionHelper.splitDimAndMemb(dim);
            }
            catch (Exception e) {
                dimsList.add(dim);
                continue;
            }
            if (dimMember.length < 2) {
                throw new KDException(BosErrorCode.paramError, new Object[]{String.format(FormulaExceptionEnum.FORMULA_EXPRESSION_ERROR.getName(), dim)});
            }
            String right = dimMember[1];
            String dimNumber = dimMember[0].toUpperCase();
            String para = right.startsWith("{") && right.endsWith("}") ? right.substring(1, right.length() - 1) : right;
            List<String> members = Arrays.asList(para.split(";"));
            ArrayList<String> dimvaluemembers = new ArrayList<String>(members.size());
            for (String member : members) {
                if (DatasetSpecialVarHelper.isEqualsCurVar(member)) {
                    if (memberMap != null && memberMap.containsKey(dimNumber)) {
                        dimMember[1] = memberMap.get(dimNumber).iterator().next();
                        dimvaluemembers.add(dimMember[1]);
                        continue;
                    }
                    throw new KDException(BosErrorCode.paramError, new Object[]{String.format(FormulaExceptionEnum.DIM_NO_DEFAULT_MEMBER.getName(), dimMember[0])});
                }
                if (DatasetSpecialVarHelper.isContainCurVar(member) && DmPeriodAndFyUtil.validCur(member).booleanValue()) {
                    if (Objects.equals(dimMember[0], "FY") || Objects.equals(dimMember[0], "P")) {
                        Object off = DmPeriodAndFyUtil.getCurOffset(member);
                        if (off instanceof Integer) {
                            offset = off;
                        }
                        if (memberMap == null || !memberMap.containsKey(dimMember[0])) {
                            throw new KDException(BosErrorCode.paramError, new Object[]{String.format(FormulaExceptionEnum.DIM_NO_DEFAULT_MEMBER.getName(), dimMember[0])});
                        }
                    } else {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e2d\u7684\u7ef4\u5ea6\u6210\u5458\u201c%s\u201d \u3002", (String)"DataSetTurnFormulaUtil_2", (String)"epm-far-business", (Object[])new Object[0]), dimMember[0]));
                    }
                    cur = memberMap.get(dimMember[0]).iterator().next();
                    dimvaluemembers.add(DmPeriodAndFyUtil.getPeriodOrFyByOffset(shownumber, dimMember[0], cur, offset));
                    continue;
                }
                if (DatasetSpecialVarHelper.isEqualsCursVar(member)) {
                    if (memberMap != null && memberMap.containsKey(dimNumber)) {
                        Set<String> curs = memberMap.get(dimNumber);
                        dimvaluemembers.addAll(curs);
                        continue;
                    }
                    throw new KDException(BosErrorCode.paramError, new Object[]{String.format(FormulaExceptionEnum.DIM_NO_DEFAULT_MEMBER.getName(), dimMember[0])});
                }
                dimvaluemembers.add(member);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(dimMember[0]);
            sb.append(".");
            if (dimvaluemembers.size() > 1) {
                sb.append("{");
                sb.append(Joiner.on((String)";").join(dimvaluemembers));
                sb.append("}");
            } else if (dimvaluemembers.size() == 1) {
                String member;
                member = (String)dimvaluemembers.get(0);
                String lastInfo = member.substring(member.lastIndexOf(".") + 1);
                RangeEnum rangeEnum = RangeEnum.getRangeByNumber((String)lastInfo);
                if (rangeEnum == null) {
                    sb.append((String)dimvaluemembers.get(0));
                } else {
                    sb.append("{");
                    sb.append((String)dimvaluemembers.get(0));
                    sb.append("}");
                }
            } else if (dimvaluemembers.isEmpty()) {
                sb.append("$All");
            }
            dimsList.add(sb.toString());
        }
        String newexpression = Joiner.on((String)",").join(dimsList);
        return newexpression;
    }

    public static void buildManageVo(DatasetDto dto, Long datasetId) {
        DynamicObject singleDS = DatasetDataReader.getSingleDS(datasetId);
        if (Objects.isNull(singleDS)) {
            return;
        }
        DatasetUtil.addManageVo(dto, singleDS);
    }
}

